<?php defined('BASEPATH') OR exit('No direct script access allowed');
/**
 * 
 */
class Services_model extends MY_Model{

	/**
	 * Description
	 * @return type
	 */
	public function __construct()
	{
		parent::__construct();
	}

	/**
	 * Description
	 * @return type
	 */
	public function get_items($status=null)
	{
		if (!$status)
		{
			$query = "SELECT * 
							FROM {$this->tables['items']} AS I 
							LEFT JOIN {$this->tables['items_groups']} AS G 
							ON I.group_id = G.group_id 
							LEFT JOIN {$this->tables['taxes']} AS T 
							ON I.tax_id = T.id
							WHERE I.is_service = 1";
			return $this->oneric->get_results($query);
		}
	}

	/**
	 * Description
	 * @param type $id 
	 * @return type
	 */
	public function get_item($id)
	{
		if ($id)
		{
			$query = "SELECT * 
							FROM {$this->tables['items']} AS I 
							LEFT JOIN {$this->tables['items_groups']} AS G
							ON I.group_id = G.group_ID 
							LEFT JOIN {$this->tables['taxes']} AS T
							ON I.tax_id = T.id WHERE I.item_id = {$id}";
			return $this->oneric->get_results($query);
		}
	}

	public function get_group($id)
	{
		if ($id)
		{
			$this->_table = 'items_groups';
			$this->_primary_key = 'group_id';

			$query = "SELECT * FROM {$this->tables[$this->_table]} WHERE {$this->_primary_key}={$id}";
			return $this->oneric->get_results($query);
		}
		return false;
	}
	/**
	 * Description
	 * @return type
	 */
	public function generate_sku()
	{
		$this->load->helper('string');
		$sku = random_string('alpha', 3);
		$sku .= '-';
		$sku .= random_string('alnum', 3);
		$sku .= '-';
		$sku .= random_string('alpha', 1);
		$sku .= random_string('numeric', 2);

		return strtoupper($sku);
	}

	/**
	 * Description
	 * @return type
	 */
	public function get_products_groups()
	{
		$query = "SELECT group_id, group_name 
						FROM {$this->tables['items_groups']} 
						ORDER BY group_name ASC
						WHERE is_service = 1";
		return $this->oneric->get_results($query);
	}
	public function get_services_groups()
	{
		$query = "SELECT group_id, group_name 
						FROM {$this->tables['items_groups']}
						WHERE is_service = 1 
						ORDER BY group_name ASC";
		return $this->oneric->get_results($query);
	}
	public function category_id($item_id)
	{
		$query = "SELECT group_id
						FROM {$this->tables['items']}
						WHERE item_id = {$item_id}";
		return $this->oneric->get_results($query);
	}
	public function category_name($category_id)
	{
		$query = "SELECT group_name
						FROM {$this->tables['items_groups']}
						WHERE group_id = {$category_id}";
		$results = $this->oneric->get_results($query);
		if ($results)
		{
			foreach ($results as $v) {
				return $v->group_name;
			}
		}
	}
	public function update_invoiced_items_group($item_id, $group_id)
	{
		if (!is_empty_table('invoices_items'))
		{
			$query = "SELECT id 
							FROM {$this->tables['invoices_items']}
							WHERE item_id = {$item_id}";
			$items = $this->oneric->get_results($query);
			if ($items)
			{
				foreach ($items as $v) {
					$id = $v->id;
					$db_data = array('item_group' => $group_id);
					$query = "UPDATE {$this->tables['invoices_items']}
									SET " . $this->oneric->get_set($db_data) . 
									" WHERE id = {$id}";
					$this->oneric->query($query);
				}
			}
			return false;
		}
		return false;
	}
	public function delete($id)
	{
		$this->_tables = ['invoices_items', 'quotes_items'];
		$this->set_table('items');
		$this->_select = 'item_id';
		$this->_primary_key = 'item_id';

		if (!$this->before_delete($id))
		{
			return parent::delete($id);
		}
		return false;
	}
	public function is_empty($table)
	{
		return $this->oneric->get_row("SELECT COUNT(*) AS rows FROM {$this->tables[$table]}")->rows == 0;
	}
}