<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
/**
 * 
 */
class Ajax extends Ajax_Controller {
    /**
     * Description
     * @return type
     */
    public function __construct()
    {
        parent::__construct();
        $this->lang->load('users/auth');
        $this->load->model('ion_auth_model', 'users');
        $this->load->model('settings/settings_model', 'settings');
    }
    public function edit_user()
    {
        $post_array = array();
        $active_tab = $this->input->post('active_tab');
        $this->session->unset_userdata('active_tab');
        $this->session->set_userdata('active_tab', $active_tab);

        $post_array['first_name'] = $this->input->post('first_name');
        $post_array['last_name'] = $this->input->post('last_name');
        $post_array['email'] = $this->input->post('email');
        $post_array['phone'] = $this->input->post('phone');
        $post_array['user_own_paypal'] = $this->input->post('user_own_paypal');
        $post_array['user_own_skrill'] = $this->input->post('user_own_skrill');
        $post_array['user_own_bank_number'] = $this->input->post('user_own_bank_number');
        $id = $this->input->post('id');
        $config = array(
            array(
                'field' => 'first_name',
                'label' => lang('first_name'),
                'rules' => 'required',
                'errors' => array(
                    'required' => lang('error_required_name')
                    )
                ),
            array(
                'field' => 'last_name',
                'label' => lang('last_name'),
                'rules' => 'required',
                'errors' => array(
                    'required' => lang('error_required_last_name')
                    )
                ),
            array(
                'field' => 'email',
                'label' => lang('email'),
                'rules' => 'required',
                'errors' => array(
                    'required' => lang('error_required_email')
                    )
                ),
            array(
                'field' => 'user_own_paypal',
                'label' => lang('email'),
                'rules' => 'valid_email',
                'errors' => array(
                    'valid_email' => lang('error_required_valid_email')
                    )
                ),
            array(
                'field' => 'user_own_skrill',
                'label' => lang('email'),
                'rules' => 'valid_email',
                'errors' => array(
                    'valid_email' => lang('error_required_valid_email')
                    )
                ),
            array(
                'field' => 'phone',
                'label' => lang('phone'),
                'rules' => ''
                ),
            array(
                'field' => 'user_own_bank_number',
                'label' => lang('user_own_bank_number'),
                'rules' => ''
                )
            );

        $this->form_validation->set_rules($config);

        if ($this->form_validation->run() === TRUE)
        {
            $groupData = $this->input->post('groups');

            if (isset($groupData) && !empty($groupData)) {

                $this->ion_auth->remove_from_group('', $id);

                foreach ($groupData as $grp) {
                    $this->ion_auth->add_to_group($grp, $id);
                }

            }
            $this->oneric->query("UPDATE {$this->tables['users']} SET ".$this->oneric->get_set($post_array)." WHERE id = " . $id);
            $this->response = array('status' => 1);
        }
        else
        {
            $this->response = array('status' => 0, 'error' => validation_errors());
        }
        echo json_encode($this->response);
    }
    public function get_invoice_generated_tpl()
    {
        $this->load->helper('file');
        $lang = lang_code_to_notif_string( get_option('default_language') );
        $path = './notifications/' . $lang . '/invoices/new_invoice.php';

        $template = read_file($path);
        echo json_encode($template);
    }
    public function get_proforma_generated_tpl()
    {
        $this->load->helper('file');
        $lang = lang_code_to_notif_string( get_option('default_language') );
        $path = './notifications/' . $lang . '/proforma/new_proforma.php';

        $template = read_file($path);
        echo json_encode($template);
    }
    public function get_invoice_payment_tpl()
    {
        $this->load->helper('file');
        $lang = lang_code_to_notif_string( get_option('default_language') );
        $path = './notifications/' . $lang . '/invoices/invoice_paid.php';
        
        $template = read_file($path);
        echo json_encode($template);
    }
    public function get_invoice_refunded_tpl()
    {
        $this->load->helper('file');
        $lang = lang_code_to_notif_string( get_option('default_language') );
        $path = './notifications/' . $lang . '/invoices/invoice_refunded.php';
        
        $template = read_file($path);
        echo json_encode($template);
    }
    public function get_overdue_invoice_reminder_tpl()
    {
        $this->load->helper('file');
        $lang = lang_code_to_notif_string( get_option('default_language') );
        $path = './notifications/' . $lang . '/invoices/overdue_invoice_reminder.php';
        
        $template = read_file($path);
        echo json_encode($template);
    }
    public function get_overdue_invoice_single_reminder_tpl()
    {
        $this->load->helper('file');
        $lang = lang_code_to_notif_string( get_option('default_language') );
        $path = './notifications/' . $lang . '/invoices/overdue_invoice_single_reminder.php';
        
        $template = read_file($path);
        echo json_encode($template);
    }
    public function get_invoice_term_tpl()
    {
        $this->load->helper('file');
        $lang = lang_code_to_notif_string( get_option('default_language') );
        $path = './notifications/' . $lang . '/invoices/invoice_terms.php';
        
        $template = read_file($path);
        echo json_encode($template);
    }
    public function get_proforma_term_tpl()
    {
        $this->load->helper('file');
        $lang = lang_code_to_notif_string( get_option('default_language') );
        $path = './notifications/' . $lang . '/proforma/proforma_terms.php';
        
        $template = read_file($path);
        echo json_encode($template);
    }
    public function get_quote_term_tpl()
    {
        $this->load->helper('file');
        $lang = lang_code_to_notif_string( get_option('default_language') );
        $path = './notifications/' . $lang . '/quotes/quote_terms.php';
        
        $template = read_file($path);
        echo json_encode($template);
    }
    public function get_invoice_footer_tpl()
    {
        $this->load->helper('file');
        $lang = lang_code_to_notif_string( get_option('default_language') );
        $path = './notifications/' . $lang . '/invoices/invoice_footer.php';
        
        $template = read_file($path);
        echo json_encode($template);
    }
    public function get_proforma_footer_tpl()
    {
        $this->load->helper('file');
        $lang = lang_code_to_notif_string( get_option('default_language') );
        $path = './notifications/' . $lang . '/proforma/proforma_footer.php';
        
        $template = read_file($path);
        echo json_encode($template);
    }
    public function get_quote_footer_tpl()
    {
        $this->load->helper('file');
        $lang = lang_code_to_notif_string( get_option('default_language') );
        $path = './notifications/' . $lang . '/quotes/quote_footer.php';
        
        $template = read_file($path);
        echo json_encode($template);
    }
    public function get_quote_generated_tpl()
    {
        $this->load->helper('file');
        $lang = lang_code_to_notif_string( get_option('default_language') );
        $path = './notifications/' . $lang . '/quotes/new_quote.php';

        $template = read_file($path);
        echo json_encode($template);
    }
    public function get_quoteaccepted_tpl()
    {
        $this->load->helper('file');
        $lang = lang_code_to_notif_string( get_option('default_language') );
        $path = './notifications/' . $lang . '/quotes/quote_accepted.php';

        $template = read_file($path);
        echo json_encode($template);
    }
    public function get_order_placed_tpl()
    {
        $this->load->helper('file');
        $lang = lang_code_to_notif_string( get_option('default_language') );
        $path = './notifications/' . $lang . '/orders/new_order.php';

        $template = read_file($path);
        echo json_encode($template);
    }
    public function get_order_shipped_tpl()
    {
        $this->load->helper('file');
        $lang = lang_code_to_notif_string( get_option('default_language') );
        $path = './notifications/' . $lang . '/orders/order_shipped.php';

        $template = read_file($path);
        echo json_encode($template);
    }
    public function get_order_terms_tpl()
    {
        $this->load->helper('file');
        $lang = lang_code_to_notif_string( get_option('default_language') );
        $path = './notifications/' . $lang . '/orders/order_terms.php';

        $template = read_file($path);
        echo json_encode($template);
    }
    public function get_order_footer_tpl()
    {
        $this->load->helper('file');
        $lang = lang_code_to_notif_string( get_option('default_language') );
        $path = './notifications/' . $lang . '/orders/order_footer.php';

        $template = read_file($path);
        echo json_encode($template);
    }

    public function general_settings()
    {
        $this->settings->set_table('options');
        $post_array = array(
            array(
                'option_name' => "company",
                'option_value' => $this->input->post('company')
                ),
            array(
                'option_name' => "legal_form",
                'option_value' => $this->input->post('legal_form')
                ),
            array(
                'option_name' => "sector",
                'option_value' => $this->input->post('sector')
                ),
            array(
                'option_name' => "siret",
                'option_value' => $this->input->post('siret')
                ),
            array(
                'option_name' => "tax_id",
                'option_value' => $this->input->post('tax_id')
                ),
            array(
                'option_name' => "chamber_commerce_id",
                'option_value' => $this->input->post('chamber_commerce_id')
                ),
            array(
                'option_name' => "bank_number",
                'option_value' => $this->input->post('bank_number')
                ),
            array(
                'option_name' => "bank_name",
                'option_value' => $this->input->post('bank_name')
                ),
            array(
                'option_name' => "activity_type",
                'option_value' => $this->input->post('activity_type')
                ),
            array(
                'option_name' => "activity",
                'option_value' => $this->input->post('activity')
                ),
            array(
                'option_name' => "first_name",
                'option_value' => $this->input->post('first_name')
                ),
            array(
                'option_name' => "last_name",
                'option_value' => $this->input->post('last_name')
                ),
            array(
                'option_name' => "address1",
                'option_value' => $this->input->post('address1')
                ),
            array(
                'option_name' => "address2",
                'option_value' => $this->input->post('address2')
                ),
            array(
                'option_name' => "city",
                'option_value' => $this->input->post('city')
                ),
            array(
                'option_name' => "state",
                'option_value' => $this->input->post('state')
                ),
            array(
                'option_name' => "postcode",
                'option_value' => $this->input->post('postcode')
                ),
            array(
                'option_name' => "country",
                'option_value' => $this->input->post('country')
                ),
            array(
                'option_name' => "phone",
                'option_value' => $this->input->post('phone')
                ),
            array(
                'option_name' => "mobile",
                'option_value' => $this->input->post('mobile')
                ), 
            array(
                'option_name' => "fax",
                'option_value' => $this->input->post('fax')
                ),
            array(
                'option_name' => "website",
                'option_value' => $this->input->post('website')
                ),
            array(
                'option_name' => "email",
                'option_value' => $this->input->post('email')
                ),
            array(
                'option_name' => "notifications_email",
                'option_value' => $this->input->post('notifications_email')
                ),
            array(
                'option_name' => "notifications_email_2",
                'option_value' => $this->input->post('notifications_email_2')
                ),
            array(
                'option_name' => "timezone",
                'option_value' => 'Paris'
                ),
            array(
                'option_name' => "number_format",
                'option_value' => '1'
                )
            );
            $config = array(
                array(
                    'field' => 'first_name',
                    'label' => lang('first_name'),
                    'rules' => 'required',
                    'errors' => array('required' => lang('error_required_first_name') . '<br />'
                        )
                    ),
                array(
                    'field' => 'last_name',
                    'label' => lang('last_name'),
                    'rules' => 'required',
                    'errors' => array(
                        'required' => lang('error_required_last_name') . '<br />'
                        )
                    ),
                array(
                    'field' => 'email',
                    'label' => lang('email'),
                    'rules' => 'required',
                    'errors' => array(
                        'required' => lang('error_required_email') . '<br />'
                        )
                    ),
                array(
                    'field' => 'notifications_email',
                    'label' => lang('email'),
                    'rules' => 'required',
                    'errors' => array(
                        'required' => lang('error_required_field_empty') . ' : ' . __('label_notification_email') .'<br />'
                        )
                    ),
                array(
                    'field' => 'company',
                    'label' => lang('company'),
                    'rules' => 'required',
                    'errors' => array(
                        'required' => lang('error_required_field_empty') . ' : ' . __('company') .'<br />'
                        )
                    ),
                array(
                    'field' => 'address1',
                    'label' => lang('label_address_1'),
                    'rules' => 'required',
                    'errors' => array(
                        'required' => lang('error_required_field_empty') . ' : ' . __('label_address_1') .'<br />'
                        )
                    ),
                array(
                    'field' => 'city',
                    'label' => lang('label_city'),
                    'rules' => 'required',
                    'errors' => array(
                        'required' => lang('error_required_field_empty') . ' : ' . __('label_city') .'<br />'
                        )
                    ),
                array(
                    'field' => 'postcode',
                    'label' => lang('label_postcode'),
                    'rules' => 'required',
                    'errors' => array(
                        'required' => lang('error_required_field_empty') . ' : ' . __('label_postcode') .'<br />'
                        )
                    ),
                array(
                    'field' => 'country',
                    'label' => lang('label_country'),
                    'rules' => 'required',
                    'errors' => array(
                        'required' => lang('error_required_field_empty') . ' : ' . __('label_country') .'<br />'
                        )
                    ),
                array(
                    'field' => 'phone',
                    'label' => lang('phone'),
                    'rules' => ''
                    )
                );
        $this->form_validation->set_rules($config);

        if ($this->form_validation->run() === TRUE)
        {
            foreach ($post_array as $key => $value) {
                set_option($post_array[$key]);
            }
            $response = array('status' => 1);
        }
        else
        {
            $response = array('status' => 0, 'error' => validation_errors());
        }
        if (is_italian_company()){
            add_italian_fields();
        }
        echo json_encode($response);
    }
    public function general()
    {
        $this->settings->set_table('options');
        $post_array = array(
            array(
                'option_name' => "sidebar_closed",
                'option_value' => null !== $this->input->post('sidebar_closed') ? 1: 0
                ),
            array(
                'option_name' => "pay_online",
                'option_value' => null !== $this->input->post('pay_online') ? 1: 0
                ),
            array(
                'option_name' => "has_paypal",
                'option_value' => null !== $this->input->post('has_paypal') ? 1: 0
                ),
            array(
                'option_name' => "has_stripe",
                'option_value' => null !== $this->input->post('has_stripe') ? 1: 0
                ),
            array(
                'option_name' => "has_mollie",
                'option_value' => null !== $this->input->post('has_mollie') ? 1: 0
                ),
            array(
                'option_name' => "has_ingenico",
                'option_value' => null !== $this->input->post('has_ingenico') ? 1: 0
                ),
            array(
                'option_name' => "timeline_enabled",
                'option_value' => null !== $this->input->post('timeline_enabled') ? 1: 0
                ),
            array(
                'option_name' => "geolocation_enabled",
                'option_value' => null !== $this->input->post('geolocation_enabled') ? 1: 0
                ),
            array(
                'option_name' => "auto_refresh_stock_table",
                'option_value' => null !== $this->input->post('auto_refresh_stock_table') ? 1: 0
                ),
            array(
                'option_name' => "user_commissions",
                'option_value' => null !== $this->input->post('user_commissions') ? 1: 0
                ),
            array(
                'option_name' => "time_tracking",
                'option_value' => null !== $this->input->post('time_tracking') ? 1: 0
                ),
            array(
                'option_name' => "items_stocks",
                'option_value' => null !== $this->input->post('items_stocks') ? 1: 0
                ),
            array(
                'option_name' => "sale_orders",
                'option_value' => null !== $this->input->post('sale_orders') ? 1: 0
                ),
            array(
                'option_name' => "display_terms",
                'option_value' => null !== $this->input->post('display_terms') ? 1: 0
                ),
            array(
                'option_name' => "display_bank_name",
                'option_value' => null !== $this->input->post('display_bank_name') ? 1: 0
                ),
            array(
                'option_name' => "display_status",
                'option_value' => null !== $this->input->post('display_status') ? 1: 0
                ),
            array(
                'option_name' => "display_vat_number",
                'option_value' => null !== $this->input->post('display_vat_number') ? 1: 0
                ),
            array(
                'option_name' => "display_ch_commerce",
                'option_value' => null !== $this->input->post('display_ch_commerce') ? 1: 0
                ),
            array(
                'option_name' => "display_iban",
                'option_value' => null !== $this->input->post('display_iban') ? 1: 0
                ),
            array(
                'option_name' => "display_contact_info",
                'option_value' => null !== $this->input->post('display_contact_info') ? 1: 0
                ),
            array(
                'option_name' => "display_logo",
                'option_value' => null !== $this->input->post('display_logo') ? 1: 0
                ),
            array(
                'option_name' => "enable_alternative_cron",
                'option_value' => null !== $this->input->post('enable_alternative_cron') ? 1: 0
                ),
            array(
                'option_name' => "is_indian",
                'option_value' => null !== $this->input->post('is_indian') ? 1: 0
                ),
            array(
                'option_name' => "is_romanian",
                'option_value' => null !== $this->input->post('is_romanian') ? 1: 0
                ),
            array(
                'option_name' => "display_vat",
                'option_value' => null !== $this->input->post('display_vat') ? 1: 0
                ),
            array(
                'option_name' => "sms_notification",
                'option_value' => null !== $this->input->post('sms_notification') ? 1: 0
                ),
            array(
                'option_name' => "recaptcha_enabled",
                'option_value' => null !== $this->input->post('recaptcha_enabled') ? 1: 0
                ),
            array(
                'option_name' => "display_discount",
                'option_value' => null !== $this->input->post('display_discount') ? 1: 0
                ),
            array(
                'option_name' => "server_side_pagination",
                'option_value' => null !== $this->input->post('server_side_pagination') ? 1: 0
                )
            );
        if( null !== $this->input->post('is_indian') )
        {
            array_push($post_array, array(
                    'option_name' => "invoice_layout",
                    'option_value' => 5
                ),
                array(
                    'option_name' => "quote_layout",
                    'option_value' => 5
                )
            );
        }
        elseif( null !== $this->input->post('is_romanian') )
        {
            array_push($post_array, array(
                    'option_name' => "invoice_layout",
                    'option_value' => 6
                ),
                array(
                    'option_name' => "quote_layout",
                    'option_value' => 6
                )
            );
        }
        else
        {
            array_push($post_array, array(
                    'option_name' => "invoice_layout",
                    'option_value' => 1
                ),
                array(
                    'option_name' => "quote_layout",
                    'option_value' => 1
                )
            );
        }
        if ($this->input->post('change_currency') == 1 && !in_array(get_option('user_currency'), ['BSD', 'GHS', 'GTQ', 'IQS', 'ISK', 'MMK', 'PAB', 'XAF', 'XOF', 'XPF'])) {
            array_push($post_array, array(
                'option_name' => "change_currency",
                'option_value' => 1
                )
            );
        } else {
            array_push($post_array, array(
                'option_name' => "change_currency",
                'option_value' => 0
                )
            );
        }
        foreach ($post_array as $key => $value) {
            set_option($post_array[$key]);
            if( 0 == get_option('change_currency') )
            {
                update_clients_currency();
                update_providers_currency();
            }
        }
        echo json_encode(array('status' => 1));
    }
    public function email_notifications_settings(){
        $this->settings->set_table('options');

        if ($this->input->post('turn_off_emails') == 1) {
            $post_array = array(
                array(
                    'option_name' => "turn_off_emails",
                    'option_value' => 1
                    ),
                array(
                    'option_name' => "turn_off_customer_invoice_emails",
                    'option_value' => 1
                    ),
                array(
                    'option_name' => "turn_off_customer_password_email",
                    'option_value' => 1
                    ),
                array(
                    'option_name' => "turn_off_items_low_stock_email",
                    'option_value' => 1
                    ),
                array(
                    'option_name' => "turn_off_provider_password_email",
                    'option_value' => 1
                    ),
                array(
                    'option_name' => "turn_off_customer_so_emails",
                    'option_value' => 1
                    ),
                array(
                    'option_name' => "turn_off_customer_proforma_emails",
                    'option_value' => 1
                    ),
                array(
                    'option_name' => "turn_off_customer_quote_emails",
                    'option_value' => 1
                    ),
                array(
                    'option_name' => "turn_off_customer_cn_emails",
                    'option_value' => 1
                    ),
                array(
                    'option_name' => "turn_off_customer_po_emails",
                    'option_value' => 1
                    ),
                );
        } else {
            $post_array = array(
                array(
                    'option_name' => "turn_off_emails",
                    'option_value' => $this->input->post('turn_off_emails')
                    ),
                array(
                    'option_name' => "turn_off_customer_invoice_emails",
                    'option_value' => $this->input->post('turn_off_customer_invoice_emails')
                    ),
                array(
                    'option_name' => "turn_off_customer_password_email",
                    'option_value' => $this->input->post('turn_off_customer_password_email')
                    ),
                array(
                    'option_name' => "turn_off_items_low_stock_email",
                    'option_value' => $this->input->post('turn_off_items_low_stock_email')
                    ),
                array(
                    'option_name' => "turn_off_provider_password_email",
                    'option_value' => $this->input->post('turn_off_provider_password_email')
                    ),
                array(
                    'option_name' => "turn_off_customer_so_emails",
                    'option_value' => $this->input->post('turn_off_customer_so_emails')
                    ),
                array(
                    'option_name' => "turn_off_customer_proforma_emails",
                    'option_value' => $this->input->post('turn_off_customer_proforma_emails')
                    ),
                array(
                    'option_name' => "turn_off_customer_quote_emails",
                    'option_value' => $this->input->post('turn_off_customer_quote_emails')
                    ),
                array(
                    'option_name' => "turn_off_customer_cn_emails",
                    'option_value' => $this->input->post('turn_off_customer_cn_emails')
                    ),
                array(
                    'option_name' => "turn_off_customer_po_emails",
                    'option_value' => $this->input->post('turn_off_customer_po_emails')
                    ),
                );
        }
        foreach ($post_array as $key => $value) {
            set_option($post_array[$key]);
        }
        echo json_encode(array('status' => 1));
    }
    public function email_settings()
    {
        $this->settings->set_table('options');
        if ($this->input->post('email_settings') === "mail")
        {
            $post_array = array(
                array(
                    'option_name' => "email_settings",
                    'option_value' => $this->input->post('email_settings')
                    )
                );
            foreach ($post_array as $key => $value) {
                set_option($post_array[$key]);
            }
            echo json_encode(array('status' => 1));
        }
        elseif ($this->input->post('email_settings') === "smtp")
        {
            $post_array = array(
                array(
                    'option_name' => "email_settings",
                    'option_value' => $this->input->post('email_settings')
                    )
                );
            $smtp = array(
                'smtp_host'     => $this->input->post('smtp_host'),
                'smtp_user'     => $this->input->post('smtp_user'),
                'smtp_pass'     => $this->input->post('smtp_pass'),
                'smtp_port'     => $this->input->post('smtp_port'),
                'smtp_crypto'     => $this->input->post('smtp_crypto')
                );
                $config = array(
                    array(
                        'field' => 'smtp_host',
                        'label' => lang('smtp_host'),
                        'rules' => 'required',
                        'errors' => array('required' => lang('error_required_field_empty') . ' : ' . __('smtp_host') .'<br />'
                            )
                        ),
                    array(
                        'field' => 'smtp_user',
                        'label' => lang('smtp_user'),
                        'rules' => 'required',
                        'errors' => array(
                            'required' => lang('error_required_field_empty') . ' : ' . __('smtp_user') .'<br />'
                            )
                        ),
                    array(
                        'field' => 'smtp_pass',
                        'label' => lang('smtp_pass'),
                        'rules' => 'required',
                        'errors' => array(
                            'required' => lang('error_required_field_empty') . ' : ' . __('smtp_pass') .'<br />'
                            )
                        ),
                    array(
                        'field' => 'smtp_port',
                        'label' => lang('smtp_port'),
                        'rules' => 'required',
                        'errors' => array(
                            'required' => lang('error_required_field_empty') . ' : ' . __('smtp_port') .'<br />'
                            )
                        ),
                    array(
                        'field' => 'smtp_crypto',
                        'label' => lang('smtp_crypto'),
                        'rules' => 'required',
                        'errors' => array(
                            'required' => lang('error_required_field_empty') . ' : ' . __('smtp_crypto') .'<br />'
                            )
                        )
                    );
            $this->form_validation->set_rules($config);

            if ($this->form_validation->run() === TRUE)
            {
                array_push($post_array, array(
                    'option_name' => "smtp_settings",
                    'option_value' => json_encode($smtp)
                    )
                );
                foreach ($post_array as $key => $value) {
                    set_option($post_array[$key]);
                }
                echo json_encode(array('status' => 1));
            }
            else
            {
                echo json_encode(array('status' => 0, 'error' => validation_errors()));
            }
        }
    }
    public function user_commission_settings()
    {
        $post_array = [];

        $this->settings->set_table('options');
        if ($this->input->post('apply_commission_on_paid_order') === "auto")
        {
            array_push($post_array,
                array(
                    'option_name' => "apply_commission_on_paid_order",
                    'option_value' => $this->input->post('apply_commission_on_paid_order')
                )
            );
        }
        if ($this->input->post('apply_commission_on_paid_order') === "manual")
        {
            array_push($post_array,
                array(
                    'option_name' => "apply_commission_on_paid_order",
                    'option_value' => $this->input->post('apply_commission_on_paid_order')
                )
            );
        }
        if ($this->input->post('commission_in_charges') == "1")
        {
            array_push($post_array,
                array(
                    'option_name' => "commission_in_charges",
                    'option_value' => 1
                ),
                array(
                    'option_name' => "commission_charges_cat",
                    'option_value' => $this->input->post('commission_charges_cat')
                )
            );
        }
        if ($this->input->post('commission_in_charges') == "0")
        {
            array_push($post_array,
                array(
                    'option_name' => "commission_in_charges",
                    'option_value' => 0
                )
            );
        }
        if ($this->input->post('eligible_roles'))
        {
            array_push($post_array,
                array(
                    'option_name' => "eligible_roles",
                    'option_value' => json_encode($this->input->post('eligible_roles'))
                )
            );
        }
        if ($this->input->post('commission_type') === "fixed")
        {
            array_push($post_array,
                array(
                    'option_name' => "commission_type",
                    'option_value' => $this->input->post('commission_type')
                ),
                array(
                    'option_name' => "commission_value",
                    'option_value' => $this->input->post('commission_value')
                )
            );
            update_user_commissions_settings($this->input->post('commission_type'), $this->input->post('commission_value'), $this->input->post('user_id'));
        }
        if ($this->input->post('commission_type') === "rate")
        {
            array_push($post_array,
                array(
                    'option_name' => "commission_type",
                    'option_value' => $this->input->post('commission_type')
                ),
                array(
                    'option_name' => "commission_value",
                    'option_value' => $this->input->post('commission_value')
                )
            );
            update_user_commissions_settings($this->input->post('commission_type'), $this->input->post('commission_value'), $this->input->post('user_id'));
        }
        if (null == $this->input->post('user_id')) {
            foreach ($post_array as $key => $value) {
                set_option($post_array[$key]);
            }
        }
        echo json_encode(array('status' => 1));
    }
    public function invoice_late_fees_settings()
    {
        $post_array = [];

        $this->settings->set_table('options');
  
        if ($this->input->post('apply_late_fees') == "1")
        {
            array_push($post_array,
                array(
                    'option_name' => "apply_late_fees",
                    'option_value' => 1
                )
            );
        }
        if ($this->input->post('apply_late_fees') == "0")
        {
            array_push($post_array,
                array(
                    'option_name' => "apply_late_fees",
                    'option_value' => 0
                )
            );
        }
        if ($this->input->post('late_fees_type') === "fixed")
        {
            array_push($post_array,
                array(
                    'option_name' => "late_fees_type",
                    'option_value' => $this->input->post('late_fees_type')
                ),
                array(
                    'option_name' => "late_fees_value",
                    'option_value' => $this->input->post('late_fees_value')
                ),
                array(
                    'option_name' => "late_fees_tax_rate",
                    'option_value' => $this->input->post('late_fees_tax_rate')
                )
            );
        }
        if ($this->input->post('late_fees_type') === "rate")
        {
            array_push($post_array,
                array(
                    'option_name' => "late_fees_type",
                    'option_value' => $this->input->post('late_fees_type')
                ),
                array(
                    'option_name' => "late_fees_value",
                    'option_value' => $this->input->post('late_fees_value')
                ),
                array(
                    'option_name' => "late_fees_tax_rate",
                    'option_value' => $this->input->post('late_fees_tax_rate')
                )
            );
        }
        if ($this->input->post('apply_late_fees_when') === "immediately")
        {
            array_push($post_array,
                array(
                    'option_name' => "apply_late_fees_when",
                    'option_value' => $this->input->post('apply_late_fees_when')
                )
            );
        }
        if ($this->input->post('apply_late_fees_when') === "after_reminder")
        {
            array_push($post_array,
                array(
                    'option_name' => "apply_late_fees_when",
                    'option_value' => $this->input->post('apply_late_fees_when')
                )
            );
        }
        
        foreach ($post_array as $key => $value) {
            set_option($post_array[$key]);
        }
        echo json_encode(array('status' => 1));
    }
    public function mollie_account()
    {
        $this->settings->set_table('options');
        $post_array = array(
            array(
                'option_name' => "mollie_api_key",
                'option_value' => $this->input->post('mollie_api_key')
                ),
            array(
                'option_name' => "mollie_partner_id",
                'option_value' => $this->input->post('mollie_partner_id')
                )
            );
            $config = array(
                array(
                    'field' => 'mollie_api_key',
                    'label' => lang('label_api_key'),
                    'rules' => 'required',
                    'errors' => array('required' => lang('error_required_api_key') . '<br />'
                        )
                    ),
                array(
                    'field' => 'mollie_partner_id',
                    'label' => lang('label_partner_ID'),
                    'rules' => 'required',
                    'errors' => array(
                        'required' => lang('error_required_ID') . '<br />'
                        )
                    )
                );
        $this->form_validation->set_rules($config);

        if ($this->form_validation->run() === TRUE)
        {
            foreach ($post_array as $key => $value) {
                set_option($post_array[$key]);
            }
            $response = array('status' => 1);
        }
        else
        {
            $response = array('status' => 0, 'error' => validation_errors());
        }
        echo json_encode($response);
    }
    public function ingenico_account()
    {
        $this->settings->set_table('options');
        $post_array = array(
            array(
                'option_name' => "ingenico_pspid",
                'option_value' => $this->input->post('ingenico_pspid')
                ),
            array(
                'option_name' => "ingenico_shain",
                'option_value' => $this->input->post('ingenico_shain')
                ),
            array(
                'option_name' => "ingenico_home_url",
                'option_value' => $this->input->post('ingenico_home_url')
                ),
            array(
                'option_name' => "ingenico_catalog_url",
                'option_value' => $this->input->post('ingenico_catalog_url')
                )
            );
            $config = array(
                array(
                    'field' => 'ingenico_pspid',
                    'label' => 'PSPID',
                    'rules' => 'required',
                    'errors' => array('required' => lang('error_required_pspid_key') . '<br />'
                        )
                    ),
                array(
                    'field' => 'ingenico_shain',
                    'label' => 'SHA-IN',
                    'rules' => 'required',
                    'errors' => array(
                        'required' => lang('error_required_sha_in') . '<br />'
                        )
                    ),
                array(
                    'field' => 'ingenico_home_url',
                    'label' => 'Home-url',
                    'rules' => 'required',
                    'errors' => array(
                        'required' => lang('error_required_home_url') . '<br />'
                        )
                    ),
                array(
                    'field' => 'ingenico_catalog_url',
                    'label' => 'Catalog',
                    'rules' => 'required',
                    'errors' => array(
                        'required' => lang('error_required_catalog_url') . '<br />'
                        )
                    )
                );
        $this->form_validation->set_rules($config);

        if ($this->form_validation->run() === TRUE)
        {
            foreach ($post_array as $key => $value) {
                set_option($post_array[$key]);
            }
            $response = array('status' => 1);
        }
        else
        {
            $response = array('status' => 0, 'error' => validation_errors());
        }
        echo json_encode($response);
    }
    public function stripe_account()
    {
        $this->settings->set_table('options');
        $post_array = array(
            array(
                'option_name' => "stripe_secret_key",
                'option_value' => $this->input->post('stripe_secret_key')
                ),
            array(
                'option_name' => "stripe_publishable_key",
                'option_value' => $this->input->post('stripe_publishable_key')
                )
            );
            $config = array(
                array(
                    'field' => 'stripe_secret_key',
                    'label' => 'Secret_key',
                    'rules' => 'required',
                    'errors' => array('required' => lang('error_required_secret_key') . '<br />'
                        )
                    ),
                array(
                    'field' => 'stripe_publishable_key',
                    'label' => 'Publishable Key',
                    'rules' => 'required',
                    'errors' => array(
                        'required' => lang('error_required_publishable_key') . '<br />'
                        )
                    )
                );
        $this->form_validation->set_rules($config);

        if ($this->form_validation->run() === TRUE)
        {
            foreach ($post_array as $key => $value) {
                set_option($post_array[$key]);
            }
            $response = array('status' => 1);
        }
        else
        {
            $response = array('status' => 0, 'error' => validation_errors());
        }
        echo json_encode($response);
    }
    public function paypal_account()
    {
        $this->settings->set_table('options');
        $post_array = array(
            array(
                'option_name' => "paypal_account",
                'option_value' => trim($this->input->post('paypal_account'))
                ),
            array(
                'option_name' => "paypal_client_id",
                'option_value' => trim($this->input->post('paypal_client_id'))
                ),
            array(
                'option_name' => "paypal_production_credentials",
                'option_value' => null == $this->input->post('paypal_production_credentials') ? 0 : 1
                )
            );
            $config = array(
                array(
                    'field' => 'paypal_account',
                    'label' => 'Paypal Account',
                    'rules' => 'required',
                    'errors' => array('required' => lang('error_required_paypal_account') . '<br />'
                        )
                    ),
                array(
                    'field' => 'paypal_client_id',
                    'label' => 'Client ID',
                    'rules' => 'required',
                    'errors' => array(
                        'required' => lang('error_required_client_id') . '<br />'
                        )
                    )
                );
        $this->form_validation->set_rules($config);

        if ($this->form_validation->run() === TRUE)
        {
            foreach ($post_array as $key => $value) {
                set_option($post_array[$key]);
            }
            $response = array('status' => 1);
        }
        else
        {
            $response = array('status' => 0, 'error' => validation_errors());
        }
        echo json_encode($response);
    }
    public function maps()
    {
        $this->settings->set_table('options');
        $post_array = array(
            array(
                'option_name' => "maps_api_key",
                'option_value' => trim($this->input->post('maps_api_key'))
                )
            );
            $config = array(
                array(
                    'field' => 'maps_api_key',
                    'label' => 'Maps API',
                    'rules' => 'required',
                    'errors' => array('required' => lang('error_required_maps_api_key') . '<br />'
                        )
                    )
                );
        $this->form_validation->set_rules($config);

        if ($this->form_validation->run() === TRUE)
        {
            foreach ($post_array as $key => $value) {
                set_option($post_array[$key]);
            }
            $response = array('status' => 1);
        }
        else
        {
            $response = array('status' => 0, 'error' => validation_errors());
        }
        echo json_encode($response);
    }
    public function recaptcha()
    {
        $this->settings->set_table('options');
        $post_array = array(
            array(
                'option_name' => "recaptcha_site_key",
                'option_value' => trim($this->input->post('recaptcha_site_key'))
                ),
            array(
                'option_name' => "recaptcha_site_secret",
                'option_value' => trim($this->input->post('recaptcha_site_secret'))
                )
            );
            $config = array(
                array(
                    'field' => 'recaptcha_site_key',
                    'label' => 'Maps reCaptcha site key',
                    'rules' => 'required',
                    'errors' => array('required' => lang('error_required_maps_recaptcha_site_key') . '<br />'
                        )
                    ),
                array(
                    'field' => 'recaptcha_site_secret',
                    'label' => 'Maps reCaptcha site secret',
                    'rules' => 'required',
                    'errors' => array('required' => lang('error_required_maps_recaptcha_site_secret') . '<br />'
                        )
                    )
                );
        $this->form_validation->set_rules($config);

        if ($this->form_validation->run() === TRUE)
        {
            foreach ($post_array as $key => $value) {
                set_option($post_array[$key]);
            }
            $response = array('status' => 1);
        }
        else
        {
            $response = array('status' => 0, 'error' => validation_errors());
        }
        echo json_encode($response);
    }
    public function clickatell_account()
    {
        $this->settings->set_table('options');
        $notify_when_invoice_is = [];
        if(null !== $this->input->post('notify_when_invoice_is'))
        {
            foreach ($this->input->post('notify_when_invoice_is') as $status) {
                array_push($notify_when_invoice_is, $status);
            }
        }
        $post_array = array(
            array(
                'option_name' => "clickatell_integration_name",
                'option_value' => trim($this->input->post('clickatell_integration_name'))
                ),
            array(
                'option_name' => "plateform_api_key",
                'option_value' => trim($this->input->post('plateform_api_key'))
                ),
            array(
                'option_name' => "notify_when_invoice_is",
                'option_value' => json_encode($notify_when_invoice_is)
                ),
            array(
                'option_name' => "sms_platform",
                'option_value' => trim($this->input->post('sms_platform'))
                ),
            array(
                'option_name' => "clickatell_production_credentials",
                'option_value' => null == $this->input->post('clickatell_production_credentials') ? 0 : 1
                )
            );
            $config = array(
                array(
                    'field' => 'clickatell_integration_name',
                    'label' => 'Integration name',
                    'rules' => 'required',
                    'errors' => array('required' => lang('error_required_field_error') . '<br />'
                        )
                    ),
                array(
                    'field' => 'plateform_api_key',
                    'label' => 'API Key',
                    'rules' => 'required',
                    'errors' => array(
                        'required' => lang('error_required_field_error') . '<br />'
                        )
                    )
                );
        $this->form_validation->set_rules($config);

        if ($this->form_validation->run() === TRUE)
        {
            foreach ($post_array as $key => $value) {
                set_option($post_array[$key]);
            }
            $response = array('status' => 1);
        }
        else
        {
            $response = array('status' => 0, 'error' => validation_errors());
        }
        echo json_encode($response);
    }
    public function sms_messages_notifications()
    {
        $this->settings->set_table('options');
        $post_array = array(
            array(
                'option_name' => "sms_invoice_paid",
                'option_value' => trim($this->input->post('sms_invoice_paid'))
                ),
            array(
                'option_name' => "sms_invoice_with_status",
                'option_value' => trim($this->input->post('sms_invoice_with_status'))
                )
            );
        foreach ($post_array as $key => $value) {
                set_option($post_array[$key]);
            }
        echo json_encode(array('status' => 1));
    }
    /**
     * Description
     * @return type
     */
    public function invoice_settings_numb_curr()
    {
        $customer_currency = [];
        $not_supported = ['BSD', 'GHS', 'GTQ', 'IQS', 'ISK', 'MMK', 'PAB', 'XAF', 'XOF', 'XPF'];

        if(null !== $this->input->post('customer_currency'))
        {
            foreach ($this->input->post('customer_currency') as $currency) {
                if ( ! in_array($currency,$not_supported)) {
                    array_push($customer_currency, $currency);
                }
            }
        }
        else
        {
            array_push($customer_currency, get_option('user_currency'));
            update_clients_currency();
            update_providers_currency();
        }

        if (4 == intval($this->input->post('invoice_numbering'))) {
            $annual_numbering = 1;
        } else {
            $annual_numbering = 0;
        }
        $post_array = array(
            array(
                'option_name' => "user_currency",
                'option_value' => $this->input->post('user_currency')
                ),
            array(
                'option_name' => "customer_currency",
                'option_value' => json_encode($customer_currency)
                ),
            array(
                'option_name' => "default_language",
                'option_value' => $this->input->post('default_language')
                ),
            array(
                'option_name' => "default_items_tax",
                'option_value' => $this->input->post('default_items_tax')
                ),
            array(
                'option_name' => "default_services_tax",
                'option_value' => $this->input->post('default_services_tax')
                ),
            array(
                'option_name' => "vat_included",
                'option_value' => $this->input->post('vat_included')
                ),
            array(
                'option_name' => "theme",
                'option_value' => $this->input->post('theme')
                ),
            array(
                'option_name' => "number_format",
                'option_value' => $this->input->post('number_format')
                ),
            array(
                'option_name' => "currency_placement",
                'option_value' => $this->input->post('currency_placement')
                ),
            array(
                'option_name' => "invoice_numbering",
                'option_value' => $this->input->post('invoice_numbering')
                ),
            array(
                'option_name' => "annual_numbering",
                'option_value' => $annual_numbering
                ),
            array(
                'option_name' => "default_duedate",
                'option_value' => $this->input->post('default_duedate')
                ),
            array(
                'option_name' => "invoice_prefix",
                'option_value' => $this->input->post('invoice_prefix')
                ),
            array(
                'option_name' => "proforma_prefix",
                'option_value' => $this->input->post('proforma_prefix')
                ),
            array(
                'option_name' => "quote_prefix",
                'option_value' => $this->input->post('quote_prefix')
                ),
            array(
                'option_name' => "purchase_order_prefix",
                'option_value' => $this->input->post('purchase_order_prefix')
                ),
            array(
                'option_name' => "sale_order_prefix",
                'option_value' => $this->input->post('sale_order_prefix')
                ),
            array(
                'option_name' => "credit_note_prefix",
                'option_value' => $this->input->post('credit_note_prefix')
                ),
            array(
                'option_name' => "display_mpn",
                'option_value' => $this->input->post('display_mpn')
                ),
            array(
                'option_name' => "default_table_size",
                'option_value' => $this->input->post('default_table_size')
                )
            );
        $lang = lang_code_to_notif_string( $this->input->post('default_language') );
        switch ($lang) {
            case 'fr-FR':
                $system_lang = 'french';
                break;
            case 'en-US':
                $system_lang = 'english';
                break;
            case 'sv-SE':
                $system_lang = 'swedish';
                break;
            case 'en-GB':
                $system_lang = 'english-gb';
                break;
            case 'nl-NL':
                $system_lang = 'dutch';
                break;
            case 'it-IT':
                $system_lang = 'italian';
                break;
            case 'ru-RU':
                $system_lang = 'russian';
                break;
            case 'ro':
                $system_lang = 'romanian';
                break;
            case 'es-ES':
                $system_lang = 'spanish';
                break;
            case 'de-DE':
                $system_lang = 'german';
                break;
            case 'el-EL':
                $system_lang = 'greek';
                break;
            case 'ar-AR':
                $system_lang = 'arabic';
                break;
            default:
                $system_lang = 'english';
                break;
        }
        $db_data = array(
            'user_id'      => user('user_id'),
            'option_key'   => "user_language",
            'option_value' => $system_lang
        );
        $this->m_manager->updateOption($db_data);
        foreach ($post_array as $key => $value) {
            set_option($post_array[$key]);
        }
        echo json_encode(array('status' => 1));
    }
    public function invoice_settings_h_d()
    {
        $post_array = array(
            array(
                'option_name' => "user_timezone",
                'option_value' => $this->input->post('user_timezone')
                ),
            array(
                'option_name' => "user_time",
                'option_value' => $this->input->post('user_time')
                ),
            array(
                'option_name' => "user_date_format",
                'option_value' => $this->input->post('user_date_format')
                )
            );
        foreach ($post_array as $key => $value) {
            set_option($post_array[$key]);
        }
        echo json_encode(array('status' => 1));
    }
    public function payment_method()
    {
        $post_array = array(
            array(
                'option_name' => "default_payment_method",
                'option_value' => $this->input->post('default_payment_method')
                )
            );
        foreach ($post_array as $key => $value) {
            set_option($post_array[$key]);
        }
        echo json_encode(array('status' => 1));
    }
    public function additional_taxes()
    {
        $post_array = array(
            array(
                'option_name' => "additional_taxes",
                'option_value' => $this->input->post('additional_taxes')
                )
            );
        foreach ($post_array as $key => $value) {
            set_option($post_array[$key]);
        }
        echo json_encode(array('status' => 1));
    }
    public function invoice_settings_layout()
    {
        $post_array = array(
            array(
                'option_name' => "invoice_layout",
                'option_value' => $this->input->post('invoice_layout')
                )
            );
        foreach ($post_array as $key => $value) {
            set_option($post_array[$key]);
        }
        echo json_encode(array('status' => 1));
    }
    public function proforma_settings_layout()
    {
        $post_array = array(
            array(
                'option_name' => "proforma_layout",
                'option_value' => $this->input->post('proforma_layout')
                )
            );
        foreach ($post_array as $key => $value) {
            set_option($post_array[$key]);
        }
        echo json_encode(array('status' => 1));
    }
    public function order_settings_layout()
    {
        $post_array = array(
            array(
                'option_name' => "order_layout",
                'option_value' => $this->input->post('order_layout')
                )
            );
        foreach ($post_array as $key => $value) {
            set_option($post_array[$key]);
        }
        echo json_encode(array('status' => 1));
    }
    public function quote_settings_layout()
    {
        $post_array = array(
            array(
                'option_name' => "quote_layout",
                'option_value' => $this->input->post('quote_layout')
                )
            );
        foreach ($post_array as $key => $value) {
            set_option($post_array[$key]);
        }
        echo json_encode(array('status' => 1));
    }
    public function set_invoice_templates()
    {
        $terms_length = $_REQUEST['terms_length'];
        $reminder_interval = $_REQUEST['reminder_interval'];
        $reminder_type = $_REQUEST['reminder_type'];
        $attach_pdf_to_invoice = $_REQUEST['attach_pdf_to_invoice'];
        $post_array = array(
            array(
                'option_name' => "terms_conditions_length",
                'option_value' => $terms_length
                ),
            array(
                'option_name' => "attach_pdf_to_invoice",
                'option_value' => $attach_pdf_to_invoice
                ),
            array(
                'option_name' => "reminder_interval",
                'option_value' => $reminder_interval
                ),
            array(
                'option_name' => "reminder_type",
                'option_value' => $reminder_type
                )
            );
        foreach ($post_array as $key => $value) {
            set_option($post_array[$key]);
        }
        
        $this->load->helper('file');
        $lang = lang_code_to_notif_string( get_option('default_language') );
        $data = array(
            '0' => $_REQUEST['tpl_invoice_generated'],
            '1' => $_REQUEST['tpl_payment_notification'],
            '2' => $_REQUEST['tpl_invoice_terms'],
            '3' => $_REQUEST['tpl_footer'],
            '4' => $_REQUEST['tpl_payment_refunded'],
            '5' => $_REQUEST['tpl_overdue_invoice_reminder'],
            '6' => $_REQUEST['tpl_overdue_invoice_single_reminder']
            );
        $paths = array(
            '0' => './notifications/' . $lang . '/invoices/new_invoice.php',
            '1' => './notifications/' . $lang . '/invoices/invoice_paid.php',
            '2' => './notifications/' . $lang . '/invoices/invoice_terms.php',
            '3' => './notifications/' . $lang . '/invoices/invoice_footer.php',
            '4' => './notifications/' . $lang . '/invoices/invoice_refunded.php',
            '5' => './notifications/' . $lang . '/invoices/overdue_invoice_reminder.php',
            '6' => './notifications/' . $lang . '/invoices/overdue_invoice_single_reminder.php'
            );
        foreach ($paths as $path) {
            if( chmod($path, 0755) ) 
            {
                chmod($path, 0777);
            }
        }
        write_file($paths[0], $data[0]);
        write_file($paths[1], $data[1]);
        write_file($paths[2], $data[2]);
        write_file($paths[3], $data[3]);
        write_file($paths[4], $data[4]);
        write_file($paths[5], $data[5]);
        write_file($paths[6], $data[6]);

        echo json_encode(array('status' => 1));
    }
    public function set_proforma_templates()
    {
        $delete_once_invoiced = $_REQUEST['delete_once_invoiced'];
        $delete_once_merged = $_REQUEST['delete_once_merged'];
        $post_array = array(
            array(
                'option_name' => "delete_once_invoiced",
                'option_value' => $delete_once_invoiced
                ),
            array(
                'option_name' => "delete_once_merged",
                'option_value' => $delete_once_merged
                )
            );
        foreach ($post_array as $key => $value) {
            set_option($post_array[$key]);
        }
        $this->load->helper('file');
        $lang = lang_code_to_notif_string( get_option('default_language') );
        $data = array(
            '0' => $_REQUEST['tpl_proforma_generated'],
            '1' => $_REQUEST['tpl_proforma_terms'],
            '2' => $_REQUEST['tpl_footer'],
            );
        $paths = array(
            '0' => './notifications/' . $lang . '/proforma/new_proforma.php',
            '1' => './notifications/' . $lang . '/proforma/proforma_terms.php',
            '2' => './notifications/' . $lang . '/proforma/proforma_footer.php',
            );
        foreach ($paths as $path) {
            if( chmod($path, 0755) ) 
            {
                chmod($path, 0777);
            }
        }
        write_file($paths[0], $data[0]);
        write_file($paths[1], $data[1]);
        write_file($paths[2], $data[2]);

        echo json_encode(array('status' => 1));
    }
    public function set_order_templates()
    {
        $this->load->helper('file');
        $lang = lang_code_to_notif_string( get_option('default_language') );
        $data = array(
            '0' => $_REQUEST['tpl_order_placed'],
            '1' => $_REQUEST['tpl_order_shipped'],
            '2' => $_REQUEST['tpl_order_terms'],
            '3' => $_REQUEST['tpl_footer'],
            );
        $paths = array(
            '0' => './notifications/' . $lang . '/orders/new_order.php',
            '1' => './notifications/' . $lang . '/orders/order_shipped.php',
            '2' => './notifications/' . $lang . '/orders/order_terms.php',
            '3' => './notifications/' . $lang . '/orders/order_footer.php',
            );
        foreach ($paths as $path) {
            if( chmod($path, 0755) ) 
            {
                chmod($path, 0777);
            }
        }
        write_file($paths[0], $data[0]);
        write_file($paths[1], $data[1]);
        write_file($paths[2], $data[2]);
        write_file($paths[3], $data[3]);
        echo json_encode(array('status' => 1));
    }
    public function set_quote_templates()
    {
        $this->load->helper('file');
        $lang = lang_code_to_notif_string( get_option('default_language') );
        $data = array(
            '0' => $_REQUEST['tpl_quote_generated'],
            '1' => $_REQUEST['tpl_quoteaccepted_notification'],
            '2' => $_REQUEST['tpl_quote_terms'],
            '3' => $_REQUEST['tpl_quote_footer']
            );
        $paths = array(
            '0' => './notifications/' . $lang . '/quotes/new_quote.php',
            '1' => './notifications/' . $lang . '/quotes/quote_accepted.php',
            '2' => './notifications/' . $lang . '/quotes/quote_terms.php',
            '3' => './notifications/' . $lang . '/quotes/quote_footer.php'
            );
        foreach ($paths as $path) {
            if( chmod($path, 0755) ) 
            {
                chmod($path, 0777);
            }
        }
        write_file($paths[0], $data[0]);
        write_file($paths[1], $data[1]);
        write_file($paths[2], $data[2]);
        write_file($paths[3], $data[3]);
        echo json_encode(array('status' => 1));

    }
    /**
     * Description
     * @return type
     */
    public function set_update_version()
    {
        $app_version = $_REQUEST['app_version'];

        $this->response = ($this->settings->update_version($app_version) != 0) ?  1 : 0;
        echo json_encode($this->response); 
    }
    public function add_payment_method()
    {
        $post_array = array(
            'payment_method_name'        => $this->input->post('payment_method_name')
            );
        $config = array(
            array(
                'field' => 'payment_method_name',
                'label' => __('payment_method_name'),
                'rules' => 'required',
                'errors' => array(
                    'required' => __('error_required_name')
                    )
                )
            );
        $this->form_validation->set_rules($config);
        $this->settings->set_table('payment_methods');
        $this->response = ($this->form_validation->run() === TRUE && $this->settings->save($post_array) != 0) ? 
            array('status' => 1) :
            array('status' => 0, 'error' => validation_errors('<div class="alert alert-danger"><a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>', '</div>'));
        echo json_encode($this->response);
    }
    public function add_additional_taxes()
    {
        $post_array = array(
            'additional_tax_name'        => $this->input->post('additional_tax_name'),
            'additional_tax_rate'        => $this->input->post('additional_tax_rate'),
            'additional_tax_criteria'        => $this->input->post('additional_tax_criteria')
        );
        $config = array(
            array(
                'field' => 'additional_tax_name',
                'label' => __('label_tax_name'),
                'rules' => 'required',
                'errors' => array(
                    'required' => __('error_required_tax_name')
                    )
                ),
            array(
                'field' => 'additional_tax_rate',
                'label' => __('label_tax_rate'),
                'rules' => 'required',
                'errors' => array(
                    'required' => __('error_required_tax_rate')
                    )
                ),
            array(
                'field' => 'additional_tax_criteria',
                'label' => __('label_tax_criteria'),
                'rules' => 'required',
                'errors' => array(
                    'required' => __('error_required_tax_criteria')
                    )
                ),
            );
        $this->form_validation->set_rules($config);
        $this->settings->set_table('additional_taxes');
        $this->response = ($this->form_validation->run() === TRUE && $this->settings->save($post_array) != 0) ? 
            array('status' => 1) :
            array('status' => 0, 'error' => validation_errors('<div class="alert alert-danger"><a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>', '</div>'));
        echo json_encode($this->response);
    }
    public function update_payment_method()
    {
        $id = $this->input->post('pk');
        $name = $this->input->post('name');
        $value = $this->input->post('value');
        $post_array[$name]      = $value;
        $this->settings->set_table('payment_methods');
        $this->settings->set_primary_key('payment_method_id');
        $this->response = ($this->settings->save($post_array, $id) != 0) ?
                array('status' => 1) :
                array('status' => 0, 'error' => validation_errors('<div class="alert alert-danger"><a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>', '</div>'));
        echo json_encode($this->response);
    }
    public function update_additional_taxes()
    {
        $id = $this->input->post('pk');
        $name = $this->input->post('name');
        $value = $this->input->post('value');
        $post_array[$name]      = $value;
        $this->settings->set_table('additional_taxes');
        $this->settings->set_primary_key('id');
        $this->response = ($this->settings->save($post_array, $id) != 0) ?
                array('status' => 1) :
                array('status' => 0, 'error' => validation_errors('<div class="alert alert-danger"><a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>', '</div>'));
        echo json_encode($this->response);
    }
    public function change_rate_support() {
        $not_supported = ['BSD', 'GHS', 'GTQ', 'IQS', 'ISK', 'MMK', 'PAB', 'XAF', 'XOF', 'XPF'];
        $currency = $_REQUEST['currency'];

        if (in_array($currency,$not_supported)) {
            echo json_encode(array('not_supported' => 1));
        }
    }
    public function disable_multicurrency() {
        set_option(array(
                'option_name' => "change_currency",
                'option_value' => 0
                )
            );
        echo json_encode(array('success' => 1));
    }
    public function add_notification_messages_category() {
        $post_array = array(
            'category_name'        => $_REQUEST['name']
            );
        $this->settings->set_table('notifications_categories');
        $this->settings->save($post_array);
        echo json_encode(array('status' => 1, 'last' => get_notification_category_id($_REQUEST['name'])));
    }
    public function add_notifications_canned_message() {
        $post_array = array(
            'title'            => htmlentities($_REQUEST['title'], ENT_QUOTES | ENT_IGNORE, "UTF-8"),
            'message'           => htmlentities($_REQUEST['message'], ENT_QUOTES | ENT_IGNORE, "UTF-8")
        );
        $this->settings->set_table('notifications');
        $this->settings->save($post_array);
        echo json_encode(array('status' => 1));
    }
    public function update_notification_canned_messages()
    {
        $id = $this->input->post('pk');
        $name = $this->input->post('name');
        $value = $this->input->post('value');
        $post_array[$name]      = $value;
        $this->settings->set_table('notifications');
        $this->settings->set_primary_key('id');
        $this->response = ($this->settings->save($post_array, $id) != 0) ?
                array('status' => 1) :
                array('status' => 0, 'error' => validation_errors('<div class="alert alert-danger"><a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>', '</div>'));
        echo json_encode($this->response);
    }
}