<?php defined('BASEPATH') OR exit('No direct script access allowed');
/**
 * 
 */
class Settings extends Admin_Controller {
    
    /**
     * Description
     * @return type
     */
    public function __construct(){
        parent::__construct();
        $this->view_data['modal'] = array(
            $this->Template->render('users', 'auth/create_user_modal.phtml', '', true),
            $this->Template->render('settings', 'notification_modal.phtml', '', true),
            $this->Template->render('purchases', 'add_shipping_address_modal.phtml', '', true)
        );
        $this->view_data['externalPluginJs'] = array(
            'https://cdnjs.cloudflare.com/ajax/libs/iCheck/1.0.2/icheck.min.js',
        );
        $this->view_data['pageJs'] = array(
            'settings.js'.'?v='.get_option('stable_version')
        );
        $this->data['breadcrumb'] = anchor('settings', __('header_setting'));
        $this->view_data['content'] = $this->Template->render('users', 'access_deny.phtml', $this->data, TRUE);
    }
    public function index()
    {
        $data = array(
            'breadcrumb'        => anchor('settings/general', __('header_setting')),
            'toolbar'           => "",
            'page_title'        => __('header_setting'),
            'page_description'  => __('message_customize_app'),
            );
        if (can_edit_settings()) {
            $this->view_data['content'] = $this->Template->render('settings', 'general_settings.phtml', $data, true);
        }
        $this->Template->render('templates', 'layout.phtml', $this->view_data);
    }
    public function general_settings()
    {
        $data = array(
            'breadcrumb'        => anchor('settings/general_settings', __('header_setting')),
            'toolbar'           => "",
            'page_title'        => __('header_setting'),
            'page_description'  => __('message_company_settings'),
            'settings' => get_options()
            );
        if (can_edit_settings()) {
            $this->view_data['content'] = $this->Template->render('settings', 'general_settings.phtml', $data, true);
        }
        $this->Template->render('templates', 'layout.phtml', $this->view_data);
    }
    public function advanced()
    {
        if (can_edit_settings()) {
            $smtp_settings = json_decode( get_option('smtp_settings') );
            if ($smtp_settings)
            {
                $smtp = $smtp_settings;
            }
            else
            {
                $smtp = json_decode( json_encode( array( 'smtp_host' => '', 'smtp_user' => '', 'smtp_port' => '', 'smtp_crypto' => '') ) );
            }
            $data = array(
                'breadcrumb'        => anchor('settings/advanced', __('header_advanced')),
                'toolbar'           => "",
                'page_title'        => __('link_advanced'),
                'page_description'  => __('message_advanced_settings'),
                'settings' => get_options(),
                'smtp' => $smtp
                );
            $this->view_data['pageJs'] = array(
                'settings.js'.'?v='.get_option('stable_version')
            );
            $this->view_data['externalPluginJs'] = array(
                'https://cdnjs.cloudflare.com/ajax/libs/iCheck/1.0.2/icheck.min.js'
            );
            $this->view_data['content'] = $this->Template->render('settings', 'advanced.phtml', $data, true);
        }
        $this->Template->render('templates', 'layout.phtml', $this->view_data);
    }
    public function general()
    {
        $data = array(
            'breadcrumb'        => anchor('settings/general', __('header_setting')),
            'toolbar'           => "",
            'page_title'        => __('header_setting'),
            'page_description'  => __('message_customize_app'),
            'settings' => get_options()
            );
        $this->view_data['content'] = $this->Template->render('settings', 'general.phtml', $data, true);
        $this->Template->render('templates', 'layout.phtml', $this->view_data);
    }
    public function shipping_addresses()
    {
        $this->view_data['pageJs'] = array(
            'clients.js'
        );
        if (_has_option('geolocation_enabled')) {
            $this->view_data['externalPluginJs'] = array(
                'https://maps.googleapis.com/maps/api/js?key=AIzaSyCC9-4zhLwMQcrpSgrs_zOkUso0Varmlj0'               
            );
            $this->view_data['localPluginJs'] = array(
                'jgooglemap/jquery.googlemap.js'
            );
        }
        $data = array(
            'breadcrumb'        => anchor('settings/general', __('header_setting')),
            'toolbar'           => "",
            'page_title'        => __('header_setting'),
            'page_description'  => __('message_customize_app'),
            'filter'  => ''
            );
        if (can_edit_settings()) {
            $this->view_data['content'] = $this->Template->render('settings', 'shipping_addresses.phtml', $data, TRUE);
        }
        $this->Template->render('templates', 'layout.phtml', $this->view_data);
    }
    public function edit_shipping_addresses()
    {
        $id = isset($_REQUEST['id']) ? _dID($_REQUEST['id']) : NULL;
    
        $data = array(
            'breadcrumb'        => anchor('settings/general', __('header_setting')),
            'toolbar'           => "",
            'page_title'        => __('header_setting'),
            'page_description'  => __('message_customize_app'),
            'id'   => $id,
            'status' => array(
                '1' => __('label_active'),
                '0' => __('label_inactive')
                ),
            );
        $this->view_data['content'] = $this->Template->render('settings', 'edit_shipping_addresses.phtml', $data, TRUE);
        $this->Template->render('templates', 'layout.phtml', $this->view_data);
    }
    public function payment_gateway_settings()
    {
        if (can_edit_settings()) {
            array_push($this->view_data['pageJs'], 'table-editable.js');
            $payment_methods = [];
            $p_methods = get_payment_methods();
            if ($p_methods)
            {
                foreach ($p_methods as $v) {
                    array_push($payment_methods, __($v->payment_method_name));
                }
            }
            $data = array(
                'breadcrumb'        => anchor('settings/payment_gateway_settings', __('header_setting')),
                'toolbar'           => "",
                'page_title'        => __('header_setting'),
                'page_description'  => __('message_payment_gateway'),
                'settings' => get_options(),
                'payment_method' => $payment_methods
                );
            $this->view_data['content'] = $this->Template->render('settings', 'online_payment_gateway.phtml', $data, true);
        }
        $this->Template->render('templates', 'layout.phtml', $this->view_data);
    }
    public function maps_recaptcha_settings()
    {
        if (can_edit_settings()) {
            $data = array(
                'breadcrumb'        => anchor('settings/recaptcha_settings', __('header_setting')),
                'toolbar'           => "",
                'page_title'        => __('header_setting'),
                'page_description'  => __('message_maps_recaptcha'),
                'settings' => get_options()
                );
            $this->view_data['content'] = $this->Template->render('settings', 'maps_recaptcha.phtml', $data, true);
        }
        $this->Template->render('templates', 'layout.phtml', $this->view_data);
    }
    public function sms_platforms_settings()
    {
        if (can_edit_settings()) {
            $data = array(
                'breadcrumb'        => anchor('settings/payment_gateway_settings', __('header_setting')),
                'toolbar'           => "",
                'page_title'        => __('header_setting'),
                'page_description'  => __('message_payment_gateway'),
                'settings' => get_options(),
                'invoice_status' => array(
                    'Draft' => ucfirst(__('option_draft')),
                    'Unpaid' => ucfirst(__('option_unpaid')),
                    'Paid' => ucfirst(__('option_paid')),
                    'Open' => ucfirst(__('label_opened')),
                    'Paidout' => ucfirst(__('label_paidout')),
                    'Failed' => ucfirst(__('is_failed')),
                    'Expired' => ucfirst(__('label_expired')),
                    'Refunded' => ucfirst(__('label_refunded')),
                    'Pending' => ucfirst(__('label_pending')),
                    'Charged_back' => ucfirst(__('label_charged_back')),
                    'Overdue' => ucfirst(__('option_overdue')),
                    'Cancelled' => ucfirst(__('option_cancelled'))
                    )
                );
            $this->view_data['content'] = $this->Template->render('settings', 'sms_platforms_settings.phtml', $data, true);
        }
        $this->Template->render('templates', 'layout.phtml', $this->view_data);
    }
    public function payment_methods_settings()
    {
        if (can_edit_settings()) {
            array_push($this->view_data['pageJs'], 'table-editable.js');
            $payment_methods = [];
            $p_methods = get_payment_methods();
            if ($p_methods)
            {
                foreach ($p_methods as $v) {
                    array_push($payment_methods, __($v->payment_method_name));
                }
            }
            $data = array(
                'breadcrumb'        => anchor('settings/payment_gateway_settings', __('header_setting')),
                'toolbar'           => "",
                'page_title'        => __('header_setting'),
                'page_description'  => __('message_payment_gateway'),
                'settings' => get_options(),
                'payment_method' => $payment_methods
                );
            $this->view_data['content'] = $this->Template->render('settings', 'payment_methods.phtml', $data, true);
        }
        $this->Template->render('templates', 'layout.phtml', $this->view_data);
    }
    public function additional_taxes_settings()
    {
        if (can_edit_settings()) {
            array_push($this->view_data['pageJs'], 'table-editable.js');
           
            $data = array(
                'breadcrumb'        => anchor('settings/additional_taxes_settings', __('header_additional_taxes_setting')),
                'toolbar'           => "",
                'page_title'        => __('header_additional_taxes_setting'),
                'page_description'  => __('message_additional_taxes'),
                'settings' => get_options()
                );
            $this->view_data['content'] = $this->Template->render('settings', 'additional_taxes_settings.phtml', $data, true);
        }
        $this->Template->render('templates', 'layout.phtml', $this->view_data);
    }
    public function invoice_settings()
    {
        if (can_edit_settings()) {
            $smtp_settings = json_decode( get_option('smtp_settings') );
            if ($smtp_settings)
            {
                $smtp = $smtp_settings;
            }
            else
            {
                $smtp = json_decode( json_encode( array( 'smtp_host' => '', 'smtp_user' => '', 'smtp_port' => '', 'smtp_crypto' => '') ) );
            }
            $data = array(
                'breadcrumb'        => anchor('settings/invoice_settings', __('header_setting')),
                'toolbar'           => "",
                'page_title'        => __('header_setting'),
                'page_description'  => __('message_customize_app'),
                'settings' => get_options(),
                'languages' => array(
                    'en_US' => 'English',
                    'en_GB' => 'English-GB',
                    'nl_NL' => 'Dutch',
                    'fr_FR' => 'Français',
                    'it_IT' => 'Italian',
                    'ar_AR' => 'اللغة العربية',
                    'el_EL' => 'Ελληνικά',
                    'es_ES' => 'Español',
                    'ro' => 'Română',
                    'sv_SE' => 'Svenska'
                    ),
                'invoice_layout' => array(
                    '1' => __('label_default_layout'),
                    '2' => __('label_french_layout'),
                    '3' => __('label_belgian_layout'),
                    '5' => __('label_indian_layout'),
                    '6' => __('label_romanian_layout'),
                    '4' => __('label_custom_layout').'<sup><a href="javascript:;" data-toggle="tooltip" title="'.__("message_custom_invoice_layout").'"> ?</a></sup>'
                    ),
                'smtp' => $smtp
                );
            $this->view_data['pageJs'] = array(
                'summernote-editors.js',
                'settings.js'.'?v='.get_option('stable_version')
            );
            $this->view_data['localPluginJs'] = array(
                'bootstrap-fileinput/bootstrap-fileinput.js'
            );
            $this->view_data['externalPluginJs'] = array(
                'https://cdnjs.cloudflare.com/ajax/libs/iCheck/1.0.2/icheck.min.js',
                'https://cdnjs.cloudflare.com/ajax/libs/summernote/0.8.2/summernote.min.js'
            );
            $this->view_data['content'] = $this->Template->render('settings', 'invoice_settings.phtml', $data, true);
        }
        $this->Template->render('templates', 'layout.phtml', $this->view_data);
    }
    public function proforma_settings()
    {
        if (can_edit_settings()) {
            $data = array(
                'breadcrumb'        => anchor('settings/proforma_settings', __('header_setting')),
                'toolbar'           => "",
                'page_title'        => __('header_setting'),
                'page_description'  => __('message_customize_app'),
                'settings' => get_options(),
                'languages' => array(
                    'en_US' => 'English',
                    'en_GB' => 'English-GB',
                    'nl_NL' => 'Dutch',
                    'fr_FR' => 'Français',
                    'it_IT' => 'Italian',
                    'ar_AR' => 'اللغة العربية',
                    'el_EL' => 'Ελληνικά',
                    'es_ES' => 'Español',
                    'ro' => 'Română',
                    'sv_SE' => 'Svenska'
                    ),
                'proforma_layout' => array(
                    '1' => __('label_default_layout'),
                    '4' => __('label_custom_layout').'<sup><a href="javascript:;" data-toggle="tooltip" title="'.__("message_custom_invoice_layout").'"> ?</a></sup>'
                    ),
                );
            $this->view_data['pageJs'] = array(
                'proforma.js',
            );
            $this->view_data['localPluginJs'] = array(
                'bootstrap-fileinput/bootstrap-fileinput.js'
            );
            $this->view_data['externalPluginJs'] = array(
                'https://cdnjs.cloudflare.com/ajax/libs/iCheck/1.0.2/icheck.min.js',
                'https://cdnjs.cloudflare.com/ajax/libs/summernote/0.8.2/summernote.min.js'
            );
            $this->view_data['content'] = $this->Template->render('settings', 'proforma_settings.phtml', $data, true);
        }
        $this->Template->render('templates', 'layout.phtml', $this->view_data);
    }
    public function order_settings()
    {
        if (can_edit_settings()) {
            $data = array(
                'breadcrumb'        => anchor('settings/order_settings', __('header_setting')),
                'toolbar'           => "",
                'page_title'        => __('header_setting'),
                'page_description'  => __('message_customize_app'),
                'settings' => get_options(),
                'order_layout' => array(
                    '1' => __('label_default_layout'),
                    '5' => __('label_indian_layout'),
                    '4' => __('label_custom_layout').'<sup><a href="javascript:;" data-toggle="tooltip" title="'.__("message_custom_order_layout").'"> ?</a></sup>'
                    )
                );
            $this->view_data['pageJs'] = array(
                'order-settings.js'.'?v='.get_option('stable_version')
            );
            $this->view_data['externalPluginJs'] = array(
                'https://cdnjs.cloudflare.com/ajax/libs/iCheck/1.0.2/icheck.min.js',
                'https://cdnjs.cloudflare.com/ajax/libs/summernote/0.8.2/summernote.min.js'
            );
            $this->view_data['content'] = $this->Template->render('settings', 'order_settings.phtml', $data, true);
        }
        $this->Template->render('templates', 'layout.phtml', $this->view_data);
    }
    public function branding_settings()
    {
        if (can_edit_settings()) {
            $smtp_settings = json_decode( get_option('smtp_settings') );
            if ($smtp_settings)
            {
                $smtp = $smtp_settings;
            }
            else
            {
                $smtp = json_decode( json_encode( array( 'smtp_host' => '', 'smtp_user' => '', 'smtp_port' => '', 'smtp_crypto' => '') ) );
            }
            $data = array(
                'breadcrumb'        => anchor('settings/invoice_settings', __('header_setting')),
                'toolbar'           => "",
                'page_title'        => __('header_setting'),
                'page_description'  => __('message_customize_app'),
                'settings' => get_options(),
                'languages' => array(
                    'en_US' => 'English',
                    'en_GB' => 'English-GB',
                    'nl_NL' => 'Dutch',
                    'fr_FR' => 'Français',
                    'it_IT' => 'Italian',
                    'ar_AR' => 'اللغة العربية',
                    'el_EL' => 'Ελληνικά',
                    'es_ES' => 'Español',
                    'ro' => 'Română',
                    'sv_SE' => 'Svenska'
                    ),
                'invoice_layout' => array(
                    '1' => __('label_default_layout'),
                    '2' => __('label_french_layout'),
                    '3' => __('label_belgian_layout'),
                    '5' => __('label_indian_layout'),
                    '6' => __('label_romanian_layout'),
                    '4' => __('label_custom_layout')
                    ),
                'smtp' => $smtp
                );
            $this->view_data['pageJs'] = array(
                'summernote-editors.js',
                'settings.js'.'?v='.get_option('stable_version')
            );
            $this->view_data['localPluginJs'] = array(
                'bootstrap-fileinput/bootstrap-fileinput.js'
            );
            $this->view_data['externalPluginJs'] = array(
                'https://cdnjs.cloudflare.com/ajax/libs/summernote/0.8.2/summernote.min.js'
            );
            $this->view_data['content'] = $this->Template->render('settings', 'branding_settings.phtml', $data, true);
        }
        $this->Template->render('templates', 'layout.phtml', $this->view_data);
    }
    public function quote_settings()
    {
        if (can_edit_settings()) {
            $smtp_settings = json_decode( get_option('smtp_settings') );
            if ($smtp_settings)
            {
                $smtp = $smtp_settings;
            }
            else
            {
                $smtp = json_decode( json_encode( array( 'smtp_host' => '', 'smtp_user' => '', 'smtp_port' => '', 'smtp_crypto' => '') ) );
            }
            $data = array(
                'breadcrumb'        => anchor('settings/invoice_settings', __('header_setting')),
                'toolbar'           => "",
                'page_title'        => __('header_setting'),
                'page_description'  => __('message_customize_app'),
                'settings' => get_options(),
                'languages' => array(
                    'en_US' => 'English',
                    'en_GB' => 'English-GB',
                    'nl_NL' => 'Dutch',
                    'fr_FR' => 'Français',
                    'it_IT' => 'Italian',
                    'ar_AR' => 'اللغة العربية',
                    'el_EL' => 'Ελληνικά',
                    'es_ES' => 'Español',
                    'ro' => 'Română',
                    'sv_SE' => 'Svenska'
                    ),
                'invoice_layout' => array(
                    '1' => __('label_default_layout'),
                    '2' => __('label_french_layout'),
                    '3' => __('label_belgian_layout'),
                    '5' => __('label_indian_layout'),
                    '6' => __('label_romanian_layout'),
                    '4' => __('label_custom_layout').'<sup><a href="javascript:;" data-toggle="tooltip" title="'.__("message_custom_quote_layout").'"> ?</a></sup>'
                    ),
                'smtp' => $smtp
                );
            $this->view_data['pageJs'] = array(
                'summernote-editors.js',
                'settings.js'.'?v='.get_option('stable_version')
            );
            $this->view_data['localPluginJs'] = array(
                'bootstrap-fileinput/bootstrap-fileinput.js'
            );
            $this->view_data['externalPluginJs'] = array(
                'https://cdnjs.cloudflare.com/ajax/libs/iCheck/1.0.2/icheck.min.js',
                'https://cdnjs.cloudflare.com/ajax/libs/summernote/0.8.2/summernote.min.js'
            );
            $this->view_data['content'] = $this->Template->render('settings', 'quote_settings.phtml', $data, true);
        }
        $this->Template->render('templates', 'layout.phtml', $this->view_data);
    }
    public function region_format()
    {
        if (can_edit_settings()) {
            $smtp_settings = json_decode( get_option('smtp_settings') );
            if ($smtp_settings)
            {
                $smtp = $smtp_settings;
            }
            else
            {
                $smtp = json_decode( json_encode( array( 'smtp_host' => '', 'smtp_user' => '', 'smtp_port' => '', 'smtp_crypto' => '') ) );
            }
            $data = array(
                'breadcrumb'        => anchor('settings/invoice_settings', __('header_setting')),
                'toolbar'           => "",
                'page_title'        => __('header_setting'),
                'page_description'  => __('message_customize_app'),
                'settings' => get_options(),
                'languages' => array(
                    'en_US' => 'English',
                    'en_GB' => 'English-GB',
                    'nl_NL' => 'Dutch',
                    'fr_FR' => 'Français',
                    'it_IT' => 'Italian',
                    'ar_AR' => 'اللغة العربية',
                    'el_EL' => 'Ελληνικά',
                    'es_ES' => 'Español',
                    'ro' => 'Română',
                    'sv_SE' => 'Svenska'
                    ),
                'invoice_layout' => array(
                    '1' => __('label_default_layout'),
                    '2' => __('label_french_layout'),
                    '3' => __('label_belgian_layout'),
                    '5' => __('label_indian_layout'),
                    '6' => __('label_romanian_layout'),
                    '4' => __('label_custom_layout')
                    ),
                'themes' => array(
                    'default' => __('label_theme_default'),
                    'custom' => __('label_theme_custom')
                ),
                'smtp' => $smtp
                );
            $this->view_data['pageJs'] = array(
                'settings.js'.'?v='.get_option('stable_version')
            );
            $this->view_data['externalPluginJs'] = array(
                'https://cdnjs.cloudflare.com/ajax/libs/iCheck/1.0.2/icheck.min.js',
            );
            $this->view_data['content'] = $this->Template->render('settings', 'region_format.phtml', $data, true);
        }
        $this->Template->render('templates', 'layout.phtml', $this->view_data);
    }
    public function users_settings()
    {
        $data = array(
            'breadcrumb'        => anchor('settings/users_settings', __('header_setting')),
            'toolbar'           => "",
            'page_title'        => __('header_setting'),
            'page_description'  => __('message_users_settings'),
            'categories'        => $this->get_groups('array'),
            'message' => (validation_errors()) ? validation_errors() : $this->session->flashdata('message')
        );
        //list the users
        $data['users'] = $this->ion_auth->users()->result();
        foreach ($data['users'] as $k => $user)
        {
            $data['users'][$k]->groups = $this->ion_auth->get_users_groups($user->id)->result();
        }
        $this->view_data['page_header'] = $this->Template->render('settings', 'page_header.phtml', '', true);
        if (can_user_manage_access()) {
            $this->view_data['content'] = $this->Template->render('settings', 'users_settings.phtml', $data, true);
        }
        $this->Template->render('templates', 'layout.phtml', $this->view_data);
    }
    public function get_payment_methods()
    {
        echo json_encode(get_payment_methods());
    }
    public function get_additional_taxes()
    {
        echo json_encode(get_additional_taxes());
    }
    public function get_additional_taxes_table()
    {
        $list = [];
        $taxes = get_additional_taxes();
        if ($taxes)
        {
            foreach ($taxes as $tax) {
                array_push($list, array(
                    'id'                         => $tax->id,
                    'additional_tax_name'        => $tax->additional_tax_name,
                    'additional_tax_rate'        => $tax->additional_tax_rate,
                    'additional_tax_rate'        => $tax->additional_tax_rate,
                    'additional_tax_criteria'    => __($tax->additional_tax_criteria),
                    )
                );
            }
        }
        echo json_encode($list);
    }
    public function delete_payment_method()
    {
        $protected = [];
        $to_del = [];
        $ids = $_REQUEST['id'];
        $response = [];
        if (is_array($ids))
        {
            foreach ($ids as $i) {
                if (is_method_in_use($i) )
                {
                    array_push($protected, $i);
                }
                else
                {
                    array_push($to_del, $i);
                }
            }
            $response['success']  = count($to_del);
            $response['fail'] = count($protected);

            if(!empty($to_del))
            {
                delete('payment_methods', 'payment_method_id', $to_del);
            }
        }
        echo json_encode($response);
    }
    public function delete_additional_taxes()
    {
        $protected = [];
        $to_del = [];
        $ids = $_REQUEST['id'];
        $response = [];
        if (is_array($ids))
        {
            foreach ($ids as $i) {
                array_push($to_del, $i);
            }
            $response['success']  = count($to_del);
            $response['fail'] = count($protected);

            if(!empty($to_del))
            {
                delete('additional_taxes', 'id', $to_del);
            }
        }
        echo json_encode($response);
    }
    public function save_purchase_code()
    {
        $purchase_code = $_REQUEST['purchase_code'];
        set_option(array('option_name' => 'purchase_code', 'option_value' => $purchase_code));
        echo json_encode(array('success', 1));
    }
    public function import($entity = null) {
        $entity = isset($entity) ? $entity : $_REQUEST['entity'];
        switch ($entity) {
            case 'customer':
                $data = array(
                    'breadcrumb'        => anchor('clients', __('link_clients')),
                    'toolbar'           => "",
                    'page_title'        => __('title_bulk_import'),
                    'page_description'  => __('subtitle_bulk_import'),
                    'entity'            => 'customer',
                    'db_vars'           => '<code>name_company</code>: '. __('help_name_company'). '<br />
                                            <code>client_email</code>: '. __('help_email'). '<br />
                                            <code>client_status</code>: '. __('help_person_status'). '<br />
                                            <code>client_type</code>: '. __('help_client_type'). '<br />
                                            <code>client_credit</code>: '. __('help_credit'). '<br />
                                            <code>client_custom_id</code>: '. __('help_id'). '<br />
                                            <code>client_address1</code>: '. __('help_address1'). '<br />
                                            <code>client_address2</code>: '. __('help_address2'). '<br />
                                            <code>client_city</code>: '. __('help_city'). '<br />
                                            <code>client_state</code>: '. __('help_state'). '<br />
                                            <code>client_postcode</code>: '. __('help_postcode'). '<br />
                                            <code>client_country</code>: '. __('help_country'). '<br />
                                            <code>client_phone</code>: '. __('help_phone'). '<br />
                                            <code>client_date_created</code>: '. __('help_date_created'). '<br />
                                            <code>client_tax_number</code>: '. __('help_tax_number'). '<br />
                                            <code>client_bank_number</code>: '. __('help_bank_number'). '<br />
                                            <code>client_website</code>: '. __('help_website'). '<br />
                                            <code>client_term_payment</code>: '. __('help_term_payment'). '<br />
                                            <code>client_change_rate</code>: '. __('help_change_rate'). '<br />
                                            <code>client_notes</code>: '. __('help_notes'). '<br />
                                            <code>client_language</code>: '. __('help_language'). '<br />
                                            <code>client_currency</code>: '. __('help_currency'). '<br />
                                            <code>client_bank_name</code>: '. __('help_bank_name'). '<br />
                                            <code>client_chamber_com</code>: '. __('help_chamber_com'). '<br />',
                    'csv_demo'          => 
'"name_company",client_email,"client_phone",client_date_created
"On\'Eric Computing",akaffou.eric@me.com,33643098015,2018-01-12
MyCompany,mycompany@yahoo.com,33643098015,2018-01-15
MyTestCompany,mytest@gmail.fr,33643098015,2018-01-20
"MyOtherCompany",myothercompany@gmail.com,33643098015,2018-01-27
OneMoreCompany,onemorecompany@gmail.com,33643098015,2018-01-31
"MyNewCopany",mynewcompany@gmail.com,33643098015,2018-02-01
"ThisIsANewOne",thisisanew@hotmail.fr,0102030405,2018-02-04
"CompanyTest",OneNew@gmail.com,33643098015,2018-02-05
GreatCompany,great@great.com,33643098015,2018-02-06
LastOne,lastone@gmail.com,33643098015,2018-02-08'
                    );
                $this->view_data['content'] = $this->Template->render('settings', 'importer.phtml', $data, true);
                break;
            case 'provider':
                $data = array(
                    'breadcrumb'        => anchor('providers', __('link_providers')),
                    'toolbar'           => "",
                    'page_title'        => __('title_bulk_import'),
                    'page_description'  => __('subtitle_bulk_import'),
                    'entity'            => 'provider',
                    'db_vars'           => '<code>name_company</code>: '. __('help_name_company'). '<br />
                                            <code>provider_email</code>: '. __('help_email'). '<br />
                                            <code>provider_contact1_email</code>: '. __('help_email'). '<br />
                                            <code>provider_contact2_email</code>: '. __('help_email'). '<br />
                                            <code>provider_fax</code>: '. __('help_fax'). '<br />
                                            <code>provider_code</code>: '. __('help_id'). '<br />
                                            <code>provider_address1</code>: '. __('help_address1'). '<br />
                                            <code>provider_contact1</code>: '. __('help_name_company'). '<br />
                                            <code>provider_contact2</code>: '. __('help_name_company'). '<br />
                                            <code>provider_address2</code>: '. __('help_address2'). '<br />
                                            <code>provider_city</code>: '. __('help_city'). '<br />
                                            <code>provider_state</code>: '. __('help_state'). '<br />
                                            <code>provider_postcode</code>: '. __('help_postcode'). '<br />
                                            <code>provider_country</code>: '. __('help_country'). '<br />
                                            <code>provider_phone</code>: '. __('help_phone'). '<br />
                                            <code>provider_date_created</code>: '. __('help_date_created'). '<br />
                                            <code>provider_location</code>: '. __('help_location'). '<br />
                                            <code>provider_tax_id</code>: '. __('help_tax_number'). '<br />
                                            <code>provider_bank_number</code>: '. __('help_bank_number'). '<br />
                                            <code>provider_notes</code>: '. __('help_notes'). '<br />
                                            <code>provider_status</code>: '. __('help_person_status'). '<br />
                                            <code>provider_language</code>: '. __('help_language'). '<br />
                                            <code>provider_currency</code>: '. __('help_currency'). '<br />
                                            <code>provider_bank_name</code>: '. __('help_bank_name'). '<br />
                                            <code>provider_bank_name</code>: '. __('help_bank_name'). '<br />
                                            <code>provider_type</code>: '. __('help_client_type'). '<br />
                                            <code>provider_chamber_com</code>: '. __('help_chamber_com'). '<br />',
                    'csv_demo'          => 
'"name_company",provider_email,"provider_phone","provider_contact1","provider_contact1_email","provider_contact2","provider_contact2_email",provider_date_created
"Apple Inc.",akaffou.eric@me.com,33643078999,"Eric Claver AKAFFOU",akaffou.eric@me.com,"Eric AKAFFOU",akaffou.eric@me.com,2018-01-30'
                    );
                $this->view_data['content'] = $this->Template->render('settings', 'importer.phtml', $data, true);
                break;
            case 'product':
                $data = array(
                    'breadcrumb'        => anchor('items', __('link_items')),
                    'toolbar'           => "",
                    'page_title'        => __('title_bulk_import'),
                    'page_description'  => __('subtitle_bulk_import'),
                    'entity'            => 'product',
                    'db_vars'           => '<code>sku</code>: '. __('help_sku'). '<br />
                                            <code>name</code>: '. __('help_name'). '<br />
                                            <code>group_id</code>: '. __('help_group'). '<br />
                                            <code>description</code>: '. __('help_description'). '<br />
                                            <code>price</code>: '. __('help_price'). '<br />
                                            <code>item_profit</code>: '. __('help_profit'). '<br />
                                            <code>purchase_price</code>: '. __('help_purchase_price'). '<br />
                                            <code>provider_contact</code>: '. __('help_contact'). '<br />
                                            <code>current_stock</code>: '. __('help_stock'). '<br />
                                            <code>initial_stock</code>: '. __('help_initial_stock'). '<br />
                                            <code>tax_id</code>: '. __('help_tax_id'). '<br />
                                            <code>item_status</code>: '. __('help_status'). '<br />
                                            <code>track_inventory</code>: '. __('help_track_inventory'). '<br />
                                            <code>reorder_point</code>: '. __('help_reorder_point'). '<br />
                                            <code>on_hand_stock</code>: '. __('help_on_hand_stock'). '<br />
                                            <code>product_ean13</code>: '. __('help_ean13'). '<br />
                                            <code>provider_name</code>: '. __('help_name'). '<br />',
                    'csv_demo'          => 
'sku,name,price
MON-RTW-Y81,iPad Pro,1372.00
GRP-EY9-V69,iMac 27,1980.00
SUE-IJG-IOH,MicroSoft Surface,900.30
UIJ-POU-IOU,iPhone X,1390.00
ACM-8SG-R19,Keyboard,10.00'
                    );
                $this->view_data['content'] = $this->Template->render('settings', 'importer.phtml', $data, true);
                break;
            case 'service':
                $data = array(
                    'breadcrumb'        => anchor('services', __('link_services')),
                    'toolbar'           => "",
                    'page_title'        => __('title_bulk_import'),
                    'page_description'  => __('subtitle_bulk_import'),
                    'entity'            => 'service',
                    'db_vars'           => '<code>sku</code>: '. __('help_sku'). '<br />
                                            <code>name</code>: '. __('help_name'). '<br />
                                            <code>group_id</code>: '. __('help_group'). '<br />
                                            <code>description</code>: '. __('help_description'). '<br />
                                            <code>price</code>: '. __('help_price'). '<br />
                                            <code>item_profit</code>: '. __('help_profit'). '<br />
                                            <code>purchase_price</code>: '. __('help_purchase_price'). '<br />
                                            <code>provider_contact</code>: '. __('help_contact'). '<br />
                                            <code>current_stock</code>: '. __('help_stock'). '<br />
                                            <code>initial_stock</code>: '. __('help_initial_stock'). '<br />
                                            <code>tax_id</code>: '. __('help_tax_id'). '<br />
                                            <code>item_status</code>: '. __('help_item_status'). '<br />
                                            <code>track_inventory</code>: '. __('help_track_inventory'). '<br />
                                            <code>reorder_point</code>: '. __('help_reorder_point'). '<br />
                                            <code>on_hand_stock</code>: '. __('help_on_hand_stock'). '<br />
                                            <code>product_ean13</code>: '. __('help_ean13'). '<br />
                                            <code>provider_name</code>: '. __('help_name'). '<br />',
                    'csv_demo'          => 
'sku,name,price
MON-RTW-Y81,Fedx,12.00'
                    );
                $this->view_data['content'] = $this->Template->render('settings', 'importer.phtml', $data, true);
                break;
                case 'bank_statement':
                $data = array(
                    'breadcrumb'        => anchor('charges', __('link_charges')),
                    'toolbar'           => "",
                    'page_title'        => __('title_bulk_import'),
                    'page_description'  => __('subtitle_bulk_import')
                    );
                $this->view_data['content'] = $this->Template->render('settings', 'ofx_importer.phtml', $data, true);
            default:
                $data = array(
                    'breadcrumb'        => "",
                    'toolbar'           => "",
                    'page_title'        => __('title_bulk_import'),
                    'page_description'  => "",
                    'entity'            => '',
                    'db_vars'           => ''
                    );
        }
        $this->view_data['localPluginJs'] = array(
            'bootstrap-fileinput/bootstrap-fileinput.js'
        );
        $this->Template->render('templates', 'layout.phtml', $this->view_data);
    }
    public function get_groups($type=null)
    {
        $groups = [];
        $results = get_charges_categories();
        if($results)
        {
            foreach ($results as $group) {
                array_push($groups, array(
                    'group_id'          => $group->group_id,
                    'group_name'        => get_charges_category($group->group_id),
                    'group_description' => $group->group_description
                    )
                );
            }
        }
        if(!$type)
        {
            echo json_encode($groups);
        }
        else if($type == 'array')
        {
            return $groups;
        }
    }
    public function update()
    {
        $data = array(
            'breadcrumb'        => anchor('settings/general', __('header_update')),
            'toolbar'           => "",
            'page_title'        => __('header_update'),
            'page_description'  => __('message_automatic_update'),
            );
        if (can_edit_settings()) {
            $this->view_data['content'] = $this->Template->render('settings', 'update.phtml', $data, true);
        }
        $this->Template->render('templates', 'layout.phtml', $this->view_data);
    }
    public function get_addresses_list() {
        $list = [];

        $addresses = get_company_shipment_addresses();
        if ($addresses)
        {
            foreach ($addresses as &$addr) {
                if (isset($addr->address1) && $addr->postcode && $addr->city && $addr->country)
                {
                    $address = $addr->address1 . ' ' . $addr->postcode . ' ' . $addr->city . ' ' . get_countries($addr->country);
                }
                else
                {
                    $address = false;
                }
                array_push($list, array(
                    'client_id'           => $addr->id,
                    'enc_client_id'       => _eID($addr->id),
                    'name_company'        => $addr->name_company,
                    'client_phone'        => $addr->phone,
                    'client_address'      => $address,
                    'client_status'       => $addr->status,
                    'client_status_str'   => status_str($addr->status)
                    )
                );
            }
            unset($addr);
        }
        echo json_encode($list);
    }
    public function delete_address()
    {
        $ids = _dID($_REQUEST['id']);
        delete_shipping_address($ids);
        $response['success']  = count($ids);
        $response['fail'] = 0;
        echo json_encode($response);
    }
    public function install($entity = null) {
        $entity = isset($entity) ? $entity : $_REQUEST['entity'];
        $data = [];
        switch ($entity) {
            case 'plugin':
                $this->view_data['content'] = $this->Template->render('settings', 'install_plugin.phtml', $data, true);
                break;
        }
        $this->Template->render('templates', 'layout.phtml', $this->view_data);
    }
    public function notifications() {
        $this->view_data['pageJs'] = array(
            'notifications.js',
            'table-editable.js'
        );
        $data = array(
            'breadcrumb'        => anchor('settings/general', __('header_setting')),
            'toolbar'           => "",
            'page_title'        => __('header_setting'),
            'page_description'  => __('label_notifications'),
            );
        if (can_edit_settings()) {
            $this->view_data['page_header'] = $this->Template->render('settings', 'notification_page_header.phtml', '', true);
            $this->view_data['content'] = $this->Template->render('settings', 'notifications.phtml', $data, true);
        }
        $this->Template->render('templates', 'layout.phtml', $this->view_data);
    }
    public function get_notification_canned_messages_categories() {
        $list = [];
        $categories = get_notification_categories();
        if ($categories) {
            foreach ($categories as $category) {
                array_push($list, array(
                    'id' => $category->id,
                    'text' => $message->category_name,
                ));
            }
        }
        echo json_encode($list);
    }
    public function get_notification_canned_messages() {
        $list = [];
        $messages = get_notification_messages();
        if ($messages) {
            foreach ($messages as $message) {
                array_push($list, array(
                    'id' => $message->id,
                    'category_id' => $message->category_id,
                    'title' => $message->title,
                    'message' => $message->message,
                    'status' => 0 == $message->active ? __('label_inactive') : __('label_displayed'),
                    'active' => $message->active
                ));
            }
        }
        echo json_encode($list);
    }
    public function delete_notification_messages() {
        $ids = $_REQUEST['id'];
        $response = [];
        if (is_array($ids))
        {
            foreach ($ids as $i) {
                delete('notifications', 'id', $i);
            }
            $response['success']  = 1;
        }
        echo json_encode($response);
    }
    public function activate_customer_portal_message()
    {
        $messages = get_notification_messages();
        if ($messages) {
            foreach ($messages as $m) {
                desactivate('notifications', 'active', 'id', $m->id);
            }
        }
        $ids = $_REQUEST['id'];
        if (is_array($ids))
        {
            foreach ($ids as $i) {
                activate('notifications', 'active', 'id', $i);
                set_client_portal_message($i);
            }
        }        
        echo json_encode(array('success' => 1));
    }
    public function desactivate_customer_portal_message()
    {
        $ids = $_REQUEST['id'];
        $response = [];
        if (is_array($ids))
        {
            foreach ($ids as $i) {
                desactivate('notifications', 'active', 'id', $i);
                unset_client_portal_message($i);
            }
        }
        echo json_encode(array('success' => 1));
    }
    public function mass_notification_emails()
    {
        $ids = $_REQUEST['id'];
        $clients = clients(1);
        if (is_array($ids))
        {
            foreach ($ids as $i) {
                $message = get_client_portal_message($i, 'message');
                $subject = get_client_portal_message($i, 'title');

                if ($clients) {
                    foreach ($clients as $client) {

                        $this->load->helper('file');
                        $client_id = $client->client_id;
                        $to = $client->client_email;

                        $lang = lang_code_to_notif_string( client($client_id, 'client_language' ));
                        $layout = './notifications/' . $lang . '/customers/message.php';
            
                        $template = read_file($layout);
                        $data = [
                            'logo_url' => base_url('uploads/admin/img/'). get_option('logo'),
                            'title' => $subject,
                            'message' => $message,
                            'to_name' => client($client_id, 'name_company' ),
                            'client_account' => base_url('index.php/client/index?id=') . _eID($client_id),
                            'btn_client_account' => __( 'btn_client_account', $client_id )
                        ];
                        $formatted_message = $this->parser->parse_string($template, $data, true);

                        if ($client_id) {
                            $client_cc = json_decode( null !== client($client_id, 'client_cc' ) ? client($client_id, 'client_cc' ): json_encode( array() ));
                        }
                        send_email($to, $formatted_message, $subject, null, $client_cc);
                    }
                }
            }
        }
        echo json_encode(array('success' => 1));
    }
}