<?php defined('BASEPATH') OR exit('No direct script access allowed');
/**
 * 
 */
class Stocks extends Admin_Controller {
	
	public function __construct()
	{
		parent::__construct();
		$this->load->model('products/products_model', 'items');
		$this->data['breadcrumb'] = anchor('stocks', __('link_stocks'));
		$this->view_data['content'] = $this->Template->render('users', 'access_deny.phtml', $this->data, TRUE);
	}
	public function index()
	{
		$this->view_data['pageJs'] = array(
            'datatable.js',
            'table-editable.js'
        );
        $data = array(
        	'breadcrumb' 		=> anchor('stocks', __('link_stocks')),
			'toolbar'    		=> "",
			'page_title' 		=> __('link_stocks'),
			'page_description' 	=> __('message_manage') .' '.__('link_stocks'),
			'filter' 	=> 'All',
			);
        if (can_access('items')) {
        	$this->view_data['page_header'] = $this->Template->render('products', 'page_header_stocks.phtml', '', true);
			$this->view_data['content'] = $this->Template->render('stocks', 'index.phtml', $data, true);
		}
		$this->Template->render('templates', 'layout.phtml', $this->view_data);
	}
	public function inventory()
	{
		$rows = [];
		$list = [];
		$pagination = false;
		$filter = isset($_REQUEST['filter']) ? $_REQUEST['filter'] : null;
		$order = isset($_REQUEST['order']) ? $_REQUEST['order'] : 'asc';
		$sort = isset($_REQUEST['sort']) ? $_REQUEST['sort'] : 'name';
		$offset = isset($_REQUEST['offset']) ? $_REQUEST['offset'] : 0;
		$limit = isset($_REQUEST['limit']) ? $_REQUEST['limit'] : 10;
		$search = isset($_REQUEST['search']) ? $_REQUEST['search'] : '';

		if (1 == get_option('server_side_pagination')) {
			$pagination = true;
		}

		$stocks = $this->items->get_items_stocks(
			array(
				'status' => $filter,
				'order' => $order,
				'sort' => $sort,
				'offset' => $offset,
				'limit' => $limit, 
				'search' => $search,
				'pagination' => $pagination
			)
		);
		if ($stocks)
		{
			foreach ($stocks as $stock) {
				array_push($rows, array(
					'item_id' 			  	 => $stock->item_id,
					'sku'          			 => $stock->sku,
					'name'   	  			 => $stock->name,
					'reorder_point'  		 => $stock->reorder_point,
					'on_hand_stock'		 	 => $stock->on_hand_stock,
					'committed'				 => $stock->committed,
					'ordered'			     => $stock->ordered,
					'available'			     => $stock->available,
					'valuation'				 => $stock->valuation
					)
				);
			}
			if ( $search) {
				$list = array(
					'total' => count($items),
					'totalNotFiltered' => count($items),
					'rows' => $rows
				);
			} else {
				$total = $this->items->count_items();
				$list = array(
					'total' => $total,
					'totalNotFiltered' => $total,
					'rows' => $rows
				);
			}
		}
		echo 1 == get_option('server_side_pagination') ? json_encode($list) :json_encode($rows);
	}
}