<?php
require_once('vendor/autoload.php');

class Stripe_return extends Basic_Controller
{
	protected $stripe;
	protected $invoice_number;
	protected $payment_status = "Unpaid";
	protected $payment_id;
	public function __construct()
	{
		parent::__construct();
		$this->stripe = array(
		  "secret_key"      => get_option('stripe_secret_key'),
		  "publishable_key" => get_option('stripe_publishable_key')
		);

		\Stripe\Stripe::setApiKey($this->stripe['secret_key']);
	}
	public function charge()
	{
		$token  			= $_REQUEST['token'];
		$amount  			= $_REQUEST['amount'];
		$currency  			= $_REQUEST['currency'];
		$this->invoice_number  	= $_REQUEST['invoicenumber'];

		// Retrieve the email used by the customer
		$stripeinfo = \Stripe\Token::retrieve($token);
		$email = $stripeinfo->email;
		$customer 			= \Stripe\Customer::create(array(
			'email' => $email,
			'source'  => $token
		  ));

		$charge = \Stripe\Charge::create(array(
		  'customer' 		=> $customer->id,
		  'amount'   		=> $amount,
		  'currency' 		=> $currency,
		  'description' 	=> __('invoices_invoice') . " " . $this->invoice_number,
		  'metadata'	 	=> array("order_id" => $this->invoice_number)
		));

		$this->payment_id = $charge['balance_transaction'];
		if ($charge['status'] === 'succeeded')
		{
			$this->payment_status = 'Paid';
			$this->load->library('m_manager');
			$this->m_manager->mass_payment_stripe(array($this->invoice_number), $this->payment_id);
			update_invoice_status($this->invoice_number, $this->payment_status, $this->payment_id);
		}
		else
		{
			$this->payment_status = 'Unpaid';
			update_invoice_status($this->invoice_number, $this->payment_status, $this->payment_id);
		}
		$status = invoice_status($this->invoice_number);
		$client_id = get_client($this->invoice_number);
		switch ($status) {
			case 'is_cancelled':
				$status = __('label_opened');
				break;
			case 'is_paid':
				$status = __('label_paid');
				break;
			case 'is_refunded':
				$status = __('label_refunded');
				break;
			case 'is_opened':
				$status = __('label_opened');
				break;
			case 'is_failed':
				$status = __('label_failed');
				break;
			case 'is_expired':
				$status = __('label_expired');
				break;
			case 'is_paidout':
				$status = __('label_paidout');
				break;
			case 'is_charged_back':
				$status = __('label_charged_back');
				break;
			default:
				$status = __('label_opened');
				break;
		}
		$data = array(
			'status' => $status,
			'invoice_url' => base_url('index.php/viewinvoice/view?id=') . _eID($this->invoice_number),
			'profile_url'   => base_url('index.php/client/index?id=') . _eID($client_id)
			);
		echo json_encode($data);
	}
}

