<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
 * 
 */
class Ajax extends Ajax_Controller
{
	/**
	 * Description
	 * @return type
	 */
	public function __construct()
	{
		parent::__construct();
		$this->load->model('support_model', 'support');
	}
	public function add_new_entry()
	{
		$user_language 			= get_option('user_language', 'users_options');
		$is_edit = $this->input->post('is_edit');
		$client_id = $this->input->post('client_id');
		$user_id =  0 != $this->input->post('user_id') ? get_user_var_by_name('first_name', $this->input->post('user_id'), 'id') : user('user_id');
		$duration =  null != $this->input->post('duration') ? $this->input->post('duration') : 0;
		$ticket_id	= $this->input->post('ticket_id');
		$extra_time_to_bill = 0;

		if ($client_id) {
			$client_remaining_time = floatval(client($client_id, 'support_contract')) - floatval($duration);
			if ($client_remaining_time < 0) {
				$extra_time_to_bill = abs($client_remaining_time);
			}
		} else {
			$client_remaining_time = 0;
			$extra_time_to_bill = $duration;
		}

		if ( ! $is_edit) {
			$support_table = array(
				'subject' 					=> $this->input->post('subject'),
				'client_id' 				=> $client_id,
				'user_id' 					=> $user_id,
				'total_duration' 			=> get_support_total_duration($ticket_id, $duration),
				'client_remaining_time' 	=> 0 > $client_remaining_time ? 0: $client_remaining_time,
				'extra_time_to_bill' 		=> $extra_time_to_bill,
				'assigned_to' 				=> 0 != $this->input->post('assigned_to') ? get_user_var_by_name('first_name', $this->input->post('assigned_to'), 'id') : user('user_id'),
				'status' 					=> $this->input->post('status'),
				'created_on'				=> mysqlDate( $user_language, $this->input->post('created_on') )
			);
			$support_details_table = array(
				'title'				=> $this->input->post('title'),
				'message'			=> $this->input->post('message'),
				'ticket_id'			=> $ticket_id,
				'client_id' 		=> $client_id,
				'duration' 			=> $duration,
				'user_id' 			=> $user_id
			);
		} else {
			$support_table = array(
				'client_id' 				=> $client_id,
				'user_id' 					=> $user_id,
				'total_duration' 			=> get_support_total_duration($ticket_id, $duration),
				'client_remaining_time' 	=> 0 > $client_remaining_time ? 0: $client_remaining_time,
				'extra_time_to_bill' 		=> get_support_extra_time($ticket_id, $extra_time_to_bill, '+'),
				'assigned_to' 				=> 0 != $this->input->post('assigned_to') ? $this->input->post('assigned_to') : user('user_id'),
				'status' 					=> $this->input->post('status')
			);
			$support_details_table = array(
				'title'				=> $this->input->post('title'),
				'message'			=> $this->input->post('message'),
				'ticket_id'			=> $ticket_id,
				'client_id' 		=> $client_id,
				'duration' 			=> $duration,
				'user_id' 			=> $user_id
			);
		}
		$config = array(
			array(
				'field' => 'subject',
				'label' => lang('label_subject'),
				'rules' => 'required',
				'errors' => array(
					'required' => lang('error_required_field_error'). '<br />'
				)),
			array(
				'field' => 'title',
				'label' => lang('label_title'),
				'rules' => 'required',
				'errors' => array(
					'required' => lang('error_required_field_error'). '<br />'
				)),
			array(
				'field' => 'duration',
				'label' => lang('label_duration'),
				'rules' => 'required',
				'errors' => array(
					'required' => lang('error_required_field_error'). '<br />'
				)),
			array(
				'field' => 'assigned_to',
				'label' => lang('label_agent'),
				'rules' => 'required',
				'errors' => array(
					'required' => lang('error_required_field_error'). '<br />'
				))
			);
		$this->form_validation->set_rules($config);

		if ($this->form_validation->run() === TRUE) {
			if ( ! $is_edit) {
				$this->support->set_table('support');
				$this->support->save($support_table);

				$this->support->set_table('support_details');
				$this->support->save($support_details_table);

			} else {
				$this->support->set_table('support');
				$this->support->save($support_table, $ticket_id);

				$this->support->set_table('support_details');
				$this->support->save($support_details_table);
			}

			if ($client_id) {
				update_client_support_contract($client_id, $duration, '-');
			}
			echo json_encode(array('status' => 1));
		}
		else
		{
			echo json_encode(array('status' => 0, 'error' => validation_errors()));
		}
	}
}