<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Support extends Admin_Controller {
	public function __construct() {
		parent::__construct();
		$this->view_data['pageJs'] = array(
	        'support.js'
	    );
	}

	public function index() {

		$data = array(
			'breadcrumb' 		=> anchor('support', __('link_support_sheets')),
			'toolbar'    		=> "",
			'page_title' 		=> __('link_support_sheets'),
			'page_description' 	=> __('message_manage') . ' '. __('link_support_sheets'),
			'clients' => clients(),
			'filter'  => ''
			);
		$this->view_data['page_header'] = $this->Template->render('support', 'page_header.phtml', '', true);
		$this->view_data['content'] = $this->Template->render('support', 'index.phtml', $data, TRUE);
		$this->Template->render('templates', 'layout.phtml', $this->view_data);
	}
	public function create_ticket()
	{
		$data = array(
			'breadcrumb' 		=> anchor('support', __('link_support_sheets')),
			'toolbar'    		=> "",
			'page_title' 		=> __('link_support_sheets'),
			'page_description' 	=> __('link_add_new') .' '.__('link_support_sheets'),
			'clients'         	=> clients(),
			'ticket' 			=> create_ticket()
			);
		$this->view_data['modal'] = $this->Template->render('clients', 'add_client_modal.phtml', '', true);
		$this->view_data['content'] = $this->Template->render('support', 'create_ticket.phtml', $data, true);
		$this->Template->render('templates', 'layout.phtml', $this->view_data);
	}
	public function edit() {
		$id = $_REQUEST['id'];
		$data = array(
			'breadcrumb' 		=> anchor('support', __('link_support_sheets')),
			'toolbar'    		=> "",
			'page_title' 		=> "",
			'page_description' 	=> "",
			'ticket' 			=> get_ticket($id),
			'ticket_messages'	=> get_ticket_messages($id),
			'filter'  			=> '',
			'user_language'  	=> get_option('user_language')
			);
		$this->view_data['content'] = $this->Template->render('support', 'edit_ticket.phtml', $data, TRUE);
		$this->Template->render('templates', 'layout.phtml', $this->view_data);
	}

	public function tickets_list()
	{
		$list = [];
		$filter = $this->uri->segment(3);
		$tickets = get_tickets($filter);
		if ($tickets)
		{
			foreach ($tickets as $ticket) {
				array_push($list, array(
					'id' 				  => $ticket->id,
					'subject'			  => $ticket->subject,
					'name_company'		  => 0 != $ticket->client_id ? client($ticket->client_id, 'name_company') : __('label_guest'),
					'email'		 	 	  => 0 != $ticket->client_id ? client($ticket->client_id, 'client_email') : '',
					'updated_on'		  => _fdate( language_string_to_locale_notation( get_option('user_language', 'users_options') ), $ticket->updated_on ),
					'updated_by'		  => get_user_var($ticket->user_id, 'first_name'),
					'updated_by_id'		  => $ticket->user_id,
					'assigned_to_id'	  => $ticket->assigned_to,
					'assigned_to'		  => get_user_var($ticket->assigned_to, 'first_name'),
					'status'		  	  => $ticket->status,
					'support_contract'    => 0 != $ticket->client_id ? floatval(client($ticket->client_id, 'support_contract')) * 60: 0
					)
				);
			}
		}
		echo json_encode($list);
	}
	public function delete_support()
	{
		$ids = $_REQUEST['id'];
		delete('support', 'id', $ids);
		echo json_encode(array('success' => 1));
	}
}