<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
 * 
 */
class Ajax extends Ajax_Controller
{
	/**
	 * Description
	 * @return type
	 */
	public function __construct()
	{
		parent::__construct();
		$this->load->model('taxes_model', 'taxes');
	}
	
	/**
	 * Description
	 * @return type
	 */
	public function create_tax()
	{
		$post_array = array(
			'tax_name'					=> $this->input->post('tax_name'),
			'tax_percent'				=> $this->input->post('tax_percent'),
			'tax_description'			=> $this->input->post('tax_description')
			);
		$config = array(
			array(
				'field' => 'tax_name',
				'label' => __('tax_name'),
				'rules' => 'required',
				'errors' => array(
					'required' => __('error_required_name')
					)
				)
			);
		$this->form_validation->set_rules($config);
		$this->response = ($this->form_validation->run() === TRUE && $this->taxes->create_tax($post_array) != 0) ? 
			array('status' => 1) :
			array('status' => 0, 'error' => validation_errors('<div class="alert alert-danger"><a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>', '</div>'));
		echo json_encode($this->response);
	}
}