<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Tracking extends Admin_Controller
{
	/**
	 * Class constructor
	 * @return type
	 */
	public function __construct()
	{
		parent::__construct();
		$this->data['breadcrumb'] = anchor('tracking', __('link_time_tracking'));
		$this->view_data['content'] = $this->Template->render('users', 'access_deny.phtml', $this->data, TRUE);

	}
	public function index() {

		$this->view_data['pageJs'] = array(
	        'timetracker.js'
	    );
		$data = array(
			'breadcrumb' 		=> anchor('tracking', __('link_time_tracking')),
			'toolbar'    		=> "",
			'page_title' 		=> __('link_time_tracking'),
			'page_description' 	=> __('message_track_project_time')
		);

		// Save timers to database
		$db_data = '';
		$timer = [];

		if (file_exists('./timetracker/timetracker.json')) {
			$db_data = file_get_contents('./timetracker/timetracker.json');
		}
		$json = $db_data;
		$json = json_decode($json, true);

		if ($json) {
			foreach ($json as $value) {
				if ($value['task']) {
					if ( !item_exists($value['task']) )
					{
						$new_item_array = array(
							'sku' => generate_sku(),
							'group_id' => 0,
							'name' => $value['task'],
							'price' => $value['rate'],
							'user_id' => user('user_id')
							);
						$this->load->model('products/products_model', 'items');
						$this->items->set_table('items');
						$this->items->save($new_item_array);
					}
					$timer[] = array(
						'client_id' => get_client_id($value['client']),
						'user_id' => get_user_id_by_name($value['agent']),
						'item_id' => get_item_vars_by_name($value['task'], 'name'),
						'item_sku' => get_item_vars_by_name($value['task'], 'sku'),
						'item_name' => $value['task'],
						'item_price' => $value['rate'],
						'item_quantity' => _durationToHour(gmdate("H:i:s", $value['timed'])),
						'item_non_formatted_quantity' => $value['timed'],
						'item_subtotal' => floatval($value['total']),
						'item_non_formatted_subtotal' => $value['total'],
						'item_description' => $value['desc']
					);
					save_timers($timer);
				}
			}
		}

		if (can_access('time_tracking')) {
			$this->view_data['content'] = $this->Template->render('tracking', 'index.phtml', $data, TRUE);
		}
		$this->view_data['page_header'] = $this->Template->render('tracking', 'page_header.phtml', '', true);
		$this->Template->render('templates', 'layout.phtml', $this->view_data);
	}

	public function task_list() {
		$list = [];

		$results = get_timers();

		if ($results) {
			foreach ($results as $value) {
				if ($value->item_subtotal > 0) {
					array_push($list, array(
						'taskid' => $value->id,
						'client' => client($value->client_id, 'name_company'),
						'task' => $value->item_name,
						'agent' => get_user_var($value->user_id, 'first_name'),
						'rate' => $value->item_price,
						'total' => $value->item_non_formatted_subtotal,
						'timed' => $value->item_non_formatted_quantity,
						'value' => add_currency(format_number($value->item_non_formatted_quantity * (floatval($value->item_price)/3600))),
						'desc' => $value->item_description,
						)
					);
				}
			}
		}
		echo json_encode($list);
	}
	public function merge_tasks() {
		$items = [];
		$ids = $_REQUEST['id'];

		if ($ids && count($ids) > 1) {
			// Insert Items in database
			$item_sku = [];
			$item_id = [];
			$item_name  = [];
			$item_quantity = [];
			$item_price  = [];
			$item_subtotal = [];
			$client_id = [];
			$user_id = [];
			$subtotal = 0;

			$invoice_number = next_invoice_number();
			$invoice_key = getAccountEntityNextId('invoice');

			foreach ($ids as $id) {
				$items = get_tracker_item($id);
				if ($items) {
					foreach ($items as $item) {
						array_push($client_id, $item->client_id);
						array_push($user_id, $item->user_id);
						array_push($item_sku, $item->item_sku);
						array_push($item_id, $item->item_id);
						array_push($item_name, $item->item_name);
						array_push($item_price, $item->item_price);
						array_push($item_quantity, $item->item_quantity);
						array_push($item_subtotal, $item->item_subtotal);
					}
				}
			}
			foreach ($item_subtotal as $value) {
				$subtotal += $value;
			}
			$this->load->model('invoices/invoices_model', 'invoices');

			$invoiceTable 								= []; // All data that will be saved on oc_invoices
			$invoiceTable['change_rate'] 				= 1; // Save change_rate for reference
			$invoiceTable['user_id'] 					= user('user_id');
			$invoiceTable['invoice_number'] 			= $invoice_number;
			$invoiceTable['invoice_key'] 				= $invoice_key;
			$invoiceTable['invoice_status'] 			= 'Draft';
			$invoiceTable['client_id'] 				    = $client_id[0];
			$invoiceTable['date'] 						= date('Y-m-d');
			$invoiceTable['due_date'] 					= date('Y-m-d');
			$invoiceTable['pay_type'] 					= 1;
			$invoiceTable['subtotal'] 					= $subtotal;
			$invoiceTable['tax_amount'] 				= 0;
			$invoiceTable['global_discount'] 			= 0;
			$invoiceTable['discount_amount'] 			= 0;
			$invoiceTable['total'] 						= $subtotal;
			$invoiceTable['notes'] 						= '';
			$invoiceTable['subject'] 					= '';
			$invoiceTable['amount_paid']				= 0;
			$invoiceTable['amount_due']					= $subtotal;
			$invoiceTable['credit_used']				= 0;
			$invoiceTable['sent']						= 0; // Set Invoice to sent or not

			$this->invoices->set_table('invoices');
			$this->invoices->save($invoiceTable);
			$event = array(
				'action' 					=> 'add',
				'referrer' 					=> 'invoices',
				'referrer_id' 				=> $this->db->insert_id(),
				'referrer_value' 			=> $invoice_number,
				'user_id' 					=> user('user_id'),
				'status' 					=> 'success'
			);
			record_event($event);

			$this->invoices->set_table('invoices_items');
			for($i = 0; $i < count($ids); $i++){
				$item_array = array(
					'invoice_number' => $invoice_number,
					'invoice_key' => $invoice_key,
					'client_id' => $client_id[$i],
					'user_id' => $user_id[$i],
					'item_sku' => $item_sku[$i],
					'item_id' => $item_id[$i],
					'item_group' => $this->m_manager->category_id($item_id[$i]),
					'item_name' => addslashes($item_name[$i]),
					'item_uom' => 'hr',
					'item_price' => $item_price[$i],
					'item_quantity' => $item_quantity[$i],
					'item_subtotal' => $item_subtotal[$i],
					'item_recurring' => 1
					);

				$this->invoices->save($item_array);
				$this->response = array('status' => 1);
			}

			// Update next invoice ID
			setAccountEntityId('invoice', $invoice_key);
			echo json_encode(array('success' => 1, 'invoice_number' => _eID($invoice_number)));
		} else {
			echo json_encode(array('fail' => 1));
		}
	}
	public function test() {
		echo json_encode(get_timers());
	}
} 