<?php
/**
 * UPLOAD CLASS CONTROLLER
 */
use Mmanager\Domain\Factory\ParserFactory;

class Upload extends Admin_Controller {
	/**
	 * Class constructor
	 * @return type
	 */
	public function __construct()
	{
		parent::__construct();
	}

	/**
	 * Index page
	 * @return mixed
	 */
	public function index()
	{
		$this->load->view('upload_form', array('error' => ' ' ));
	}

	/**
	 * Handle the file upload
	 * @return json
	 */
	public function do_upload()
	{
		$config['upload_path']          = './uploads/admin/img';
		if( chmod($config['upload_path'], 0755) ) 
        {
            chmod($config['upload_path'], 0777);
        }
		$config['allowed_types']        = 'gif|jpg|png';
		$config['file_name']        	= 'logo';
		$config['overwrite']        	= TRUE;


		$this->load->library('upload', $config);

		if ( ! $this->upload->do_upload('logo'))
		{
			$error = $this->upload->display_errors();
			$this->response = array('status' => 0, 'error' => $error );
		}
		else
		{
			$data = $this->upload->data();
			$table = "options";
			$db_data = array(
				'option_name' => 'logo',
				'option_value' => $data['file_name']
				);

			set_option($db_data);
			$this->response = array('status' => 1);
		}
		echo json_encode($this->response);
	}
	public function user_avatar()
	{
		$config['upload_path']          = './uploads/users/avatars';
		if( chmod($config['upload_path'], 0755) ) 
        {
            chmod($config['upload_path'], 0777);
        }
		$config['allowed_types']        = 'gif|jpg|png';
		$config['file_name']        	= 'avatar' . $this->input->post('user_id');
		$config['overwrite']        	= TRUE;


		$this->load->library('upload', $config);

		if ( ! $this->upload->do_upload('avatar'))
		{
			$error = $this->upload->display_errors();
			$this->response = array('status' => 0, 'error' => $error );
		}
		else
		{
			$data = $this->upload->data();
			$id = $this->input->post('user_id');
			$post_array = array(
				'user_avatar' => $data['file_name'],
				);
			$this->oneric->query("UPDATE {$this->tables['users']} SET ".$this->oneric->get_set($post_array)." WHERE id = " . $id);
			$this->response = array('status' => 1);
		}
		echo json_encode($this->response);
	}
	public function upload_csv() {
		$entity = $_REQUEST['entity'];
		
		$response = [];
		$column_headers = FALSE;
		$initial_line = FALSE;
		$delimiter = 1 == $this->input->post('delimiter') ? ';' : FALSE;
		$detect_line_endings = 1 == $this->input->post('line_ending') ? ';' : FALSE;

		$config['upload_path']          = './uploads/import';
		if (!file_exists($config['upload_path']))
		    mkdir($config['upload_path']);

		if( chmod($config['upload_path'], 0755) ) 
        {
            chmod($config['upload_path'], 0777);
        }
		$config['allowed_types']        = 'csv';
		$config['file_name']        	= 'import';
		$config['overwrite']        	= TRUE;

		$this->load->library('upload', $config);

		if ( ! $this->upload->do_upload('importer'))
		{
			$error = $this->upload->display_errors();
			$response = array('status' => 0, 'error' => $error );
		}
		else
		{
			$filePath = 'uploads/import/import.csv';
			$parser = new ParserFactory();
			$results = $parser->createCsvParser()->parse($filePath, $column_headers, $detect_line_endings, $initial_line, $delimiter);

			switch ($entity) {
				case 'customer':
					$duplicated_key = 'name_company';
					$current_values = get_entity_by($entity, $duplicated_key);
					$duplicated_data = [];
					$new_data = [];
					$table = 'oc_clients';
	
					foreach ($results as $value) {
						$imported[] = array(
							'name_company' => replcSpecChar($value['name_company']),
							'client_email' => isset($value['client_email']) ? $value['client_email']: '',
							'client_phone' => isset($value['client_phone']) ? $value['client_phone']: '',
							'client_address1' => isset($value['client_address1']) ? $value['client_address1']: '',
							'client_address2' => isset($value['client_address2']) ? $value['client_address2']: '',
							'client_city' => isset($value['client_city']) ? $value['client_city']: '',
							'client_state' => isset($value['client_state']) ? $value['client_state']: '',
							'client_postcode' => isset($value['client_postcode']) ? $value['client_postcode']: '',
							'client_country' => isset($value['client_country']) ? $value['client_country']: '',
							'client_notes' => isset($value['client_notes']) ? $value['client_notes']: '',
							'client_status' => isset($value['client_status']) ? $value['client_status']: 1,
							'client_type' => isset($value['client_type']) ? $value['client_type']: 1,
							'client_credit' => isset($value['client_credit']) ? $value['client_credit']: 0,
							'client_tax_number' => isset($value['client_tax_number']) ? $value['client_tax_number']: '',
							'client_bank_number' => isset($value['client_bank_number']) ? $value['client_bank_number']: '',
							'client_custom_id' => isset($value['client_custom_id']) ? $value['client_custom_id']: '',
							'client_website' => isset($value['client_website']) ? $value['client_website']: '',
							'client_term_payment' => isset($value['client_term_payment']) ? $value['client_term_payment']: 3,
							'client_change_rate' => isset($value['client_change_rate']) ? $value['client_change_rate']: 1,
							'client_bank_name' => isset($value['client_bank_name']) ? $value['client_bank_name']: '',
							'client_chamber_com' => isset($value['client_chamber_com']) ? $value['client_chamber_com']: '',
							'client_language' => isset($value['client_language']) ? $value['client_language']: get_option('user_language', 'users_options'),
							'client_currency' => isset($value['client_currency']) ? $value['client_currency']: get_option('user_currency'),
							'client_date_created' => isset($value['client_date_created']) ? mysqlDate( get_option('user_language', 'users_options'), $value['client_date_created'] ) : date('Y-m-d')
						);
					};
					if ($imported) {
						foreach ($imported as $key => $value) {
							if( ! in_array($imported[$key][$duplicated_key], $current_values)) {
								array_push($new_data, $imported[$key]);
								_importFromCsv($table, $imported[$key]);
							}
							else {
								array_push($duplicated_data, $imported[$key][$duplicated_key]);
							}
						}
						$response['success']  = count($new_data);
						$response['fail'] = count($duplicated_data);
						$response['faillist'] = json_encode($duplicated_data);
					}
					echo json_encode($response);
					break;
				case 'provider':
					$duplicated_key = 'name_company';
					$current_values = get_entity_by($entity, $duplicated_key);
					$duplicated_data = [];
					$new_data = [];
					$table = 'oc_providers';
			
					foreach ($results as $value) {
						$imported[] = array(
							'name_company' => $value['name_company'],
							'provider_email' => isset($value['provider_email']) ? $value['provider_email']: '',
							'provider_contact1_email' => isset($value['provider_contact1_email']) ? $value['provider_contact1_email']: '',
							'provider_contact2_email' => isset($value['provider_contact2_email']) ? $value['provider_contact2_email']: '',
							'provider_code' => isset($value['provider_code']) ? $value['provider_code']: '',
							'provider_fax' => isset($value['provider_fax']) ? $value['provider_fax']: '',
							'provider_address1' => isset($value['provider_address1']) ? $value['provider_address1']: '',
							'provider_contact1' => isset($value['provider_contact1']) ? $value['provider_contact1']: '',
							'provider_contact2' => isset($value['provider_contact2']) ? $value['provider_contact2']: '',
							'provider_address2' => isset($value['provider_address2']) ? $value['provider_address2']: '',
							'provider_city' => isset($value['provider_city']) ? $value['provider_city']: '',
							'provider_state' => isset($value['provider_state']) ? $value['provider_state']: '',
							'provider_postcode' => isset($value['provider_postcode']) ? $value['provider_postcode']: '',
							'provider_country' => isset($value['provider_country']) ? $value['provider_country']: '',
							'provider_phone' => isset($value['provider_phone']) ? $value['provider_phone']: '',
							'provider_location' => isset($value['provider_location']) ? $value['provider_location']: '',
							'provider_tax_id' => isset($value['provider_tax_id']) ? $value['provider_tax_id']: '',
							'provider_bank_number' => isset($value['provider_bank_number']) ? $value['provider_bank_number']: '',
							'provider_bank_name' => isset($value['provider_bank_name']) ? $value['provider_bank_name']: '',
							'provider_notes' => isset($value['provider_notes']) ? $value['provider_notes']: '',
							'provider_status' => isset($value['provider_status']) ? $value['provider_status']: 1,
							'provider_language' => isset($value['provider_language']) ? $value['provider_language']: get_option('user_language', 'users_options'),
							'provider_currency' => isset($value['provider_currency']) ? $value['provider_currency']: get_option('user_currency'),
							'provider_tax_number' => isset($value['provider_tax_number']) ? $value['provider_tax_number']: '',
							'provider_bank_number' => isset($value['provider_bank_number']) ? $value['provider_bank_number']: '',
							'provider_type' => isset($value['provider_type']) ? $value['provider_type']: 1,
							'provider_chamber_com' => isset($value['provider_chamber_com']) ? $value['provider_chamber_com']: '',
							'provider_date_created' => isset($value['provider_date_created']) ? mysqlDate( get_option('user_language', 'users_options'), $value['provider_date_created'] ) : date('Y-m-d')
						);
					};
					if ($imported) {
						foreach ($imported as $key => $value) {
							if( ! in_array($imported[$key][$duplicated_key], $current_values)) {
								array_push($new_data, $imported[$key]);
								_importFromCsv($table, $imported[$key]);
							}
							else {
								array_push($duplicated_data, $imported[$key][$duplicated_key]);
							}
						}
						$response['success']  = count($new_data);
						$response['fail'] = count($duplicated_data);
						$response['faillist'] = json_encode($duplicated_data);
					}
					echo json_encode($response);
					break;
				case 'product':
					$duplicated_key = 'name';
					$current_values = get_entity_by($entity, $duplicated_key);
					$duplicated_data = [];
					$new_data = [];
					$table = 'oc_items';

					foreach ($results as $value) {
						$imported[] = array(
							'group_id' => isset($value['group_id']) ? $value['group_id']: 0,
							'sku' => isset($value['sku']) ? $value['sku']: '',
							'name' => $value['name'],
							'description' => isset($value['description']) ? $value['description']: '',
							'price' => isset($value['price']) ? $value['price']: '',
							'purchase_price' => isset($value['purchase_price']) ? $value['purchase_price']: '',
							'item_profit' => isset($value['item_profit']) ? $value['item_profit']: '',
							'provider_name' => isset($value['provider_name']) ? $value['provider_name']: '',
							'provider_contact' => isset($value['provider_contact']) ? $value['provider_contact']: '',
							'current_stock' => isset($value['current_stock']) ? $value['current_stock']: '',
							'tax_id' => isset($value['tax_id']) ? $value['tax_id']: '',
							'item_status' => isset($value['item_status']) ? $value['item_status']: 1,
							'track_inventory' => isset($value['track_inventory']) ? $value['track_inventory']: 1,
							'initial_stock' => isset($value['initial_stock']) ? $value['initial_stock']: '',
							'initial_cost' => isset($value['initial_cost']) ? $value['initial_cost']: '',
							'reorder_point' => isset($value['reorder_point']) ? $value['reorder_point']: '',
							'on_hand_stock' => isset($value['on_hand_stock']) ? $value['on_hand_stock']: '',
							'available' => isset($value['available']) ? $value['available']: '',
							'committed' => isset($value['committed']) ? $value['committed']: '',
							'ordered' => isset($value['ordered']) ? $value['ordered']: '',
							'valuation' => isset($value['valuation']) ? $value['valuation']: '',
							'next_stock_warning' => isset($value['next_stock_warning']) ? $value['next_stock_warning']: '',
							'has_barcode' => isset($value['has_barcode']) ? $value['has_barcode']: '',
							'has_qrcode' => isset($value['has_qrcode']) ? $value['has_qrcode']: '',
							'qrcode' => isset($value['qrcode']) ? $value['qrcode']: '',
							'barcode' => isset($value['barcode']) ? $value['barcode']: '',
							'uom_id' => isset($value['uom_id']) ? $value['uom_id']: '',
							'hsn_sac_id' => isset($value['hsn_sac_id']) ? $value['hsn_sac_id']: '',
							'sgst_id' => isset($value['sgst_id']) ? $value['sgst_id']: '',
							'igst_id' => isset($value['igst_id']) ? $value['igst_id']: '',
							'cgst_id' => isset($value['cgst_id']) ? $value['cgst_id']: '',
							'cess_id' => isset($value['cess_id']) ? $value['cess_id']: '',
							'product_ean13' => isset($value['product_ean13']) ? $value['product_ean13']: '',
							'is_service'			=> 0
						);
					};
					if ($imported) {
						foreach ($imported as $key => $value) {
							if( ! in_array($imported[$key][$duplicated_key], $current_values)) {
								array_push($new_data, $imported[$key]);
								_importFromCsv($table, $imported[$key]);
							}
							else {
								array_push($duplicated_data, $imported[$key][$duplicated_key]);
							}
						}
						$response['success']  = count($new_data);
						$response['fail'] = count($duplicated_data);
						$response['faillist'] = json_encode($duplicated_data);
					}
					echo json_encode($response);
					break;
				case 'service':
					$duplicated_key = 'name';
					$current_values = get_entity_by($entity, $duplicated_key);
					$duplicated_data = [];
					$new_data = [];
					$table = 'oc_items';

					foreach ($results as $value) {
						$imported[] = array(
							'group_id' => isset($value['group_id']) ? $value['group_id']: 0,
							'sku' => isset($value['sku']) ? $value['sku']: '',
							'name' => $value['name'],
							'description' => isset($value['description']) ? $value['description']: '',
							'price' => isset($value['price']) ? $value['price']: '',
							'purchase_price' => isset($value['purchase_price']) ? $value['purchase_price']: '',
							'item_profit' => isset($value['item_profit']) ? $value['item_profit']: '',
							'provider_name' => isset($value['provider_name']) ? $value['provider_name']: '',
							'provider_contact' => isset($value['provider_contact']) ? $value['provider_contact']: '',
							'current_stock' => isset($value['current_stock']) ? $value['current_stock']: '',
							'tax_id' => isset($value['tax_id']) ? $value['tax_id']: '',
							'item_status' => isset($value['item_status']) ? $value['item_status']: 1,
							'track_inventory' => isset($value['track_inventory']) ? $value['track_inventory']: 1,
							'initial_stock' => isset($value['initial_stock']) ? $value['initial_stock']: '',
							'initial_cost' => isset($value['initial_cost']) ? $value['initial_cost']: '',
							'reorder_point' => isset($value['reorder_point']) ? $value['reorder_point']: '',
							'on_hand_stock' => isset($value['on_hand_stock']) ? $value['on_hand_stock']: '',
							'available' => isset($value['available']) ? $value['available']: '',
							'committed' => isset($value['committed']) ? $value['committed']: '',
							'ordered' => isset($value['ordered']) ? $value['ordered']: '',
							'valuation' => isset($value['valuation']) ? $value['valuation']: '',
							'next_stock_warning' => isset($value['next_stock_warning']) ? $value['next_stock_warning']: '',
							'has_barcode' => isset($value['has_barcode']) ? $value['has_barcode']: '',
							'has_qrcode' => isset($value['has_qrcode']) ? $value['has_qrcode']: '',
							'qrcode' => isset($value['qrcode']) ? $value['qrcode']: '',
							'barcode' => isset($value['barcode']) ? $value['barcode']: '',
							'uom_id' => isset($value['uom_id']) ? $value['uom_id']: '',
							'hsn_sac_id' => isset($value['hsn_sac_id']) ? $value['hsn_sac_id']: '',
							'sgst_id' => isset($value['sgst_id']) ? $value['sgst_id']: '',
							'igst_id' => isset($value['igst_id']) ? $value['igst_id']: '',
							'cgst_id' => isset($value['cgst_id']) ? $value['cgst_id']: '',
							'cess_id' => isset($value['cess_id']) ? $value['cess_id']: '',
							'product_ean13' => isset($value['product_ean13']) ? $value['product_ean13']: '',
							'is_service'			=> 1
						);
					};
					if ($imported) {
						foreach ($imported as $key => $value) {
							if( ! in_array($imported[$key][$duplicated_key], $current_values)) {
								array_push($new_data, $imported[$key]);
								_importFromCsv($table, $imported[$key]);
							}
							else {
								array_push($duplicated_data, $imported[$key][$duplicated_key]);
							}
						}
						$response['success']  = count($new_data);
						$response['fail'] = count($duplicated_data);
						$response['faillist'] = json_encode($duplicated_data);
					}
					echo json_encode($response);
					break;
				default:
					return FALSE;
					break;
			}
		}
	}
	public function upload_plugin_zip() {
		$response = [];
		$config['upload_path']          = './uploads/import';

		if (!file_exists($config['upload_path']))
		    mkdir($config['upload_path']);

		if( chmod($config['upload_path'], 0755) ) 
	    {
	        chmod($config['upload_path'], 0777);
	    }
		$config['allowed_types']        = 'zip';
		$config['file_name']        	= 'plugin';
		$config['overwrite']        	= TRUE;

		$this->load->library('upload', $config);

		if ( ! $this->upload->do_upload('importer'))
		{
			$error = $this->upload->display_errors();
			$response = array('success' => 0, 'error' => $error );
		}
		else
		{
			$zipHandle = zip_open(getcwd().'/uploads/import/plugin.zip');
			while ($aF = zip_read($zipHandle) ) 
			{
				$thisFileName = zip_entry_name($aF);
				$thisFileDir = dirname($thisFileName);
				
				//Continue if its not a file
				if ( substr($thisFileName,-1,1) == '/') continue;
				
			
				//Make the directory if we need to...
				if ( !is_dir ( getcwd().'/'.$thisFileDir ) )
				{
					 mkdir( getcwd().'/'.$thisFileDir, 0755, true );
				}
				
				//Overwrite the file
				if ( !is_dir(getcwd().'/'.$thisFileName) ) {
					$contents = zip_entry_read($aF, zip_entry_filesize($aF));
					$contents = str_replace("\r\n", "\n", $contents);
					$updateThis = '';
					
					$updateThis = fopen(getcwd().'/'.$thisFileName, 'w');
					fwrite($updateThis, $contents);
					fclose($updateThis);
					unset($contents);
				}
			}
			$response['success']  = 1;
			unlink(getcwd().'/uploads/import/plugin.zip');
		}
		echo json_encode(array('success' => 1, 'pluginUrl' => base_url('index.php/repair')));
	}
	public function upload_ofx() {

		$response = [];
		$config['upload_path']          = './uploads/import';

		if (!file_exists($config['upload_path']))
		    mkdir($config['upload_path']);

		if( chmod($config['upload_path'], 0755) ) 
        {
            chmod($config['upload_path'], 0777);
        }
		$config['allowed_types']        = '*';
		$config['file_name']        	= 'import';
		$config['overwrite']        	= TRUE;

		$this->load->library('upload', $config);

		if ( ! $this->upload->do_upload('importer'))
		{
			$error = $this->upload->display_errors();
			$response = array('success' => 0, 'error' => $error );
		}
		else
		{
			$ofxParser = new ParserFactory();
			$results = $ofxParser->createOfxParser()->parse('uploads/import/import.ofx');
			if ($results) {
				$fail = [];
				$success = [];
				$created_on = date('Y-m-d');

				foreach ($results as $key => $transaction) {
					$date = $transaction->date;
					foreach ($date as $k => $d) {
						if ($k === 'date') {
							$created_on = $d;
						}
					}
					if (null == get_transaction_id('unique_id', $transaction->uniqueId)) {
						if ($transaction->amount > 0) {
							$db_data = array(
								'incomes_name'		    => $transaction->name, 
								'incomes_sku'		    => generate_sku(), 
								'incomes_category'		=> 1, 
								'incomes_value'			=> $transaction->amount, 
								'payment_method'		=> '', 
								'incomes_notes'			=> $transaction->memo, 
								'unique_id'				=> $transaction->uniqueId, 
								'turnover_included'		=> 1, 
								'created_on'    		=> $created_on, 
								'item_sku' 				=> null,
								'invoice_number' 		=> null,
								'user_id' 				=> USERID
							);
						} else {
							$db_data = array(
								'charges_name'			=> $transaction->name, 
								'charges_sku'			=> generate_sku(), 
								'charges_category'		=> 1,
								'charges_value'			=> substr($transaction->amount, 1),
								'payment_method'		=> '',
								'charges_notes'			=> $transaction->memo,
								'unique_id'				=> $transaction->uniqueId,   
								'turnover_included'		=> 1, 
								'created_on'    		=> $created_on, 
								'user_id' 				=> USERID
							);
						}
						record_charges($db_data);
						array_push($success, '<pre>'. $created_on. ' ' . $transaction->name . ' : '.$transaction->amount . ' : ' .$transaction->memo. "\n". '</pre>');
					} else {
						array_push($fail, '<pre>'. $created_on. ' ' . $transaction->name . ' : '.$transaction->amount . ' : ' .$transaction->memo. "\n". '</pre>');
					}
				}
				$response['success']  = count($success);
				$response['ofx']  = 1;
				$response['fail'] = count($fail);
				$response['faillist'] = $fail;
				$response['successlist'] = $success;
			}
			echo json_encode($response);
		}
	}
	public function ticket_files() {

		$response = [];
		$config['upload_path']          = './uploads/repairs';

		if (!file_exists($config['upload_path']))
		    mkdir($config['upload_path']);

		if( chmod($config['upload_path'], 0755) ) 
        {
            chmod($config['upload_path'], 0777);
        }
        
		$config['allowed_types']        = '*';
		$config['file_name']        	= 'test';
		$config['overwrite']        	= TRUE;

		$this->load->library('upload', $config);

		if ( ! $this->upload->do_upload('file'))
		{
			$error = $this->upload->display_errors();
			$this->response = array('success' => 0, 'error' => $error );
			echo json_encode($this->response);
		}
		else
		{
			$this->response = array('success' => 1, 'error' => '' );
			echo json_encode($this->response);
		}
	}
}