<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
require_once('vendor/autoload.php');
use PhpRbac\Rbac;

class Ajax extends Basic_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->lang->load('users/auth');
		$this->load->model('ion_auth_model', 'users');
		
		if( ! $this->input->is_ajax_request() )
			return show_error(lang('not_ajax_request'));
	}

    function register_newsletter()
    {
    	$response = array();
    	$db_data = array(
    		'email' => strtolower( $this->input->post('email'))
    		);
    	$config = array(
			array(
				'field' => 'email',
				'label' => lang('email'),
				'rules' => 'required|valid_email|is_unique[' . $this->config->item('newsletter_table') . '.email]',
				'errors' => array(
                    'required' => lang('error_required_first_name'),
                    'valid_email' => lang('error_required_valid_email'),
                    'is_unique' => lang('error_required_email')
                )
			)
		);

		$this->form_validation->set_rules($config);

		if ($this->form_validation->run() == FALSE)
		{
			$response = array('status' => 0, 'error' => validation_errors());
		}
		else
		{
			$query = " INSERT INTO ". $this->config->item('newsletter_table'). " SET ". $this->oneric->get_set($db_data);
			$result = $this->oneric->query($query);
			$response = array('status' => 1, 'error' => '');
		}
		echo json_encode($response);
    }
    public function register()
    {
        $response = array();
        $tables = $this->config->item('tables','ion_auth');
        $identity_column = $this->config->item('identity','ion_auth');
        $data['identity_column'] = $identity_column;

        $config = array(
            array(
                'field' => 'first_name',
                'label' => strtolower( lang('first_name') ),
                'rules' => 'required',
                'errors' => array(
                    'required' => lang('error_required_first_name')
                )
            ),
            array(
                'field' => 'last_name',
                'label' => strtolower( lang('last_name') ),
                'rules' => 'required',
                'errors' => array(
                    'required' => lang('error_required_last_name')
                )
            ),
            array(
                'field' => 'email',
                'label' => strtolower( lang('email') ),
                'rules' => 'required|valid_email|is_unique[' . $tables['users'] . '.email]',
                'errors' => array(
                    'required' => lang('error_required_email'),
                    'valid_email' => lang('error_required_email'),
                    'is_unique' => lang('error_email_exists')
                )
            ),
            array(
                'field' => 'password',
                'label' => strtolower( lang('password') ),
                'rules' => 'required|min_length[' . $this->config->item('min_password_length', 'ion_auth') . ']|max_length[' . $this->config->item('max_password_length', 'ion_auth') . ']|matches[password_confirm]',
                'errors' => array(
                    'required' => lang('error_password_required_field_error'),
                    'min_length' => lang('error_password_too_short'),
                    'max_length' => lang('error_password_too_long'),
                    'matches' => lang('error_password_confirm')
                )
            ),
            array(
                'field' => 'password_confirm',
                'label' => strtolower( lang('password_confirm') ),
                'rules' => 'required',
                'errors' => array(
                    'required' => lang('error_password_confirm_required_field_error')
                )
            )
        );

        $this->form_validation->set_rules($config);

        if ($this->form_validation->run() === FALSE)
        {
            $response = array('status' => 0, 'error' => validation_errors('<div class="alert alert-danger"><a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>', '</div>'));
        }
        else
        {
            $email    = strtolower($this->input->post('email'));
            $identity = ($identity_column==='email') ? $email : $this->input->post('username');
            $password = $this->input->post('password');

            $additional_data = array(
                'first_name' => $this->input->post('first_name'),
                'last_name'  => $this->input->post('last_name'),
                'company'    => $this->input->post('company')
            );

            if ( $this->ion_auth->register($identity, $password, $email, $additional_data) )
            {
                $response = array('status' => 1);
            }
        }
        echo json_encode($response);
    }

    function edit_user()
    {
		$post_array = array();
		$response = array();
		$active_tab = $this->input->post('active_tab');
		$this->session->unset_userdata('active_tab');
        $this->session->set_userdata('active_tab', $active_tab);

		$post_array['first_name'] = $this->input->post('first_name');
		$post_array['last_name'] = $this->input->post('last_name');
		$post_array['company'] = $this->input->post('company');
        $post_array['phone'] = $this->input->post('phone');
		$post_array['user_own_paypal'] = $this->input->post('user_own_paypal');
		$post_array['user_address1'] = $this->input->post('user_address1');
		$post_array['user_address2'] = $this->input->post('user_address2');
		$post_array['user_city'] = $this->input->post('user_city');
		$post_array['user_state'] = $this->input->post('user_state');
		$post_array['user_postcode'] = $this->input->post('user_postcode');
		$post_array['user_country'] = $this->input->post('user_country');
		$post_array['user_about'] = $this->input->post('user_about');
		$post_array['user_website'] = $this->input->post('user_website');

    	$config = array(
			array(
				'field' => 'first_name',
				'label' => lang('label_first_name'),
				'rules' => 'required',
				'errors' => array(
					'required' => lang('required_field_error'). '<br />'
					)
				),
			array(
				'field' => 'last_name',
				'label' => lang('label_last_name'),
				'rules' => 'required',
				'errors' => array(
					'required' => lang('required_field_error'). '<br />'
					)
				),
			array(
				'field' => 'company',
				'label' => lang('label_company'),
				'rules' => ''
				),
            array(
                'field' => 'phone',
                'label' => lang('label_phone'),
                'rules' => ''
                ),
			array(
				'field' => 'paypal',
				'label' => lang('label_user_own_paypal'),
				'rules' => 'valid_email',
                'errors' => array(
                    'valid_email' => lang('error_required_valid_email'). '<br />'
                    )
                )
			);

		$this->form_validation->set_rules($config);

		if ($this->form_validation->run() === TRUE)
		{
			$insert_id = $this->oneric->query("UPDATE {$this->tables['users']} SET ".$this->oneric->get_set($post_array)." WHERE id = " . user('user_id') );
			if ($insert_id != 0) 
				$response = array('status' => 1);
		}
		else
		{
			$response = array('status' => 0, 'error' => validation_errors());
		}
		echo json_encode($response);
    }

    function change_password()
    {
    	$post_array = array();
    	$post_array['password'] = $this->input->post('password');
		$post_array['password_confirm'] = $this->input->post('password_confirm');
        $user_id = $this->input->post('user_id');
		$config = array(
			array(
				'field' => 'password',
				'label' => lang('label_password'),
				'rules' => 'required|min_length[' . $this->config->item('min_password_length', 'ion_auth') . ']|max_length[' . $this->config->item('max_password_length', 'ion_auth') . ']|matches[password_confirm]',
				'errors' => array(
                    'required' => lang('error_password_required_field_error'). '<br />',
                    'min_length' => lang('error_password_too_short'). '<br />',
                    'max_length' => lang('error_password_too_long'). '<br />',
                    'matches' => lang('error_password_confirm') . '<br />'
                )
			),
			array(
				'field' => 'password_confirm',
				'label' => lang('label_password_confirm'),
				'rules' => 'required',
				'errors' => array(
                    'required' => lang('error_password_confirm_required_field_error') . '<br />'
                )
            )
		);

		$this->form_validation->set_rules($config);

		if ($this->form_validation->run() === TRUE)
		{
			$this->load->model('users/ion_auth_model', 'auth');

			$hash_password = $this->auth->hash_password( $this->input->post('password') );
			$db_data = array( 'password' => $hash_password );

			$insert_id = $this->oneric->query("UPDATE {$this->tables['users']} SET ".$this->oneric->get_set($db_data)." WHERE id = " .$user_id);

			if ($insert_id != 0) 
				$response = array('status' => 1);
		}
		else
		{
			$response = array('status' => 0, 'error' => validation_errors());
		}
		echo json_encode($response);

    }
    public function deactivate()
    {
    	$id = (int) $_REQUEST['id'];
    	$this->ion_auth->deactivate($id);
    	echo json_encode(array('status' => 1));
    }
    // activate the user
    public function activate()
    {
    	$id = (int) $_REQUEST['id'];
    	$this->ion_auth->activate($id);
    	echo json_encode(array('status' => 1));
    }
    public function users_autocomplete() {
        $users = [];
        $results = get_users();
        if ($results)
        {
            foreach ($results as $k => $v) {
                $users[] = $v->first_name;
            }
        }
        echo json_encode($users);
    }
    public function roles_users_select() {
        $users = [];
        $results = get_users();
        if ($results)
        {
            foreach ($results as $k => $v) {
                $users[] = array(
                    'id' => $v->id,
                    'name' => $v->first_name
                );
            }
        }
        echo json_encode($users);
    }
    public function roles_select() {
        $roles = [];
        $results = get_roles();
        if ($results)
        {
            foreach ($results as $k => $v) {
                $roles[] = array(
                    'id' => $v->ID,
                    'name' => ucfirst(__($v->Title))
                );
            }
        }
        echo json_encode($roles);
    }
    public function user_permissions() {
        $rbac = new Rbac();
        $role = $this->input->post('role');

        // Create Role and Permission
        if ($this->input->post('homepage_access_any') == 1) {
            if (! $rbac->Permissions->returnId('homepage_access_any')) {
                $id = $rbac->Permissions->add('homepage_access_any', 'User can view dashboard summaries');
                $rbac->Roles->assign($role, $id);
            } else {
                $rbac->Roles->assign($role, $rbac->Permissions->returnId('homepage_access_any'));
            }
        } else {
            $rbac->Permissions->unassign($role, 'homepage_access_any');
        }
        if ($this->input->post('homepage') == 1) {
            if (! $rbac->Permissions->returnId('homepage')) {
                $id = $rbac->Permissions->add('homepage', 'User can access dashboard');
                $rbac->Roles->assign($role, $id);
            } else {
                $rbac->Roles->assign($role, $rbac->Permissions->returnId('homepage'));
            }
        } else {
            $rbac->Permissions->unassign($role, 'homepage');
        }
        if ($this->input->post('items') == 1) {
            if (! $rbac->Permissions->returnId('items')) {
                $id = $rbac->Permissions->add('items', 'User can manage items and services');
                $rbac->Roles->assign($role, $id);
            } else {
                $rbac->Roles->assign($role, $rbac->Permissions->returnId('items'));
            }
        } else {
            $rbac->Permissions->unassign($role, 'items');
        }
        if ($this->input->post('users') == 1) {
            if (! $rbac->Permissions->returnId('users')) {
                $id = $rbac->Permissions->add('users', 'User can manage users');
                $rbac->Roles->assign($role, $id);
            } else {
                $rbac->Roles->assign($role, $rbac->Permissions->returnId('users'));
            }
        } else {
            $rbac->Permissions->unassign($role, 'users');
        }
        if ($this->input->post('customers') == 1) {
            if (! $rbac->Permissions->returnId('customers')) {
                $id = $rbac->Permissions->add('customers', 'User can manage customers');
                $rbac->Roles->assign($role, $id);
            } else {
                $rbac->Roles->assign($role, $rbac->Permissions->returnId('customers'));
            }
        } else {
            $rbac->Permissions->unassign($role, 'customers');
        }
        if ($this->input->post('providers') == 1) {
            if (! $rbac->Permissions->returnId('providers')) {
                $id = $rbac->Permissions->add('providers', 'User can manage providers');
                $rbac->Roles->assign($role, $id);
            } else {
                $rbac->Roles->assign($role, $rbac->Permissions->returnId('providers'));
            }
        } else {
            $rbac->Permissions->unassign($role, 'providers');
        }
        if ($this->input->post('invoices') == 1) {
            if (! $rbac->Permissions->returnId('invoices')) {
                $id = $rbac->Permissions->add('invoices', 'User can manage invoices');
                $rbac->Roles->assign($role, $id);
            } else {
                $rbac->Roles->assign($role, $rbac->Permissions->returnId('invoices'));
            }
        } else {
            $rbac->Permissions->unassign($role, 'invoices');
        }
        if ($this->input->post('purchases') == 1) {
            if (! $rbac->Permissions->returnId('purchases')) {
                $id = $rbac->Permissions->add('purchases', 'User can manage purchases');
                $rbac->Roles->assign($role, $id);
            } else {
                $rbac->Roles->assign($role, $rbac->Permissions->returnId('purchases'));
            }
        } else {
            $rbac->Permissions->unassign($role, 'purchases');
        }
        if ($this->input->post('money') == 1) {
            if (! $rbac->Permissions->returnId('money')) {
                $id = $rbac->Permissions->add('money', 'User can manage Charges and Incomes');
                $rbac->Roles->assign($role, $id);
            } else {
                $rbac->Roles->assign($role, $rbac->Permissions->returnId('money'));
            }
        } else {
            $rbac->Permissions->unassign($role, 'money');
        }
        if ($this->input->post('reports') == 1) {
            if (! $rbac->Permissions->returnId('reports')) {
                $id = $rbac->Permissions->add('reports', 'User can manage Reports and Stats');
                $rbac->Roles->assign($role, $id);
            } else {
                $rbac->Roles->assign($role, $rbac->Permissions->returnId('reports'));
            }
        } else {
            $rbac->Permissions->unassign($role, 'reports');
        }
        if ($this->input->post('system') == 1) {
            if (! $rbac->Permissions->returnId('system')) {
                $id = $rbac->Permissions->add('system', 'User can manage system and settings');
                $rbac->Roles->assign($role, $id);
            } else {
                $rbac->Roles->assign($role, $rbac->Permissions->returnId('system'));
            }
        } else {
            $rbac->Permissions->unassign($role, 'system');
        }
        if ($this->input->post('homepage_owner') == 1) {
            if ( ! $rbac->Permissions->returnId('homepage_owner')) {
                $id = $rbac->Permissions->add('homepage_owner', 'Can view own records only');
                $rbac->Roles->assign($role, $id);
            } else {
                $rbac->Roles->assign($role, $rbac->Permissions->returnId('homepage_owner'));
            }
        } else {
            if ($rbac->Permissions->returnId('homepage_owner')) {
                $rbac->Permissions->unassign($role, 'homepage_owner');
            }
        }
        if ($this->input->post('items_services_add_edit') == 1) {
            if ( ! $rbac->Permissions->returnId('items_services_add_edit')) {
                $id = $rbac->Permissions->add('items_services_add_edit', 'Can add and edit items and services');
                $rbac->Roles->assign($role, $id);
            } else {
                $rbac->Roles->assign($role, $rbac->Permissions->returnId('items_services_add_edit'));
            }
        } else {
            if ($rbac->Permissions->returnId('items_services_add_edit')) {
                $rbac->Permissions->unassign($role, 'items_services_add_edit');
            }
        }
        if ($this->input->post('items_services_add_edit_delete') == 1) {
            if ( ! $rbac->Permissions->returnId('items_services_add_edit_delete')) {
                $id = $rbac->Permissions->add('items_services_add_edit_delete', 'Can add, edit and delete items and services');
                $rbac->Roles->assign($role, $id);
            } else {
                $rbac->Roles->assign($role, $rbac->Permissions->returnId('items_services_add_edit_delete'));
            }
        } else {
            if ($rbac->Permissions->returnId('items_services_add_edit_delete')) {
                $rbac->Permissions->unassign($role, 'items_services_add_edit_delete');
            }
        }
        if ($this->input->post('items_services_batch_update_price') == 1) {
            if ( ! $rbac->Permissions->returnId('items_services_batch_update_price')) {
                $id = $rbac->Permissions->add('items_services_batch_update_price', 'Can update items and services price in batch tab');
                $rbac->Roles->assign($role, $id);
            } else {
                $rbac->Roles->assign($role, $rbac->Permissions->returnId('items_services_batch_update_price'));
            }
        } else {
            if ($rbac->Permissions->returnId('items_services_batch_update_price')) {
                $rbac->Permissions->unassign($role, 'items_services_batch_update_price');
            }
        }
        if ($this->input->post('items_services_edit_stocks') == 1) {
            if ( ! $rbac->Permissions->returnId('items_services_edit_stocks')) {
                $id = $rbac->Permissions->add('items_services_edit_stocks', 'Can edit items and services stocks');
                $rbac->Roles->assign($role, $id);
            } else {
                $rbac->Roles->assign($role, $rbac->Permissions->returnId('items_services_edit_stocks'));
            }
        } else {
            if ($rbac->Permissions->returnId('items_services_edit_stocks')) {
                $rbac->Permissions->unassign($role, 'items_services_edit_stocks');
            }
        }
        if ($this->input->post('user_add_edit') == 1) {
            if ( ! $rbac->Permissions->returnId('user_add_edit')) {
                $id = $rbac->Permissions->add('user_add_edit', 'Can add, edit user');
                $rbac->Roles->assign($role, $id);
            } else {
                $rbac->Roles->assign($role, $rbac->Permissions->returnId('user_add_edit'));
            }
        } else {
            if ($rbac->Permissions->returnId('user_add_edit')) {
                $rbac->Permissions->unassign($role, 'user_add_edit');
            }
        }
        if ($this->input->post('user_add_edit_delete') == 1) {
            if ( ! $rbac->Permissions->returnId('user_add_edit_delete')) {
                $id = $rbac->Permissions->add('user_add_edit_delete', 'Can add, edit and delete user');
                $rbac->Roles->assign($role, $id);
            } else {
                $rbac->Roles->assign($role, $rbac->Permissions->returnId('user_add_edit_delete'));
            }
        } else {
            if ($rbac->Permissions->returnId('user_add_edit_delete')) {
                $rbac->Permissions->unassign($role, 'user_add_edit_delete');
            }
        }
        if ($this->input->post('user_run_time_tracking') == 1) {
            if ( ! $rbac->Permissions->returnId('user_run_time_tracking')) {
                $id = $rbac->Permissions->add('user_run_time_tracking', 'Can run Time tracking');
                $rbac->Roles->assign($role, $id);
            } else {
                $rbac->Roles->assign($role, $rbac->Permissions->returnId('user_run_time_tracking'));
            }
        } else {
            if ($rbac->Permissions->returnId('user_run_time_tracking')) {
                $rbac->Permissions->unassign($role, 'user_run_time_tracking');
            }
        }
        if ($this->input->post('user_reset_password') == 1) {
            if ( ! $rbac->Permissions->returnId('user_reset_password')) {
                $id = $rbac->Permissions->add('user_reset_password', 'Can reset all passwords');
                $rbac->Roles->assign($role, $id);
            } else {
                $rbac->Roles->assign($role, $rbac->Permissions->returnId('user_reset_password'));
            }
        } else {
            if ($rbac->Permissions->returnId('user_reset_password')) {
                $rbac->Permissions->unassign($role, 'user_reset_password');
            }
        }
        if ($this->input->post('user_manage_access') == 1) {
            if ( ! $rbac->Permissions->returnId('user_manage_access')) {
                $id = $rbac->Permissions->add('user_manage_access', 'Can access and manage users roles and permissions');
                $rbac->Roles->assign($role, $id);
            } else {
                $rbac->Roles->assign($role, $rbac->Permissions->returnId('user_manage_access'));
            }
        } else {
            if ($rbac->Permissions->returnId('user_manage_access')) {
                $rbac->Permissions->unassign($role, 'user_manage_access');
            }
        }
        if ($this->input->post('customer_add_edit') == 1) {
            if ( ! $rbac->Permissions->returnId('customer_add_edit')) {
                $id = $rbac->Permissions->add('customer_add_edit', 'Can add and edit customer');
                $rbac->Roles->assign($role, $id);
            } else {
                $rbac->Roles->assign($role, $rbac->Permissions->returnId('customer_add_edit'));
            }
        } else {
            if ($rbac->Permissions->returnId('customer_add_edit')) {
                $rbac->Permissions->unassign($role, 'customer_add_edit');
            }
        }
        if ($this->input->post('user_manage_commissions') == 1) {
            if ( ! $rbac->Permissions->returnId('user_manage_commissions')) {
                $id = $rbac->Permissions->add('user_manage_commissions', 'Can manage User/Agent commissions');
                $rbac->Roles->assign($role, $id);
            } else {
                $rbac->Roles->assign($role, $rbac->Permissions->returnId('user_manage_commissions'));
            }
        } else {
            if ($rbac->Permissions->returnId('user_manage_commissions')) {
                $rbac->Permissions->unassign($role, 'user_manage_commissions');
            }
        }
        if ($this->input->post('customer_add_edit_delete') == 1) {
            if ( ! $rbac->Permissions->returnId('customer_add_edit_delete')) {
                $id = $rbac->Permissions->add('customer_add_edit_delete', 'Can add, edit and delete customer');
                $rbac->Roles->assign($role, $id);
            } else {
                $rbac->Roles->assign($role, $rbac->Permissions->returnId('customer_add_edit_delete'));
            }
        } else {
            if ($rbac->Permissions->returnId('customer_add_edit_delete')) {
                $rbac->Permissions->unassign($role, 'customer_add_edit_delete');
            }
        }
        if ($this->input->post('customer_access_any') == 1) {
            if ( ! $rbac->Permissions->returnId('customer_access_any')) {
                $id = $rbac->Permissions->add('customer_access_any', 'Can access all customers');
                $rbac->Roles->assign($role, $id);
            } else {
                $rbac->Roles->assign($role, $rbac->Permissions->returnId('customer_access_any'));
            }
        } else {
            if ($rbac->Permissions->returnId('customer_access_any')) {
                $rbac->Permissions->unassign($role, 'customer_access_any');
            }
        }
        if ($this->input->post('customer_owner') == 1) {
            if ( ! $rbac->Permissions->returnId('customer_owner')) {
               $id = $rbac->Permissions->add('customer_owner', 'Can access own customers only'); 
               $rbac->Roles->assign($role, $id);
            } else {
                $rbac->Roles->assign($role, $rbac->Permissions->returnId('customer_owner'));
            }
        } else {
            if ($rbac->Permissions->returnId('customer_owner')) {
                $rbac->Permissions->unassign($role, 'customer_owner');
            }
        }
        if ($this->input->post('provider_add_edit') == 1) {
            if ( ! $rbac->Permissions->returnId('provider_add_edit')) {
                $id = $rbac->Permissions->add('provider_add_edit', 'Can add and edit provider');
                $rbac->Roles->assign($role, $id);
            } else {
                $rbac->Roles->assign($role, $rbac->Permissions->returnId('provider_add_edit'));
            }
        } else {
            if ($rbac->Permissions->returnId('provider_add_edit')) {
                $rbac->Permissions->unassign($role, 'provider_add_edit');
            }
        }
        if ($this->input->post('provider_add_edit_delete') == 1) {
            if ( ! $rbac->Permissions->returnId('provider_add_edit_delete')) {
                $id = $rbac->Permissions->add('provider_add_edit_delete', 'Can add, edit and delete provider');
                $rbac->Roles->assign($role, $id);
            } else {
                $rbac->Roles->assign($role, $rbac->Permissions->returnId('provider_add_edit_delete'));
            }
        } else {
            if ($rbac->Permissions->returnId('provider_add_edit_delete')) {
                $rbac->Permissions->unassign($role, 'provider_add_edit_delete');
            }
        }
        if ($this->input->post('invoice_add_edit') == 1) {
            if ( ! $rbac->Permissions->returnId('invoice_add_edit')) {
                $id = $rbac->Permissions->add('invoice_add_edit', 'Can add and edit invoice');
                $rbac->Roles->assign($role, $id);
            } else {
                $rbac->Roles->assign($role, $rbac->Permissions->returnId('invoice_add_edit'));
            }
        } else {
            if ($rbac->Permissions->returnId('invoice_add_edit')) {
                $rbac->Permissions->unassign($role, 'invoice_add_edit');
            }
        }
        if ($this->input->post('invoice_add_edit_delete') == 1) {
            if ( ! $rbac->Permissions->returnId('invoice_add_edit_delete')) {
                $id = $rbac->Permissions->add('invoice_add_edit_delete', 'Can add, edit and delete invoice');
                $rbac->Roles->assign($role, $id);
            } else {
                $rbac->Roles->assign($role, $rbac->Permissions->returnId('invoice_add_edit_delete'));
            }
        } else {
            if ($rbac->Permissions->returnId('invoice_add_edit_delete')) {
                $rbac->Permissions->unassign($role, 'invoice_add_edit_delete');
            }
        }
        if ($this->input->post('invoice_create_credit_note') == 1) {
            if ( ! $rbac->Permissions->returnId('invoice_create_credit_note')) {
                $id = $rbac->Permissions->add('invoice_create_credit_note', 'Can create credit note');
                $rbac->Roles->assign($role, $id);
            } else {
                $rbac->Roles->assign($role, $rbac->Permissions->returnId('invoice_create_credit_note'));
            }
        } else {
            if ($rbac->Permissions->returnId('invoice_create_credit_note')) {
                $rbac->Permissions->unassign($role, 'invoice_create_credit_note');
            }
        }
        if ($this->input->post('invoice_access_any') == 1) {
            if ( ! $rbac->Permissions->returnId('invoice_access_any')) {
                $id = $rbac->Permissions->add('invoice_access_any', 'Can access all invoices');
                $rbac->Roles->assign($role, $id);
            } else {
                $rbac->Roles->assign($role, $rbac->Permissions->returnId('invoice_access_any'));
            }
        } else {
            if ($rbac->Permissions->returnId('invoice_access_any')) {
                $rbac->Permissions->unassign($role, 'invoice_access_any');
            }
        }
        if ($this->input->post('invoice_owner') == 1) {
            if ( ! $rbac->Permissions->returnId('invoice_owner')) {
                $id = $rbac->Permissions->add('invoice_owner', 'Can access own invoices only');
                $rbac->Roles->assign($role, $id);
            } else {
                $rbac->Roles->assign($role, $rbac->Permissions->returnId('invoice_owner'));
            }
        } else {
            if ($rbac->Permissions->returnId('invoice_owner')) {
                $rbac->Permissions->unassign($role, 'invoice_owner');
            }
        }
        if ($this->input->post('purchase_add_edit') == 1) {
            if ( ! $rbac->Permissions->returnId('purchase_add_edit')) {
                $id = $rbac->Permissions->add('purchase_add_edit', 'Can add and edit purchase order');
                $rbac->Roles->assign($role, $id);
            } else {
                $rbac->Roles->assign($role, $rbac->Permissions->returnId('purchase_add_edit'));
            }
        } else {
            if ($rbac->Permissions->returnId('purchase_add_edit')) {
                $rbac->Permissions->unassign($role, 'purchase_add_edit');
            }
        }
        if ($this->input->post('purchase_add_edit_delete') == 1) {
            if ( ! $rbac->Permissions->returnId('purchase_add_edit_delete')) {
                $id = $rbac->Permissions->add('purchase_add_edit_delete', 'Can add, edit and delete purchase order');
                $rbac->Roles->assign($role, $id);
            } else {
                $rbac->Roles->assign($role, $rbac->Permissions->returnId('purchase_add_edit_delete'));
            }
        } else {
            if ($rbac->Permissions->returnId('purchase_add_edit_delete')) {
                $rbac->Permissions->unassign($role, 'purchase_add_edit_delete');
            }
        }
        if ($this->input->post('charge_income_add_edit') == 1) {
            if ( ! $rbac->Permissions->returnId('charge_income_add_edit')) {
                $id = $rbac->Permissions->add('charge_income_add_edit', 'Can add and edit charges and incomes');
                $rbac->Roles->assign($role, $id);
            } else {
                $rbac->Roles->assign($role, $rbac->Permissions->returnId('charge_income_add_edit'));
            }
        } else {
            if ($rbac->Permissions->returnId('charge_income_add_edit')) {
                $rbac->Permissions->unassign($role, 'charge_income_add_edit');
            }
        }
        if ($this->input->post('charge_income_add_edit_delete') == 1) {
            if ( ! $rbac->Permissions->returnId('charge_income_add_edit_delete')) {
                $id = $rbac->Permissions->add('charge_income_add_edit_delete', 'Can add, edit and delete charges and incomes');
                $rbac->Roles->assign($role, $id);
            } else {
                $rbac->Roles->assign($role, $rbac->Permissions->returnId('charge_income_add_edit_delete'));
            }
        } else {
            if ($rbac->Permissions->returnId('charge_income_add_edit_delete')) {
                $rbac->Permissions->unassign($role, 'charge_income_add_edit_delete');
            }
        }
        if ($this->input->post('charge_income_access_any') == 1) {
            if ( ! $rbac->Permissions->returnId('charge_income_access_any')) {
                $id = $rbac->Permissions->add('charge_income_access_any', 'Can access all charges and incomes');
                $rbac->Roles->assign($role, $id);
            } else {
                $rbac->Roles->assign($role, $rbac->Permissions->returnId('charge_income_access_any'));
            }
        } else {
            if ($rbac->Permissions->returnId('charge_income_access_any')) {
                $rbac->Permissions->unassign($role, 'charge_income_access_any');
            }
        }
        if ($this->input->post('charge_income_owner') == 1) {
            if ( ! $rbac->Permissions->returnId('charge_income_owner')) {
                $id = $rbac->Permissions->add('charge_income_owner', 'Can access own charges and incomes only');
                $rbac->Roles->assign($role, $id);
            } else {
                $rbac->Roles->assign($role, $rbac->Permissions->returnId('charge_income_owner'));
            }
        } else {
            if ($rbac->Permissions->returnId('charge_income_owner')) {
                $rbac->Permissions->unassign($role, 'charge_income_owner');
            }
        }
        if ($this->input->post('report_access_any') == 1) {
            if ( ! $rbac->Permissions->returnId('report_access_any')) {
                $id = $rbac->Permissions->add('report_access_any', 'Can access all reports and stats');
                $rbac->Roles->assign($role, $id);
            } else {
                $rbac->Roles->assign($role, $rbac->Permissions->returnId('report_access_any'));
            }
        } else {
            if ($rbac->Permissions->returnId('report_access_any')) {
                $rbac->Permissions->unassign($role, 'report_access_any');
            }
        }
        if ($this->input->post('report_owner') == 1) {
            if ( ! $rbac->Permissions->returnId('report_owner')) {
                $id = $rbac->Permissions->add('report_owner', 'Can access own reports and stats only');
                $rbac->Roles->assign($role, $id);
            } else {
                $rbac->Roles->assign($role, $rbac->Permissions->returnId('report_owner'));
            }
        } else {
            if ($rbac->Permissions->returnId('report_owner')) {
                $rbac->Permissions->unassign($role, 'report_owner');
            }
        }
        if ($this->input->post('setting_readonly') == 1) {
            if ( ! $rbac->Permissions->returnId('setting_readonly')) {
                $id = $rbac->Permissions->add('setting_readonly', 'Can read only settings');
                $rbac->Roles->assign($role, $id);
            } else {
                $rbac->Roles->assign($role, $rbac->Permissions->returnId('setting_readonly'));
            }
        } else {
            if ($rbac->Permissions->returnId('setting_readonly')) {
                $rbac->Permissions->unassign($role, 'setting_readonly');
            }
        }
        if ($this->input->post('setting_read_write') == 1) {
            if ( ! $rbac->Permissions->returnId('setting_read_write')) {
                $id = $rbac->Permissions->add('setting_read_write', 'Can read and update settings');
                $rbac->Roles->assign($role, $id);
            } else {
                $rbac->Roles->assign($role, $rbac->Permissions->returnId('setting_read_write'));
            }
        }
        else {
            if ($rbac->Permissions->returnId('setting_read_write')) {
                $rbac->Permissions->unassign($role, 'setting_read_write');
            }
        }
        echo json_encode(array('status' => 1));
    }
    public function assign_role() {
        $rbac = new Rbac();
        // Assign Role to User (The UserID is provided by the application's User Management System)
        $user_id = $this->input->post('user_id');
        $role_id = $this->input->post('user_role');

        // Get user current roles. Remove them before assigning new one
        $roles = $rbac->Users->allRoles($user_id);
        if ($roles) {
            foreach ($roles as $key => $value) {
                $rbac->Users->unassign($value['Title'], $user_id);
            }
        }
        $rbac->Users->assign($role_id, $user_id);
        echo json_encode(array('status' => 1));
    }
}