<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Auth extends Basic_Controller {
	public function __construct()
	{
		parent::__construct();
		$this->load->library('EzSQL_codeigniter');
		$this->oneric = new EzSQL_codeigniter;

		$this->form_validation->set_error_delimiters($this->config->item('error_start_delimiter', 'ion_auth'), $this->config->item('error_end_delimiter', 'ion_auth'));
		
		$this->data['breadcrumb'] = "";
		$this->view_data['content'] = $this->Template->render('users', 'access_deny.phtml', $this->data, TRUE);
	}

	// redirect if needed, otherwise display the user list
	public function index($action = FALSE, $id = FALSE)
	{

		if (!$this->ion_auth->logged_in())
		{
			// redirect them to the login page
			redirect('auth/login');
		}
		elseif (!$this->ion_auth->is_admin()) // remove this elseif if you want to enable this for non-admins
		{
			// redirect them to the home page because they must be an administrator to view this
			//return show_error('You must be an administrator to view this page.');
			$this->Template->render('templates', 'coming_soon.phtml');
		}
		else
		{
			if( isset($_REQUEST['action']) )
				
				$action = $_REQUEST['action'];
			switch($action)
			{
				case "view":
					// set the flash data error message if there is one
					$this->data['message'] = (validation_errors()) ? validation_errors() : $this->session->flashdata('message');

					//list the users
					$this->data['users'] = $this->ion_auth->users()->result();
					foreach ($this->data['users'] as $k => $user)
					{
						$this->data['users'][$k]->groups = $this->ion_auth->get_users_groups($user->id)->result();
					}

					$this->Template->render('users', 'auth/index.phtml', $this->data);
					break;
				default:
					// set the flash data error message if there is one
					$this->data['message'] = (validation_errors()) ? validation_errors() : $this->session->flashdata('message');

					//list the users
					$this->data['users'] = $this->ion_auth->users()->result();
					foreach ($this->data['users'] as $k => $user)
					{
						$this->data['users'][$k]->groups = $this->ion_auth->get_users_groups($user->id)->result();
					}

					$this->Template->render('users', 'auth/index.phtml', $this->data);
			}
		}
	}

	// log the user in
	public function login()
	{
		if( _has_option('recaptcha_enabled') ) {
			$response = false;
		} else {
			$response['success'] = true;
		}

		$this->data['title'] = $this->lang->line('login_heading');

		//validate form input
		$this->form_validation->set_rules('identity', str_replace(':', '', $this->lang->line('login_identity_label')), 'required');
		$this->form_validation->set_rules('password', str_replace(':', '', $this->lang->line('login_password_label')), 'required');

		if( _has_option('recaptcha_enabled') ) {
			$this->load->library('recaptcha');
			$recaptcha = $this->input->post('g-recaptcha-response');
			if (!empty($recaptcha)) {
			    $response = $this->recaptcha->verifyResponse($recaptcha);
			}
			$this->data['widget'] = $this->recaptcha->getWidget();
		    $this->data['script'] = $this->recaptcha->getScriptTag();
		}

		if ($this->form_validation->run() == true && isset($response['success']) && $response['success'] == true)
		{
			// check to see if the user is logging in
			// check for "remember me"
			//$remember = (bool) $this->input->post('remember');
			$remember = (bool) 1;

			if ($this->ion_auth->login($this->input->post('identity'), $this->input->post('password'), $remember))
			{
				$url = base_url();
				//if the login is successful
				//redirect them back to the home page
				$this->session->set_flashdata('message', $this->ion_auth->messages());
				alert_connection();
				if(isset($_SESSION['url'])) {
					if ( is_404($_SESSION['url'])) {
						$url = $_SESSION['url']; // holds url for last page visited.
					}
				}
				header("Location: $url");
			}
			else
			{
				// if the login was un-successful
				// redirect them back to the login page
				$this->session->set_flashdata('message', $this->ion_auth->errors());
				redirect('auth/login'); // use redirects instead of loading views for compatibility with MY_Controller libraries
			}
		}
		else
		{
			// the user is not logging in so display the login page
			// set the flash data error message if there is one
			$this->data['message'] = (validation_errors()) ? validation_errors() : $this->session->flashdata('message');

			$this->data['identity'] = array('name' => 'identity',
				'id'    => 'identity',
				'type'  => 'text',
				'value' => $this->form_validation->set_value('identity'),
			);
			$this->data['password'] = array('name' => 'password',
				'id'   => 'password',
				'type' => 'password',
				'placeholder' => lang('label_password'),
			);
			
			$this->Template->render('users', 'auth/login.phtml', $this->data);
		}
	}
	public function client_login()
	{
		if( _has_option('recaptcha_enabled') ) {
			$response = false;
		} else {
			$response['success'] = true;
		}
		$this->data['title'] = $this->lang->line('customer_login_heading');

		//validate form input
		$this->form_validation->set_rules('identity', str_replace(':', '', $this->lang->line('login_identity_label')), 'required');
		$this->form_validation->set_rules('password', str_replace(':', '', $this->lang->line('login_password_label')), 'required');

		if( _has_option('recaptcha_enabled') ) {
			$this->load->library('recaptcha');
			$recaptcha = $this->input->post('g-recaptcha-response');
			if (!empty($recaptcha)) {
			    $response = $this->recaptcha->verifyResponse($recaptcha);
			}
			$this->data['widget'] = $this->recaptcha->getWidget();
		    $this->data['script'] = $this->recaptcha->getScriptTag();
		}

		if ($this->form_validation->run() == true)
		{
			// check to see if the user is logging in
			// check for "remember me"
			//$remember = (bool) $this->input->post('remember');
			$remember = (bool) 1;

			if ( $this->check_client_password($this->input->post('identity'), $this->input->post('password')))
			{
				//if the login is successful
				$client_url = base_url('client/index');

				$this->session->set_userdata(
					array(
						'client_logged_in' => true,
						'pwd_verified' => true,
						'client_id' => get_client_id(null, $this->input->post('identity')),
						'eci' => _eID(get_client_id(null, $this->input->post('identity')))
					)
				);
				if(isset($_SESSION['client_url'])) {
					if ( is_404($_SESSION['client_url'])) {
						$client_url = $_SESSION['client_url']; // holds client_url for last page visited.
					}
				}
				header("Location: $client_url");
			}
			else
			{
				// if the login was un-successful
				// redirect them back to the login page
				$this->ion_auth->set_error('login_unsuccessful');
				$this->session->set_flashdata('message', $this->ion_auth->errors());
				redirect('auth/client_login'); // use redirects instead of loading views for compatibility with MY_Controller libraries
			}
		}
		else
		{
			// the user is not logging in so display the login page
			// set the flash data error message if there is one
			$this->data['message'] = (validation_errors()) ? validation_errors() : $this->session->flashdata('message');

			$this->data['identity'] = array('name' => 'identity',
				'id'    => 'identity',
				'type'  => 'text',
				'value' => $this->form_validation->set_value('identity'),
			);
			$this->data['password'] = array('name' => 'password',
				'id'   => 'password',
				'type' => 'password',
				'placeholder' => lang('label_password'),
			);

			$this->Template->render('users', 'auth/client_login.phtml', $this->data);
		}
	}

	// log the user out
	public function logout()
	{
		$this->data['title'] = "Logout";

		// log the user out
		$logout = $this->ion_auth->logout();

		// redirect them to the login page
		$this->session->set_flashdata('message', $this->ion_auth->messages());
		redirect('auth/login');
	}

	public function customer_logout()
	{
		session_destroy();
		// redirect them to the login page
		$this->session->set_flashdata('message', $this->ion_auth->messages());
		$url = 'client/index?id='.$id;
		redirect($url);
	}
	public function provider_logout()
	{
		session_destroy();

		// redirect them to the login page
		$this->session->set_flashdata('message', $this->ion_auth->messages());
		$url = 'provider/index?id='.$id;
		redirect($url);
	}
	
	// change password
	public function change_password()
	{
		$this->form_validation->set_rules('old', $this->lang->line('change_password_validation_old_password_label'), 'required');
		$this->form_validation->set_rules('new', $this->lang->line('change_password_validation_new_password_label'), 'required|min_length[' . $this->config->item('min_password_length', 'ion_auth') . ']|max_length[' . $this->config->item('max_password_length', 'ion_auth') . ']|matches[new_confirm]');
		$this->form_validation->set_rules('new_confirm', $this->lang->line('change_password_validation_new_password_confirm_label'), 'required');

		if (!$this->ion_auth->logged_in())
		{
			redirect('auth/login');
		}

		$user = $this->ion_auth->user()->row();

		if ($this->form_validation->run() == false)
		{
			// display the form
			// set the flash data error message if there is one
			$this->data['message'] = (validation_errors()) ? validation_errors() : $this->session->flashdata('message');

			$this->data['min_password_length'] = $this->config->item('min_password_length', 'ion_auth');
			$this->data['old_password'] = array(
				'name' => 'old',
				'id'   => 'old',
				'type' => 'password',
			);
			$this->data['new_password'] = array(
				'name'    => 'new',
				'id'      => 'new',
				'type'    => 'password',
				'pattern' => '^.{'.$this->data['min_password_length'].'}.*$',
			);
			$this->data['new_password_confirm'] = array(
				'name'    => 'new_confirm',
				'id'      => 'new_confirm',
				'type'    => 'password',
				'pattern' => '^.{'.$this->data['min_password_length'].'}.*$',
			);
			$this->data['user_id'] = array(
				'name'  => 'user_id',
				'id'    => 'user_id',
				'type'  => 'hidden',
				'value' => $user->id,
			);

			// render
			$this->Template->render('users', 'change_password.phtml', $this->data);
		}
		else
		{
			$identity = $this->session->userdata('identity');

			$change = $this->ion_auth->change_password($identity, $this->input->post('old'), $this->input->post('new'));

			if ($change)
			{
				//if the password was successfully changed
				$this->session->set_flashdata('message', $this->ion_auth->messages());
				$this->logout();
			}
			else
			{
				$this->session->set_flashdata('message', $this->ion_auth->errors());
				redirect('auth/change_password');
			}
		}
	}

	// forgot password
	public function forgot_password()
	{
		// setting validation rules by checking whether identity is username or email
		if($this->config->item('identity', 'ion_auth') != 'email' )
		{
		   $this->form_validation->set_rules('identity', $this->lang->line('forgot_password_identity_label'), 'required');
		}
		else
		{
		   $this->form_validation->set_rules('identity', $this->lang->line('forgot_password_validation_email_label'), 'required|valid_email');
		}


		if ($this->form_validation->run() == false)
		{
			$this->data['type'] = $this->config->item('identity','ion_auth');
			// setup the input
			$this->data['identity'] = array('name' => 'identity',
				'id' => 'identity',
				'class' => 'form-control form-control-solid placeholder-no-fix'
			);

			if ( $this->config->item('identity', 'ion_auth') != 'email' ){
				$this->data['identity_label'] = $this->lang->line('forgot_password_identity_label');
			}
			else
			{
				$this->data['identity_label'] = $this->lang->line('forgot_password_email_identity_label');
			}

			// set any errors and display the form
			$this->data['message'] = (validation_errors()) ? validation_errors() : $this->session->flashdata('message');
			$this->Template->render('users', 'forgot_password.phtml', $this->data);
		}
		else
		{
			$identity_column = $this->config->item('identity','ion_auth');
			$identity = $this->ion_auth->where($identity_column, $this->input->post('identity'))->users()->row();

			if(empty($identity)) {

	            		if($this->config->item('identity', 'ion_auth') != 'email')
		            	{
		            		$this->ion_auth->set_error('forgot_password_identity_not_found');
		            	}
		            	else
		            	{
		            	   $this->ion_auth->set_error('forgot_password_email_not_found');
		            	}

		                $this->session->set_flashdata('message', $this->ion_auth->errors());
                		redirect("auth/forgot_password");
            		}

			// run the forgotten password method to email an activation code to the user
			$forgotten = $this->ion_auth->forgotten_password($identity->{$this->config->item('identity', 'ion_auth')});

			if ($forgotten)
			{
				// if there were no errors
				$this->session->set_flashdata('message', $this->ion_auth->messages());
				redirect("auth/login"); //we should display a confirmation page here instead of the login page
			}
			else
			{
				$this->session->set_flashdata('message', $this->ion_auth->errors());
				redirect("auth/forgot_password");
			}
		}
	}
	public function client_forgot_password()
	{
		// setting validation rules by checking whether identity is username or email
		if($this->config->item('identity', 'ion_auth') != 'email' )
		{
		   $this->form_validation->set_rules('identity', $this->lang->line('forgot_password_identity_label'), 'required');
		}
		else
		{
		   $this->form_validation->set_rules('identity', $this->lang->line('forgot_password_validation_email_label'), 'required|valid_email');
		}


		if ($this->form_validation->run() == false)
		{
			$this->data['type'] = $this->config->item('identity','ion_auth');
			// setup the input
			$this->data['identity'] = array('name' => 'identity',
				'id' => 'identity',
				'class' => 'form-control form-control-solid placeholder-no-fix'
			);

			if ( $this->config->item('identity', 'ion_auth') != 'email' ){
				$this->data['identity_label'] = $this->lang->line('forgot_password_identity_label');
			}
			else
			{
				$this->data['identity_label'] = $this->lang->line('forgot_password_email_identity_label');
			}

			// set any errors and display the form
			$this->data['message'] = (validation_errors()) ? validation_errors() : $this->session->flashdata('message');
			$this->Template->render('users', 'client_forgot_password.phtml', $this->data);
		}
		else
		{
			$identity_column = $this->config->item('identity','ion_auth');
			$client_id = get_client_id(null, $this->input->post('identity'));

			if( ! $client_id) {

	            		if($this->config->item('identity', 'ion_auth') != 'email')
		            	{
		            		$this->ion_auth->set_error('forgot_password_identity_not_found');
		            	}
		            	else
		            	{
		            	   $this->ion_auth->set_error('forgot_password_email_not_found');
		            	}

		                $this->session->set_flashdata('message', $this->ion_auth->errors());
                		redirect("auth/client_forgot_password");
            		}

			// run the forgotten password method to email an activation code to the user
			$forgotten = $this->ion_auth->client_forgotten_password($client_id);

			if ($forgotten)
			{
				// if there were no errors
				$this->session->set_flashdata('message', $this->ion_auth->messages());
				redirect("auth/client_login"); //we should display a confirmation page here instead of the login page
			}
			else
			{
				$this->session->set_flashdata('message', $this->ion_auth->errors());
				redirect("auth/client_forgot_password");
			}
		}
	}

	// reset password - final step for forgotten password
	public function reset_password($code = NULL)
	{
		if (!$code)
		{
			show_404();
		}

		$user = $this->ion_auth->forgotten_password_check($code);

		if ($user)
		{
			// if the code is valid then display the password reset form

			$this->form_validation->set_rules('new', $this->lang->line('reset_password_validation_new_password_label'), 'required|min_length[' . $this->config->item('min_password_length', 'ion_auth') . ']|max_length[' . $this->config->item('max_password_length', 'ion_auth') . ']|matches[new_confirm]');
			$this->form_validation->set_rules('new_confirm', $this->lang->line('reset_password_validation_new_password_confirm_label'), 'required');

			if ($this->form_validation->run() == false)
			{
				// display the form

				// set the flash data error message if there is one
				$this->data['message'] = (validation_errors()) ? validation_errors() : $this->session->flashdata('message');

				$this->data['min_password_length'] = $this->config->item('min_password_length', 'ion_auth');
				$this->data['new_password'] = array(
					'name' => 'new',
					'id'   => 'new',
					'type' => 'password',
					'pattern' => '^.{'.$this->data['min_password_length'].'}.*$',
					'class' => 'form-control form-control-solid placeholder-no-fix',
					'placeholder' => __('placeholder_new_password'),
				);
				$this->data['new_password_confirm'] = array(
					'name'    => 'new_confirm',
					'id'      => 'new_confirm',
					'type'    => 'password',
					'pattern' => '^.{'.$this->data['min_password_length'].'}.*$',
					'class' => 'form-control form-control-solid placeholder-no-fix',
					'placeholder' => __('placeholder_confirm_new_password')
				);
				$this->data['user_id'] = array(
					'name'  => 'user_id',
					'id'    => 'user_id',
					'type'  => 'hidden',
					'value' => $user->id,
				);
				$this->data['csrf'] = $this->_get_csrf_nonce();
				$this->data['code'] = $code;

				// render
				$this->Template->render('users', 'auth/reset_password.phtml', $this->data);
			}
			else
			{
				// do we have a valid request?
				if ($this->_valid_csrf_nonce() === FALSE || $user->id != $this->input->post('user_id'))
				{

					// something fishy might be up
					$this->ion_auth->clear_forgotten_password_code($code);

					show_error($this->lang->line('error_csrf'));

				}
				else
				{
					// finally change the password
					$identity = $user->{$this->config->item('identity', 'ion_auth')};

					$change = $this->ion_auth->reset_password($identity, $this->input->post('new'));

					if ($change)
					{
						// if the password was successfully changed
						$this->session->set_flashdata('message', $this->ion_auth->messages());
						redirect("auth/login");
					}
					else
					{
						$this->session->set_flashdata('message', $this->ion_auth->errors());
						redirect('auth/reset_password/' . $code);
					}
				}
			}
		}
		else
		{
			// if the code is invalid then send them back to the forgot password page
			$this->session->set_flashdata('message', $this->ion_auth->errors());
			redirect("auth/forgot_password");
		}
	}

	// deactivate the user
	public function deactivate($id = NULL)
	{
		if (!$this->ion_auth->logged_in() || !$this->ion_auth->is_admin())
		{
			// redirect them to the home page because they must be an administrator to view this
			return show_error('You must be an administrator to view this page.');
		}

		$id = (int) $id;

		$this->load->library('form_validation');
		$this->form_validation->set_rules('confirm', $this->lang->line('deactivate_validation_confirm_label'), 'required');
		$this->form_validation->set_rules('id', $this->lang->line('deactivate_validation_user_id_label'), 'required|alpha_numeric');

		if ($this->form_validation->run() == FALSE)
		{
			// insert csrf check
			$this->data['csrf'] = $this->_get_csrf_nonce();
			$this->data['user'] = $this->ion_auth->user($id)->row();

			$data['content'] = $this->Template->render('users', 'auth/deactivate_user.phtml', $this->data, TRUE);
			$this->Template->render('templates', 'layout.phtml', $data);
		}
		else
		{
			// do we really want to deactivate?
			if ($this->input->post('confirm') == 'yes')
			{
				// do we have a valid request?
				if ($this->_valid_csrf_nonce() === FALSE || $id != $this->input->post('id'))
				{
					show_error($this->lang->line('error_csrf'));
				}

				// do we have the right userlevel?
				if ($this->ion_auth->logged_in() && $this->ion_auth->is_admin())
				{
					$this->ion_auth->deactivate($id);
				}
			}

			// redirect them back to the auth page
			redirect('settings/index?a=users');
		}
	}
	// activate the user
	public function activate($id, $code=false)
	{
		if ($code !== false)
		{
			$activation = $this->ion_auth->activate($id, $code);
		}
		else if ($this->ion_auth->is_admin())
		{
			$activation = $this->ion_auth->activate($id);
		}

		if ($activation)
		{
			// redirect them to the auth page
			$this->session->set_flashdata('message', $this->ion_auth->messages());
			//redirect("users/auth/index");
			redirect("dashboard");
		}
		else
		{
			// redirect them to the forgot password page
			$this->session->set_flashdata('message', $this->ion_auth->errors());
			redirect("auth/forgot_password");
		}
	}

	// edit a user
	public function edit_user($id)
	{
		$this->data['title'] = $this->lang->line('edit_user_heading');		
		if (!$this->ion_auth->logged_in() || (!$this->ion_auth->is_admin() && !($this->ion_auth->user()->row()->id == $id)))
		{
			redirect('auth');
		}

		$user = $this->ion_auth->user($id)->row();
		$groups=$this->ion_auth->groups()->result_array();
		$currentGroups = $this->ion_auth->get_users_groups($id)->result();

		// validate form input
		$this->form_validation->set_rules('first_name', $this->lang->line('edit_user_validation_fname_label'), 'required');
		$this->form_validation->set_rules('last_name', $this->lang->line('edit_user_validation_lname_label'), 'required');
		$this->form_validation->set_rules('phone', $this->lang->line('edit_user_validation_phone_label'), 'required');
		$this->form_validation->set_rules('user_own_paypal', __('label_email'), 'valid_email');
		$this->form_validation->set_rules('user_own_skrill', __('label_email'), 'valid_email');
		$this->form_validation->set_rules('company', $this->lang->line('edit_user_validation_company_label'), 'required');

		if (isset($_POST) && !empty($_POST))
		{
			// do we have a valid request?
			if ($this->_valid_csrf_nonce() === FALSE || $id != $this->input->post('id'))
			{
				show_error($this->lang->line('error_csrf'));
			}

			// update the password if it was posted
			if ($this->input->post('password'))
			{
				$this->form_validation->set_rules('password', $this->lang->line('edit_user_validation_password_label'), 'required|min_length[' . $this->config->item('min_password_length', 'ion_auth') . ']|max_length[' . $this->config->item('max_password_length', 'ion_auth') . ']|matches[password_confirm]');
				$this->form_validation->set_rules('password_confirm', $this->lang->line('edit_user_validation_password_confirm_label'), 'required');
			}

			if ($this->form_validation->run() === TRUE)
			{
				$data = array(
					'first_name' => $this->input->post('first_name'),
					'last_name'  => $this->input->post('last_name'),
					'company'    => $this->input->post('company'),
					'phone'      => $this->input->post('phone'),
					'user_own_paypal'      => $this->input->post('user_own_paypal'),
					'user_own_skrill'      => $this->input->post('user_own_skrill'),
					'user_own_bank_number'      => $this->input->post('user_own_bank_number'),
				);

				// update the password if it was posted
				if ($this->input->post('password'))
				{
					$data['password'] = $this->input->post('password');
				}

				// Only allow updating groups if user is admin
				if ($this->ion_auth->is_admin())
				{
					//Update the groups user belongs to
					$groupData = $this->input->post('groups');

					if (isset($groupData) && !empty($groupData)) {

						$this->ion_auth->remove_from_group('', $id);

						foreach ($groupData as $grp) {
							$this->ion_auth->add_to_group($grp, $id);
						}

					}
				}

			// check to see if we are updating the user
			   if($this->ion_auth->update($user->id, $data))
			    {
			    	// redirect them back to the admin page if admin, or to the base url if non admin
				    $this->session->set_flashdata('message', $this->ion_auth->messages() );
				    if ($this->ion_auth->is_admin())
					{
						redirect('dashboard');
					}
					else
					{
						redirect('/');
					}

			    }
			    else
			    {
			    	// redirect them back to the admin page if admin, or to the base url if non admin
				    $this->session->set_flashdata('message', $this->ion_auth->errors() );
				    if ($this->ion_auth->is_admin())
					{
						redirect('auth');
					}
					else
					{
						redirect('/');
					}

			    }

			}
		}

		// display the edit user form
		$this->data['csrf'] = $this->_get_csrf_nonce();

		// set the flash data error message if there is one
		$this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));

		// pass the user to the view
		$this->data['user'] = $user;
		$this->data['groups'] = $groups;
		$this->data['currentGroups'] = $currentGroups;

		$this->data['user_id'] = array(
			'value' => $this->form_validation->set_value('user_id', $user->id),
		);
		$this->data['first_name'] = array(
			'name'  => 'first_name',
			'id'    => 'first_name',
			'type'  => 'text',
			'value' => $this->form_validation->set_value('first_name', $user->first_name),
		);
		$this->data['last_name'] = array(
			'name'  => 'last_name',
			'id'    => 'last_name',
			'type'  => 'text',
			'value' => $this->form_validation->set_value('last_name', $user->last_name),
		);
		$this->data['email'] = array(
			'name'  => 'email',
			'id'    => 'email',
			'type'  => 'text',
			'value' => $this->form_validation->set_value('email', $user->email),
		);
		$this->data['company'] = array(
			'name'  => 'company',
			'id'    => 'company',
			'type'  => 'text',
			'value' => $this->form_validation->set_value('company', $user->company),
		);
		$this->data['phone'] = array(
			'name'  => 'phone',
			'id'    => 'phone',
			'type'  => 'text',
			'value' => $this->form_validation->set_value('phone', $user->phone),
		);
		$this->data['user_own_paypal'] = array(
			'name'  => 'user_own_paypal',
			'id'    => 'user_own_paypal',
			'type'  => 'text',
			'value' => $this->form_validation->set_value('user_own_paypal', $user->user_own_paypal),
		);
		$this->data['user_own_skrill'] = array(
			'name'  => 'user_own_skrill',
			'id'    => 'user_own_skrill',
			'type'  => 'text',
			'value' => $this->form_validation->set_value('user_own_skrill', $user->user_own_skrill),
		);
		$this->data['user_own_bank_number'] = array(
			'name'  => 'user_own_bank_number',
			'id'    => 'user_own_bank_number',
			'type'  => 'text',
			'value' => $this->form_validation->set_value('user_own_bank_number', $user->user_own_bank_number),
		);
		$this->data['user_address1'] = array(
			'name'  => 'user_address1',
			'id'    => 'user_address1',
			'type'  => 'text',
			'value' => $this->form_validation->set_value('user_address1', $user->user_address1),
		);
		$this->data['user_address2'] = array(
			'name'  => 'user_address2',
			'id'    => 'user_address2',
			'type'  => 'text',
			'value' => $this->form_validation->set_value('user_address2', $user->user_address2),
		);
		$this->data['user_city'] = array(
			'name'  => 'user_city',
			'id'    => 'user_city',
			'type'  => 'text',
			'value' => $this->form_validation->set_value('user_city', $user->user_city),
		);
		$this->data['user_state'] = array(
			'name'  => 'user_state',
			'id'    => 'user_state',
			'type'  => 'text',
			'value' => $this->form_validation->set_value('user_state', $user->user_state),
		);
		$this->data['user_postcode'] = array(
			'name'  => 'user_postcode',
			'id'    => 'user_postcode',
			'type'  => 'text',
			'value' => $this->form_validation->set_value('user_postcode', $user->user_postcode),
		);
		$this->data['user_country'] = array(
			'name'  => 'user_country',
			'id'    => 'user_country',
			'type'  => 'text',
			'value' => $this->form_validation->set_value('user_country', $user->user_country),
		);
		$this->data['user_about'] = array(
			'name'  => 'user_about',
			'id'    => 'user_about',
			'type'  => 'text',
			'value' => $this->form_validation->set_value('user_about', $user->user_about),
		);
		$this->data['user_website'] = array(
			'name'  => 'user_website',
			'id'    => 'user_website',
			'type'  => 'text',
			'value' => $this->form_validation->set_value('user_website', $user->user_website),
		);
		$this->data['password'] = array(
			'name' => 'password',
			'id'   => 'password',
			'type' => 'password'
		);
		$this->data['password_confirm'] = array(
			'name' => 'password_confirm',
			'id'   => 'password_confirm',
			'type' => 'password'
		);
		$this->data['error'] = '';
		$this->data['user_id'] = $id;
		$this->data['user_commissions'] = get_user_commissions($id);
		$this->data['commissions_totals'] = commissions_total_by_user($id);
		$data['content'] = $this->Template->render('users', 'edit_user.phtml', $this->data, TRUE);
		$data['localPluginJs'] = array(
                    'bootstrap-fileinput/bootstrap-fileinput.js'
                );
		$this->Template->render('templates', 'layout.phtml', $data);
	}

	// create a new group
	public function create_group()
	{
		$this->data['title'] = $this->lang->line('create_group_title');

		if (!$this->ion_auth->logged_in() || !$this->ion_auth->is_admin())
		{
			redirect('auth');
		}

		// validate form input
		$this->form_validation->set_rules('group_name', $this->lang->line('create_group_validation_name_label'), 'required');

		if ($this->form_validation->run() == TRUE)
		{
			$new_group_id = $this->ion_auth->create_group($this->input->post('group_name'), $this->input->post('description'));
			if($new_group_id)
			{
				// check to see if we are creating the group
				// redirect them back to the admin page
				$this->session->set_flashdata('message', $this->ion_auth->messages());
				redirect("auth");
			}
		}
		else
		{
			// display the create group form
			// set the flash data error message if there is one
			$this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));

			$this->data['group_name'] = array(
				'name'  => 'group_name',
				'id'    => 'group_name',
				'type'  => 'text',
				'value' => $this->form_validation->set_value('group_name'),
			);
			$this->data['description'] = array(
				'name'  => 'description',
				'id'    => 'description',
				'type'  => 'text',
				'value' => $this->form_validation->set_value('description'),
			);

			$this->Template->render('users', 'auth/create_group.phtml', $this->data);
		}
	}

	// edit a group
	public function edit_group($id)
	{
		// bail if no group id given
		if(!$id || empty($id))
		{
			redirect('dashboard');
		}

		$this->data['title'] = $this->lang->line('edit_group_title');

		if (!$this->ion_auth->logged_in() || !$this->ion_auth->is_admin())
		{
			redirect('dashboard');
		}

		$group = $this->ion_auth->group($id)->row();

		// validate form input
		$this->form_validation->set_rules('group_name', $this->lang->line('edit_group_validation_name_label'), 'required');

		if (isset($_POST) && !empty($_POST))
		{
			if ($this->form_validation->run() === TRUE)
			{
				$group_update = $this->ion_auth->update_group($id, $_POST['group_name'], $_POST['group_description']);

				if($group_update)
				{
					$this->session->set_flashdata('message', $this->lang->line('edit_group_saved'));
				}
				else
				{
					$this->session->set_flashdata('message', $this->ion_auth->errors());
				}
				redirect("settings/index?a=users");
			}
		}

		// set the flash data error message if there is one
		$this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));

		// pass the user to the view
		$this->data['group'] = $group;
		
		$this->data['readonly'] = array(
			'value' => $this->config->item('admin_group', 'ion_auth') === $group->name ? 'readonly' : ''
			);
		$this->data['group_name'] = array(
			'name'    => 'group_name',
			'id'      => 'group_name',
			'type'    => 'text',
			'value'   => $this->form_validation->set_value('group_name', $group->name)
		);
		$this->data['group_description'] = array(
			'name'  => 'group_description',
			'id'    => 'group_description',
			'type'  => 'text',
			'value' => $this->form_validation->set_value('group_description', $group->description),
		);
		$this->data['group_id'] = array(
			'name'  => 'group_id',
			'id'    => 'group_id',
			'type'  => 'text',
			'value' => $this->form_validation->set_value('group_id', $group->id),
		);

		$data['content'] = $this->Template->render('users', 'auth/edit_group.phtml', $this->data, TRUE);
		$this->Template->render('templates', 'layout.phtml', $data);
	}


	public function _get_csrf_nonce()
	{
		$this->load->helper('string');
		$key   = random_string('alnum', 8);
		$value = random_string('alnum', 20);
		$this->session->set_flashdata('csrfkey', $key);
		$this->session->set_flashdata('csrfvalue', $value);

		return array($key => $value);
	}

	public function _valid_csrf_nonce()
	{
		if ($this->input->post($this->session->flashdata('csrfkey')) !== FALSE &&
			$this->input->post($this->session->flashdata('csrfkey')) == $this->session->flashdata('csrfvalue'))
		{
			return TRUE;
		}
		else
		{
			return FALSE;
		}
	}

	public function _render_page($module, $view, $data=null, $returnhtml=false)//I think this makes more sense
	{

		$this->viewdata = (empty($data)) ? $this->data: $data;

		$view_html = $this->Template->render($module, $view, $this->viewdata, $returnhtml);

		if ($returnhtml) return $view_html;//This will return html on 3rd argument being true
	}
    function calendar()
    {
    	$data = array();
    	$data['content'] = $this->Template->render('users', 'calendar.phtml', '', true);
    	$this->Template->render('templates', 'layout.phtml', $data);
    }
    function edit_profile()
    {
    	$data = array();
    	$data['content'] = $this->Template->render('users', 'edit_user.phtml', '', true);
    	$this->Template->render('templates', 'layout.phtml', $data);
    }
    function lock_screen()
    {
    	$data = array();
    	$data['content'] = $this->Template->render('users', 'lock_screen.phtml', '', true);
    	$this->Template->render('templates', 'layout.phtml', $data);
    }
    public function check_client_password($client_email, $client_password) {

    	return boolval(password_verify($client_password, client(get_client_id(null, $client_email), 'client_password')));
    }

}
