var CashFlow = (function($) {
    var handleTaxReportTable = function() {
            var start = moment().subtract(29, 'days');
            var end = moment();
            var $from = $('#report-str').data('from');
            var $to = $('#report-str').data('to');
            var defaultUrl = $('#base-url').data('target') + 'index.php/reports/cashflow?start=' + start.format('YYYY-MM-DD') + '&end=' + end.format('YYYY-MM-DD');

            var chartTotalUrl = $('#base-url').data('target') + 'index.php/reports/get_tax_total';
            $.getJSON(chartTotalUrl, {start: start.format('YYYY-MM-DD'), end: end.format('YYYY-MM-DD')}, function(response){
                $('#incomes-total').text(accounting.formatMoney(response.invoice_total));
                $('#charges-total').text(accounting.formatMoney(response.charges_total));
            });

            $('#report-range-text').text('* '+ $from + ' '+start.format('YYYY-MM-DD') + ' ' +$to + ' '+end.format('YYYY-MM-DD') );
            $('#cashflowTable').bootstrapTable('refresh', {
                url: defaultUrl
            });
            $('#tax-report-range').on('apply.daterangepicker', function(ev, picker) {
              start = picker.startDate.format('YYYY-MM-DD');
              end = picker.endDate.format('YYYY-MM-DD');

              var chartTotalUrl = $('#base-url').data('target') + 'index.php/reports/get_tax_total';
              $.getJSON(chartTotalUrl, {start: start, end: end}, function(response){
                    $('#incomes-total').text(accounting.formatMoney(response.invoice_total));
                    $('#charges-total').text(accounting.formatMoney(response.charges_total));
              });

              newUrl = $('#base-url').data('target') + 'index.php/reports/cashflow?start=' + start + '&end=' + end;
               $('#report-range-text').text("");
               $('#report-range-text').text('* ' + $from + ' '+start + ' '+$to + ' '+end );
              $('#cashflowTable').bootstrapTable('refresh', {
                  url: newUrl
              });
            });
        };
    return {
        init: function() {
            handleTaxReportTable()
        }
    }
})(jQuery);
jQuery(document).ready(function() {
    CashFlow.init()
});
