var chargesCharts = (function($) {
    var handleChargesPieCharts = function() {
        var pieChart = echarts.init(document.getElementById("echarts_pie_charges")),
            options = {
                tooltip: {
                    trigger: "item",
                    formatter: "{a} <br/>{b}: {c} ({d}%)"
                },
                legend: {
                    orient: "horizontal",
                    x: "center",
                    y: "bottom",
                    padding: 0,
                    data: $("#items-sums").data("legend")
                },
                series: [{
                    name: '',
                    type: "pie",
                    selectedMode: "single",
                    radius: ["50%", "75%"],
                    avoidLabelOverlap: false,
                    label: {
                        normal: {
                            show: !1,
                            position: 'center'
                        },
                        emphasis: {
                            show: true,
                            textStyle: {
                                fontSize: '15',
                                fontWeight: 'bold'
                            }
                        }
                    },
                    labelLine: {
                        normal: {
                            show: !1
                        }
                    },
                    data: []
                }]
            };

        interval = 'all';
        // Count item sold
        chargesUrl = $("#base-url").data("target") + "index.php/charges/get_charges_per_category", $.getJSON(chargesUrl, {
            interval: interval
        }).done(function(e) {
            pieChart.setOption({
                series: [{
                    name: '',
                    data: e
                }]
            })
        });
        // Resize the graph
        jQuery(window).on("resize", function() {
            null != pieChart && void 0 != pieChart && pieChart.resize()
        });
        pieChart.setOption(options);
    },

    handleDeleteCharges = function(){
        var $table = $('#chargesTable'),
            $remove = $('#remove-charges'),
            selections = [];

        // sometimes footer render error.
        setTimeout(function () {
            $table.bootstrapTable('resetView');
        }, 200);
        $table.on('check.bs.table uncheck.bs.table ' +
                        'check-all.bs.table uncheck-all.bs.table', function () {
                    $remove.prop('disabled', !$table.bootstrapTable('getSelections').length);

                    // save your data, here just save the current page
                    selections = getIdSelections();
                    // push or splice the selections if you want to save all data selections
                });
        $remove.click(function () {
            var ids = getIdSelections();
            $base_url = $('#base-url').data('target'),
            $url = $.trim( $base_url + 'index.php/charges/delete_charges' );
            $this = $('#remove-charges');
            swal({
              title: $this.data('sure'),
              text: $this.data('message'),
              type: "warning",
              showCancelButton: true,
              cancelButtonText: $('#btn-cancel').data('text'),
              confirmButtonClass: "btn-danger",
              confirmButtonText: $this.data('confirm'),
              closeOnConfirm: true
            },
            function(){ 
                $.getJSON({
                    url: $url,
                    data: {
                        id: ids
                    },
                    success: function (data) {
                        if (data.success > 0)
                        {
                            $table.bootstrapTable('remove', {
                                field: 'transaction_id',
                                values: ids
                            });
                            App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#remove-charges').data('success')});
                            $remove.prop('disabled', true);
                        }
                        if(data.fail > 0)
                        {
                            App.alert({container: $('#notification-alert'), type: "danger", close: true, message: $('#remove-charges').data('danger') + '&nbsp;' + data.fail});
                            setTimeout(function () {
                                $table.bootstrapTable('refresh', true);
                            }, 200);
                            $remove.prop('disabled', true);
                        }
                    }
                });
            });
        });
        function getIdSelections() {
            return $.map($table.bootstrapTable('getSelections'), function (row) {
                return row.transaction_id
            });
        }
    },
    handleChargesAutocomplete = function(){
        url = $('#base-url').data('target') + 'index.php/products/get_items_services_name';
        $.getJSON(url, function(data){
            $( "#charges-autocomplete" ).autocomplete({
              source: data
            });
            $("#charges-autocomplete").autocomplete( "option", "appendTo", "#charges-add-modal");
        });
    };
    return {
        init: function() {
            handleChargesPieCharts(),
            handleChargesAutocomplete(),
            handleDeleteCharges()
        }
    }
})(jQuery);
jQuery(document).ready(function() {
    chargesCharts.init()
});