var RepairStatus = (function($){
	var handleCheckTicketStatus = function() {
		const urlParams = new URLSearchParams(window.location.search);
		const $reference = urlParams.get('reference');

		if ($reference) {
			$('#reference').val($reference);
			$.getJSON({
			    url: $('#base-url').data('target') + 'index.php/client/get_repair_status',
			    data: {
			        reference: $reference
			    },
			    success: function (data) {
			        if (data.success == 1) {
			            $('#status-fail').removeClass('hidden');
			            $('#status-fail').addClass('hidden');
			            $('.status-success').removeClass('hidden');
			            drawTable(jQuery.parseJSON(data.status));
			        } else {
			            $('.status-success').removeClass('hidden').addClass('hidden');
			            $('#status-fail').removeClass('hidden');
			        }
			    }
			});
		}
    	$('#btn-check-status-cancel').on('click', function(){
    		if ($reference) {
    			window.location = $('#base-url').data('target') + 'index.php/client/view_repair_status';
    		} else {
    			$('#reference').val('');
    			$("#repairTable").find("tr:gt(0)").remove();
    			$('.status-success').removeClass('hidden').addClass('hidden');
    			$('#status-fail').removeClass('hidden').addClass('hidden');
    		}
    	});
    	$('#btn-check-status').on('click', function(){
    		$("#repairTable").find("tr:gt(0)").remove();
    	    $.getJSON({
    	        url: $('#base-url').data('target') + 'index.php/client/get_repair_status',
    	        data: {
    	            reference: $('#reference').val().trim()
    	        },
    	        success: function (data) {
    	            if (data.success == 1) {
    	                $('#status-fail').removeClass('hidden').addClass('hidden');
    	                $('.status-success').removeClass('hidden');
    	                drawTable(jQuery.parseJSON(data.status));
    	            } else {
    	                $('.status-success').removeClass('hidden').addClass('hidden');
    	                $('#status-fail').removeClass('hidden');
    	            }
    	        }
    	    });
    	});
    	$('.repair-reference').on('click', function(){
    		var $this = $(this),
    			$reference = $this.data('reference');
    		$("#repairTable").find("tr:gt(0)").remove();
    		if ($reference !== "" || typeof($reference) !== 'undefined') {
    			$('#reference').val($reference);
    			$.getJSON({
    			    url: $('#base-url').data('target') + 'index.php/client/get_repair_status',
    			    data: {
    			        reference: $reference.trim()
    			    },
    			    success: function (data) {
    			        if (data.success == 1) {
    			            $('#status-fail').removeClass('hidden').addClass('hidden');
    			            $('.status-success').removeClass('hidden');
    			            drawTable(jQuery.parseJSON(data.status));
    			        } else {
    			            $('.status-success').removeClass('hidden').addClass('hidden');
    			            $('#status-fail').removeClass('hidden');
    			        }
    			    }
    			});
    		}
    	});
	};
	return {
		init: function(){
			handleCheckTicketStatus()
		}
	};
})(jQuery);
jQuery(document).ready(function() {
	RepairStatus.init()
});