var clientIncome = (function($) {
    var handlePieCharts = function() {
            var pieChart = echarts.init(document.getElementById("echarts_pie")),
                options = {
                    tooltip: {
                        trigger: "item",
                        formatter: "{a} <br/>{b}: {c} ({d}%)"
                    },
                    legend: {
                        orient: "vertical",
                        x: "left",
                        y: "left",
                        padding: 0,
                        show: false
                    },
                    toolbox: {
                        show: !0,
                        showTitle: !1,
                        feature: {
                            mark: {
                                show: !1
                            },
                            dataView: {
                                show: !1,
                                readOnly: !1
                            },
                            restore: {
                                show: !0
                            },
                            saveAsImage: {
                                show: !0
                            }
                        }
                    },
                    series: [{
                        name: '',
                        type: "pie",
                        selectedMode: "single",
                        radius: ["50%", "75%"],
                        avoidLabelOverlap: true,
                        label: {
                            normal: {
                                show: true
                            },
                            emphasis: {
                                show: true
                            }
                        },
                        labelLine: {
                            normal: {
                                show: true
                            },
                            emphasis: {
                                show: true
                            }
                        },
                        data: []
                    }]
                };
            // Dynamic range
            $('#tax-report-range').on('apply.daterangepicker', function(ev, picker) {
                start = picker.startDate.format('YYYY-MM-DD');
                end = picker.endDate.format('YYYY-MM-DD');

                url = $("#base-url").data("target") + "index.php/reports/get_income_by_client", $.getJSON(url, {
                    start: start,
                    end: end
                }).done(function(e) {
                    pieChart.setOption({
                        series: [{
                            name: '',
                            data: e
                        }]
                    })
                });
                url2 = $('#base-url').data('target') + 'index.php/reports/get_income_by_client?start='+start+'&end='+end;
                $('#home-items-count').bootstrapTable('refresh', {url: url2});
            });

            // Default range
            url = $("#base-url").data("target") + "index.php/reports/get_income_by_client", $.getJSON(url, {
                start: start.format('YYYY-MM-DD'),
                end: end.format('YYYY-MM-DD')
            }).done(function(e) {
                pieChart.setOption({
                    series: [{
                        name: '',
                        data: e
                    }]
                })
            });
            url2 = $('#base-url').data('target') + 'index.php/reports/get_income_by_client?start='+start.format('YYYY-MM-DD')+'&end='+end.format('YYYY-MM-DD');
            $('#home-items-count').bootstrapTable('refresh', {url: url2});

            // Resize the graph
            jQuery(window).on("resize", function() {
                null != pieChart && void 0 != pieChart && pieChart.resize()
            });
            pieChart.setOption(options);
        };
    return {
        init: function() {
            handlePieCharts()
        }
    }
})(jQuery);
jQuery(document).ready(function() {
    clientIncome.init()
});