var ClientInvoicesIndex = (function($){
	var handleClientMassApproved = function(){
		var $table = $('#clientQuoteTable'),
		    $markApproved = $('#quote-mark-approved'),
		    selections = [];

		// sometimes footer render error.
		setTimeout(function () {
			$table.bootstrapTable('resetView');
		}, 200);
		$table.on('check.bs.table uncheck.bs.table ' +
		                'check-all.bs.table uncheck-all.bs.table', function () {
		            $markApproved.prop('disabled', !$table.bootstrapTable('getSelections').length);

		            // save your data, here just save the current page
		            selections = getIdSelections();
		            // push or splice the selections if you want to save all data selections
		        });
		$markApproved.click(function () {
		    var ids = getIdSelections();
		    $base_url = $('#base-url').data('target'),
		    $url = $.trim( $base_url + 'index.php/client/mark_approved' );
		    $this = $('#quote-mark-approved');
		    swal({
		      title: $this.data('sure'),
		      text: $this.data('message'),
		      type: "warning",
		      showCancelButton: true,
		      confirmButtonClass: "btn-danger",
		      confirmButtonText: $this.data('confirm'),
		      cancelButtonText: $('#btn-cancel').data('text'),
		      closeOnConfirm: true
		    },
		    function(){ 
		        $.getJSON({
		            url: $url,
		            data: {
		                id: ids
		            },
		            success: function (data) {
		            	if (data.success > 0)
		            	{
		            		App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#quote-mark-approved').data('success')});
		            		setTimeout(function () {
		            			$table.bootstrapTable('refresh', true);
		            		}, 200);
		            		$markApproved.prop('disabled', true);
		            	}
		            	if(data.fail > 0)
		            	{
		            		App.alert({container: $('#notification-alert'), type: "danger", close: true, message: $('#quote-mark-approved').data('danger') + ' ' + data.fail });
		            		setTimeout(function () {
		            			$table.bootstrapTable('refresh', true);
		            		}, 200);
		            		$markApproved.prop('disabled', true);
		            	}
		            }
		        });
		    });
		});
		function getIdSelections() {
		    return $.map($table.bootstrapTable('getSelections'), function (row) {
		        return row.enc_quote_number
		    });
		}
	},
	handleClientMassEmailQuotes = function(){
		var $table = $('#clientQuoteTable'),
		    $markSent = $('#quote-send-email'),
		    selections = [];

		// sometimes footer render error.
		setTimeout(function () {
			$table.bootstrapTable('resetView');
		}, 200);
		$table.on('check.bs.table uncheck.bs.table ' +
		                'check-all.bs.table uncheck-all.bs.table', function () {
		            $markSent.prop('disabled', !$table.bootstrapTable('getSelections').length);

		            // save your data, here just save the current page
		            selections = getIdSelections();
		            // push or splice the selections if you want to save all data selections
		        });
		$markSent.click(function () {
		    var ids = getIdSelections();
		    $base_url = $('#base-url').data('target'),
		    $url = $.trim( $base_url + 'index.php/client/mass_quotes_email' );
		    $this = $('#quote-send-email');
		    swal({
		      title: $this.data('sure'),
		      text: $this.data('message'),
		      type: "warning",
		      showCancelButton: true,
		      confirmButtonClass: "btn-danger",
		      confirmButtonText: $this.data('confirm'),
		      cancelButtonText: $('#btn-cancel').data('text'),
		      closeOnConfirm: true
		    },
		    function(){ 
		        $.getJSON({
		            url: $url,
		            data: {
		                id: ids
		            },
		            success: function (data) {
		            	if (data.success > 0)
		            	{
		            		App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#quote-send-email').data('success')});
		            		setTimeout(function () {
		            			$table.bootstrapTable('refresh', true);
		            		}, 200);
		            		$markSent.prop('disabled', true);
		            	}
		            	if(data.fail > 0)
		            	{
		            		App.alert({container: $('#notification-alert'), type: "danger", close: true, message: $('#quote-send-email').data('danger') + ' ' + data.fail });
		            		setTimeout(function () {
		            			$table.bootstrapTable('refresh', true);
		            		}, 200);
		            		$markSent.prop('disabled', true);
		            	}
		            }
		        });
		    });
		});
		function getIdSelections() {
		    return $.map($table.bootstrapTable('getSelections'), function (row) {
		        return row.enc_quote_number;
		    });
		}
	};
	return {
		init: function(){
			handleClientMassEmailQuotes(),
			handleClientMassApproved()
		}
	}
})(jQuery);
jQuery(document).ready(function() {
	ClientInvoicesIndex.init()
});
