var Clients = (function($){
	var handleAddClient = function(){
		var options = {
			dataType: 'json',
			uploadProgress: ajaxDone,
			success: addClientFormServerResponse
		};
		$("#client-add-form").submit(function() {
			$(".btn-submit").attr("disabled","disabled");
			$(".btn-submit").text($('#btn-loading').data('text'));
			$(this).ajaxSubmit(options);	
			return false;
		});
	},
	handleUpdateClient = function(){
		var options = {
			dataType: 'json',
			uploadProgress: ajaxDone,
			success: updateClientFormServerResponse
		};
		$("#client-update-form").submit(function() {
			$(".btn-submit").attr("disabled","disabled");
			$(".btn-submit").text($('#btn-loading').data('text'));
			$(this).ajaxSubmit(options);	
			return false;
		});
	},
	handleCustomSearch = function(){
		$(function() {
		  $('#table').bootstrapTable({
		    formatSearch: function () {
		      return 'Search'
		    }
		  })
		})

		function clientSearch(data, text) {
		  return data.filter(function (row) {
		    return row.name_company.indexOf(text) > -1
		  })
		}
	},
	handleClientActivation = function(){
		var $table = $('#table'),
		    $activation = $('#activate-client'),
		    selections = [];

		// sometimes footer render error.
		setTimeout(function () {
			$table.bootstrapTable('resetView');
		}, 200);
		$table.on('check.bs.table uncheck.bs.table ' +
		                'check-all.bs.table uncheck-all.bs.table', function () {
		            $activation.prop('disabled', !$table.bootstrapTable('getSelections').length);

		            // save your data, here just save the current page
		            selections = getIdSelections();
		            // push or splice the selections if you want to save all data selections
		        });
		$activation.click(function () {
		    var ids = getIdSelections();
		    $base_url = $('#base-url').data('target'),
		    $url = $.trim( $base_url + 'index.php/clients/activate_client' );
		    $this = $('#activate-client');
		    swal({
		      title: $this.data('sure'),
		      text: $this.data('message'),
		      type: "warning",
		      showCancelButton: true,
		      confirmButtonClass: "btn-warning",
		      confirmButtonText: $this.data('confirm'),
		      cancelButtonText: $('#btn-cancel').data('text'),
		      closeOnConfirm: true
		    },
		    function(){ 
		        $.getJSON({
		            url: $url,
		            data: {
		                id: ids
		            },
		            success: function (data) {
		            	if (data.success > 0)
		            	{
		            		App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#activate-client').data('success')});
		            		setTimeout(function () {
		            			$table.bootstrapTable('refresh', true);
		            		}, 200);
		            		$activation.prop('disabled', true);
		            	}
		            	if(data.fail > 0)
		            	{
		            		App.alert({container: $('#notification-alert'), type: "danger", close: true, message: $('#activate-client').data('danger')});
		            		setTimeout(function () {
		            			$table.bootstrapTable('refresh', true);
		            		}, 200);
		            		$activation.prop('disabled', true);
		            	}
		            }
		        });
		    });
		});
		function getIdSelections() {
		    return $.map($table.bootstrapTable('getSelections'), function (row) {
		        return row.enc_client_id
		    });
		}
	},
	handleClientDesactivation = function(){
		var $table = $('#table'),
		    $desactivation = $('#desactivate-client'),
		    selections = [];

		// sometimes footer render error.
		setTimeout(function () {
			$table.bootstrapTable('resetView');
		}, 200);
		$table.on('check.bs.table uncheck.bs.table ' +
		                'check-all.bs.table uncheck-all.bs.table', function () {
		            $desactivation.prop('disabled', !$table.bootstrapTable('getSelections').length);

		            // save your data, here just save the current page
		            selections = getIdSelections();
		            // push or splice the selections if you want to save all data selections
		        });
		$desactivation.click(function () {
		    var ids = getIdSelections();
		    $base_url = $('#base-url').data('target'),
		    $url = $.trim( $base_url + 'index.php/clients/desactivate_client' );
		    $this = $('#desactivate-client');
		    swal({
		      title: $this.data('sure'),
		      text: $this.data('message'),
		      type: "warning",
		      showCancelButton: true,
		      confirmButtonClass: "btn-warning",
		      confirmButtonText: $this.data('confirm'),
		      cancelButtonText: $('#btn-cancel').data('text'),
		      closeOnConfirm: true
		    },
		    function(){ 
		        $.getJSON({
		            url: $url,
		            data: {
		                id: ids
		            },
		            success: function (data) {
		            	if (data.success > 0)
		            	{
		            		App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#desactivate-client').data('success')});
		            		setTimeout(function () {
		            			$table.bootstrapTable('refresh', true);
		            		}, 200);
		            		$desactivation.prop('disabled', true);
		            	}
		            	if(data.fail > 0)
		            	{
		            		App.alert({container: $('#notification-alert'), type: "danger", close: true, message: $('#desactivate-client').data('danger')});
		            		setTimeout(function () {
		            			$table.bootstrapTable('refresh', true);
		            		}, 200);
		            		$desactivation.prop('disabled', true);
		            	}
		            }
		        });
		    });
		});
		function getIdSelections() {
		    return $.map($table.bootstrapTable('getSelections'), function (row) {
		        return row.enc_client_id
		    });
		}
	},
	handleDeleteClient = function(){
		var $table = $('#table'),
		    $remove = $('#remove-client'),
		    selections = [];
		$('#table').bootstrapTable('refreshOptions', {
		    exportOptions: {ignoreColumn: ['0', 'checkbox', '7', 'client_status_str']}
		});
		// sometimes footer render error.
		setTimeout(function () {
			$table.bootstrapTable('resetView');
		}, 200);
		$table.on('check.bs.table uncheck.bs.table ' +
		                'check-all.bs.table uncheck-all.bs.table', function () {
		            $remove.prop('disabled', !$table.bootstrapTable('getSelections').length);

		            // save your data, here just save the current page
		            selections = getIdSelections();
		            // push or splice the selections if you want to save all data selections
		        });
		$remove.click(function () {
		    var ids = getIdSelections();
		    $base_url = $('#base-url').data('target'),
		    $url = $.trim( $base_url + 'index.php/clients/delete_client' );
		    $this = $('#remove-client');
		    swal({
		      title: $this.data('sure'),
		      text: $this.data('message'),
		      type: "warning",
		      showCancelButton: true,
		      confirmButtonClass: "btn-danger",
		      confirmButtonText: $this.data('confirm'),
		      cancelButtonText: $('#btn-cancel').data('text'),
		      closeOnConfirm: true
		    },
		    function(){ 
		        $.getJSON({
		            url: $url,
		            data: {
		                id: ids
		            },
		            success: function (data) {
		            	if (data.success > 0)
		            	{
		            		$table.bootstrapTable('remove', {
		            		    field: 'enc_client_id',
		            		    values: ids
		            		});
		            		App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#remove-client').data('success')});
		            		$remove.prop('disabled', true);
		            	}
		            	if(data.fail > 0)
		            	{
		            		App.alert({container: $('#notification-alert'), type: "danger", close: true, message: $('#remove-client').data('danger') + '&nbsp;' + data.fail});
		            		setTimeout(function () {
		            			$table.bootstrapTable('refresh', true);
		            		}, 200);
		            		$remove.prop('disabled', true);
		            	}
		            }
		        });
		    });
		});
		function getIdSelections() {
		    return $.map($table.bootstrapTable('getSelections'), function (row) {
		        return row.enc_client_id
		    });
		}
		function detailFormatter(index, row) {
		    var html = [];
		    $.each(row, function (key, value) {
		        html.push('<p><b>' + key + ':</b> ' + value + '</p>');
		    });
		    return html.join('');
		}
		function DoOnCellHtmlData(cell, row, col, data) {
		    var result = "";
		    if (typeof data != 'undefined' && data != "") {
		      var html = $.parseHTML(data);

		      $.each( html, function() {
		          if ( typeof $(this).html() === 'undefined' )
		              result += $(this).text();
		          else if ( typeof $(this).attr('class') === 'undefined' || $(this).hasClass('th-inner') === true )
		              result += $(this).html();
		      });
		    }
		    return result;
		}
	},
	handleDeleteShippingAddress = function(){
		var $table = $('#table'),
		    $remove = $('#remove-billingaddress'),
		    selections = [];
		$('#table').bootstrapTable('refreshOptions', {
		    exportOptions: {ignoreColumn: ['0', 'checkbox', '7', 'client_status_str']}
		});
		// sometimes footer render error.
		setTimeout(function () {
			$table.bootstrapTable('resetView');
		}, 200);
		$table.on('check.bs.table uncheck.bs.table ' +
		                'check-all.bs.table uncheck-all.bs.table', function () {
		            $remove.prop('disabled', !$table.bootstrapTable('getSelections').length);

		            // save your data, here just save the current page
		            selections = getIdSelections();
		            // push or splice the selections if you want to save all data selections
		        });
		$remove.click(function () {
		    var ids = getIdSelections();
		    $base_url = $('#base-url').data('target'),
		    $url = $.trim( $base_url + 'index.php/settings/delete_address' );
		    $this = $('#remove-billingaddress');
		    swal({
		      title: $this.data('sure'),
		      text: $this.data('message'),
		      type: "warning",
		      showCancelButton: true,
		      confirmButtonClass: "btn-danger",
		      confirmButtonText: $this.data('confirm'),
		      cancelButtonText: $('#btn-cancel').data('text'),
		      closeOnConfirm: true
		    },
		    function(){ 
		        $.getJSON({
		            url: $url,
		            data: {
		                id: ids
		            },
		            success: function (data) {
		            	if (data.success > 0)
		            	{
		            		$table.bootstrapTable('remove', {
		            		    field: 'enc_client_id',
		            		    values: ids
		            		});
		            		App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#remove-billingaddress').data('success')});
		            		$remove.prop('disabled', true);
		            	}
		            	if(data.fail > 0)
		            	{
		            		App.alert({container: $('#notification-alert'), type: "danger", close: true, message: $('#remove-billingaddress').data('danger') + '&nbsp;' + data.fail});
		            		setTimeout(function () {
		            			$table.bootstrapTable('refresh', true);
		            		}, 200);
		            		$remove.prop('disabled', true);
		            	}
		            }
		        });
		    });
		});
		function getIdSelections() {
		    return $.map($table.bootstrapTable('getSelections'), function (row) {
		        return row.enc_client_id
		    });
		}
		function detailFormatter(index, row) {
		    var html = [];
		    $.each(row, function (key, value) {
		        html.push('<p><b>' + key + ':</b> ' + value + '</p>');
		    });
		    return html.join('');
		}
		function DoOnCellHtmlData(cell, row, col, data) {
		    var result = "";
		    if (typeof data != 'undefined' && data != "") {
		      var html = $.parseHTML(data);

		      $.each( html, function() {
		          if ( typeof $(this).html() === 'undefined' )
		              result += $(this).text();
		          else if ( typeof $(this).attr('class') === 'undefined' || $(this).hasClass('th-inner') === true )
		              result += $(this).html();
		      });
		    }
		    return result;
		}
	},
	handleIncomeByClient = function(){
		var url = $('.actions').data('target'),
			$range = 'this_month',
			$id = $('.actions').data('clientid');
		$.getJSON(url, {id: $id, range: $range}).done(function(data){
			$('#income-by-client').text(accounting.formatMoney(parseFloat(data[0])));
			$('#unpaid-by-client').text(accounting.formatMoney(parseFloat(data[1])));
			$('#range').text($('#this_month').text());
		});
		$('.income-by-client').on('click', function(){
			var $this = $(this),
				url = $('.actions').data('target'),
				$range = $this.data('range'),
				$id = $('.actions').data('clientid');
			$.getJSON(url, {id: $id, range: $range}).done(function(data){
				$('#income-by-client').text(accounting.formatMoney(parseFloat(data[0])));
				$('#unpaid-by-client').text(accounting.formatMoney(parseFloat(data[1])));
				$('#range').text($this.text());
			});
		});
	},
	addClientFormServerResponse = function(responseText, statusText, xhr, $form){
		if(responseText.status == 1)
		{
			App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#default-save-success').data('message')});
			$('#client-add-form').resetForm();
			$(".btn-submit").removeAttr("disabled");
			$(".btn-submit").text($('#btn-save').data('text'));
		}
		else
		{
			message = responseText.error;
			message = message.replace(/<\/?p[^>]*>/g, "");
			if( message != '')
			{
				App.alert({container: $('#notification-alert'), type: "danger", close: true, message: message});
			}
			else
			{
				App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#default-update-success').data('message')});
			}
			$(".btn-submit").removeAttr("disabled");
			$(".btn-submit").text($('#btn-save').data('text'));
		}
	},
	updateClientFormServerResponse = function(responseText, statusText, xhr, $form){
		if(responseText.status == 1)
		{
			App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#default-update-success').data('message')});
			$(".btn-submit").removeAttr("disabled");
			$(".btn-submit").text($('#btn-save').data('text'));
		}
		else
		{
			message = responseText.error;
			message = message.replace(/<\/?p[^>]*>/g, "");
			if( message != '')
			{
				App.alert({container: $('#notification-alert'), type: "danger", close: true, message: message});
			}
			else
			{
				App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#default-update-success').data('message')});
			}
			$(".btn-submit").removeAttr("disabled");
			$(".btn-submit").text($('#btn-save').data('text'));
		}
	},
	handleClientPassword = function(){
		var hasPassword = $('#has_password').data('value');
		var passwordMessage = $('#password_message').data('value');
		var pwdVerified = $('#has_password').data('pwdverified');
		var clientID = $('#client_id').data('value');
 		checkPwdUrl = $("#base-url").data('target') + 'index.php/client/check_password';
		if (hasPassword === 1 && pwdVerified !== 1)
		{
			bootbox.prompt({
			    title: passwordMessage,
			    inputType: 'password',
			    callback: function (result) {
			    	if (result)
			    	{
			    		$.getJSON(checkPwdUrl, {client_id: clientID, password: result}, function(data){
			    			if(data.success == 1)
			    			{
			    				$('#client-view').removeClass('hidden');
			    				$('#frontend-edit').removeClass('hidden');
			    			}
			    			else if(data.success == 0)
			    			{
			    				location.reload();
			    			}
			    		});
			    	}
			    	else
			    	{
			    		location.reload();
			    	}
			    }
			});
		}
		else
		{
			$('#client-view').removeClass('hidden');
			$('#frontend-edit').removeClass('hidden');
		}
	},
	handleItalianPro = function(){
		$client_type = parseInt($('#client-type').val());
		if ($client_type !== 2) {
			$('#italian-pro').removeClass('hidden');
			$('#italian-pro').addClass('hidden');
		} else {
			$('#italian-pro').removeClass('hidden');
		}
		$('#client-type').on('change', function(){
			$client_type = parseInt($('#client-type').val());
			if ($client_type !== 2) {
				$('#italian-pro').removeClass('hidden');
				$('#italian-pro').addClass('hidden');
			} else {
				$('#italian-pro').removeClass('hidden');
			}
		});
	},
	handleClientsGeolocation = function(){
		if($("#clients-map").length != 0) {
		  hasGeo = $('#has-geolocation').data('value');
		  if (hasGeo) {
		  	url = $('#base-url').data('target') + 'index.php/clients/get_clients_address';
		  	$("#clients-map").googleMap();
		  	$.getJSON(url, function(data){
		  	    $.each(data, function (key, value) {
		  	        $("#clients-map").addMarker({
		  	            address: value.address,
		  	            url: 'https://www.google.fr/maps/dir//' + value.address
		  	        });
		  	    });
		  	});
		  }
		}
	};
	return {
		init: function(){
			handleAddClient(), 
			handleUpdateClient(), 
			handleDeleteClient(), 
			handleIncomeByClient(),
			handleClientsGeolocation(),
			handleClientActivation(),
			handleClientDesactivation(),
			handleClientPassword(),
			handleItalianPro(),
			handleDeleteShippingAddress(),
			handleCustomSearch()
		}
	}
})(jQuery);
jQuery(document).ready(function() {
    Clients.init()
});
