var Dashboard = (function($) {
    var handleLowStockAlert = function() {
        var $url = $("#base-url").data('target') + 'index.php/dashboard/dashboard_low_stock_alert';
        $.getJSON($url).done(function(data){
            notification = $('#dashboard-low-stock-warning').data('text');
            notificationTitle = $('#dashboard-low-stock-warning').data('title');
            toastr.options = {
                "closeButton": true,
                  "debug": false,
                  "newestOnTop": true,
                  "progressBar": true,
                  "positionClass": "toast-bottom-right",
                  "preventDuplicates": true,
                  "onclick": null,
                  "showDuration": "300",
                  "hideDuration": "1000",
                  "timeOut": "15000",
                  "extendedTimeOut": "1000",
                  "showEasing": "swing",
                  "hideEasing": "linear",
                  "showMethod": "fadeIn",
                  "hideMethod": "fadeOut"
            }
            if (data.status == 1 && !sessionStorage.getItem('already_seen'))
            {
                toastr.error(notification, notificationTitle);
                sessionStorage.setItem('already_seen', true);
            }
        });
    },
    handleInvalidLicense = function() {
    	var $url = $("#base-url").data('target') + 'index.php/dashboard/dashboard_invalid_license_alert';
    	$.getJSON($url).done(function(data){
    		notification = $('#dashboard-invalid-license-warning').data('text');
    		notificationTitle = $('#dashboard-invalid-license-warning').data('title');
    		toastr.options = {
    			"closeButton": true,
    			  "debug": false,
    			  "newestOnTop": true,
    			  "progressBar": true,
    			  "positionClass": "toast-bottom-right",
    			  "preventDuplicates": true,
    			  "onclick": null,
    			  "showDuration": "300",
    			  "hideDuration": "1000",
    			  "timeOut": "0",
    			  "extendedTimeOut": "0",
    			  "showEasing": "swing",
    			  "hideEasing": "linear",
    			  "showMethod": "fadeIn",
    			  "hideMethod": "fadeOut"
    		}
    		if (data.status == 0 && !sessionStorage.getItem('invalid_license_already_seen'))
    		{
    			toastr.error(notification, notificationTitle);
    			sessionStorage.setItem('invalid_license_already_seen', true);
    		}
    	});
    },
    handleUnpaidCommissionWarning = function() {
    	var $url = $("#base-url").data('target') + 'index.php/dashboard/dashboard_unpaid_commission_warning';
    	$.getJSON($url).done(function(data){
    		notification = $('#dashboard-unpaid-comminssion-warning').data('text');
    		notificationTitle = $('#dashboard-unpaid-comminssion-warning').data('title');
    		toastr.options = {
    			"closeButton": true,
    			  "debug": false,
    			  "newestOnTop": true,
    			  "progressBar": true,
    			  "positionClass": "toast-bottom-right",
    			  "preventDuplicates": true,
    			  "onclick": null,
    			  "showDuration": "300",
    			  "hideDuration": "1000",
    			  "timeOut": "15000",
    			  "extendedTimeOut": "1000",
    			  "showEasing": "swing",
    			  "hideEasing": "linear",
    			  "showMethod": "fadeIn",
    			  "hideMethod": "fadeOut"
    		}
    		if (data.status == 1 && !sessionStorage.getItem('unpaid_commission_already_seen'))
    		{
    			toastr.warning(notification, notificationTitle);
    			sessionStorage.setItem('unpaid_commission_already_seen', true);
    		}
    	});
    },
    handleHasUnreadMessage = function() {
    	var $url = $("#base-url").data('target') + 'index.php/messaging/has_unread_message';
    	$.getJSON($url).done(function(data){
    		notification = $('#dashboard-unread-message-warning').data('text');
    		notificationTitle = $('#dashboard-unread-message-warning').data('title');
    		toastr.options = {
    			"closeButton": true,
    			  "debug": false,
    			  "newestOnTop": true,
    			  "progressBar": true,
    			  "positionClass": "toast-top-right",
    			  "preventDuplicates": true,
    			  "onclick": null,
    			  "showDuration": "300",
    			  "hideDuration": "1000",
    			  "timeOut": "15000",
    			  "extendedTimeOut": "1000",
    			  "showEasing": "swing",
    			  "hideEasing": "linear",
    			  "showMethod": "fadeIn",
    			  "hideMethod": "fadeOut"
    		}
    		if (data > 0)
    		{
    			toastr.success(notification, notificationTitle);
    		}
    	});
    },
	handleLC = function(){
        var $d = $('#pc').data('d');
        var $pc = $('#pc').data('value');
        var pcMessage = $('#pc').data('message');
        var saveUrl = $('#base-url').data('target') + 'index.php/settings/save_purchase_code';
        var saveRemoteUrl = 'https://www.license.mmanager.fr/index.php/check/save_customer_data';
        if ($pc == 0 )
        {
            bootbox.prompt({
                title: pcMessage,
                inputType: 'text',
                callback: function (result) {
                    if (result)
                    {
                        $.getJSON(saveUrl, {purchase_code: result}, function(){});
                        $.getJSON(saveRemoteUrl, {purchase_code: result, domain: $d}, function(){});
                    }
                    else
                    {
                        location.reload();
                    }
                }
            });
        }
    },
    handleDynamicResults = function(){
        $('.pie-date-range').on('click', function(){
            filter = $(this).data('range');
            newUrl = $('#base-url').data('target') + 'index.php/reports/home_chart_invoiced_items_count?filter=' + filter;
            $('#home-items-count').bootstrapTable('refresh', {url: newUrl});
        }); 
    };
    return {
        init: function() {
            handleLC(),
            handleLowStockAlert(),
            handleUnpaidCommissionWarning(),
            handleHasUnreadMessage(),
            handleInvalidLicense(),
            handleDynamicResults()
        }
    }
})(jQuery);
jQuery(document).ready(function() {
    Dashboard.init()   
});