var Import = (function($){
	
	var handleImport = function(){
		var options = {
			dataType:  'json',
			success: importServerResponse,
			error: function (err) {
			        App.alert({container: $('#notification-alert'), type: "danger", close: true, message: $('#importnotification').data('mismatch')});
			        $(".btn-submit").removeAttr("disabled");
			    }
		},
		ticketAttachmentOptions = {
			dataType:  'json',
			success: ticketAttachmentServerResponse,
			error: function (err) {
			        App.alert({container: $('#notification-alert'), type: "danger", close: true, message: $('#importnotification').data('mismatch')});
			        $(".btn-submit").removeAttr("disabled");
			    }
		};
		$('#import').submit(function(){
			$(".btn-submit").attr("disabled","disabled");
			$(this).ajaxSubmit(options);
			return false; 
		});
		$('#add-ticket-attachment').submit(function(){
			$(".btn-submit").attr("disabled","disabled");
			$('#add-ticket-attachment').ajaxSubmit(ticketAttachmentOptions);
			return false; 
		});
	},
	importServerResponse = function(responseText, statusText, xhr, $form){
		if(responseText.success > 0)
		{
			var list = '';
			if (typeof responseText.successlist != 'undefined' && responseText.successlist != "") {
				list = responseText.successlist;
			}
			App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#importnotification').data('success')+ list});
			if (responseText.pluginUrl) {
				setTimeout(function () {
					document.location.replace(responseText.pluginUrl);
				}, 200);
			}
			if (responseText.oxf == 1) {
				$('#importnotification').text(responseText.successlist);
			}
		}
		if(responseText.fail > 0)
		{
			App.alert({container: $('#notification-alert'), type: "danger", close: true, message: responseText.fail + ' '+ $('#importnotification').data('fail') + responseText.faillist});
			$(".btn-submit").removeAttr("disabled");
		}
	},
	ticketAttachmentServerResponse = function(responseText, statusText, xhr, $form){
		if(responseText.success > 0)
		{} else {}
	};
	return {
		init: function(){
			handleImport()
		}
	};
})(jQuery);
jQuery(document).ready(function() {
	Import.init()
});