var IncomeForecast = (function($) {
    var handleBarCharts = function() {
            // Init the bar chart
            var barChart = echarts.init(document.getElementById("echarts_bar")),
                $incomeWithTaxesLabel = $("#echarts_bar").data("incomewithtaxeslabel"),
                $taxesLabel = $("#echarts_bar").data("taxlabel"),
                $incomeLabel = $("#echarts_bar").data("incomelabel"),
                // Set Options
                options = {
                    title: {},
                    tooltip: {
                        trigger: 'axis',
                        axisPointer: {
                            type: 'cross',
                            axis: 'y'
                        }
                    },
                    legend: {
                        orient: "horizontal",
                        x: "center",
                        y: "bottom",
                        padding: 0,
                        data: [$taxesLabel, $incomeLabel, $incomeWithTaxesLabel],
                        selected: {
                           [$incomeWithTaxesLabel]: false,
                        }
                    },
                    grid: {
                        left: '3%',
                        right: '9%',
                        bottom: '5%',
                        containLabel: true
                    },
                    toolbox: {
                        show: !0,
                        showTitle: !1,
                        feature: {
                            mark: {
                                show: !1
                            },
                            dataView: {
                                show: !1,
                                readOnly: !1
                            },
                            magicType: {
                                show: !0,
                                type: ["line"]
                            },
                            restore: {
                                show: !0
                            },
                            saveAsImage: {
                                show: !0
                            }
                        }
                    },
                    yAxis: {
                        scale: true
                    },
                    xAxis: {
                        data: []
                    },
                    series: [{
                            name: $taxesLabel,
                            type: "line",
                            smooth: true,
                            showAllSymbol: true,
                            symbol: 'emptyCircle',
                            symbolSize: 15,
                            label: {
                                normal: {
                                    show: false,
                                    position: 'insideRight'
                                }
                            },
                            data: []
                        },
                        {
                            name: $incomeLabel,
                            type: "line",
                            smooth: true,
                            showAllSymbol: true,
                            symbol: 'emptyCircle',
                            symbolSize: 15,
                            label: {
                                normal: {
                                    show: false,
                                    position: 'insideRight'
                                }
                            },
                            data: []
                        },
                        {
                            name: $incomeWithTaxesLabel,
                            type: "line",
                            smooth: true,
                            showAllSymbol: true,
                            symbol: 'emptyCircle',
                            symbolSize: 15,
                            label: {
                                normal: {
                                    show: false,
                                    position: 'insideRight'
                                }
                            },
                            data: []
                        }
                    ]
                },
            url = $("#base-url").data("target") + "index.php/reports/income_forecast";

            barChart.showLoading();
            $.getJSON(url, {}).done(function(a) {
                if (a.length > 0 ) {
                    $('#no-data').removeClass('hidden');
                    $('#no-data').addClass('hidden');
                    $('#echarts_bar').show();
                } else {
                    barChart.hideLoading();
                    $('#echarts_bar').hide();
                    $('#no-data').removeClass('hidden');
                }
                $incomes = [], $incomesWithTax = [], $months = [], $taxes = [], $charges = [];
                for (var n = 0; n < a.length; n++) $incomesWithTax.push(a[n].incomeswithtax), $incomes.push(a[n].incomes), $months.push(a[n].month + "/" + a[n].year), $taxes.push(a[n].taxes);
                var total = 0,
                    results = 0,
                    taxes = 0,
                    color = '';
                $.each($incomes, function() {
                    total += this;
                });
                $.each($taxes, function() {
                    taxes += this;
                });

                barChart.hideLoading(), barChart.setOption({
                    series: [{
                            name: $taxesLabel,
                            type: "line",
                            smooth: true,
                            showAllSymbol: true,
                            symbol: 'emptyCircle',
                            symbolSize: 15,
                            label: {
                                normal: {
                                    show: false,
                                    position: 'insideRight'
                                }
                            },
                            data: $taxes
                        },
                        {
                            name: $incomeLabel,
                            type: "line",
                            smooth: true,
                            showAllSymbol: true,
                            symbol: 'emptyCircle',
                            symbolSize: 15,
                            label: {
                                normal: {
                                    show: false,
                                    position: 'insideRight'
                                }
                            },
                            data: $incomes
                        },
                        {
                            name: $incomeWithTaxesLabel,
                            type: "line",
                            smooth: true,
                            showAllSymbol: true,
                            symbol: 'emptyCircle',
                            symbolSize: 15,
                            label: {
                                normal: {
                                    show: false,
                                    position: 'insideRight'
                                }
                            },
                            data: $incomesWithTax
                        }
                    ],
                    yAxis: {
                        scale: true
                    },
                    xAxis: {
                        data: $months
                    }
                })
            });
        
            jQuery(window).on("resize", function() {
                null != barChart && void 0 != barChart && barChart.resize()
            });
            barChart.setOption(options);
        };
    return {
        init: function() {
            handleBarCharts()
        }
    }
})(jQuery);
jQuery(document).ready(function() {
    IncomeForecast.init()
});