var incomesCharts = (function($) {
    var handleIncomesPieCharts = function() {
        var pieChart = echarts.init(document.getElementById("echarts_pie_incomes")),
            options = {
                tooltip: {
                    trigger: "item",
                    formatter: "{a} <br/>{b}: {c} ({d}%)"
                },
                legend: {
                    orient: "horizontal",
                    x: "center",
                    y: "bottom",
                    padding: 0,
                    data: $("#items-sums").data("legend")
                },
                series: [{
                    name: '',
                    type: "pie",
                    selectedMode: "single",
                    radius: ["50%", "75%"],
                    avoidLabelOverlap: false,
                    label: {
                        normal: {
                            show: !1,
                            position: 'center'
                        },
                        emphasis: {
                            show: true,
                            textStyle: {
                                fontSize: '15',
                                fontWeight: 'bold'
                            }
                        }
                    },
                    labelLine: {
                        normal: {
                            show: !1
                        }
                    },
                    data: []
                }]
            };

        interval = 'all';
        // Count item sold
        incomesUrl = $("#base-url").data("target") + "index.php/incomes/get_incomes_per_category", $.getJSON(incomesUrl, {
            interval: interval
        }).done(function(e) {
            pieChart.setOption({
                series: [{
                    name: '',
                    data: e
                }]
            })
        });
        // Resize the graph
        jQuery(window).on("resize", function() {
            null != pieChart && void 0 != pieChart && pieChart.resize()
        });
        pieChart.setOption(options);
    };
    return {
        init: function() {
            handleIncomesPieCharts()
        }
    }
})(jQuery);
jQuery(document).ready(function() {
    incomesCharts.init()
});