var CgstReports = (function($) {
    var handleBarCharts = function() {
        // Init the bar chart
        var barChart = echarts.init(document.getElementById("cgst_echarts_tax_report")),
            // Set Options
            options = {
                title: {},
                color: ["#001a33", "#990000"],
                tooltip: {
                    trigger: 'axis',
                    axisPointer: {
                        type: 'shadow'
                    }
                },
                legend: {
                    orient: "horizontal",
                    x: "center",
                    y: "bottom",
                    padding: 0,
                    data: [$('#label-tax-value').data('label'), $('#label-subtotal').data('label')]
                },
                grid: {
                    left: '3%',
                    right: '9%',
                    bottom: '5%',
                    containLabel: true
                },
                xAxis: {
                    type: 'category',
                    data: []
                },
                yAxis: {
                    type: 'value'
                },
                series: [{
                        name: $('#label-subtotal').data('label'),
                        type: "bar",
                        stack: 'Total',
                        label: {
                            normal: {
                                show: false,
                                position: 'insideRight'
                            }
                        },
                        data: []
                    },
                    {
                        name: $('#label-tax-value').data('label'),
                        type: "bar",
                        stack: 'Total',
                        label: {
                            normal: {
                                show: false,
                                position: 'insideRight'
                            }
                        },
                        data: []
                    }
                ]
            };
            // Default Range set to the last 30 days
            var start = moment().subtract(2, 'months');
            var end = moment();

            function cb(start, end) {
                $('#cgst-tax-report-range span').html(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'));
            }

            $('#cgst-tax-report-range').daterangepicker({
                startDate: start,
                endDate: end,
                ranges: {
                    'Today': [moment(), moment()],
                    'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                    'Last 7 Days': [moment().subtract(6, 'days'), moment()],
                    'Last 30 Days': [moment().subtract(29, 'days'), moment()],
                    'This Month': [moment().startOf('month'), moment().endOf('month')],
                    'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
                }
            }, cb);

            cb(start, end);

            url = $("#base-url").data("target") + "index.php/reports/tax_report_cgst";
            barChart.showLoading();
            $.getJSON(url, {
                start: start.format('YYYY-MM-DD'),
                end: end.format('YYYY-MM-DD')
            }).done(function(a) {
                $cgstsubTotal = [], $cgstmonths = [], $cgst_tax_rate = [], $cgst_tax_value = [];
                for (var n = 0; n < a.length; n++) $cgstsubTotal.push(a[n].item_subtotal), $cgstmonths.push(a[n].month + "/" + a[n].year), $cgst_tax_rate.push(a[n].cgst_tax_rate), $cgst_tax_value.push(a[n].cgst_tax_value);
                var cgstsubTotal = 0,
                    cgst_tax_value = 0,
                    cgst_tax_rate = 0;
                $.each($cgstsubTotal, function() {
                    cgstsubTotal += this;
                });
                $.each($cgst_tax_value, function() {
                    cgst_tax_value += this;
                });
                $.each($cgst_tax_rate, function() {
                    cgst_tax_rate += this;
                });

                $('#cgst-tax-invoice-total').text(accounting.formatMoney(cgstsubTotal));
                $('#cgst-tax-tax-total').text(accounting.formatMoney(cgst_tax_rate));

                barChart.hideLoading(), barChart.setOption({
                    series: [{
                            name: $('#label-tax-value').data('label'),
                            type: "bar",
                            stack: 'Total',
                            label: {
                                normal: {
                                    show: false,
                                    position: 'insideRight'
                                }
                            },
                            data: $cgst_tax_value
                        },
                        {
                            name: $('#label-subtotal').data('label'),
                            type: "bar",
                            stack: 'Total',
                            label: {
                                normal: {
                                    show: false,
                                    position: 'insideRight'
                                }
                            },
                            data: $cgstsubTotal
                        }
                    ],
                    xAxis: {
                        data: $cgst_tax_rate
                    }
                })
            });

            // Dynamic range
            $('#cgst-tax-report-range').on('apply.daterangepicker', function(ev, picker) {
                url = $("#base-url").data("target") + "index.php/reports/tax_report_cgst";
                barChart.showLoading();
                $.getJSON(url, {
                    start: picker.startDate.format('YYYY-MM-DD'),
                    end: picker.endDate.format('YYYY-MM-DD')
                }).done(function(a) {
                    $cgstsubTotal = [], $cgstmonths = [], $cgst_tax_rate = [], $cgst_tax_value = [];
                    for (var n = 0; n < a.length; n++) $cgstsubTotal.push(a[n].item_subtotal), $cgstmonths.push(a[n].month + "/" + a[n].year), $cgst_tax_rate.push(a[n].cgst_tax_rate), $cgst_tax_value.push(a[n].cgst_tax_value);
                    var cgstsubTotal = 0,
                        cgst_tax_value = 0,
                        cgst_tax_rate = 0;
                    $.each($cgstsubTotal, function() {
                        cgstsubTotal += this;
                    });
                    $.each($cgst_tax_value, function() {
                        cgst_tax_value += this;
                    });
                    $.each($cgst_tax_rate, function() {
                        cgst_tax_rate += this;
                    });

                    $('#cgst-tax-invoice-total').text(accounting.formatMoney(cgstsubTotal));
                    $('#cgst-tax-tax-total').text(accounting.formatMoney(cgst_tax_rate));

                    barChart.hideLoading(), barChart.setOption({
                        series: [{
                                name: $('#label-tax-value').data('label'),
                                type: "bar",
                                stack: 'Total',
                                label: {
                                    normal: {
                                        show: false,
                                        position: 'insideRight'
                                    }
                                },
                                data: $cgst_tax_value
                            },
                            {
                                name: $('#label-subtotal').data('label'),
                                type: "bar",
                                stack: 'Total',
                                label: {
                                    normal: {
                                        show: false,
                                        position: 'insideRight'
                                    }
                                },
                                data: $cgstsubTotal
                            }
                        ],
                        xAxis: {
                            data: $cgst_tax_rate
                        }
                    })
                });
            });
            jQuery(window).on("resize", function() {
                null != barChart && void 0 != barChart && barChart.resize()
            });
            barChart.setOption(options);
        },
        handlecgstTaxReportTable = function() {
            var start = moment().subtract(29, 'days');
            var end = moment();
            var defaultUrl = $('#base-url').data('target') + 'index.php/reports/tax_report_cgst?start=' + start.format('YYYY-MM-DD') + '&end=' + end.format('YYYY-MM-DD');
            
            var chartTotalUrl = $('#base-url').data('target') + 'index.php/reports/get_tax_total';
            $.getJSON(chartTotalUrl, {start: start.format('YYYY-MM-DD'), end: end.format('YYYY-MM-DD')}, function(response){
                //$('#cgst-tax-invoice-total').text(accounting.formatMoney(response.invoice_total));
               // $('#cgst-tax-tax-total').text(accounting.formatMoney(response.cgst_tax_total));
            });

            $('#cgst-report-range-text').text('* From ' + start.format('YYYY-MM-DD') + ' to ' + end.format('YYYY-MM-DD') );
            $('#cgstTaxReportTable').bootstrapTable('refresh', {
                url: defaultUrl
            });
            $('#cgst-tax-report-range').on('apply.daterangepicker', function(ev, picker) {
              start = picker.startDate.format('YYYY-MM-DD');
              end = picker.endDate.format('YYYY-MM-DD');

              var chartTotalUrl = $('#base-url').data('target') + 'index.php/reports/get_tax_total';
              $.getJSON(chartTotalUrl, {start: start, end: end}, function(response){
                  //$('#cgst-tax-invoice-total').text(accounting.formatMoney(response.invoice_total));
                  //$('#cgst-tax-tax-total').text(accounting.formatMoney(response.cgst_tax_total));
              });

              newUrl = $('#base-url').data('target') + 'index.php/reports/tax_report_cgst?start=' + start + '&end=' + end;
               $('#cgst-report-range-text').text("");
               $('#cgst-report-range-text').text('* From ' + start + ' to ' + end );
              $('#cgstTaxReportTable').bootstrapTable('refresh', {
                  url: newUrl
              });
            });
        };
    return {
        init: function() {
            handleBarCharts(),
            handlecgstTaxReportTable()
        }
    }
})(jQuery);
jQuery(document).ready(function() {
    CgstReports.init()
});