var IgstReports = (function($) {
    var handleBarCharts = function() {
        // Init the bar chart
        var barChart = echarts.init(document.getElementById("igst_echarts_tax_report")),
            // Set Options
            options = {
                title: {},
                color: ["#001a33", "#990000"],
                tooltip: {
                    trigger: 'axis',
                    axisPointer: {
                        type: 'shadow'
                    }
                },
                legend: {
                    orient: "horizontal",
                    x: "center",
                    y: "bottom",
                    padding: 0,
                    data: [$('#label-tax-value').data('label'), $('#label-subtotal').data('label')]
                },
                grid: {
                    left: '3%',
                    right: '9%',
                    bottom: '5%',
                    containLabel: true
                },
                xAxis: {
                    type: 'category',
                    data: []
                },
                yAxis: {
                    type: 'value'
                },
                series: [{
                        name: $('#label-subtotal').data('label'),
                        type: "bar",
                        stack: 'Total',
                        label: {
                            normal: {
                                show: false,
                                position: 'insideRight'
                            }
                        },
                        data: []
                    },
                    {
                        name: $('#label-tax-value').data('label'),
                        type: "bar",
                        stack: 'Total',
                        label: {
                            normal: {
                                show: false,
                                position: 'insideRight'
                            }
                        },
                        data: []
                    }
                ]
            };
            // Default Range set to the last 30 days
            var start = moment().subtract(2, 'months');
            var end = moment();

            function cb(start, end) {
                $('#igst-tax-report-range span').html(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'));
            }

            $('#igst-tax-report-range').daterangepicker({
                startDate: start,
                endDate: end,
                ranges: {
                    'Today': [moment(), moment()],
                    'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                    'Last 7 Days': [moment().subtract(6, 'days'), moment()],
                    'Last 30 Days': [moment().subtract(29, 'days'), moment()],
                    'This Month': [moment().startOf('month'), moment().endOf('month')],
                    'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
                }
            }, cb);

            cb(start, end);

            url = $("#base-url").data("target") + "index.php/reports/tax_report_igst";
            barChart.showLoading();
            $.getJSON(url, {
                start: start.format('YYYY-MM-DD'),
                end: end.format('YYYY-MM-DD')
            }).done(function(a) {
                $igstsubTotal = [], $igstmonths = [], $igst_tax_rate = [], $igst_tax_value = [];
                for (var n = 0; n < a.length; n++) $igstsubTotal.push(a[n].item_subtotal), $igstmonths.push(a[n].month + "/" + a[n].year), $igst_tax_rate.push(a[n].igst_tax_rate), $igst_tax_value.push(a[n].igst_tax_value);
                var igstsubTotal = 0,
                    igst_tax_value = 0,
                    igst_tax_rate = 0;
                $.each($igstsubTotal, function() {
                    igstsubTotal += this;
                });
                $.each($igst_tax_value, function() {
                    igst_tax_value += this;
                });
                $.each($igst_tax_rate, function() {
                    igst_tax_rate += this;
                });

                $('#igst-tax-invoice-total').text(accounting.formatMoney(igstsubTotal));
                $('#igst-tax-tax-total').text(accounting.formatMoney(igst_tax_value));

                barChart.hideLoading(), barChart.setOption({
                    series: [{
                            name: $('#label-tax-value').data('label'),
                            type: "bar",
                            stack: 'Total',
                            label: {
                                normal: {
                                    show: false,
                                    position: 'insideRight'
                                }
                            },
                            data: $igst_tax_value
                        },
                        {
                            name: $('#label-subtotal').data('label'),
                            type: "bar",
                            stack: 'Total',
                            label: {
                                normal: {
                                    show: false,
                                    position: 'insideRight'
                                }
                            },
                            data: $igstsubTotal
                        }
                    ],
                    xAxis: {
                        data: $igst_tax_rate
                    }
                })
            });

            // Dynamic range
            $('#igst-tax-report-range').on('apply.daterangepicker', function(ev, picker) {
                url = $("#base-url").data("target") + "index.php/reports/tax_report_igst";
                barChart.showLoading();
                $.getJSON(url, {
                    start: picker.startDate.format('YYYY-MM-DD'),
                    end: picker.endDate.format('YYYY-MM-DD')
                }).done(function(a) {
                    $igstsubTotal = [], $igstmonths = [], $igst_tax_rate = [], $igst_tax_value = [];
                    for (var n = 0; n < a.length; n++) $igstsubTotal.push(a[n].item_subtotal), $igstmonths.push(a[n].month + "/" + a[n].year), $igst_tax_rate.push(a[n].igst_tax_rate), $igst_tax_value.push(a[n].igst_tax_value);
                    var igstsubTotal = 0,
                        igst_tax_value = 0,
                        igst_tax_rate = 0;
                    $.each($igstsubTotal, function() {
                        igstsubTotal += this;
                    });
                    $.each($igst_tax_value, function() {
                        igst_tax_value += this;
                    });
                    $.each($igst_tax_rate, function() {
                        igst_tax_rate += this;
                    });

                    $('#igst-tax-invoice-total').text(accounting.formatMoney(igstsubTotal));
                    $('#igst-tax-tax-total').text(accounting.formatMoney(igst_tax_value));

                    barChart.hideLoading(), barChart.setOption({
                        series: [{
                                name: $('#label-tax-value').data('label'),
                                type: "bar",
                                stack: 'Total',
                                label: {
                                    normal: {
                                        show: false,
                                        position: 'insideRight'
                                    }
                                },
                                data: $igst_tax_value
                            },
                            {
                                name: $('#label-subtotal').data('label'),
                                type: "bar",
                                stack: 'Total',
                                label: {
                                    normal: {
                                        show: false,
                                        position: 'insideRight'
                                    }
                                },
                                data: $igstsubTotal
                            }
                        ],
                        xAxis: {
                            data: $igst_tax_rate
                        }
                    })
                });
            });
            jQuery(window).on("resize", function() {
                null != barChart && void 0 != barChart && barChart.resize()
            });
            barChart.setOption(options);
        },
        handleigstTaxReportTable = function() {
            var start = moment().subtract(29, 'days');
            var end = moment();
            var defaultUrl = $('#base-url').data('target') + 'index.php/reports/tax_report_igst?start=' + start.format('YYYY-MM-DD') + '&end=' + end.format('YYYY-MM-DD');
            
            var chartTotalUrl = $('#base-url').data('target') + 'index.php/reports/get_tax_total';
            $.getJSON(chartTotalUrl, {start: start.format('YYYY-MM-DD'), end: end.format('YYYY-MM-DD')}, function(response){
                //$('#igst-tax-invoice-total').text(accounting.formatMoney(response.invoice_total));
                //$('#igst-tax-tax-total').text(accounting.formatMoney(response.igst_tax_total));
            });

            $('#igst-report-range-text').text('* From ' + start.format('YYYY-MM-DD') + ' to ' + end.format('YYYY-MM-DD') );
            $('#igstTaxReportTable').bootstrapTable('refresh', {
                url: defaultUrl
            });
            $('#igst-tax-report-range').on('apply.daterangepicker', function(ev, picker) {
              start = picker.startDate.format('YYYY-MM-DD');
              end = picker.endDate.format('YYYY-MM-DD');

              var chartTotalUrl = $('#base-url').data('target') + 'index.php/reports/get_tax_total';
              $.getJSON(chartTotalUrl, {start: start, end: end}, function(response){
                  //$('#igst-tax-invoice-total').text(accounting.formatMoney(response.invoice_total));
                  //$('#igst-tax-tax-total').text(accounting.formatMoney(response.igst_tax_total));
              });

              newUrl = $('#base-url').data('target') + 'index.php/reports/tax_report_igst?start=' + start + '&end=' + end;
               $('#igst-report-range-text').text("");
               $('#igst-report-range-text').text('* From ' + start + ' to ' + end );
              $('#igstTaxReportTable').bootstrapTable('refresh', {
                  url: newUrl
              });
            });
        };
    return {
        init: function() {
            handleBarCharts(),
            handleigstTaxReportTable()
        }
    }
})(jQuery);
jQuery(document).ready(function() {
    IgstReports.init()
});