var SgstReports = (function($) {
    var handleBarCharts = function() {
        // Init the bar chart
        var barChart = echarts.init(document.getElementById("sgst_echarts_tax_report")),
            // Set Options
            options = {
                title: {},
                color: ["#001a33", "#990000"],
                tooltip: {
                    trigger: 'axis',
                    axisPointer: {
                        type: 'shadow'
                    }
                },
                legend: {
                    orient: "horizontal",
                    x: "center",
                    y: "bottom",
                    padding: 0,
                    data: [$('#label-tax-value').data('label'), $('#label-subtotal').data('label')]
                },
                grid: {
                    left: '3%',
                    right: '9%',
                    bottom: '5%',
                    containLabel: true
                },
                xAxis: {
                    type: 'category',
                    data: []
                },
                yAxis: {
                    type: 'value'
                },
                series: [{
                        name: $('#label-subtotal').data('label'),
                        type: "bar",
                        stack: 'Total',
                        label: {
                            normal: {
                                show: false,
                                position: 'insideRight'
                            }
                        },
                        data: []
                    },
                    {
                        name: $('#label-tax-value').data('label'),
                        type: "bar",
                        stack: 'Total',
                        label: {
                            normal: {
                                show: false,
                                position: 'insideRight'
                            }
                        },
                        data: []
                    }
                ]
            };
            // Default Range set to the last 30 days
            var start = moment().subtract(29, 'days');
            var end = moment();

            function cb(start, end) {
                $('#sgst-tax-report-range span').html(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'));
            }

            $('#sgst-tax-report-range').daterangepicker({
                startDate: start,
                endDate: end,
                ranges: {
                    'Today': [moment(), moment()],
                    'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                    'Last 7 Days': [moment().subtract(6, 'days'), moment()],
                    'Last 30 Days': [moment().subtract(29, 'days'), moment()],
                    'This Month': [moment().startOf('month'), moment().endOf('month')],
                    'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
                }
            }, cb);

            cb(start, end);

            url = $("#base-url").data("target") + "index.php/reports/tax_report_sgst";
            barChart.showLoading();
            $.getJSON(url, {
                start: start.format('YYYY-MM-DD'),
                end: end.format('YYYY-MM-DD')
            }).done(function(a) {
                $sgstsubTotal = [], $sgstmonths = [], $sgst_tax_rate = [], $sgst_tax_value = [];
                for (var n = 0; n < a.length; n++) $sgstsubTotal.push(a[n].item_subtotal), $sgstmonths.push(a[n].month + "/" + a[n].year), $sgst_tax_rate.push(a[n].sgst_tax_rate), $sgst_tax_value.push(a[n].sgst_tax_value);
                var sgstsubTotal = 0,
                    sgst_tax_value = 0,
                    sgst_tax_rate = 0;
                $.each($sgstsubTotal, function() {
                    sgstsubTotal += this;
                });
                $.each($sgst_tax_value, function() {
                    sgst_tax_value += this;
                });
                $.each($sgst_tax_rate, function() {
                    sgst_tax_rate += this;
                });

                barChart.hideLoading(), barChart.setOption({
                    series: [{
                            name: $('#label-tax-value').data('label'),
                            type: "bar",
                            stack: 'Total',
                            label: {
                                normal: {
                                    show: false,
                                    position: 'insideRight'
                                }
                            },
                            data: $sgst_tax_value
                        },
                        {
                            name: $('#label-subtotal').data('label'),
                            type: "bar",
                            stack: 'Total',
                            label: {
                                normal: {
                                    show: false,
                                    position: 'insideRight'
                                }
                            },
                            data: $sgstsubTotal
                        }
                    ],
                    xAxis: {
                        data: $sgst_tax_rate
                    }
                })
            });

            // Dynamic range
            $('#sgst-tax-report-range').on('apply.daterangepicker', function(ev, picker) {
                url = $("#base-url").data("target") + "index.php/reports/tax_report_sgst";
                barChart.showLoading();
                $.getJSON(url, {
                    start: picker.startDate.format('YYYY-MM-DD'),
                    end: picker.endDate.format('YYYY-MM-DD')
                }).done(function(a) {
                    $sgstsubTotal = [], $sgstmonths = [], $sgst_tax_rate = [], $sgst_tax_value = [];
                    for (var n = 0; n < a.length; n++) $sgstsubTotal.push(a[n].item_subtotal), $sgstmonths.push(a[n].month + "/" + a[n].year), $sgst_tax_rate.push(a[n].sgst_tax_rate), $sgst_tax_value.push(a[n].sgst_tax_value);
                    var sgstsubTotal = 0,
                        sgst_tax_value = 0,
                        sgst_tax_rate = 0;
                    $.each($sgstsubTotal, function() {
                        sgstsubTotal += this;
                    });
                    $.each($sgst_tax_value, function() {
                        sgst_tax_value += this;
                    });
                    $.each($sgst_tax_rate, function() {
                        sgst_tax_rate += this;
                    });

                    barChart.hideLoading(), barChart.setOption({
                        series: [{
                                name: $('#label-tax-value').data('label'),
                                type: "bar",
                                stack: 'Total',
                                label: {
                                    normal: {
                                        show: false,
                                        position: 'insideRight'
                                    }
                                },
                                data: $sgst_tax_value
                            },
                            {
                                name: $('#label-subtotal').data('label'),
                                type: "bar",
                                stack: 'Total',
                                label: {
                                    normal: {
                                        show: false,
                                        position: 'insideRight'
                                    }
                                },
                                data: $sgstsubTotal
                            }
                        ],
                        xAxis: {
                            data: $sgst_tax_rate
                        }
                    })
                });
            });
            jQuery(window).on("resize", function() {
                null != barChart && void 0 != barChart && barChart.resize()
            });
            barChart.setOption(options);
        },
        handlesgstTaxReportTable = function() {
            var start = moment().subtract(29, 'days');
            var end = moment();
            var defaultUrl = $('#base-url').data('target') + 'index.php/reports/tax_report_sgst?start=' + start.format('YYYY-MM-DD') + '&end=' + end.format('YYYY-MM-DD');
            
            var chartTotalUrl = $('#base-url').data('target') + 'index.php/reports/get_tax_total';
            $.getJSON(chartTotalUrl, {start: start.format('YYYY-MM-DD'), end: end.format('YYYY-MM-DD')}, function(result){
                $('#sgst-tax-invoice-total').text(accounting.formatMoney(result.invoice_total));
                $('#sgst-tax-tax-total').text(accounting.formatMoney(result.sgst_tax_total));
            });

            $('#sgst-report-range-text').text('* From ' + start.format('YYYY-MM-DD') + ' to ' + end.format('YYYY-MM-DD') );
            $('#sgstTaxReportTable').bootstrapTable('refresh', {
                url: defaultUrl
            });
            $('#sgst-tax-report-range').on('apply.daterangepicker', function(ev, picker) {
              start = picker.startDate.format('YYYY-MM-DD');
              end = picker.endDate.format('YYYY-MM-DD');

              var chartTotalUrl = $('#base-url').data('target') + 'index.php/reports/get_tax_total';
              $.getJSON(chartTotalUrl, {start: start, end: end}, function(result){
                  $('#sgst-tax-invoice-total').text(accounting.formatMoney(result.invoice_total));
                  $('#sgst-tax-tax-total').text(accounting.formatMoney(result.sgst_tax_total));
              });

              newUrl = $('#base-url').data('target') + 'index.php/reports/tax_report_sgst?start=' + start + '&end=' + end;
               $('#sgst-report-range-text').text("");
               $('#sgst-report-range-text').text('* From ' + start + ' to ' + end );
              $('#sgstTaxReportTable').bootstrapTable('refresh', {
                  url: newUrl
              });
            });
        };
    return {
        init: function() {
            handleBarCharts(),
            handlesgstTaxReportTable()
        }
    }
})(jQuery);
jQuery(document).ready(function() {
    SgstReports.init()
});