var Invoices = (function($){
	var handleInvoiceForm = function(){
		var options = {
			dataType:  'json',
			success: serverResponse
		};
		$('#create-invoice-form').submit(function(){

			// Prevent 2 or more submissions
			$("#btn-create-invoice").attr("disabled","disabled");
			$('#create-invoice-form').ajaxSubmit(options);
			return false; 
		});
	},
	handleQuoteForm = function(){
		var options = {
			dataType:  'json',
			success: serverResponseQuote
		};
		$('#create-quote-form').submit(function(){

			// Prevent 2 or more submissions
			$("#btn-create-quote").attr("disabled","disabled");
			$('#create-quote-form').ajaxSubmit(options);
			return false; 
		});
	},
	handleSelectClient = function(){
		$('.invoice_to').each(function(){
			var $base_url = $('#base-url').data('target'),
				$url = $.trim( $base_url + 'index.php/clients/get_active_clients' );

			$.getJSON( $url, function(response){
				var stringified = JSON.stringify(response);
				stringified = stringified.replace(/client_id/g, 'id');
				stringified = stringified.replace(/name_company/g, 'text');
				var data = JSON.parse(stringified);
				$('.invoice_to').select2({
					data: data
				})
			});
		});
	},
	handleUpdateInvoice = function(){
		var options = {
			dataType:  'json',
			success: updateInvoiceServerResponse
		};
		$('#update-invoice-form').submit(function(){
			$(this).ajaxSubmit(options);
			return false; 
		});
	},
	handleUpdateQuote = function(){
		var options = {
			dataType:  'json',
			success: updateQuoteServerResponse
		};
		$('#update-quote-form').submit(function(){
			$(this).ajaxSubmit(options);
			return false; 
		});
	},
	handleDeleteInvoice = function(){
		var $table = $('#btable'),
		    $remove = $('#remove-invoice'),
		    selections = [];

		// sometimes footer render error.
		setTimeout(function () {
			$table.bootstrapTable('resetView');
		}, 200);
		$table.on('check.bs.table uncheck.bs.table ' +
		                'check-all.bs.table uncheck-all.bs.table', function () {
		            $remove.prop('disabled', !$table.bootstrapTable('getSelections').length);

		            // save your data, here just save the current page
		            selections = getIdSelections();
		            // push or splice the selections if you want to save all data selections
		        });
		$remove.click(function () {
		    var ids = getIdSelections();
		    $base_url = $('#base-url').data('target'),
		    $url = $.trim( $base_url + 'index.php/invoices/delete_invoice' );
		    $this = $('#remove-invoice');
		    swal({
		      title: $this.data('sure'),
		      text: $this.data('message'),
		      type: "warning",
		      showCancelButton: true,
		      confirmButtonClass: "btn-danger",
		      confirmButtonText: $this.data('confirm'),
		      cancelButtonText: $('#btn-cancel').data('text'),
		      closeOnConfirm: true
		    },
		    function(){ 
		        $.getJSON({
		            url: $url,
		            data: {
		                id: ids
		            },
		            success: function (data) {
		            	if (data.success > 0)
		            	{
		            		$table.bootstrapTable('remove', {
		            		    field: 'enc_invoice_number',
		            		    values: ids
		            		});
		            		App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#remove-invoice').data('success')});
		            		$remove.prop('disabled', true);
		            	}
		            	if(data.fail > 0)
		            	{
		            		App.alert({container: $('#notification-alert'), type: "danger", close: true, message: $('#remove-invoice').data('danger') + ' ' + data.fail });
		            		setTimeout(function () {
		            			$table.bootstrapTable('refresh', true);
		            		}, 200);
		            		$remove.prop('disabled', true);
		            	}
		            }
		        });
		    });
		});
		function getIdSelections() {
		    return $.map($table.bootstrapTable('getSelections'), function (row) {
		        return row.enc_invoice_number
		    });
		}
	},
	handleDeleteQuote = function(){
		var $table = $('#quoteTable'),
		    $remove = $('#remove-quote'),
		    selections = [];

		// sometimes footer render error.
		setTimeout(function () {
			$table.bootstrapTable('resetView');
		}, 200);
		$table.on('check.bs.table uncheck.bs.table ' +
		                'check-all.bs.table uncheck-all.bs.table', function () {
		            $remove.prop('disabled', !$table.bootstrapTable('getSelections').length);

		            // save your data, here just save the current page
		            selections = getIdSelections();
		            // push or splice the selections if you want to save all data selections
		        });
		$remove.click(function () {
		    var ids = getIdSelections();
		    $base_url = $('#base-url').data('target'),
		    $url = $.trim( $base_url + 'index.php/quotes/delete_quote' );
		    $this = $('#remove-quote');
		    swal({
		      title: $this.data('sure'),
		      text: $this.data('message'),
		      type: "warning",
		      showCancelButton: true,
		      confirmButtonClass: "btn-danger",
		      confirmButtonText: $this.data('confirm'),
		      cancelButtonText: $('#btn-cancel').data('text'),
		      closeOnConfirm: true
		    },
		    function(){ 
		        $.getJSON({
		            url: $url,
		            data: {
		                id: ids
		            },
		            success: function (data) {
		            	if (data.success > 0)
		            	{
		            		$table.bootstrapTable('remove', {
		            		    field: 'enc_quote_number',
		            		    values: ids
		            		});
		            		App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#remove-quote').data('success')});
		            		$remove.prop('disabled', true);
		            	}
		            	if(data.fail > 0)
		            	{
		            		App.alert({container: $('#notification-alert'), type: "danger", close: true, message: $('#remove-quote').data('danger') + ' ' + data.fail });
		            		setTimeout(function () {
		            			$table.bootstrapTable('refresh', true);
		            		}, 200);
		            		$remove.prop('disabled', true);
		            	}
		            }
		        });
		    });
		});
		function getIdSelections() {
		    return $.map($table.bootstrapTable('getSelections'), function (row) {
		        return row.enc_quote_number
		    });
		}
	},
	handleMassPayment = function(){
		var $table = $('#btable'),
		    $markPaid = $('#mark-paid'),
		    selections = [];

		// sometimes footer render error.
		setTimeout(function () {
			$table.bootstrapTable('resetView');
		}, 200);
		$table.on('check.bs.table uncheck.bs.table ' +
		                'check-all.bs.table uncheck-all.bs.table', function () {
		            $markPaid.prop('disabled', !$table.bootstrapTable('getSelections').length);

		            // save your data, here just save the current page
		            selections = getIdSelections();
		            // push or splice the selections if you want to save all data selections
		        });
		$markPaid.click(function () {
		    var ids = getIdSelections();
		    $base_url = $('#base-url').data('target'),
		    $url = $.trim( $base_url + 'index.php/invoices/mark_paid' );
		    $this = $('#mark-paid');
		    swal({
		      title: $this.data('sure'),
		      text: $this.data('message'),
		      type: "warning",
		      showCancelButton: true,
		      confirmButtonClass: "btn-danger",
		      confirmButtonText: $this.data('confirm'),
		      cancelButtonText: $('#btn-cancel').data('text'),
		      closeOnConfirm: true
		    },
		    function(){ 
		        $.getJSON({
		            url: $url,
		            data: {
		                id: ids
		            },
		            success: function (data) {
		            	if (data.success > 0)
		            	{
		            		App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#mark-paid').data('success')});
		            		setTimeout(function () {
		            			$table.bootstrapTable('refresh', true);
		            		}, 200);
		            		$markPaid.prop('disabled', true);
		            	}
		            	if(data.fail > 0)
		            	{
		            		App.alert({container: $('#notification-alert'), type: "danger", close: true, message: $('#mark-paid').data('danger') + ' ' + data.fail });
		            		setTimeout(function () {
		            			$table.bootstrapTable('refresh', true);
		            		}, 200);
		            		$markPaid.prop('disabled', true);
		            	}
		            }
		        });
		    });
		});
		function getIdSelections() {
		    return $.map($table.bootstrapTable('getSelections'), function (row) {
		        return row.enc_invoice_number
		    });
		}
	},
	handleMassApproved = function(){
		var $table = $('#quoteTable'),
		    $markApproved = $('#quote-mark-approved'),
		    selections = [];

		// sometimes footer render error.
		setTimeout(function () {
			$table.bootstrapTable('resetView');
		}, 200);
		$table.on('check.bs.table uncheck.bs.table ' +
		                'check-all.bs.table uncheck-all.bs.table', function () {
		            $markApproved.prop('disabled', !$table.bootstrapTable('getSelections').length);

		            // save your data, here just save the current page
		            selections = getIdSelections();
		            // push or splice the selections if you want to save all data selections
		        });
		$markApproved.click(function () {
		    var ids = getIdSelections();
		    $base_url = $('#base-url').data('target'),
		    $url = $.trim( $base_url + 'index.php/quotes/mark_approved' );
		    $this = $('#quote-mark-approved');
		    swal({
		      title: $this.data('sure'),
		      text: $this.data('message'),
		      type: "warning",
		      showCancelButton: true,
		      confirmButtonClass: "btn-danger",
		      confirmButtonText: $this.data('confirm'),
		      cancelButtonText: $('#btn-cancel').data('text'),
		      closeOnConfirm: true
		    },
		    function(){ 
		        $.getJSON({
		            url: $url,
		            data: {
		                id: ids
		            },
		            success: function (data) {
		            	if (data.success > 0)
		            	{
		            		App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#quote-mark-approved').data('success')});
		            		setTimeout(function () {
		            			$table.bootstrapTable('refresh', true);
		            		}, 200);
		            		$markApproved.prop('disabled', true);
		            	}
		            	if(data.fail > 0)
		            	{
		            		App.alert({container: $('#notification-alert'), type: "danger", close: true, message: $('#quote-mark-approved').data('danger') + ' ' + data.fail });
		            		setTimeout(function () {
		            			$table.bootstrapTable('refresh', true);
		            		}, 200);
		            		$markApproved.prop('disabled', true);
		            	}
		            }
		        });
		    });
		});
		function getIdSelections() {
		    return $.map($table.bootstrapTable('getSelections'), function (row) {
		        return row.enc_quote_number
		    });
		}
	},
	handleMassEmailInvoices = function(){
		var $table = $('#btable'),
		    $markSent = $('#send-email'),
		    selections = [];

		// sometimes footer render error.
		setTimeout(function () {
			$table.bootstrapTable('resetView');
		}, 200);
		$table.on('check.bs.table uncheck.bs.table ' +
		                'check-all.bs.table uncheck-all.bs.table', function () {
		            $markSent.prop('disabled', !$table.bootstrapTable('getSelections').length);

		            // save your data, here just save the current page
		            selections = getIdSelections();
		            // push or splice the selections if you want to save all data selections
		        });
		$markSent.click(function () {
		    var ids = getIdSelections();
		    $base_url = $('#base-url').data('target'),
		    $url = $.trim( $base_url + 'index.php/invoices/mass_invoices_email' );
		    $this = $('#send-email');
		    swal({
		      title: $this.data('sure'),
		      text: $this.data('message'),
		      type: "warning",
		      showCancelButton: true,
		      confirmButtonClass: "btn-danger",
		      confirmButtonText: $this.data('confirm'),
		      cancelButtonText: $('#btn-cancel').data('text'),
		      closeOnConfirm: true
		    },
		    function(){ 
		        $.getJSON({
		            url: $url,
		            data: {
		                id: ids
		            },
		            success: function (data) {
		            	if (data.success > 0)
		            	{
		            		App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#send-email').data('success')});
		            		setTimeout(function () {
		            			$table.bootstrapTable('refresh', true);
		            		}, 200);
		            		$markSent.prop('disabled', true);
		            	}
		            	if(data.fail > 0)
		            	{
		            		App.alert({container: $('#notification-alert'), type: "danger", close: true, message: $('#send-email').data('danger') + ' ' + data.fail });
		            		setTimeout(function () {
		            			$table.bootstrapTable('refresh', true);
		            		}, 200);
		            		$markSent.prop('disabled', true);
		            	}
		            }
		        });
		    });
		});
		function getIdSelections() {
		    return $.map($table.bootstrapTable('getSelections'), function (row) {
		        return row.enc_invoice_number
		    });
		}
	},
	handleMassEmailQuotes = function(){
		var $table = $('#quoteTable'),
		    $markSent = $('#quote-send-email'),
		    selections = [];

		// sometimes footer render error.
		setTimeout(function () {
			$table.bootstrapTable('resetView');
		}, 200);
		$table.on('check.bs.table uncheck.bs.table ' +
		                'check-all.bs.table uncheck-all.bs.table', function () {
		            $markSent.prop('disabled', !$table.bootstrapTable('getSelections').length);

		            // save your data, here just save the current page
		            selections = getIdSelections();
		            // push or splice the selections if you want to save all data selections
		        });
		$markSent.click(function () {
		    var ids = getIdSelections();
		    $base_url = $('#base-url').data('target'),
		    $url = $.trim( $base_url + 'index.php/quotes/mass_quotes_email' );
		    $this = $('#quote-send-email');
		    swal({
		      title: $this.data('sure'),
		      text: $this.data('message'),
		      type: "warning",
		      showCancelButton: true,
		      confirmButtonClass: "btn-danger",
		      confirmButtonText: $this.data('confirm'),
		      cancelButtonText: $('#btn-cancel').data('text'),
		      closeOnConfirm: true
		    },
		    function(){ 
		        $.getJSON({
		            url: $url,
		            data: {
		                id: ids
		            },
		            success: function (data) {
		            	if (data.success > 0)
		            	{
		            		App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#quote-send-email').data('success')});
		            		setTimeout(function () {
		            			$table.bootstrapTable('refresh', true);
		            		}, 200);
		            		$markSent.prop('disabled', true);
		            	}
		            	if(data.fail > 0)
		            	{
		            		App.alert({container: $('#notification-alert'), type: "danger", close: true, message: $('#quote-send-email').data('danger') + ' ' + data.fail });
		            		setTimeout(function () {
		            			$table.bootstrapTable('refresh', true);
		            		}, 200);
		            		$markSent.prop('disabled', true);
		            	}
		            }
		        });
		    });
		});
		function getIdSelections() {
		    return $.map($table.bootstrapTable('getSelections'), function (row) {
		        return row.enc_quote_number
		    });
		}
	},
	handleAutoComplete = function(){
		var i = $('table tr').length;
		var client = $('#client').val();
		if (client == 0)
		{
			credit = 0;
		}
		var $user_currency = $('#money-format').data('symbol');
		url = $.trim( $('#base-url').data('target') + 'index.php/invoices/invoice_autocomplete' );
		var price = [];
		$.getJSON(url, function(data, status, xhr){
			if (status === 'success')
				prices = data;
		});
		$('#add-new-row').on('click', function(){
			newRow = '<tr>';
			newRow += '<td> <input type="text" data-type="itemSN" name="itemSN[]" id="itemSN_'+i+'" class="form-control autocomplete_txt itemSN" autocomplete="off" style="width: auto" /></td>';
			newRow += '<td> <input type="text" data-type="itemSku" name="itemSku[]" id="itemSku_'+i+'" class="form-control autocomplete_txt itemSku" autocomplete="off" style="width: auto" /></td>';
			newRow += '<td> <input type="text" data-type="itemName" name="itemName[]" id="itemName_'+i+'" class="form-control autocomplete_txt itemName" autocomplete="off" style="width: auto"> </td>';
			newRow += '<td> <input type="text" name="itemHSNSAC[]" id="itemHSNSAC_'+i+'" class="form-control autocomplete_txt itemHSNSAC" autocomplete="off" style="width: 80px"> </td>';
			newRow += '<td> <input type="text" min="0" name="itemQuantity[]" id="itemQuantity_'+i+'" class="form-control changeNo" autocomplete="off" style="width: 65px;" onkeypress="return IsNumeric(event);" ondrop="return false;" onpaste="return false;" /> </td>';
			newRow += '<td> <input type="text" name="itemUom[]" id="itemUom_'+i+'" class="form-control" style="width: 50px" /> </td>';
			newRow += '<td> <div class="input-group"><span class="input-group-addon currency">' +$user_currency+ '</span><input type="text" min="0" name="itemPrice[]" id="itemPrice_'+i+'" class="form-control itemPrice changeNo" autocomplete="off" style="width: 100px;" onkeypress="return IsNumeric(event);" ondrop="return false;" onpaste="return false;" /> </div></td>';
			newRow += '<td> <div class="input-group"><span class="input-group-addon currency">' +$user_currency+ '</span><input type="text" min="0" step="0.01" name="itemAmountDiscount[]" id="itemAmountDiscount_'+i+'" class="form-control changeNo" style="width: 65px;" onkeypress="return IsNumeric(event);" ondrop="return false;" onpaste="return false;" /> <input type="hidden" disabled name="itemAmountDiscountAmount[]" id="itemAmountDiscountAmount_'+i+'" class="itemAmountDiscountAmount"/></div></td>';
			newRow += '<td> <div class="input-group"><span class="input-group-addon">%</span><input type="text" min="0" step="0.01" name="itemDiscount[]" id="itemDiscount_'+i+'" class="form-control changeNo" style="width: 65px;" onkeypress="return IsNumeric(event);" ondrop="return false;" onpaste="return false;" /> <input type="hidden" disabled name="itemDiscountAmount[]" id="itemDiscountAmount_'+i+'" class="itemDiscountAmount"/></div></td>';
			newRow += '<td><div class="input-group"><span class="input-group-addon currency">'+$user_currency+'</span><input type="text" min="0" name="itemTaxableValue[]" id="itemTaxableValue_'+i+'" class="form-control" readonly="readonly" autocomplete="off" style="width: 100px;" onkeypress="return IsNumeric(event);" ondrop="return false;" onpaste="return false;" /></div></td>';
			newRow += '<td class="hidden"> <div class="input-group"><span class="input-group-addon">%</span><input type="text" min="0" step="0.01" name="itemTax[]" id="itemTax_'+i+'" class="form-control changeNo" style="width: 65px;" onkeypress="return IsNumeric(event);" ondrop="return false;" onpaste="return false;" /></div><input type="hidden" disabled name="itemTaxAmount[]" id="itemTaxAmount_'+i+'" class="itemTaxAmount"/></td>';
			newRow += '<td><div class="input-group"><span class="input-group-addon">%</span><input type="text" min="0" step="0.01" class="form-control changeNo" name="itemTaxCGST[]" id="itemTaxCGST_'+i+'" style="width: 70px;" onkeypress="return IsNumeric(event);" ondrop="return false;" onpaste="return false;" /><input type="text" readonly="true" name="itemTaxAmountCGST[]" id="itemTaxAmountCGST_'+i+'" class="form-control itemTaxAmountCGST" style="width: 70px;" /></div></td>';
			newRow += '<td><div class="input-group"><span class="input-group-addon">%</span><input type="text" min="0" step="0.01" class="form-control changeNo" name="itemTaxSGST[]" id="itemTaxSGST_'+i+'" style="width: 70px;" onkeypress="return IsNumeric(event);" ondrop="return false;" onpaste="return false;" /><input type="text" readonly="true" name="itemTaxAmountSGST[]" id="itemTaxAmountSGST_'+i+'" class="form-control itemTaxAmountSGST" style="width: 70px;" /></div></td>';
			newRow += '<td><div class="input-group"><span class="input-group-addon">%</span><input type="text" min="0" step="0.01" class="form-control changeNo" name="itemTaxIGST[]" id="itemTaxIGST_'+i+'" style="width: 70px;" onkeypress="return IsNumeric(event);" ondrop="return false;" onpaste="return false;" /><input type="text" readonly="true" name="itemTaxAmountIGST[]" id="itemTaxAmountIGST_'+i+'" class="form-control itemTaxAmountIGST" style="width: 70px;"/></div></td>';
			newRow += '<td class="hidden"><div class="input-group"><span class="input-group-addon">%</span><input type="text" min="0" step="0.01" class="form-control changeNo" name="itemTaxCESS[]" id="itemTaxCESS_'+i+'" style="width: 70px;" onkeypress="return IsNumeric(event);" ondrop="return false;" onpaste="return false;" /><input type="text" readonly="true" name="itemTaxAmountCESS[]" id="itemTaxAmountCESS_'+i+'" class="form-control itemTaxAmountCESS" style="width: 70px;"/></div></td>';
			newRow += '<td class="hidden"> <div class="input-group"><span class="input-group-addon currency">' +$user_currency+ '</span><input type="text" name="itemSubTotal[]" id="itemSubTotal_'+i+'" class="form-control itemSubTotal" readonly="readonly" autocomplete="off" style="width: 100px;"> </div></td>';
			newRow += '<td>  <a href="javascript:;" class="btn btn-sm btn-danger delete_item"><i class="icon-trash"></i><input type="hidden" class="autocomplete_txt itemID" name="itemID[]" id="itemID_'+i+'"></td>';
			newRow += '</tr>';

			$('table').append(newRow);
			i++;
			
		});
		$(document).on('click', 'a.delete_item', function(){
			$(this).parents('tr').remove();
			calculateTotal();
		});

		// Autocomplete
		$(document).on('focus', '.autocomplete_txt', function(){
			client_id = $('.invoice_to').val();
			if (client_id == 0)
			{
				credit = 0;
			}
			var $type = $(this).data('type');
			if($type == 'itemSku')
				var autoTypeNo = 0;
			if($type == 'itemName')
				autoTypeNo = 1;
			if($type == 'itemSN')
				autoTypeNo = 11;
			$(this).autocomplete({
				source: function( request, response ){
					var array = $.map(prices, function(item){
						var code = item.split('|');
						return {
							label: code[autoTypeNo],
							value: code[autoTypeNo],
							data: item
						}
					});
					response($.ui.autocomplete.filter(array, request.term));
				},
				autoFocus: true,
				minLength: 1,
				select: function(event, ui) {
					var names = ui.item.data.split('|'),
					id_arr = $(this).attr('id'),
					id = id_arr.split('_');

					globalDiscount = $('#globalDiscount').val();
					if (globalDiscount != '')
					{
						discount = globalDiscount;
						$('#itemDiscount_'+id[1]).prop('readonly', true);
					}
					else
					{
						discount = 0;
						$('#itemDiscount_'+id[1]).prop('readonly', false);
					}
					if(names)
					{
						if(names[3] == '')
						{
							names[3] = 0.00;
						}
						if(names[7] == '')
						{
							names[7] = 0.00;
						}
						if(names[8] == '')
						{
							names[8] = 0.00;
						}
						if(names[9] == '')
						{
							names[9] = 0.00;
						}
						if(names[10] == '')
						{
							names[10] = 0.00;
						}
						$('#itemSku_'+id[1]).val(names[0]);
						$('#itemID_'+id[1]).val(names[4]);
						$('#itemName_'+id[1]).val(names[1]);
						$('#itemQuantity_'+id[1]).val(1);
						$('#itemPrice_'+id[1]).val( parseFloat(names[2]) );
						$('#itemTax_'+id[1]).val(names[3]);
						$('#itemUom_'+id[1]).val(names[5]); // Unit of measure
						$('#itemHSNSAC_'+id[1]).val(names[6]); // HSN / SAC
						$('#itemTaxSGST_'+id[1]).val(names[7]); // SGST
						$('#itemTaxIGST_'+id[1]).val(names[8]); // IGST
						$('#itemTaxCGST_'+id[1]).val(names[9]); // CGST
						$('#itemTaxCESS_'+id[1]).val(names[10]); // CESS
						$('#itemDiscount_'+id[1]).val(discount);
						$('#itemSubTotal_'+id[1]).val( parseFloat((1 * names[2]) - (1 * names[2] * discount / 100)) );
						$('#itemTaxableValue_'+id[1]).val( parseFloat((1 * names[2]) - (1 * names[2] * discount / 100)) );
						$('#itemTaxAmount_'+id[1]).val( parseFloat(names[2]) * parseFloat(names[3]) / 100 );
						$('#itemTaxAmountSGST_'+id[1]).val( (parseFloat(names[2]) * parseFloat(names[7]) / 100 ) );
						$('#itemTaxAmountCGST_'+id[1]).val( (parseFloat(names[2]) * parseFloat(names[9]) / 100 ) );
						$('#itemTaxAmountIGST_'+id[1]).val( (parseFloat(names[2]) * parseFloat(names[8]) / 100 ) );
						$('#itemTaxAmountCESS_'+id[1]).val( (parseFloat(names[2]) * parseFloat(names[10]) / 100 ) );
					}
					calculateTotal();
				}
			});
		});

		$(document).on('change keyup mouseup blur', '.changeNo', function(){
			id_arr = $(this).attr('id');
			id = id_arr.split('_');

			var quantity = $('#itemQuantity_'+id[1]).val();
			var price = $('#itemPrice_'+id[1]).val();
			var itemDiscount = $('#itemDiscount_'+id[1]).val();
			var itemAmountDiscount = $('#itemAmountDiscount_'+id[1]).val();

			if (itemDiscount == "" || typeof(itemDiscount) == 'undefined') {
				$('#itemDiscount_'+id[1]).val(0);
			}

			if (itemAmountDiscount == "" || typeof(itemAmountDiscount) == 'undefined') {
				$('#itemAmountDiscount_'+id[1]).val(0);
			}

			if (itemAmountDiscount > 0) {
				$percentage = (itemAmountDiscount * 100) /price;
				$('#itemDiscount_'+id[1]).val($percentage);
			}
			
			if( quantity != '' && price != '' )
			{
				if( $('#itemDiscount_'+id[1]).val() != '')
				{
					var itemDiscount = $('#itemDiscount_'+id[1]).val();
				}
				else
				{
					itemDiscount = 0;
					$('#itemDiscount_'+id[1].val(0));
				}
				$('#itemSubTotal_'+id[1]).val( (parseFloat(price) * parseFloat(quantity) - (parseFloat(price) * parseFloat(quantity) * parseFloat(itemDiscount) / 100) ));
				$('#itemTaxableValue_'+id[1]).val( (parseFloat(price) * parseFloat(quantity) - (parseFloat(price) * parseFloat(quantity) * parseFloat(itemDiscount) / 100) )); // Taxable value
				var itemSubTotal = $('#itemSubTotal_'+id[1]).val();
				var itemTax = $('#itemTax_'+id[1]).val();

				if (itemTax == "" || typeof(itemTax) == 'undefined') {
					$('#itemTax_'+id[1]).val(0);
				}
				
				var itemTaxCGST = $('#itemTaxCGST_'+id[1]).val();
				var itemTaxSGST = $('#itemTaxSGST_'+id[1]).val();
				var itemTaxIGST = $('#itemTaxIGST_'+id[1]).val();
				var itemTaxCESS = $('#itemTaxCESS_'+id[1]).val();
				

				if( itemTax != '')
				{
					$('#itemTaxAmount_'+id[1]).val( (parseFloat(itemSubTotal) * parseFloat(itemTax) /100 ) );
					$('#taxAmount').val( (parseFloat(itemSubTotal) * parseFloat(itemTax) / 100 ) );

				}
				else
				{
					$('#itemTaxAmount_'+id[1]).val(0);
				}

				// CGST Tax
				if( itemTaxCGST != '')
				{
					$('#itemTaxAmountCGST_'+id[1]).val( (parseFloat(itemSubTotal) * parseFloat(itemTaxCGST) /100 ) );
					$('#taxAmount').val( (parseFloat(itemSubTotal) * parseFloat(itemTaxCGST) / 100 ) );

				}
				else
				{
					$('#itemTaxAmountCGST_'+id[1]).val(0);
				}

				// SGST Tax
				if( itemTaxSGST != '')
				{
					$('#itemTaxAmountSGST_'+id[1]).val( (parseFloat(itemSubTotal) * parseFloat(itemTaxSGST) /100 ) );
					$('#taxAmount').val( (parseFloat(itemSubTotal) * parseFloat(itemTaxSGST) / 100 ) );

				}
				else
				{
					$('#itemTaxAmountSGST_'+id[1]).val(0);
				}

				// IGST Tax
				if( itemTaxIGST != '')
				{
					$('#itemTaxAmountIGST_'+id[1]).val( (parseFloat(itemSubTotal) * parseFloat(itemTaxIGST) /100 ) );
					$('#taxAmount').val( (parseFloat(itemSubTotal) * parseFloat(itemTaxIGST) / 100 ) );

				}
				else
				{
					$('#itemTaxAmountIGST_'+id[1]).val(0);
				}
				// CESS Tax
				if( itemTaxCESS != '')
				{
					$('#itemTaxAmountCESS_'+id[1]).val( (parseFloat(itemSubTotal) * parseFloat(itemTaxCESS) /100 ) );
					$('#taxAmount').val( (parseFloat(itemSubTotal) * parseFloat(itemTaxCESS) / 100 ) );

				}
				else
				{
					$('#itemTaxAmountCESS_'+id[1]).val(0);
				}

				if( itemDiscount != '')
				{
					$('#itemDiscountAmount_'+id[1]).val( (price * quantity * itemDiscount ) /100 );
					$('#discountAmount').val( (price * quantity * itemDiscount ) /100 );

				}
				else
				{
					$('#itemDiscountAmount_'+id[1]).val(0);
					$('#discountAmount').val(0);
				}
				calculateTotal();
			}
		});

		// $(document).on('change keyup mouseup blur', '#amountPaid', function(){
		// 	calculateAmountDue();
		// });
		$(document).on('change', '#client-credit', function(){
			calculateAmountDue();
		});
		// $(document).on('focus', '#amountPaid', function(){
		// 	$('#amountPaid').val($('.amountDue').val());
		// 	calculateAmountDue();
		// });
		$(document).on('change keyup mouseup blur', '#globalDiscount', function(){
			globalDiscount = $(this).val();
			if (globalDiscount != '')
			{
				discount = globalDiscount;
			}
			else
			{
				discount = 0;
			}
			$('.changeNo').each(function(){
				id_arr = $(this).attr('id');
				id = id_arr.split('_');

				var quantity = $('#itemQuantity_'+id[1]).val();
				var price = $('#itemPrice_'+id[1]).val();

				if (discount != '')
				{
					$('#itemDiscount_'+id[1]).prop('readonly', true);
				}
				else
				{
					$('#itemDiscount_'+id[1]).prop('readonly', false);
				}
				$('#itemDiscount_'+id[1]).val(discount);

				if( quantity != '' && price != '' )
				{
					if( $('#itemDiscount_'+id[1]).val() != '')
					{
						var itemDiscount = $('#itemDiscount_'+id[1]).val();
					}
					else
					{
						itemDiscount = 0;
						$('#itemDiscount_'+id[1].val(0));
					}
					$('#itemSubTotal_'+id[1]).val( (parseFloat(price) * parseFloat(quantity) - (parseFloat(price) * parseFloat(quantity) * parseFloat(itemDiscount) / 100) ));
					$('#itemTaxableValue_'+id[1]).val( (parseFloat(price) * parseFloat(quantity) - (parseFloat(price) * parseFloat(quantity) * parseFloat(itemDiscount) / 100) ));
					var itemSubTotal = $('#itemSubTotal_'+id[1]).val();
					var itemTax = $('#itemTax_'+id[1]).val();

					if (itemTax == "" || typeof(itemTax) == 'undefined') {
					$('#itemTax_'+id[1]).val(0);
				}
				
					var itemTaxCGST = $('#itemTaxCGST_'+id[1]).val();
					var itemTaxSGST = $('#itemTaxSGST_'+id[1]).val();
					var itemTaxIGST = $('#itemTaxIGST_'+id[1]).val();
					var itemTaxCESS = $('#itemTaxCESS_'+id[1]).val();
					

					if( itemTax != '')
					{
						$('#itemTaxAmount_'+id[1]).val( (parseFloat(itemSubTotal) * parseFloat(itemTax) /100 ) );
						$('#taxAmount').val( (parseFloat(itemSubTotal) * parseFloat(itemTax) / 100 ) );

					}

					// CGST
					if( itemTaxCGST != '')
					{
						$('#itemTaxAmountCGST_'+id[1]).val( (parseFloat(itemSubTotal) * parseFloat(itemTaxCGST) /100 ) );
						$('#taxAmount').val( (parseFloat(itemSubTotal) * parseFloat(itemTaxCGST) / 100 ) );

					}

					// SGST
					if( itemTaxSGST != '')
					{
						$('#itemTaxAmountSGST_'+id[1]).val( (parseFloat(itemSubTotal) * parseFloat(itemTaxSGST) /100 ) );
						$('#taxAmount').val( (parseFloat(itemSubTotal) * parseFloat(itemTaxSGST) / 100 ) );

					}
					// IGST
					if( itemTaxIGST != '')
					{
						$('#itemTaxAmountIGST_'+id[1]).val( (parseFloat(itemSubTotal) * parseFloat(itemTaxIGST) /100 ) );
						$('#taxAmount').val( (parseFloat(itemSubTotal) * parseFloat(itemTaxIGST) / 100 ) );

					}
					// IGST
					if( itemTaxCESS != '')
					{
						$('#itemTaxAmountCESS_'+id[1]).val( (parseFloat(itemSubTotal) * parseFloat(itemTaxCESS) /100 ) );
						$('#taxAmount').val( (parseFloat(itemSubTotal) * parseFloat(itemTaxCESS) / 100 ) );

					}
					if( itemDiscount != '')
					{
						$('#itemDiscountAmount_'+id[1]).val( (price * quantity * itemDiscount ) /100 );
						$('#discountAmount').val( (price * quantity * itemDiscount ) /100 );

					}
					else
					{
						$('#itemDiscountAmount_'+id[1]).val(0);
					}
					calculateTotal();
				}
			});
		});
		$(document).on('change', '.invoice_to', function(){
			credit = 0;
			client_id = $('.invoice_to').val();
			multiCurrencySupport = $('#multicurrency-support').data('value');
			if (client_id == 0)
			{
				credit = 0;
				$('#credit-available > span').removeClass('mysuccess');
				$('#credit-available > span').text("");
				$("#client-credit").attr("readonly","readonly");
			}
			else
			{
				url = $.trim( $('#base-url').data('target') + 'index.php/clients/get_client_credit' );
				if ( multiCurrencySupport )
				{
					clientCurrencyUrl = $.trim( $('#base-url').data('target') + 'index.php/client/get_client_currency');
					$.getJSON(url, {client_id : client_id}).done(function(data){
						credit = parseFloat(data);
						if (credit >= 0.01)
						{
							$("#client-credit").removeAttr("readonly");
							html = $('#c-available').data('text');
							$('#credit-available > span').removeClass('mydanger');
							$('#credit-available > span').text(html + credit).addClass('mysuccess');
						}
						else
						{
							$('#credit-available > span').removeClass('mysuccess');
							$('#credit-available > span').text("");
							$("#client-credit").val(parseFloat(0));
							$("#client-credit").attr("readonly","readonly");
						}
					});
					$.getJSON(clientCurrencyUrl, {client_id : client_id}).done(function(data){
						clientCurrencyStr = data.currency_str;
						clientCurrencySymb = data.currency_symb;
						changeRate = data.change_rate;
						$('#changerate').val(changeRate);
						$('#clientchangerate').val(changeRate);
						latestChangeRate = $('#latestchangerate').data('message').replace(/%s/g, changeRate);
						clientCurrencyNotification = $('#clientcurrencywarning').data('message').replace(/%s/g, clientCurrencyStr + ' (' + clientCurrencySymb + ' ' +latestChangeRate + ')');
						toastr.options = {
						  "closeButton": true,
						  "debug": false,
						  "newestOnTop": true,
						  "progressBar": true,
						  "positionClass": "toast-top-right",
						  "preventDuplicates": true,
						  "onclick": null,
						  "showDuration": "300",
						  "hideDuration": "1000",
						  "timeOut": "5000",
						  "extendedTimeOut": "1000",
						  "showEasing": "swing",
						  "hideEasing": "linear",
						  "showMethod": "fadeIn",
						  "hideMethod": "fadeOut"
						}
						if (changeRate != 1)
						{
							toastr.info(clientCurrencyNotification, "");
						}
					});
				}
			}
		});
	},
	setDate = function(){
		var currentDate = new Date(),
			$locale = $('#user-language').data('language');
		switch($locale) {
		    case "french":
		        $locale = 'fr';
		        break;
		    case "german":
		        $locale = 'de';
		        break;
		    case "russian":
		        $locale = 'ru';
		        break;
		    case "spanish":
		        $locale = 'es';
		        break;
		    case "english":
		        $locale = 'en-GB';
		        break;

		    default:
		        $locale = "en-GB";
		        break;
		}
		$('.datepicker').datepicker({
			language: $.trim($locale),
			autoclose: true,
			todayHighlight: true
		});
		$('.datepicker-edit').datepicker({
			language: $.trim($locale),
			autoclose: true,
			todayHighlight: true
		});
		$(".datepicker").datepicker("setDate", currentDate);
		$(".datepicker-edit").datepicker();
	},
	serverResponse = function(responseText, statusText, xhr, $form){
		if(responseText.status == 1)
		{
			App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#default-save-success').data('message')});
			setTimeout(function(){
			   window.location.reload();
			}, 3000);
		}
		else
		{
			message = responseText.error;
			message = message.replace(/<\/?p[^>]*>/g, "");
			if( message != '')
			{
				App.alert({container: $('#notification-alert'), type: "danger", close: true, message: message});
			}
			else
			{
				App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#default-update-success').data('message')});
			}
			$("#btn-create-invoice").removeAttr("disabled");
			$(".btn-submit").text($('#btn-save').data('text'));
		}
	},
	serverResponseQuote = function(responseText, statusText, xhr, $form){
		if(responseText.status == 1)
		{
			App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#default-save-success').data('message')});
			setTimeout(function(){
			   window.location.reload();
			}, 3000);
		}
		else
		{
			message = responseText.error;
			message = message.replace(/<\/?p[^>]*>/g, "");
			if( message != '')
			{
				App.alert({container: $('#notification-alert'), type: "danger", close: true, message: message});
			}
			else
			{
				App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#default-update-success').data('message')});
			}
			$("#btn-create-quote").removeAttr("disabled");
			$(".btn-submit").text($('#btn-save').data('text'));
		}
	},
	updateInvoiceServerResponse = function(responseText, statusText, xhr, $form){

		if(responseText.status == 1)
		{
			App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#default-update-success').data('message')});
			setTimeout(function () {
				window.location.reload();
			}, 200);
		}
		else
		{
			message = responseText.error;
			message = message.replace(/<\/?p[^>]*>/g, "");
			if( message != '')
			{
				App.alert({container: $('#notification-alert'), type: "danger", close: true, message: message});
			}
			else
			{
				App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#default-update-success').data('message')});
			}
			$(".btn-submit").removeAttr("disabled");
			$(".btn-submit").text($('#btn-save').data('text'));
		}
	},
	updateQuoteServerResponse = function(responseText, statusText, xhr, $form){

		if(responseText.status == 1)
		{
			App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#default-update-success').data('message')});
			$(".btn-submit").removeAttr("disabled");
			$(".btn-submit").text($('#btn-save').data('text'));
		}
		else
		{
			message = responseText.error;
			message = message.replace(/<\/?p[^>]*>/g, "");
			if( message != '')
			{
				App.alert({container: $('#notification-alert'), type: "danger", close: true, message: message});
			}
			else
			{
				App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#default-update-success').data('message')});
			}
			$(".btn-submit").removeAttr("disabled");
			$(".btn-submit").text($('#btn-save').data('text'));
		}
	},
	nextInvoiceNumber = function(){
		url = $('#base-url').data('target') + 'index.php/invoices/next_invoice_number';
		$.getJSON(url, function(data){
			if (data) {
				$('#invoice_number').val(data);
				$('#btn-create-invoice').removeAttr("disabled");
			}
		});
	},
	nextOrderNumber = function(){
		url = $('#base-url').data('target') + 'index.php/orders/next_order_number';
		$.getJSON(url, function(data){
			if (data) {
				$('#order_number').val(data);
				$('#btn-create-invoice').removeAttr("disabled");
			}
		});
	},
	nextQuoteNumber = function(){
		url = $('#base-url').data('target') + 'index.php/quotes/next_quote_number';
		$.getJSON(url, function(data){
			if (data) {
				$('#quote_number').val(data);
				$('#btn-create-quote').removeAttr("disabled");
			}
		});
	},
	calculateTotal = function(){
		var taxAmount = 0,
			discountAmount = 0,
			subTotal = 0,
			total = 0;
		$('.itemSubTotal').each(function() {
			if( $(this).val() != '' )
			{
				subTotal += parseFloat( $(this).val() );
			}
		});

		$('.itemTaxAmount').each(function() {
			if( $(this).val() != '')
			{
				taxAmount += parseFloat( $(this).val() );
			}
		});
		$('.itemTaxAmountCGST').each(function() {
			if( $(this).val() != '')
			{
				taxAmount += parseFloat( $(this).val() );
			}
		});
		$('.itemTaxAmountSGST').each(function() {
			if( $(this).val() != '')
			{
				taxAmount += parseFloat( $(this).val() );
			}
		});
		$('.itemTaxAmountIGST').each(function() {
			if( $(this).val() != '')
			{
				taxAmount += parseFloat( $(this).val() );
			}
		});
		$('.itemTaxAmountCESS').each(function() {
			if( $(this).val() != '')
			{
				taxAmount += parseFloat( $(this).val() );
			}
		});
		$('.itemDiscountAmount').each(function() {
			if( $(this).val() != '')
			{
				discountAmount += parseFloat( $(this).val() );
			}
		});

		$('#subTotal').val( subTotal );
		$('#taxAmount').val( taxAmount );
		$('#discountAmount').val( discountAmount );

		total = (subTotal + taxAmount);

		$('#totalAftertax').val( total );
		$('#items_subTotal').val( subTotal );

		calculateAmountDue();
	},
	calculateAmountDue = function(){
		client_id = $('.invoice_to').val();
		if (client_id == 0)
		{
			credit = 0;
		}
		var amountPaid = $('#amountPaid').val(),
			credit_used = $('#client-credit').val(),
			total = $('#totalAftertax').val();
			if (credit_used == "" || typeof(credit_used) == "undefined")
			{
				credit_used = 0.00;
			}
		if( amountPaid != '' && typeof(amountPaid) != "undefined")
		{
			amountDue = parseFloat(total) - parseFloat( amountPaid ) - parseFloat( credit_used );
			$('.amountDue').val( amountDue );
			credit_remaining = parseFloat(credit - credit_used);
			if (credit_remaining > 0)
			{
				html = $('#c-available').data('text');
				$('#credit-available > span').text(html + credit_remaining).addClass('mysuccess');
			}
			else
			{
				html = $('#c-available').data('text');
			$('#credit-available > span').text(html + credit_remaining).addClass('mydanger');
			}
		}
		else
		{
			total = parseFloat(total) - parseFloat(credit_used);
			if (total < 0)
			{
				$('.amountDue').val(parseFloat(total)).addClass('mydanger');
			}
			else
			{
				$('.amountDue').removeClass('mydanger');
				$('.amountDue').val(parseFloat(total));
			}
			credit_remaining = parseFloat(credit - credit_used);
			if (credit_remaining > 0)
			{
				html = $('#c-available').data('text');
				$('#credit-available > span').removeClass('mydanger');
				$('#credit-available > span').text(html + credit_remaining).addClass('mysuccess');
			}
			else
			{
				html = $('#c-available').data('text');
				$('#credit-available > span').text(html + credit_remaining).addClass('mydanger');
			}
		}
	},
	mollieRefund = function() {
		$("#mollie-refund").click(function(e) {
			e.preventDefault();
			$user_currency = $('#money-format').data('symbol');
			$notMolliePayment = $('#total-refunded').data('notmolliepayment');
			$header = $('#total-refunded').data('message') + $user_currency + parseFloat($('#total-refunded').data('value'));
			bootbox.prompt({
			    title:  $header,
			    inputType: 'number',
			    buttons: {
			            'cancel': {
			                label: $('#btn-cancel').data('text'),
			                className: 'btn-default pull-left'
			            },
			            'confirm': {
			                label: $('#btn-save').data('text'),
			                className: 'btn-danger pull-right'
			            }
			        },
			    callback: function (result) {
			    	if (result > 0)
			    	{
				        $amount = result;
				        $transaction_id = $('#mollie-refund').data('transaction');
				        $url = $('#base-url').data('target') + 'index.php/mollie/refund_payment/index';
				        $.getJSON({
				            url: $url,
				            data: {
				                amount: $amount,
				                transaction_id: $transaction_id
	 			            },
				            success: function (data) {
				            	if (data.success > 0)
				            	{
				            		location.reload(true);
				            	}
				            	if(data.fail > 0)
				            	{
				            		swal({
				            		  title: 'Oooops',
				            		  text: $notMolliePayment,
				            		  type: "warning",
				            		  confirmButtonClass: "btn-danger",
				            		  closeOnConfirm: true
				            		});
				            	}
				            }
				        });
			    	}
			    }
			});
        })
	},
	manualRefund = function() {
		$("#manual-refund").click(function(e) {
			e.preventDefault();
			$user_currency = $('#money-format').data('symbol');
			$header = $('#total-refunded').data('message') + $user_currency + parseFloat($('#total-refunded').data('value'));
			bootbox.prompt({
			    title:  $header,
			    inputType: 'number',
			    callback: function (result) {
			    	if (result > 0)
			    	{
				        $amount = result;
				        $invoice_number = $('#manual-refund').data('invoice');
				        $url = $('#base-url').data('target') + 'index.php/invoices/ajax/refund_payment';
				        $.getJSON({
				            url: $url,
				            data: {
				                amount: $amount,
				                invoice_number: $invoice_number
	 			            },
				            success: function (data) {
				            	if (data.success > 0)
				            	{
				            		location.reload(true);
				            	}
				            	if(data.fail > 0)
				            	{
				            		swal({
				            		  title: 'Oooops',
				            		  text: $('#manual-refund').data('refundfailed'),
				            		  type: "warning",
				            		  confirmButtonClass: "btn-danger",
				            		  closeOnConfirm: true
				            		});
				            	}
				            }
				        });
			    	}
			    }
			});
        })
	},
	handleCreditNote = function(){
		var $table = $('#btable'),
		    $creditNote = $('#credit-note'),
		    selections = [];

		// sometimes footer render error.
		setTimeout(function () {
			$table.bootstrapTable('resetView');
		}, 200);
		$table.on('check.bs.table uncheck.bs.table ' +
		                'check-all.bs.table uncheck-all.bs.table', function () {
		            $creditNote.prop('disabled', !$table.bootstrapTable('getSelections').length);

		            // save your data, here just save the current page
		            selections = getIdSelections();
		            // push or splice the selections if you want to save all data selections
		        });
		$creditNote.click(function () {
		    var ids = getIdSelections();
		    $base_url = $('#base-url').data('target'),
		    $url = $.trim( $base_url + 'index.php/creditnote/create_credit_note' );
		    $this = $('#credit-note');
		    swal({
		      title: $this.data('sure'),
		      text: $this.data('message'),
		      type: "warning",
		      showCancelButton: true,
		      confirmButtonClass: "btn-danger",
		      confirmButtonText: $this.data('confirm'),
		      cancelButtonText: $('#btn-cancel').data('text'),
		      closeOnConfirm: true
		    },
		    function(){ 
		        $.getJSON({
		            url: $url,
		            data: {
		                id: ids
		            },
		            success: function (data) {
		            	if (data.success > 0)
		            	{
		            		App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#credit-note').data('success')});
		            		setTimeout(function () {
		            			window.location = $base_url + 'index.php/creditnote';
		            		}, 300);
		            		$markPaid.prop('disabled', true);
		            	}
		            	if(data.fail > 0)
		            	{
		            		App.alert({container: $('#notification-alert'), type: "danger", close: true, message: $('#credit-note').data('danger') + ' ' + data.fail });
		            		setTimeout(function () {
		            			$table.bootstrapTable('refresh', true);
		            		}, 300);
		            		$markPaid.prop('disabled', true);
		            	}
		            }
		        });
		    });
		});
		function getIdSelections() {
		    return $.map($table.bootstrapTable('getSelections'), function (row) {
		        return row.enc_invoice_number
		    });
		}
	},
	handleShowTransactionHistory = function(){
		$("#view-transaction").on('click', function(){
			$('#transaction-details').toggleClass('hidden');
		});
	};
	return {
		init: function(){
			handleInvoiceForm(),
			handleAutoComplete(),
			handleUpdateInvoice(),
			handleSelectClient(),
			handleDeleteInvoice(),
			nextInvoiceNumber(),
			nextQuoteNumber(),
			handleMassPayment(),
			handleMassEmailInvoices(),
			handleQuoteForm(),
			handleUpdateQuote(),
			handleDeleteQuote(),
			handleMassEmailQuotes(),
			handleMassApproved(),
			mollieRefund(),
			manualRefund(),
			handleShowTransactionHistory(),
			handleCreditNote()
		}
	}
})(jQuery);
jQuery(document).ready(function() {
	Invoices.init()
});
