var Inventory = (function ($) {
    var handleTable = function () {
        function restoreRow(oTable, nRow) {
            var aData = oTable.fnGetData(nRow);
            var jqTds = $('>td', nRow);

            for (var i = 0, iLen = jqTds.length; i < iLen; i++) {
                oTable.fnUpdate(aData[i], nRow, i, false);
            }

            oTable.fnDraw();
        }
        function editRow(oTable, nRow) {
            var aData = oTable.fnGetData(nRow);
            var jqTds = $('>td', nRow);
            jqTds[0].innerHTML = '<input type="text" readonly="true" class="form-control input-small" value="' + aData[0] + '">';
            jqTds[1].innerHTML = '<input type="text" readonly="true" class="form-control input-small" value="' + aData[1] + '">';
            jqTds[2].innerHTML = '<input type="text" readonly="true" class="form-control input-small" value="' + aData[2] + '">';
            jqTds[3].innerHTML = '<input type="text" class="form-control input-small" onkeypress="return IsNumeric(event);" ondrop="return false;" onpaste="return false;" value="' + aData[3] + '">';
            jqTds[4].innerHTML = '<input type="text" readonly="true" class="form-control input-small" onkeypress="return IsNumeric(event);" ondrop="return false;" onpaste="return false;" value="' + aData[4] + '">';
            jqTds[5].innerHTML = '<input type="text" readonly="true" class="form-control input-small" onkeypress="return IsNumeric(event);" ondrop="return false;" onpaste="return false;" value="' + aData[5] + '">';
            jqTds[6].innerHTML = '<input type="text" readonly="true" class="form-control input-small" onkeypress="return IsNumeric(event);" ondrop="return false;" onpaste="return false;" value="' + aData[6] + '">';
            jqTds[7].innerHTML = '<input type="text" class="form-control input-small" onkeypress="return IsNumeric(event);" ondrop="return false;" onpaste="return false;" value="' + aData[7] + '">';
            jqTds[8].innerHTML = '<input type="text" readonly="true" class="form-control input-small" onkeypress="return IsNumeric(event);" ondrop="return false;" onpaste="return false;" value="' + aData[7] + '">';
            jqTds[9].innerHTML = '<a class="edit" href=""><i class="fa fa-floppy-o" aria-hidden="true"></i></a>';
            jqTds[10].innerHTML = '<a class="cancel" href=""><i class="fa fa-ban" aria-hidden="true"></i></a>';
        }
        function saveRow(oTable, nRow) {
            var jqInputs = $('input', nRow);
            oTable.fnUpdate(jqInputs[0].value, nRow, 0, false);
            oTable.fnUpdate(jqInputs[1].value, nRow, 1, false);
            oTable.fnUpdate(jqInputs[2].value, nRow, 2, false);
            oTable.fnUpdate(jqInputs[3].value, nRow, 3, false);
            oTable.fnUpdate(jqInputs[4].value, nRow, 4, false);
            oTable.fnUpdate(jqInputs[5].value, nRow, 5, false);
            oTable.fnUpdate(jqInputs[6].value, nRow, 6, false);
            oTable.fnUpdate(jqInputs[7].value, nRow, 7, false);
            oTable.fnUpdate(jqInputs[8].value, nRow, 8, false);
            oTable.fnUpdate('<a class="edit" href=""><i class="icon-note"></i></a>', nRow, 9, false);
            oTable.fnUpdate('<a class="delete" href=""><i class="icon-trash" style="color: red"></i></a>', nRow, 10, false);
            oTable.fnDraw();

            var updateStockUrl = $('#base-url').data('target') + 'index.php/products/ajax/update_stock';
            var item_id = jqInputs[0].value;
            var $db_data = {
                on_hand_stock: jqInputs[3].value,
                reorder_point: jqInputs[7].value
            };
            $.getJSON(updateStockUrl, {item_id: item_id, db_data: $db_data}, function(result){
                if(result.status == 1)
                {
                    location.reload();
                    App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#default-save-success').data('message')});
                }
                else
                {
                    message = result.error;
                    message = message.replace(/<\/?p[^>]*>/g, "");
                    if( message != '')
                    {
                        App.alert({container: $('#notification-alert'), type: "danger", close: true, message: message});
                    }
                }
            });
        }
        function cancelEditRow(oTable, nRow) {
            var jqInputs = $('input', nRow);
            oTable.fnUpdate(jqInputs[0].value, nRow, 0, false);
            oTable.fnUpdate(jqInputs[1].value, nRow, 1, false);
            oTable.fnUpdate(jqInputs[2].value, nRow, 2, false);
            oTable.fnUpdate(jqInputs[3].value, nRow, 3, false);
            oTable.fnUpdate(jqInputs[4].value, nRow, 4, false);
            oTable.fnUpdate(jqInputs[5].value, nRow, 5, false);
            oTable.fnUpdate(jqInputs[6].value, nRow, 6, false);
            oTable.fnUpdate(jqInputs[7].value, nRow, 7, false);
            oTable.fnUpdate(jqInputs[8].value, nRow, 8, false);
            oTable.fnUpdate('<a class="edit" href=""><i class="icon-note"></i></a>', nRow, 9, false);
            oTable.fnDraw();
        }
        var table = $('#inventory_index');

        var oTable = table.dataTable({

            // Uncomment below line("dom" parameter) to fix the dropdown overflow issue in the datatable cells. The default datatable layout
            // setup uses scrollable div(table-scrollable) with overflow:auto to enable vertical scroll(see: assets/global/plugins/datatables/plugins/bootstrap/dataTables.bootstrap.js). 
            // So when dropdowns used the scrollable div should be removed. 
            //"dom": "<'row'<'col-md-6 col-sm-12'l><'col-md-6 col-sm-12'f>r>t<'row'<'col-md-5 col-sm-12'i><'col-md-7 col-sm-12'p>>",

            "lengthMenu": [
                [15, 20, 30, -1],
                [15, 20, 30, "All"] // change per page values here
            ],

            // Or you can use remote translation file
            //"language": {
            //   url: '//cdn.datatables.net/plug-ins/3cfcc339e89/i18n/Portuguese.json'
            //},

            // set the initial value
            "pageLength": 15,
            "columnDefs": [{ // set default column settings
                'orderable': true,
                'targets': [0]
            }, 
            {
                // The `data` parameter refers to the data for the cell (defined by the
                // `data` option, which defaults to the column being worked with, in
                // this case `data: 0`.
                "render": function ( data, type, row ) {
                    return '<span class="mytext-center">' +mFormatNumber(data)+'</span>';
                },
                "targets": 8
            },
            {
                // The `data` parameter refers to the data for the cell (defined by the
                // `data` option, which defaults to the column being worked with, in
                // this case `data: 0`.
                "render": function ( data, type, row ) {
                    if (data > 0)
                    {
                        return '<span class="mytext-center">' +mFormatNumber(data)+'</span>';
                    }
                    else
                    {
                        return '<span class="mytext-center">' +0+'</span>';
                    }
                },
                "targets": 5
            },
            {
                // The `data` parameter refers to the data for the cell (defined by the
                // `data` option, which defaults to the column being worked with, in
                // this case `data: 0`.
                "render": function ( data, type, row ) {
                    if (data > 0)
                    {
                        return '<span class="mytext-center">' +mFormatNumber(data)+'</span>';
                    }
                    else
                    {
                        return '<span class="mytext-center">' +0+'</span>';
                    }
                },
                "targets": 7
            },
            {
                // The `data` parameter refers to the data for the cell (defined by the
                // `data` option, which defaults to the column being worked with, in
                // this case `data: 0`.
                "render": function ( data, type, row ) {
                    if (data > 0)
                    {
                        return '<span class="mytext-center">' +mFormatNumber(data)+'</span>';
                    }
                    else
                    {
                        return '<span class="mytext-center">' +0+'</span>';
                    }
                },
                "targets": 4
            },
            {
                // The `data` parameter refers to the data for the cell (defined by the
                // `data` option, which defaults to the column being worked with, in
                // this case `data: 0`.
                "render": function ( data, type, row ) {
                    if (data > 0)
                    {
                        return '<span class="mytext-center">' +mFormatNumber(data)+'</span>';
                    }
                    else
                    {
                        return '<span class="mytext-center">' +0+'</span>';
                    }
                },
                "targets": 3
            },
            {
                // The `data` parameter refers to the data for the cell (defined by the
                // `data` option, which defaults to the column being worked with, in
                // this case `data: 0`.
                "render": function ( data, type, row ) {
                    if (data < 0)
                    {
                        return '<span class="mytext-center mydanger"><strong>' + mFormatNumber(data)+ '</strong></span>';
                    }
                    else if(data == 0)
                    {
                        return '<button type="button" class="btn red btn-outline sbold uppercase"><strong>' + $('#label-out-of-stock').text()+ '</strong></button>';
                    }
                    else
                    {
                        return '<span class="mytext-center mysuccess"><strong>' + mFormatNumber(data)+ '</strong></span>';
                    }
                },
                "targets": 6
            },
            {
                "searchable": true,
                "targets": [0]
            }],
            "order": [
                [0, "desc"]
            ], // set first column as a default sort by asc
            "dom": 'Bfrtip',
            "buttons": [
                'excelHtml5',
                'csvHtml5',
                'pdfHtml5'
            ]
        });

        var tableWrapper = $("#inventory_index_wrapper");

        var nEditing = null;
        var nNew = false;

        $('#inventory_index_new').click(function (e) {
            e.preventDefault();

            if (nNew && nEditing) {
                if (confirm("Previose row not saved. Do you want to save it ?")) {
                    saveRow(oTable, nEditing); // save
                    $(nEditing).find("td:first").html("Untitled");
                    nEditing = null;
                    nNew = false;

                } else {
                    oTable.fnDeleteRow(nEditing); // cancel
                    nEditing = null;
                    nNew = false;
                    
                    return;
                }
            }

            var aiNew = oTable.fnAddData(['', '', '', '', '', '']);
            var nRow = oTable.fnGetNodes(aiNew[0]);
            editRow(oTable, nRow);
            nEditing = nRow;
            nNew = true;
        });

        table.on('click', '.delete', function (e) {
            e.preventDefault();
            var $this = $(this);
            swal({
              title: $this.data('sure'),
              text: $this.data('message'),
              type: "warning",
              showCancelButton: true,
              confirmButtonClass: "btn-danger",
              confirmButtonText: $this.data('confirm'),
              cancelButtonText: $('#btn-cancel').data('text'),
              closeOnConfirm: true
            },
            function(){ 
                var nRow = $this.parents('tr')[0];
                var $item_id = [].concat(oTable.fnGetData(nRow)[0]);
                var deleteItemUrl = $('#base-url').data('target') + 'index.php/products/delete_item';
                $.getJSON(deleteItemUrl, {id: $item_id}, function(result){
                    if(result.success > 0)
                    {
                        oTable.fnDeleteRow(nRow);
                        App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#remove-item').data('success')});
                    }
                    if(result.fail > 0)
                    {
                        App.alert({container: $('#notification-alert'), type: "danger", close: true, message: $('#remove-item').data('danger') + '&nbsp;' + result.fail});
                    }
                });
            });
        });
        table.on('click', '.cancel', function (e) {
            e.preventDefault();
            if (nNew) {
                oTable.fnDeleteRow(nEditing);
                nEditing = null;
                nNew = false;
            } else {
                restoreRow(oTable, nEditing);
                nEditing = null;
            }
        });

        table.on('click', '.edit', function (e) {
            e.preventDefault();
            nNew = false;
            
            /* Get the row as a parent of the link that was clicked on */
            var nRow = $(this).parents('tr')[0];

            if (nEditing !== null && nEditing != nRow) {
                /* Currently editing - but not this row - restore the old before continuing to edit mode */
                restoreRow(oTable, nEditing);
                editRow(oTable, nRow);
                nEditing = nRow;
            } else if (nEditing == nRow && this.innerHTML == '<i class="fa fa-floppy-o" aria-hidden="true"></i>') {
                /* Editing this row and want to save it */
                saveRow(oTable, nEditing);
                nEditing = null;
            } else {
                /* No edit in progress - let's start one */
                editRow(oTable, nRow);
                nEditing = nRow;
            }
        });
    };
    return {
        init: function () {
            handleTable();
        }
    };

})(jQuery);
jQuery(document).ready(function() {
    Inventory.init();
});