var mCharts = (function($) {
    var handleBarCharts = function() {
            // Init the bar chart
            var barChart = echarts.init(document.getElementById("echarts_bar")),
                // Set Options
                options = {
                    title: {},
                    tooltip: {
                        trigger: 'axis',
                        axisPointer: {
                            type: 'shadow'
                        }
                    },
                    legend: {
                        orient: "horizontal",
                        x: "center",
                        y: "bottom",
                        padding: 0,
                        data: [$("#taxes").data("label"), $("#fees").data("label"), $("#income").data("label")]
                    },
                    grid: {
                        left: '3%',
                        right: '9%',
                        bottom: '5%',
                        containLabel: true
                    },
                    toolbox: {
                        show: !0,
                        showTitle: !1,
                        feature: {
                            mark: {
                                show: !1
                            },
                            dataView: {
                                show: !1,
                                readOnly: !1
                            },
                            magicType: {
                                show: !0,
                                type: ["line", "bar"]
                            },
                            restore: {
                                show: !0
                            },
                            saveAsImage: {
                                show: !0
                            }
                        }
                    },
                    calculable: !0,
                    xAxis: {
                        data: []
                    },
                    yAxis: {},
                    series: [{
                            name: $("#taxes").data("label"),
                            type: "bar",
                            label: {
                                normal: {
                                    show: false,
                                    position: 'insideRight'
                                }
                            },
                            data: [],
                            markLine: {
                                data: [{
                                    type: 'average',
                                    name: $("#period-average").data('label')
                                }]
                            }
                        },
                        {
                            name: $("#fees").data("label"),
                            type: "bar",
                            label: {
                                normal: {
                                    show: false,
                                    position: 'insideRight'
                                }
                            },
                            data: []
                        },
                        {
                            name: $("#income").data("label"),
                            type: "bar",
                            label: {
                                normal: {
                                    show: false,
                                    position: 'insideRight'
                                }
                            },
                            data: [],
                            markLine: {
                                data: [{
                                    type: 'average',
                                    name: $("#period-average").data('label')
                                }]
                            }
                        }
                    ]
                },
                // Default Range set to the last 3 months
                range = "last_three_months";
            url = $("#base-url").data("target") + "index.php/reports/financial_accounting";

            barChart.showLoading();
            $.getJSON(url, {
                interval: range
            }).done(function(a) {
                if (a.length > 0 ) {
                    $('#no-data').removeClass('hidden');
                    $('#no-data').addClass('hidden');
                    $('#echarts_bar').show();
                    $('#report-details').show();
                } else {
                    barChart.hideLoading();
                    $('#echarts_bar').hide();
                    $('#report-details').hide();
                    $('#no-data').removeClass('hidden');
                }
                $incomes = [], $months = [], $taxes = [], $charges = [];
                for (var n = 0; n < a.length; n++) $incomes.push(a[n].incomes), $months.push(a[n].month + "/" + a[n].year), $taxes.push(a[n].taxes), $charges.push(a[n].charges);
                var total = 0,
                    charges = 0,
                    results = 0,
                    taxes = 0,
                    color = '';
                $.each($incomes, function() {
                    total += this;
                });
                $.each($charges, function() {
                    charges += this;
                });
                $.each($taxes, function() {
                    taxes += this;
                });
                results = total - charges;
                if (results >= 0)
                {
                    $("#period-results").text(accounting.formatMoney(results)).addClass('total font-green-seagreen');
                }
                else
                {
                   $("#period-results").removeClass('font-green-seagreen');
                   $("#period-results").text(accounting.formatMoney(results)).addClass('mydanger');
                }
                $("#period-total").text(accounting.formatMoney(total)).addClass('total font-green-seagreen');
                $("#period-average").text(accounting.formatMoney(total / $incomes.length)).addClass('total');
                $("#period-taxes").text(accounting.formatMoney(taxes)).addClass('total');
                $("#period-total-with-taxes").text(accounting.formatMoney(total + taxes)).addClass('total');
                $("#period-total-taxes-free").text(accounting.formatMoney(total)).addClass('total');
                $(".period-charges").text(accounting.formatMoney(charges)).addClass('mydanger');
                barChart.hideLoading(), barChart.setOption({
                    series: [{
                            name: $("#taxes").data("label"),
                            type: "bar",
                            label: {
                                normal: {
                                    show: false,
                                    position: 'insideRight'
                                }
                            },
                            data: $taxes
                        },
                        {
                            name: $("#fees").data("label"),
                            type: "bar",
                            label: {
                                normal: {
                                    show: false,
                                    position: 'insideRight'
                                }
                            },
                            data: $charges
                        },
                        {
                            name: $("#income").data("label"),
                            type: "bar",
                            label: {
                                normal: {
                                    show: false,
                                    position: 'insideRight'
                                }
                            },
                            data: $incomes
                        }
                    ],
                    xAxis: {
                        data: $months
                    }
                })
            });
            // Dynamic range
            $(".reports-date-range").on("click", function() {
                var $this = $(this),
                    range = $this.data("range");
                url = $("#base-url").data("target") + "index.php/reports/financial_accounting";
                $("#graph-period").text($this.text());
                barChart.showLoading();
                $.getJSON(url, {
                    interval: range
                }).done(function(a) {
                    if (a.length > 0 ) {
                        $('#no-data').removeClass('hidden');
                        $('#no-data').addClass('hidden');
                        $('#echarts_bar').show();
                        $('#report-details').show();
                    } else {
                        barChart.hideLoading();
                        $('#echarts_bar').hide();
                        $('#report-details').hide();
                        $('#no-data').removeClass('hidden');
                    }
                    $incomes = [], $months = [], $taxes = [], $charges = [];
                    for (var n = 0; n < a.length; n++) $incomes.push(a[n].incomes), $months.push(a[n].month + "/" + a[n].year), $taxes.push(a[n].taxes), $charges.push(a[n].charges);
                    var total = 0,
                        charges = 0,
                        results = 0,
                        taxes = 0,
                        color = '';
                    $.each($incomes, function() {
                        total += this;
                    });
                    $.each($charges, function() {
                        charges += this;
                    });
                    $.each($taxes, function() {
                        taxes += this;
                    });
                    results = total - charges;
                    if (results >= 0)
                    {
                        $("#period-results").text(accounting.formatMoney(results)).addClass('font-green-seagreen');
                    }
                    else
                    {
                       $("#period-results").removeClass('font-green-seagreen');
                       $("#period-results").text(accounting.formatMoney(results)).addClass('mydanger');
                    }
                    $("#period-total").text(accounting.formatMoney(total)).addClass('total font-green-seagreen');
                    $("#period-average").text(accounting.formatMoney(total / $incomes.length)).addClass('total');
                    $("#period-taxes").text(accounting.formatMoney(taxes)).addClass('total');
                    $("#period-total-with-taxes").text(accounting.formatMoney(total + taxes)).addClass('total');
                    $("#period-total-taxes-free").text(accounting.formatMoney(total)).addClass('total');
                    $(".period-charges").text(accounting.formatMoney(charges)).addClass('mydanger');
                    url2 = $("#base-url").data("target") + "index.php/dashboard/incomeByCategory";
                    $.getJSON(url2, {
                        interval: range
                    }).done(function(data) {
                        $("#cat-list").html("");
                        if (data) {
                            for (var i = 0; i < data.length; i++) {
                                html = '<span><strong>' + data[i].category + '</strong> : ' + accounting.formatMoney(data[i].value);
                                html += '</span> <br />';
                                $("#cat-list").append(html);
                            }
                        }
                    });
                    barChart.hideLoading();
                    barChart.setOption({
                        series: [{
                                name: $("#income").data("label"),
                                type: "bar",
                                label: {
                                    normal: {
                                        show: false,
                                        position: 'insideRight'
                                    }
                                },
                                data: $incomes
                            }, {
                                name: $("#taxes").data("label"),
                                type: "bar",
                                label: {
                                    normal: {
                                        show: false,
                                        position: 'insideRight'
                                    }
                                },
                                data: $taxes
                            },
                            {
                                name: $("#fees").data("label"),
                                type: "bar",
                                label: {
                                    normal: {
                                        show: false,
                                        position: 'insideRight'
                                    }
                                },
                                data: $charges
                            }
                        ],
                        xAxis: {
                            data: $months
                        }
                    })
                })
            });
            jQuery(window).on("resize", function() {
                null != barChart && void 0 != barChart && barChart.resize()
            });
            barChart.setOption(options);
        },
        handlePieChartsItemsSum = function() {
            var pieChart = echarts.init(document.getElementById("echarts_pie")),
                options = {
                    tooltip: {
                        trigger: "item",
                        formatter: "{a} <br/>{b}: {c} ({d}%)"
                    },
                    legend: {
                        orient: "vertical",
                        x: "left",
                        y: "left",
                        padding: 2,
                        show: false,
                        data: $("#items-sums").data("legend")
                    },
                    series: [{
                        name: '',
                        type: "pie",
                        selectedMode: "single",
                        radius: ["50%", "75%"],
                        avoidLabelOverlap: false,
                        label: {
                            normal: {
                                show: false,
                                position: 'center'
                            },
                            emphasis: {
                                show: true,
                                textStyle: {
                                    fontSize: '15',
                                    fontWeight: 'bold'
                                }
                            }
                        },
                        labelLine: {
                            normal: {
                                show: false
                            }
                        },
                        data: []
                    }]
                };
            // Dynamic range
            $('.pie-date-range').click(function(event) {
                interval = $(this).data('range');
                // Get income by item
                url = $("#base-url").data("target") + "index.php/dashboard/invoicedItemsSum", $.getJSON(url, {
                    interval: interval
                }).done(function(e) {
                    pieChart.setOption({
                        series: [{
                            name: '',
                            data: e
                        }]
                    })
                });
            });

            // Default interval set to this month
            interval = 'this_month';
            // Get income by item
            url = $("#base-url").data("target") + "index.php/dashboard/invoicedItemsSum", $.getJSON(url, {
                interval: interval
            }).done(function(e) {
                pieChart.setOption({
                    series: [{
                        name: '',
                        data: e
                    }]
                })
            });
            // Resize the graph
            jQuery(window).on("resize", function() {
                null != pieChart && void 0 != pieChart && pieChart.resize()
            });
            pieChart.setOption(options);
        },
        handlePieChartsItemsCount = function() {
            var pieChart = echarts.init(document.getElementById("echarts_pie_count")),
                options = {
                    tooltip: {
                        trigger: "item",
                        formatter: "{a} <br/>{b}: {c} ({d}%)"
                    },
                    legend: {
                        orient: "vertical",
                        x: "left",
                        y: "left",
                        padding: 0,
                        show: false,
                        data: $("#items-sums").data("legend")
                    },
                    series: [{
                        name: '',
                        type: "pie",
                        selectedMode: "single",
                        radius: ["50%", "75%"],
                        avoidLabelOverlap: false,
                        label: {
                            normal: {
                                show: !1,
                                position: 'center'
                            },
                            emphasis: {
                                show: true,
                                textStyle: {
                                    fontSize: '15',
                                    fontWeight: 'bold'
                                }
                            }
                        },
                        labelLine: {
                            normal: {
                                show: !1
                            }
                        },
                        data: []
                    }]
                };
            // Dynamic range
            $('.pie-date-range').click(function(event) {
                interval = $(this).data('range');
                // Count item sold
                url = $("#base-url").data("target") + "index.php/dashboard/invoicedItemsCount", $.getJSON(url, {
                    interval: interval
                }).done(function(e) {
                    pieChart.setOption({
                        series: [{
                            name: '',
                            data: e
                        }]
                    })
                });
            });

            // Default interval set to this month
            interval = 'this_month';
            // Count item sold
            url = $("#base-url").data("target") + "index.php/dashboard/invoicedItemsCount", $.getJSON(url, {
                interval: interval
            }).done(function(e) {
                pieChart.setOption({
                    series: [{
                        name: '',
                        data: e
                    }]
                })
            });
            // Resize the graph
            jQuery(window).on("resize", function() {
                null != pieChart && void 0 != pieChart && pieChart.resize()
            });
            pieChart.setOption(options);
        };
    return {
        init: function() {
            handleBarCharts(), handlePieChartsItemsSum()
            $('#statistics_orders_tab').on('shown.bs.tab', function(e) {
                handlePieChartsItemsCount();
            });
        }
    }
})(jQuery);
jQuery(document).ready(function() {
    mCharts.init()
});