var UIBootbox = (function($) {
    var handleLowStockAlert = function() {
        var $url = $("#base-url").data('target') + 'index.php/dashboard/dashboard_low_stock_alert';
        $.getJSON($url).done(function(data){
            notification = $('#dashboard-low-stock-warning').data('text');
            notificationTitle = $('#dashboard-low-stock-warning').data('title');
            toastr.options = {
                "closeButton": true,
                  "debug": false,
                  "newestOnTop": true,
                  "progressBar": true,
                  "positionClass": "toast-bottom-right",
                  "preventDuplicates": true,
                  "onclick": null,
                  "showDuration": "300",
                  "hideDuration": "1000",
                  "timeOut": "15000",
                  "extendedTimeOut": "1000",
                  "showEasing": "swing",
                  "hideEasing": "linear",
                  "showMethod": "fadeIn",
                  "hideMethod": "fadeOut"
            }
            if (data.status == 1 && !sessionStorage.getItem('already_seen'))
            {
                toastr.error(notification, notificationTitle);
                sessionStorage.setItem('already_seen', true);
            }
        });
    },
    handleInvalidLicense = function() {
    	var $url = $("#base-url").data('target') + 'index.php/dashboard/dashboard_invalid_license_alert';
    	$.getJSON($url).done(function(data){
    		notification = $('#dashboard-invalid-license-warning').data('text');
    		notificationTitle = $('#dashboard-invalid-license-warning').data('title');
    		toastr.options = {
    			"closeButton": true,
    			  "debug": false,
    			  "newestOnTop": true,
    			  "progressBar": true,
    			  "positionClass": "toast-bottom-right",
    			  "preventDuplicates": true,
    			  "onclick": null,
    			  "showDuration": "300",
    			  "hideDuration": "1000",
    			  "timeOut": "0",
    			  "extendedTimeOut": "0",
    			  "showEasing": "swing",
    			  "hideEasing": "linear",
    			  "showMethod": "fadeIn",
    			  "hideMethod": "fadeOut"
    		}
    		if (data.status == 0 && !sessionStorage.getItem('invalid_license_already_seen'))
    		{
    			toastr.error(notification, notificationTitle);
    			sessionStorage.setItem('invalid_license_already_seen', true);
    		}
    	});
    },
    handleUnpaidCommissionWarning = function() {
    	var $url = $("#base-url").data('target') + 'index.php/dashboard/dashboard_unpaid_commission_warning';
    	$.getJSON($url).done(function(data){
    		notification = $('#dashboard-unpaid-comminssion-warning').data('text');
    		notificationTitle = $('#dashboard-unpaid-comminssion-warning').data('title');
    		toastr.options = {
    			"closeButton": true,
    			  "debug": false,
    			  "newestOnTop": true,
    			  "progressBar": true,
    			  "positionClass": "toast-bottom-right",
    			  "preventDuplicates": true,
    			  "onclick": null,
    			  "showDuration": "300",
    			  "hideDuration": "1000",
    			  "timeOut": "15000",
    			  "extendedTimeOut": "1000",
    			  "showEasing": "swing",
    			  "hideEasing": "linear",
    			  "showMethod": "fadeIn",
    			  "hideMethod": "fadeOut"
    		}
    		if (data.status == 1 && !sessionStorage.getItem('unpaid_commission_already_seen'))
    		{
    			toastr.warning(notification, notificationTitle);
    			sessionStorage.setItem('unpaid_commission_already_seen', true);
    		}
    	});
    },
    handleHasUnreadMessage = function() {
    	var $url = $("#base-url").data('target') + 'index.php/messaging/has_unread_message';
    	$.getJSON($url).done(function(data){
    		notification = $('#dashboard-unread-message-warning').data('text');
    		notificationTitle = $('#dashboard-unread-message-warning').data('title');
    		toastr.options = {
    			"closeButton": true,
    			  "debug": false,
    			  "newestOnTop": true,
    			  "progressBar": true,
    			  "positionClass": "toast-top-right",
    			  "preventDuplicates": true,
    			  "onclick": null,
    			  "showDuration": "300",
    			  "hideDuration": "1000",
    			  "timeOut": "15000",
    			  "extendedTimeOut": "1000",
    			  "showEasing": "swing",
    			  "hideEasing": "linear",
    			  "showMethod": "fadeIn",
    			  "hideMethod": "fadeOut"
    		}
    		if (data > 0)
    		{
    			toastr.success(notification, notificationTitle);
    		}
    	});
    },
    handleLinkActive = function(){
        var baseUrl = $('#base-url').data('target');
        if(window.location.href=== baseUrl)
        {
            $('#dashboard').addClass('active');
        }
        else if (window.location.href.indexOf("clients") > -1)
        {
             $('#clients').addClass('active');
        }
        else if (window.location.href.indexOf("products/update_price") > -1)
        {
             $('#updateprice').addClass('active');
        }
        else if (window.location.href.indexOf("stocks") > -1)
        {
             $('#stocks').addClass('active');
        }
        else if (window.location.href.indexOf("products") > -1)
        {
             $('#products').addClass('active');
        } 
        else if (window.location.href.indexOf("services") > -1)
        {
             $('#services').addClass('active');
        }
        else if (window.location.href.indexOf("providers") > -1)
        {
             $('#providers').addClass('active');
        }
        else if (window.location.href.indexOf("creditnote") > -1)
        {
             $('#creditnotes').addClass('active');
        }
        else if (window.location.href.indexOf("invoices") > -1)
        {
             $('#invoices').addClass('active');
        }
        else if (window.location.href.indexOf("settings/proforma_settings") > -1)
        {
             $('#proforma-settings').addClass('active');
             $('#app').addClass('active open');
             $('#app-arrow').addClass('open');
             $('#settings-arrow').addClass('open');
             $('#settings').addClass('active');
        }
        else if (window.location.href.indexOf("proforma") > -1)
        {
             $('#proforma').addClass('active');
        }
        else if (window.location.href.indexOf("quotes") > -1)
        {
             $('#quotes').addClass('active');
        }
        else if (window.location.href.indexOf("charges") > -1)
        {
             $('#charges').addClass('active');
        }
        else if (window.location.href.indexOf("incomes") > -1)
        {
             $('#incomes').addClass('active');
        }
        else if (window.location.href.indexOf("reports/view?a=income_per_user") > -1)
        {
             $('#commissions').addClass('active');
        }
        else if (window.location.href.indexOf("reports") > -1)
        {
             $('#reports').addClass('active');
        }
        else if (window.location.href.indexOf("purchases") > -1)
        {
             $('#purchaseorder').addClass('active');
        }
        else if (window.location.href.indexOf("orders") > -1)
        {
             $('#saleorders').addClass('active');
        }
        else if (window.location.href.indexOf("tracking") > -1)
        {
             $('#timetracking').addClass('active');
        }
        else if (window.location.href.indexOf("repair/settings") > -1)
        {
             $('#extensions').addClass('active');
             $('#repairsettings').addClass('active open');
             $('#repairsettingsarrow').addClass('open');
             $('#settings-arrow').addClass('open');
             $('#settings').addClass('active');
        }
        else if (window.location.href.indexOf("repair") > -1)
        {
             $('#repaircenter').addClass('active');
        }
        else if (window.location.href.indexOf("settings/import?entity=bank_statement") > -1)
        {
             $('#import-bank').addClass('active');
        }
        else if (window.location.href.indexOf("settings/general_settings") > -1)
        {
             $('#name-entity').addClass('active');
             $('#business').addClass('active open');
             $('#business-arrow').addClass('open');
             $('#settings-arrow').addClass('open');
             $('#settings').addClass('active');
        }
        else if (window.location.href.indexOf("settings/install?entity=plugin") > -1)
        {
             $('#extensions-list').addClass('active');
             $('#extensions').addClass('active open');
             $('#plugin-arrow').addClass('open');
             $('#settings-arrow').addClass('open');
             $('#settings').addClass('active');
        }
        else if (window.location.href.indexOf("settings/shipping_addresses") > -1)
        {
             $('#shipping-addresses').addClass('active');
             $('#business').addClass('active open');
             $('#business-arrow').addClass('open');
             $('#settings-arrow').addClass('open');
             $('#settings').addClass('active');
        }
        else if (window.location.href.indexOf("settings/edit_shipping_addresses") > -1)
        {
             $('#shipping-address').addClass('active');
             $('#business').addClass('active open');
             $('#business-arrow').addClass('open');
             $('#settings-arrow').addClass('open');
             $('#settings').addClass('active');
        }
        else if (window.location.href.indexOf("settings/notifications") > -1)
        {
             $('#notifications').addClass('active');
             $('#business').addClass('active open');
             $('#business-arrow').addClass('open');
             $('#settings-arrow').addClass('open');
             $('#settings').addClass('active');
        }
        else if (window.location.href.indexOf("settings/region_format") > -1)
        {
             $('#region-settings').addClass('active');
             $('#business').addClass('open');
             $('#business-arrow').addClass('open');
             $('#settings-arrow').addClass('open');
             $('#settings').addClass('active');
        }
        else if (window.location.href.indexOf("settings/invoice_settings") > -1)
        {
             $('#invoices-settings').addClass('active');
             $('#app').addClass('active open');
             $('#app-arrow').addClass('open');
             $('#settings-arrow').addClass('open');
             $('#settings').addClass('active');
        }
        else if (window.location.href.indexOf("settings/order_settings") > -1)
        {
             $('#orders-settings').addClass('active');
             $('#app').addClass('active open');
             $('#app-arrow').addClass('open');
             $('#settings-arrow').addClass('open');
             $('#settings').addClass('active');
        }
        else if (window.location.href.indexOf("settings/quote_settings") > -1)
        {
             $('#quotes-settings').addClass('active');
             $('#app').addClass('active open');
             $('#app-arrow').addClass('open');
             $('#settings-arrow').addClass('open');
             $('#settings').addClass('active');
        }
        else if (window.location.href.indexOf("settings/branding_settings") > -1)
        {
             $('#branding-settings').addClass('active');
             $('#app').addClass('active open');
             $('#app-arrow').addClass('open');
             $('#settings-arrow').addClass('open');
             $('#settings').addClass('active');
        }
        else if (window.location.href.indexOf("settings/update") > -1)
        {
             $('#update-system').addClass('active');
             $('#app').addClass('active open');
             $('#app-arrow').addClass('open');
             $('#settings-arrow').addClass('open');
             $('#settings').addClass('active');
        }
        else if (window.location.href.indexOf("settings/advanced") > -1)
        {
             $('#advanced').addClass('active');
             $('#app').addClass('active open');
             $('#app-arrow').addClass('open');
             $('#settings-arrow').addClass('open');
             $('#settings').addClass('active');
        }
        else if (window.location.href.indexOf("settings/sms_platforms_settings") > -1)
        {
             $('#smsnotification').addClass('active');
             $('#app').addClass('active open');
             $('#app-arrow').addClass('open');
             $('#settings-arrow').addClass('open');
             $('#settings').addClass('active');
        }
        else if (window.location.href.indexOf("settings/update?doUpdate=true") > -1)
        {
             $('#update-system').addClass('active');
             $('#app').addClass('active open');
             $('#app-arrow').addClass('open');
             $('#settings-arrow').addClass('open');
             $('#settings').addClass('active');
        }
        else if (window.location.href.indexOf("settings/payment_gateway_settings") > -1)
        {
             $('#pgateways').addClass('active');
             $('#app').addClass('active open');
             $('#app-arrow').addClass('open');
             $('#settings-arrow').addClass('open');
             $('#settings').addClass('active');
        }
        else if (window.location.href.indexOf("settings/payment_methods_settings") > -1)
        {
             $('#pmethods').addClass('active');
             $('#app').addClass('active open');
             $('#app-arrow').addClass('open');
             $('#settings-arrow').addClass('open');
             $('#settings').addClass('active');
        }
        else if (window.location.href.indexOf("settings/additional_taxes_settings") > -1)
        {
             $('#additional-taxes').addClass('active');
             $('#app').addClass('active open');
             $('#app-arrow').addClass('open');
             $('#settings-arrow').addClass('open');
             $('#settings').addClass('active');
        }
        else if (window.location.href.indexOf("settings/general") > -1)
        {
             $('#modules-settings').addClass('active');
             $('#app').addClass('active open');
             $('#app-arrow').addClass('open');
             $('#settings-arrow').addClass('open');
             $('#settings').addClass('active');
        }
        else if (window.location.href.indexOf("settings/maps_recaptcha_settings") > -1)
        {
             $('#maps-recaptcha').addClass('active');
             $('#app').addClass('active open');
             $('#app-arrow').addClass('open');
             $('#settings-arrow').addClass('open');
             $('#settings').addClass('active');
        }
        else if (window.location.href.indexOf("settings/users_settings") > -1)
        {
             $('#users-settings').addClass('active');
             $('#settings-arrow').addClass('open');
             $('#settings').addClass('active');
        }
        else if (window.location.href.indexOf("settings/general") > -1)
        {
             $('#general').addClass('active');
        }
    },
	handleLanguageSelection = function() {
		$('li', '#selectedLanguage').click(function(e){
	    var $this = $(this),
	      $language = $this.data('language'),
	      $selected = $this.find('img').attr('src');

	      switch($language){
	        case 'Spanish':
	          $('.langname').text('ES');
	          break;
	        case 'German':
	          $('.langname').text('DE');
	          break;
	        case 'Russian':
	          $('.langname').text('RU');
	          break;
	        case 'French':
	          $('.langname').text('FR');
	          break;
	        case 'English':
	          $('.langname').text('US');
	          break;
            case 'English-GB':
              $('.langname').text('EN-GB');
              break;
	        case 'Italian':
	          $('.langname').text('IT');
	          break;
	        default:
	          $('.langname').text('FR');
	          break;  
	      }
	      $('#langFlag').attr('src', $selected);
	      $.post($('#change-user-language').data('url'), 
	      {
	        option_value: $language
	      },
	      function(){
	        location.reload(true);
	      });
	  })
	},
	handleRedirections = function(){
        jQuery('.btn-back').click(function() {
        	var $this = $(this);
        	window.location = $this.data('location');
        });
        jQuery('.previous').click(function() {
        	var $this = $(this);
        	window.location = $this.data('target');
        });
	},
	handleDeleteNotes = function(){
		var $table = $('#notesTable'),
		    $remove = $('#remove-notes'),
		    selections = [];

		// sometimes footer render error.
		setTimeout(function () {
			$table.bootstrapTable('resetView');
		}, 200);
		$table.on('check.bs.table uncheck.bs.table ' +
		                'check-all.bs.table uncheck-all.bs.table', function () {
		            $remove.prop('disabled', !$table.bootstrapTable('getSelections').length);

		            // save your data, here just save the current page
		            selections = getIdSelections();
		            // push or splice the selections if you want to save all data selections
		        });
		$remove.click(function () {
		    var ids = getIdSelections();
		    $base_url = $('#base-url').data('target'),
		    $url = $.trim( $base_url + 'index.php/notes/delete_notes' );
		    $this = $('#remove-notes');
		    swal({
		      title: $this.data('sure'),
		      text: $this.data('message'),
		      type: "warning",
		      showCancelButton: true,
		      cancelButtonText: $('#btn-cancel').data('text'),
		      confirmButtonClass: "btn-danger",
		      confirmButtonText: $this.data('confirm'),
		      closeOnConfirm: true
		    },
		    function(){ 
		        $.getJSON({
		            url: $url,
		            data: {
		                id: ids
		            },
		            success: function (data) {
		            	if (data.success > 0)
		            	{
		            		$table.bootstrapTable('remove', {
		            		    field: 'note_id',
		            		    values: ids
		            		});
		            		App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#remove-notes').data('success')});
		            		$remove.prop('disabled', true);
		            	}
		            	if(data.fail > 0)
		            	{
		            		App.alert({container: $('#notification-alert'), type: "danger", close: true, message: $('#remove-notes').data('danger') + '&nbsp;' + data.fail});
		            		setTimeout(function () {
		            			$table.bootstrapTable('refresh', true);
		            		}, 200);
		            		$remove.prop('disabled', true);
		            	}
		            }
		        });
		    });
		});
		function getIdSelections() {
		    return $.map($table.bootstrapTable('getSelections'), function (row) {
		        return row.note_id
		    });
		}
	},
	handleLC = function(){
        var $d = $('#pc').data('d');
        var $pc = $('#pc').data('value');
        var pcMessage = $('#pc').data('message');
        var saveUrl = $('#base-url').data('target') + 'index.php/settings/save_purchase_code';
        var saveRemoteUrl = 'https://www.license.mmanager.fr/index.php/check/save_customer_data';
        if ($pc == 0 )
        {
            bootbox.prompt({
                title: pcMessage,
                inputType: 'text',
                callback: function (result) {
                    if (result)
                    {
                        $.getJSON(saveUrl, {purchase_code: result}, function(){});
                        $.getJSON(saveRemoteUrl, {purchase_code: result, domain: $d}, function(){});
                    }
                    else
                    {
                        location.reload();
                    }
                }
            });
        }
    },
    handleULC = function(){
        $("#l-settings").on('click', function(e){
            e.preventDefault();
            
            var $d = $('#pc').data('d');
            var $pc = $('#pc').data('value');
            var saveUrl = $('#base-url').data('target') + 'index.php/settings/save_purchase_code';
            var saveRemoteUrl = 'https://www.license.mmanager.fr/index.php/check/save_customer_data';
            var result = $("#purchase_code").val();

            $.getJSON(saveUrl, {purchase_code: result}, function(){location.reload();});
            $.getJSON(saveRemoteUrl, {purchase_code: result, domain: $d}, function(){location.reload();});
        });
	},
	handleClassicSelect2 = function(){
		jQuery('.select2').select2(
            {
                tags: true,
                tokenSeparators: [','],
                allowClear: true,
                placeholder: {
                    id: '-1', // the value of the option
                    text: 'Select an option'
                }
            }
        );
	},
	handleLogout = function(){
		$('#logout').on('click', function(){
			var logoutUrl = $('#base-url').data('target') + 'index.php/users/auth/logout',
				warning = $('#timer-warning');
			if (localStorage.getItem('running_timers')) {
				swal({
				  title: warning.data('title'),
				  text: warning.data('message'),
				  type: "warning",
				  showCancelButton: true,
				  confirmButtonClass: "btn-info",
				  cancelButtonClass: "btn-danger",
				  confirmButtonText: warning.data('logout'),
				  cancelButtonText: warning.data('cancel'),
				  closeOnConfirm: true,
				  closeOnCancel: true
				},
				function(isConfirm) {
				  if (isConfirm) {
				    window.location = logoutUrl;
				  }
				});
			}
			else
			{
				window.location = logoutUrl;
			}
		});
	},
    handleBackupDB = function() {
        $('#backup-now').on('click', function(){
            var $url = $('#base-url').data('target') + 'index.php/dashboard/ajax/backup_DB_now';
            var $notification = $('#cron-done-successfuly').data('text');
            $notification = "&nbsp;&nbsp;<code>"+$notification+"</code>";
            $.getJSON( $url, function(response){
                $('#backup-status').html($notification);
            });
        });
    },
    handleRunSystemCron = function() {
        $('#system-cron').on('click', function(){
            var $url = $('#base-url').data('target') + 'index.php/dashboard/ajax/run_system_cron';
            var $notification = $('#cron-done-successfuly').data('text');
            $notification = "&nbsp;&nbsp;<code>"+$notification+"</code>";
            $.getJSON( $url, function(response){
                $('#run-system-cron').html($notification);
            });
        });
    },
    handleRunNumberingCron = function() {
        $('#annual-numbering-cron').on('click', function(){
            var $url = $('#base-url').data('target') + 'index.php/dashboard/ajax/run_annual_cron';
            var $notification = $('#cron-done-successfuly').data('text');
            $notification = "&nbsp;&nbsp;<code>"+$notification+"</code>";
            $.getJSON( $url, function(response){
                $('#run-numbering-cron').html($notification);
            });
        });
    },
	handleAdditionalAddress = function() {
	    $('.billing-address').on('ifClicked', function(event){
	    	var $input = $(this);

	    	$input.on('ifChecked', function(){
	    	  $('#billing-address').removeClass('hidden');
	    	});

	    	$input.on('ifUnchecked', function(){
	    	  $('#billing-address').removeClass('hidden');
	    	  $('#billing-address').addClass('hidden');
	    	});
	    });
	    $('.shipping-address').on('ifClicked', function(event){
	    	var $input = $(this);

	    	$input.on('ifChecked', function(){
	    	  $('#shipping-address').removeClass('hidden');
	    	});

	    	$input.on('ifUnchecked', function(){
	    	  $('#shipping-address').removeClass('hidden');
	    	  $('#shipping-address').addClass('hidden');
	    	});
	    });
	};
    return {
        init: function() {
            handleLanguageSelection(), 
            handleRedirections(), 
            handleClassicSelect2(),
            handleLinkActive(),
            handleDeleteNotes(),
            handleLogout(),
            handleRunSystemCron(),
            handleRunNumberingCron(),
            handleBackupDB()
        }
    }
})(jQuery);
jQuery(document).ready(function() {
    UIBootbox.init()
    $('.money-format').each(function(){
        $(this).text(accounting.formatMoney($(this).data('value')));
    });  
});
var specialKeys = new Array();
specialKeys.push(8,46); //Backspace

function IsNumeric(e) {
    var keyCode = e.which ? e.which : e.keyCode;
    var $return = ((keyCode >= 48 && keyCode <= 57) || specialKeys.indexOf(keyCode) != -1);
    return $return;
}
function mFormatNumber(n)
{
	if (isInt(n))
	{
		return parseInt(n);
	}
	else
	{
		return n;
	}
}
function isInt(n) {
   return n % 1 === 0;
}
function formatMoney(value, row, index) {
  return accounting.formatMoney(value);
}
// Default Range set to the last 30 days
var start = moment().subtract(29, 'days');
var end = moment();

function cb(start, end) {
    $('#tax-report-range span').html(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'));
}
// Default start and end 
$('#tax-report-range').daterangepicker({
    startDate: start,
    endDate: end,
    ranges: {
        'Today': [moment(), moment().add(1, 'days')], // +1 day because query is BETWEEN start AND end
        'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
        'Last 7 Days': [moment().subtract(6, 'days'), moment()],
        'Last 30 Days': [moment().subtract(29, 'days'), moment()],
        'This Month': [moment().startOf('month'), moment().endOf('month')],
        'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
    }
}, cb);
cb(start, end);
function ajaxDone(event, position, total, percentComplete){
	if (percentComplete == 100)
	{
		$('.btn-submit').button('reset');
	}
}

jQuery.each(jQuery('textarea[data-autoresize]'), function() {
    var offset = this.offsetHeight - this.clientHeight;
 
    var resizeTextarea = function(el) {
        jQuery(el).css('height', 'auto').css('height', el.scrollHeight + offset);
    };
    jQuery(this).on('keyup input', function() { resizeTextarea(this); }).removeAttr('data-autoresize');
});
$(function(){
    $('#goback').on('click', function(){
        window.history.back();
    });
    $('#goforward').on('click', function(){
        window.history.forward();
    });
});
$('#pay-type').on('change', function(){
    var frequency = $(this).val();
    if (frequency > 1)
    {
        $('#frequency').removeClass('hidden');
        $('.invoice-date').removeClass('hidden');
    }
    else
    {
        $('#frequency').removeClass('hidden');
        $('.invoice-date').removeClass('hidden');
        $('#frequency').addClass('hidden');
    }
});
$(document).ready(function(){
    $('[data-toggle="tooltip"]').tooltip();    
});
if (0 == $('#purchase-code').data('value'))
{
    alert('invalid licence');
}
$(function(){
    localStorage.setItem('user_id', $('#user_id').data('value'));
    localStorage.setItem('agent', $('#user_id').data('firstname'));
    if (localStorage.getItem('running_timers') == 1) {
        $('.has_running_timers').removeClass('hidden');
    }
    else
    {
        $('.has_running_timers').removeClass('hidden');
        $('.has_running_timers').addClass('hidden');
    }
});

$(function(){
    $(".homepage").change(function(){
        var $selection = $(this).closest("ul").find("li .homepage-children");
        $selection.prop("checked", !$selection.prop("checked"));
    });
    $(".items-services").change(function(){
        var $selection = $(this).closest("ul").find("li .items-services-children");
        $selection.prop("checked", !$selection.prop("checked"));
    });
    $(".users").change(function(){
        var $selection = $(this).closest("ul").find("li .users-children");
        $selection.prop("checked", !$selection.prop("checked"));
    });
    $(".customers").change(function(){
        var $selection = $(this).closest("ul").find("li .customers-children");
        $selection.prop("checked", !$selection.prop("checked"));
    });
    $(".providers").change(function(){
        var $selection = $(this).closest("ul").find("li .providers-children");
        $selection.prop("checked", !$selection.prop("checked"));
    });
    $(".invoices-quotes").change(function(){
        var $selection = $(this).closest("ul").find("li .invoices-quotes-children");
        $selection.prop("checked", !$selection.prop("checked"));
    });
    $(".purchases").change(function(){
        var $selection = $(this).closest("ul").find("li .purchases-children");
        $selection.prop("checked", !$selection.prop("checked"));
    });
    $(".incomes-charges").change(function(){
        var $selection = $(this).closest("ul").find("li .incomes-charges-children");
        $selection.prop("checked", !$selection.prop("checked"));
    });
    $(".reports").change(function(){
        var $selection = $(this).closest("ul").find("li .reports-children");
        $selection.prop("checked", !$selection.prop("checked"));
    });
    $(".settings").change(function(){
        var $selection = $(this).closest("ul").find("li .settings-children");
        $selection.prop("checked", !$selection.prop("checked"));
    });
});
$(function(){
    $("#account-settings").on('click', function(){
        $("#account-overview").removeClass("active");
        $("#account-settings").addClass("active");
        $(".tab-pane").removeClass("active");
        $("#tab_1_1").addClass("active");
        $("#div-overview").addClass("hidden");
        $("#div-settings").removeClass("hidden");
    });
    $("#account-overview").on('click', function(){
        $("#account-overview").addClass("active");
        $("#account-settings").removeClass("active");
        $("#div-overview").removeClass("hidden");
        $("#div-settings").addClass("hidden");
    });
});
$(function(){
    $("#commission-value").attr("placeholder", "commission type");
    $(".commission-type").each(function(){
        var $this = $(this);
        if ($this.val() == "fixed" && $this.attr("checked")) {
            $(".input-group-addon").text($("#money-format").data('symbol'));
        }
        if ($this.val() == "rate" && $this.attr("checked")) {
            $(".input-group-addon").text("%");
        }
    });
    $(".commission-type").on('click', function(){
        var $this = $(this);
        if ($this.val() == "fixed") {
            $("#commission-value").attr("placeholder", "Fixed amount");
            $(".input-group-addon").text($("#money-format").data('symbol'));
        } else if($this.val() == "rate") {
            $("#commission-value").attr("placeholder", "%");
            $(".input-group-addon").text("%");
        } else {
            $("#commission-value").attr("placeholder", "commission type");
        }
    });
});
$(function(){
    $("#user-currency").on("change", function(){
        var $currency = $(this).val();
        var $multicurrency = $("#multicurrency");
        var $multicurrencyTitle = $multicurrency.data('title');
        var $multicurrencyNotSupported = $multicurrency.data('notsupported');

        url = $('#base-url').data('target') + 'index.php/settings/ajax/change_rate_support';
        $.getJSON( url, {currency:$currency}, function(data){
            if (data.not_supported) {
                $url = $('#base-url').data('target') + 'index.php/settings/ajax/disable_multicurrency';
                swal({
                  title: $multicurrencyTitle,
                  text: $multicurrencyNotSupported,
                  type: "warning",
                  confirmButtonClass: "btn-danger",
                  confirmButtonText: "ok",
                  closeOnConfirm: true
                },
                function(){ 
                    $.getJSON( $url, function(data){

                    });
                });
            }
        });
    });
});