var Modals = (function($) {

    var handleAddClientModal = function() {
            var options = {
                dataType: 'json',
                success: addClientServerResponse
            };
            $("#client-add-modal").submit(function() {
                $(".btn-submit").attr("disabled", "disabled");
                $(this).ajaxSubmit(options);
                return false;
            });
        },
        handleAddPaymentMethodModal = function() {
            var options = {
                dataType: 'json',
                success: addPaymentMethodServerResponse
            };
            $("#add-payment-method-form").submit(function() {
                $(".btn-submit").attr("disabled", "disabled");
                $(this).ajaxSubmit(options);
                return false;
            });
        },
        handleAddTicketIssueTypeModal = function() {
            var options = {
                dataType: 'json',
                success: addTicketIssueTypeServerResponse
            };
            $("#add-issue-type-form").submit(function() {
                $(".btn-submit").attr("disabled", "disabled");
                $(this).ajaxSubmit(options);
                return false;
            });
        },
        handleAddTicketCannedResponseTypeModal = function() {
            $("#add-canned-category").on('click', function(e) {
                e.preventDefault();
                $("#add-canned-category").attr("disabled", "disabled");
                var $base_url = $('#base-url').data('target'),
                    $url = $.trim($base_url + 'index.php/repair/ajax/add_response_category');
                $.getJSON($url, {name: $('#category-name').val()}, function(data) {
                    if (data.status == 1) {
                        var $url2 = $.trim($base_url + 'index.php/repair/get_ticket_canned_responses_categories');
                        $.getJSON($url2, function(response) {
                            $("#canned-responses-categories").select2({
                                data: response
                            })
                            $("#canned-responses-categories").val(data.last).trigger('change');
                        });
                        $(".modal-add-category").removeClass("hidden");
                        $(".modal-add-category").addClass("hidden");
                        $(".message").removeClass("hidden");
                    }
                });
            });
        },
        handleAddNotificationCannedMessagesCategoryModal = function() {
            $("#add-notifications-canned-category").on('click', function(e) {
                e.preventDefault();
                $("#add-notifications-canned-category").attr("disabled", "disabled");
                var $base_url = $('#base-url').data('target'),
                    $url = $.trim($base_url + 'index.php/settings/ajax/add_notification_messages_category');
                $.getJSON($url, {name: $('#category-name').val()}, function(data) {
                    if (data.status == 1) {
                        var $url2 = $.trim($base_url + 'index.php/settings/get_notification_canned_messages_categories');
                        $.getJSON($url2, function(response) {
                            $("#notification-canned-messages-categories").select2({
                                data: response
                            })
                            $("#notification-canned-messages-categories").val(data.last).trigger('change');
                        });
                        $(".modal-add-category").removeClass("hidden");
                        $(".modal-add-category").addClass("hidden");
                        $(".message").removeClass("hidden");
                    }
                });
            });
        },
        handleAddCannedNotificationsModal = function() {
            $("#add-notif-canned-message").on('click', function(e) {
                e.preventDefault();
                $("#add-notif-canned-message").attr("disabled", "disabled");
                var $base_url = $('#base-url').data('target'),
                    $url = $.trim($base_url + 'index.php/settings/ajax/add_notifications_canned_message');
                $.getJSON($url, {title: $('#title').val(), message: $('#message').val()}, function(data) {
                    if (data.status == 1) {
                        $("#add-notifications-canned-message-modal").modal('hide');
                        $('#add-notifications-canned-message-modal').on('hidden.bs.modal', function() {
                            $('#add-notifications-canned-message-form').find('form').trigger('reset');
                            $table = $('#notifications-messages');
                            setTimeout(function () {
                                $table.bootstrapTable('refresh', true);
                            }, 200);
                        });
                    }
                });
            });
        },
        handleAddCannedResponsesdModal = function() {
            $("#add-canned-response").on('click', function(e) {
                e.preventDefault();
                $("#add-canned-response").attr("disabled", "disabled");
                var $base_url = $('#base-url').data('target'),
                    $url = $.trim($base_url + 'index.php/repair/ajax/add_ticket_canned_response');
                $.getJSON($url, {category_id: $('#canned-responses-categories').val(), ticket_canned_response_title: $('#ticket-canned-response-title').val(), ticket_canned_response_body: $('#ticket-canned-response-body').val()}, function(data) {
                    if (data.status == 1) {
                        $("#add-ticket-canned-response-modal").modal('hide');
                        $('#add-ticket-canned-response-modal').on('hidden.bs.modal', function() {
                            $('#add-ticket-canned-response-form').find('form').trigger('reset');
                            var $url2 = $.trim($base_url + 'index.php/repair/get_ticket_canned_responses');
                            $.getJSON($url2, function(response) {
                                $(".canned-responses").select2({
                                    data: response
                                })
                            });
                        });
                    }
                });
            });
        },
        handleAddCompanyShippingAddressModal = function() {
            var options = {
                dataType: 'json',
                success: addCompanyShippingAddressModalServerResponse
            };
            $("#companyshippingaddress-add-modal").submit(function() {
                $(".btn-submit").attr("disabled", "disabled");
                $(this).ajaxSubmit(options);
                return false;
            });
        },
        handleAddAdditionalTaxesModal = function() {
            var options = {
                dataType: 'json',
                success: addAdditionalTaxesServerResponse
            };
            $("#add-additional-taxes-form").submit(function() {
                $(".btn-submit").attr("disabled", "disabled");
                $(this).ajaxSubmit(options);
                return false;
            });
        },
        handleChargeAmountWithTax = function() {
            $('#tax_rate, #charges_value_without_tax, #charges_fixed_value').on('change keyup mouseup blur', function() {
                var $tax_rate = parseFloat($("#tax_rate option:selected").text());
                var $amount = parseFloat($('input[name="charges_value_without_tax"]').val());
                var $fixedAmount = parseFloat($('input[name="charges_fixed_value"]').val());
                if (isNaN($fixedAmount))
                {
                    $fixedAmount = 0;
                }
                if (isNaN($tax_rate) || $tax_rate == 0) {
                    $("#charges_value").val(parseFloat($amount + $fixedAmount));
                    if (isNaN($("#charges_value").val())) {
                        $("#charges_value").val("");
                    }
                } else {
                    $('input[name="charges_fixed_value"]').val("");
                    $charges_tax_amount = (($amount * $tax_rate) / 100);
                    $charges_value = $amount + $charges_tax_amount;
                    $("#charges_value").val(parseFloat($charges_value));
                    $("#charges_tax_amount").val(parseFloat($charges_tax_amount));
                }
            });
        },
        handleIncomeAmountWithFees = function() {
            $('#incomes_tax_rate, #incomes_value_without_tax, #incomes_charges_value').on('change keyup mouseup blur', function() {
                var $tax_rate = parseFloat($("#incomes_tax_rate option:selected").text());
                var $amount = parseFloat($('input[name="incomes_value_without_tax"]').val());
                var $fixedAmount = parseFloat($('input[name="incomes_charges_value"]').val());
                if (isNaN($fixedAmount))
                {
                    $fixedAmount = 0;
                }
                if (isNaN($tax_rate) || $tax_rate == 0) {
                    $("#incomes_value").val(parseFloat($amount - $fixedAmount));
                    $("#incomes_charges_value").val(parseFloat($fixedAmount));
                    if (isNaN($("#incomes_value").val())) {
                        $("#incomes_value").val("");
                    }
                }
                else 
                {
                    $('input[name="incomes_charges_value"]').val("");
                    $charges_value = (($amount * $tax_rate) / 100);
                    $incomes_value = $amount - $charges_value;
                    $("#incomes_value").val(parseFloat($incomes_value));
                    $("#incomes_charges_value").val(parseFloat($charges_value));
                }
            });
        },
        handleHideShowChargesFields = function() {
            $('#apply-tax').change(function() {
                var $input = $(this);
                if ($input.prop("checked")) {
                    $('#apply-tax-div').removeClass('hidden');
                } else {
                    $('input[name="charges_value_without_tax"]').val('');
                    $(".select2").val('-1').trigger('change');
                    $('#apply-tax-div').removeClass('hidden');
                    $('#apply-tax-div').addClass('hidden');
                }
            });
            $('#add-attachment').change(function() {
                var $input = $(this);
                if ($input.prop("checked")) {
                    $('#add-attachment-div').removeClass('hidden');
                } else {
                    $('#add-attachment-div').removeClass('hidden');
                    $('#add-attachment-div').addClass('hidden');
                }
            });
            $('#add-notes').change(function() {
                var $input = $(this);
                if ($input.prop("checked")) {
                    $('#add-notes-div').removeClass('hidden');
                } else {
                    $('#add-notes-div').removeClass('hidden');
                    $('#add-notes-div').addClass('hidden');
                }
            });
            $('#add-charges-modal').on('hidden.bs.modal', function() {
                $('input:checkbox').removeAttr('checked');
                $('#add-attachment-div').addClass('hidden');
                $('#add-notes-div').addClass('hidden');
                $('#apply-tax-div').addClass('hidden');
            });
        },
        handleAddProviderModal = function() {
            var options = {
                dataType: 'json',
                success: addProviderServerResponse
            };
            $("#provider-add-modal").submit(function() {
                $(".btn-submit").attr("disabled", "disabled");
                $(this).ajaxSubmit(options);
                return false;
            });
        },
        initSelect = function() {
            var $base_url = $('#base-url').data('target'),
                $url = $.trim($base_url + 'index.php/charges/get_groups');
            $urlIncomes = $.trim($base_url + 'index.php/incomes/get_groups');
            $urlProviders = $.trim($base_url + 'index.php/providers/get_active_providers');
            if ($("#charges-categories").length !== 0) {
                $.getJSON($url, function(response) {
                    var stringified = JSON.stringify(response);
                    stringified = stringified.replace(/group_id/g, 'id');
                    stringified = stringified.replace(/group_name/g, 'text');
                    var data = JSON.parse(stringified);
                    $("#charges-categories").select2({
                        data: data
                    })
                });
            }
            if ($("#incomes-categories").length !== 0) {
                $.getJSON($urlIncomes, function(response) {
                    var stringified = JSON.stringify(response);
                    stringified = stringified.replace(/group_id/g, 'id');
                    stringified = stringified.replace(/group_name/g, 'text');
                    var data = JSON.parse(stringified);
                    $("#incomes-categories").select2({
                        data: data
                    })
                });
            }
            if ($("#select-provider").length !== 0) {
                // Providers
                $.getJSON($urlProviders, function(response) {
                    var stringified = JSON.stringify(response);
                    stringified = stringified.replace(/provider_id/g, 'id');
                    stringified = stringified.replace(/name_company/g, 'text');
                    var data = JSON.parse(stringified);
                    $("#select-provider").select2({
                        data: data
                    })
                });
            }
        },
        handleAddChargeGroupModal = function() {
            var options = {
                dataType: 'json',
                success: addChargeGroupServerResponse
            };
            $("#add-chargesgroup").submit(function() {
                $(".btn-submit").attr("disabled", "disabled");
                $(this).ajaxSubmit(options);
                return false;
            });
        },
        handleAddIncomeGroupModal = function() {
            var options = {
                dataType: 'json',
                success: addIncomeGroupServerResponse
            };
            $("#add-incomesgroup").submit(function() {
                $(".btn-submit").attr("disabled", "disabled");
                $(this).ajaxSubmit(options);
                return false;
            });
        },
        addClientServerResponse = function(responseText, statusText, xhr, $form) {
            if (responseText.status == 1) {
                $(".btn-submit").removeAttr("disabled");
                $(".btn-submit").text($('#btn-save').data('text'));
                $("#add-client-modal").modal('hide');
                $('#add-client-modal').on('hidden.bs.modal', function() {
                    $(this).find('form').trigger('reset');

                    var $base_url = $('#base-url').data('target'),
                        $url = $.trim($base_url + 'index.php/clients/get_clients');

                    $.getJSON($url, function(response) {
                        var stringified = JSON.stringify(response);
                        stringified = stringified.replace(/client_id/g, 'id');
                        stringified = stringified.replace(/name_company/g, 'text');
                        var data = JSON.parse(stringified);
                        $(".invoice_to").select2({
                            data: data
                        })
                    });
                });
            } else {
                $("#client-modal-validation-errors").html(responseText.error);
                $(".btn-submit").removeAttr("disabled");
                $(".btn-submit").text($('#btn-save').data('text'));
            }
        },
        addPaymentMethodServerResponse = function(responseText, statusText, xhr, $form) {
            if (responseText.status == 1) {
                $(".btn-submit").removeAttr("disabled");
                $(".btn-submit").text($('#btn-save').data('text'));
                $("#add-payment-method-modal").modal('hide');
                $('#add-payment-method-modal').on('hidden.bs.modal', function() {
                    $(this).find('form').trigger('reset');

                    var $base_url = $('#base-url').data('target'),
                        $url = $.trim($base_url + 'index.php/settings/get_payment_methods');

                    $.getJSON($url, function(response) {
                        var stringified = JSON.stringify(response);
                        stringified = stringified.replace(/payment_method_id/g, 'id');
                        stringified = stringified.replace(/payment_method_name/g, 'text');
                        var data = JSON.parse(stringified);
                        $("#payment-method").select2({
                            data: data
                        })
                    });
                    location.reload();
                });
            } else {
                $("#payment-method-modal-validation-errors").html(responseText.error);
                $(".btn-submit").removeAttr("disabled");
                $(".btn-submit").text($('#btn-save').data('text'));
            }
        },
        addTicketIssueTypeServerResponse = function(responseText, statusText, xhr, $form) {
            if (responseText.status == 1) {
                $(".btn-submit").removeAttr("disabled");
                $(".btn-submit").text($('#btn-save').data('text'));
                $("#add-issue-type-modal").modal('hide');
                $('#add-issue-type-modal').on('hidden.bs.modal', function() {
                    $(this).find('form').trigger('reset');

                    var $base_url = $('#base-url').data('target'),
                        $url = $.trim($base_url + 'index.php/repair/get_ticket_issue_types');

                    $.getJSON($url, function(response) {
                        var stringified = JSON.stringify(response);
                        stringified = stringified.replace(/id/g, 'id');
                        stringified = stringified.replace(/name/g, 'text');
                        var data = JSON.parse(stringified);
                        $("#ticket-issue-type").select2({
                            data: data
                        })
                    });
                });
            } else {
                $("#issue-type-modal-validation-errors").html(responseText.error);
                $(".btn-submit").removeAttr("disabled");
                $(".btn-submit").text($('#btn-save').data('text'));
            }
        },
        addCompanyShippingAddressModalServerResponse = function(responseText, statusText, xhr, $form) {
            if (responseText.notify == 1) {
                App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#default-update-success').data('message')});
                $(".btn-submit").removeAttr("disabled");
                $(".btn-submit").text($('#btn-save').data('text'));
            }
            if (responseText.status == 1) {
                if (window.location.href.indexOf("settings/shipping_addresses") > -1) {
                    location.reload();
                }
                $(".btn-submit").removeAttr("disabled");
                $(".btn-submit").text($('#btn-save').data('text'));
                $("#add-companyshippingaddress-modal").modal('hide');
                $('#add-companyshippingaddress-modal').on('hidden.bs.modal', function() {
                    $(this).find('form').trigger('reset');
                    var $base_url = $('#base-url').data('target'),
                        $url = $.trim($base_url + 'index.php/purchases/get_shipping_addresses');

                    $.getJSON($url, function(response) {
                        var stringified = JSON.stringify(response);
                        stringified = stringified.replace(/id/g, 'id');
                        stringified = stringified.replace(/name_company/g, 'text');
                        var data = JSON.parse(stringified);
                        $(".companyshippingaddress").select2({
                            data: data
                        })
                    });
                });
            } else {
                $("#companyshippingaddress-modal-validation-errors").html(responseText.error);
                $(".btn-submit").removeAttr("disabled");
                $(".btn-submit").text($('#btn-save').data('text'));
            }
        },
        addAdditionalTaxesServerResponse = function(responseText, statusText, xhr, $form) {
            if (responseText.status == 1) {
                $(".btn-submit").removeAttr("disabled");
                $(".btn-submit").text($('#btn-save').data('text'));
                $("#add-additional-taxes-modal").modal('hide');
                $('#add-additional-taxes-modal').on('hidden.bs.modal', function() {
                    $(this).find('form').trigger('reset');

                    var $base_url = $('#base-url').data('target'),
                        $url = $.trim($base_url + 'index.php/settings/get_additional_taxes');

                    $.getJSON($url, function(response) {
                        var stringified = JSON.stringify(response);
                        stringified = stringified.replace(/additional_tax_name/g, 'text');
                        var data = JSON.parse(stringified);
                        $("#additional-tax").select2({
                            data: data
                        })
                    });
                    location.reload();
                });
            } else {
                $("#additional-taxes-modal-validation-errors").html(responseText.error);
                $(".btn-submit").removeAttr("disabled");
                $(".btn-submit").text($('#btn-save').data('text'));
            }
        },
        addProviderServerResponse = function(responseText, statusText, xhr, $form) {
            if (responseText.status == 1) {
                $(".btn-submit").removeAttr("disabled");
                $(".btn-submit").text($('#btn-save').data('text'));
                $("#add-provider-modal").modal('hide');
                $('#add-provider-modal').on('hidden.bs.modal', function() {
                    $(this).find('form').trigger('reset');

                    var $base_url = $('#base-url').data('target'),
                        $url = $.trim($base_url + 'index.php/providers/get_active_providers');

                    $.getJSON($url, function(response) {
                        var stringified = JSON.stringify(response);
                        stringified = stringified.replace(/provider_id/g, 'id');
                        stringified = stringified.replace(/name_company/g, 'text');
                        var data = JSON.parse(stringified);
                        $("#provider_name").select2({
                            data: data
                        });
                        $("#select-provider").select2({
                            data: data
                        });
                    });
                    // Make provider available in dropdown on submit
                    $.getJSON($url, function(response) {
                        var stringified = JSON.stringify(response);
                        stringified = stringified.replace(/provider_id/g, 'id');
                        stringified = stringified.replace(/name_company/g, 'text');
                        var data = JSON.parse(stringified);
                        $("#provider_id").select2({
                            data: data
                        })
                    });
                });
            } else {
                $("#provider-modal-validation-errors").html(responseText.error);
                $(".btn-submit").removeAttr("disabled");
                $(".btn-submit").text($('#btn-save').data('text'));
            }
        },
        addChargeGroupServerResponse = function(responseText, statusText, xhr, $form) {
            if (responseText.status == 1) {
                $(".btn-submit").removeAttr("disabled");
                $(".btn-submit").text($('#btn-save').data('text'));
                $("#add-chargesgroup-modal").modal('hide');
                $('#add-chargesgroup-modal').on('hidden.bs.modal', function() {
                    $(this).find('form').trigger('reset');

                    var $base_url = $('#base-url').data('target'),
                        $url = $.trim($base_url + 'index.php/charges/get_groups');
                    $.getJSON($url, function(response) {
                        var stringified = JSON.stringify(response);
                        stringified = stringified.replace(/group_id/g, 'id');
                        stringified = stringified.replace(/group_name/g, 'text');
                        var data = JSON.parse(stringified);
                        $("#charges-categories").select2({
                            data: data
                        })
                    });
                });
            } else {
                $("#charges-group-modal-validation-errors").html(responseText.error);
                $(".btn-submit").removeAttr("disabled");
                $(".btn-submit").text($('#btn-save').data('text'));
            }
        },
        addIncomeGroupServerResponse = function(responseText, statusText, xhr, $form) {
            if (responseText.status == 1) {
                $(".btn-submit").removeAttr("disabled");
                $(".btn-submit").text($('#btn-save').data('text'));
                $("#add-incomesgroup-modal").modal('hide');
                $('#add-incomesgroup-modal').on('hidden.bs.modal', function() {
                    $(this).find('form').trigger('reset');

                    var $base_url = $('#base-url').data('target'),
                        $url = $.trim($base_url + 'index.php/incomes/get_groups');
                    $.getJSON($url, function(response) {
                        var stringified = JSON.stringify(response);
                        stringified = stringified.replace(/group_id/g, 'id');
                        stringified = stringified.replace(/group_name/g, 'text');
                        var data = JSON.parse(stringified);
                        $("#incomes-categories").select2({
                            data: data
                        })
                    });
                });
            } else {
                $("#incomes-group-modal-validation-errors").html(responseText.error);
                $(".btn-submit").removeAttr("disabled");
                $(".btn-submit").text($('#btn-save').data('text'));
            }
        },
        handleQRCodeBarCode = function() {
            $('#show-qr-bar-code-modal').on('show.bs.modal', function(e) {
                var qrCodeTarget = $(e.relatedTarget).data('qrcode');
                var barCodeTarget = $(e.relatedTarget).data('barcode');
                var itemName = $(e.relatedTarget).data('itemname');
                var itemSku = $(e.relatedTarget).data('itemsku');
                var itemPrice = $(e.relatedTarget).data('itemprice');
                $(e.currentTarget).find('img[id="qrcode"]').attr("src", qrCodeTarget);
                $(e.currentTarget).find('img[id="barcode"]').attr("src", barCodeTarget);
                $(e.currentTarget).find('span[id="itemname"]').text(itemName);
                $(e.currentTarget).find('span[id="itemsku"]').text(itemSku);
                $(e.currentTarget).find('span[id="itemprice"]').text(itemPrice);
            });
        };
    return {
        init: function() {
            handleAddClientModal(),
            handleAddProviderModal(),
            handleAddChargeGroupModal(),
            handleAddIncomeGroupModal(),
            initSelect(),
            handleAddPaymentMethodModal(),
            handleChargeAmountWithTax(),
            handleIncomeAmountWithFees(),
            handleHideShowChargesFields(),
            handleQRCodeBarCode(),
            handleAddAdditionalTaxesModal(),
            handleAddCompanyShippingAddressModal(),
            handleAddTicketIssueTypeModal(),
            handleAddTicketCannedResponseTypeModal(),
            handleAddCannedResponsesdModal(),
            handleAddNotificationCannedMessagesCategoryModal(),
            handleAddCannedNotificationsModal()
        }
    }
})(jQuery);
jQuery(document).ready(function() {
    Modals.init()
});