var Reports = (function($) {
    var handleBarCharts = function() {
        // Init the bar chart
        var barChart = echarts.init(document.getElementById("echarts_report")),
            // Set Options
            options = {
                title: {},
                color: ["#001a33", "#990000"],
                tooltip: {
                    trigger: 'axis',
                    axisPointer: {
                        type: 'shadow'
                    }
                },
                legend: {
                    orient: "horizontal",
                    x: "center",
                    y: "bottom",
                    padding: 0,
                    data: [$('#label-tax-value').data('label'), $('#label-subtotal').data('label')]
                },
                grid: {
                    left: '3%',
                    right: '9%',
                    bottom: '5%',
                    containLabel: true
                },
                xAxis: {
                    type: 'category',
                    data: []
                },
                yAxis: {
                    type: 'value'
                },
                series: [{
                        name: $('#label-subtotal').data('label'),
                        type: "bar",
                        stack: 'Total',
                        label: {
                            normal: {
                                show: false,
                                position: 'insideRight'
                            }
                        },
                        data: []
                    },
                    {
                        name: $('#label-tax-value').data('label'),
                        type: "bar",
                        stack: 'Total',
                        label: {
                            normal: {
                                show: false,
                                position: 'insideRight'
                            }
                        },
                        data: []
                    }
                ]
            };
            // Default Range set to the last 30 days
            var start = moment().subtract(2, 'months');
            var end = moment();

            function cb(start, end) {
                $('#report-range span').html(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'));
            }

            $('#report-range').daterangepicker({
                startDate: start,
                endDate: end,
                ranges: {
                    'Today': [moment(), moment()],
                    'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                    'Last 7 Days': [moment().subtract(6, 'days'), moment()],
                    'Last 30 Days': [moment().subtract(29, 'days'), moment()],
                    'This Month': [moment().startOf('month'), moment().endOf('month')],
                    'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
                }
            }, cb);

            cb(start, end);

            url = $("#base-url").data("target") + "index.php/reports/monthly_orders_report";
            barChart.showLoading();
            $.getJSON(url, {
                start: start.format('YYYY-MM-DD'),
                end: end.format('YYYY-MM-DD')
            }).done(function(a) {
                $subTotal = [], $months = [], $tax_value = [];
                for (var n = 0; n < a.length; n++) $subTotal.push(a[n].item_subtotal), $months.push(a[n].month + "/" + a[n].year), $tax_value.push(a[n].tax_value);
                var subTotal = 0,
                    tax_value = 0;
                $.each($subTotal, function() {
                    subTotal += this;
                });
                $.each($tax_value, function() {
                    tax_value += this;
                });
                barChart.hideLoading(), barChart.setOption({
                    series: [{
                            name: $('#label-tax-value').data('label'),
                            type: "bar",
                            stack: 'Total',
                            label: {
                                normal: {
                                    show: false,
                                    position: 'insideRight'
                                }
                            },
                            data: $tax_value
                        },
                        {
                            name: $('#label-subtotal').data('label'),
                            type: "bar",
                            stack: 'Total',
                            label: {
                                normal: {
                                    show: false,
                                    position: 'insideRight'
                                }
                            },
                            data: $subTotal
                        }
                    ],
                    xAxis: {
                        data: $months
                    }
                })
            });

            // Dynamic range
            $('#report-range').on('apply.daterangepicker', function(ev, picker) {
                url = $("#base-url").data("target") + "index.php/reports/monthly_orders_report";
                barChart.showLoading();
                $.getJSON(url, {
                    start: picker.startDate.format('YYYY-MM-DD'),
                    end: picker.endDate.format('YYYY-MM-DD')
                }).done(function(a) {
                    $subTotal = [], $months = [], $tax_value = [];
                    for (var n = 0; n < a.length; n++) $subTotal.push(a[n].item_subtotal), $months.push(a[n].month + "/" + a[n].year), $tax_value.push(a[n].tax_value);
                    var subTotal = 0,
                        tax_value = 0;
                    $.each($subTotal, function() {
                        subTotal += this;
                    });
                    $.each($tax_value, function() {
                        tax_value += this;
                    });
                    barChart.hideLoading(), barChart.setOption({
                        series: [{
                                name: $('#label-tax-value').data('label'),
                                type: "bar",
                                stack: 'Total',
                                label: {
                                    normal: {
                                        show: false,
                                        position: 'insideRight'
                                    }
                                },
                                data: $tax_value
                            },
                            {
                                name: $('#label-subtotal').data('label'),
                                type: "bar",
                                stack: 'Total',
                                label: {
                                    normal: {
                                        show: false,
                                        position: 'insideRight'
                                    }
                                },
                                data: $subTotal
                            }
                        ],
                        xAxis: {
                            data: $months
                        }
                    })
                });
            });
            jQuery(window).on("resize", function() {
                null != barChart && void 0 != barChart && barChart.resize()
            });
            barChart.setOption(options);
        },
        handleReportTable = function() {
            var start = moment().subtract(2, 'months');
            var end = moment();
            var defaultUrl = $('#base-url').data('target') + 'index.php/reports/monthly_orders_report?start=' + start.format('YYYY-MM-DD') + '&end=' + end.format('YYYY-MM-DD');
            
            var chartTotalUrl = $('#base-url').data('target') + 'index.php/reports/get_tax_total';
            $.getJSON(chartTotalUrl, {start: start.format('YYYY-MM-DD'), end: end.format('YYYY-MM-DD')}, function(result){
                $('#invoice-total').text(accounting.formatMoney(result.invoice_total));
                $('#tax-total').text(accounting.formatMoney(result.tax_total));
                $('#total-with-tax').text(accounting.formatMoney(result.total_with_tax));
            });

            $('#report-range-text').text('* From ' + start.format('YYYY-MM-DD') + ' to ' + end.format('YYYY-MM-DD') );
            $('#reportTable').bootstrapTable('refresh', {
                url: defaultUrl
            });
            $('#report-range').on('apply.daterangepicker', function(ev, picker) {
              start = picker.startDate.format('YYYY-MM-DD');
              end = picker.endDate.format('YYYY-MM-DD');

              var chartTotalUrl = $('#base-url').data('target') + 'index.php/reports/get_tax_total';
              $.getJSON(chartTotalUrl, {start: start, end: end}, function(result){
                  $('#invoice-total').text(accounting.formatMoney(result.invoice_total));
                  $('#tax-total').text(accounting.formatMoney(result.tax_total));
                  $('#total-with-tax').text(accounting.formatMoney(result.total_with_tax));
              });

              newUrl = $('#base-url').data('target') + 'index.php/reports/monthly_orders_report?start=' + start + '&end=' + end;
               $('#report-range-text').text("");
               $('#report-range-text').text('* From ' + start + ' to ' + end );
              $('#reportTable').bootstrapTable('refresh', {
                  url: newUrl
              });
            });
        };
    return {
        init: function() {
            handleBarCharts(),
            handleReportTable()
        }
    }
})(jQuery);
jQuery(document).ready(function() {
    Reports.init()
});