var Settings = (function($){
	var handleOrderSettings = function(){
		var options = {
			dataType:  'json',
			success: settingsServerResponse
		};
		$('#order_settings_layout').submit(function(e){
			e.preventDefault();
			$(".btn-submit").attr("disabled","disabled");
			$(this).ajaxSubmit(options);
			return false; 
		});
	},
	settingsServerResponse = function(responseText, statusText, xhr, $form){
		if(responseText.status == 1)
		{
			App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#default-update-success').data('message')});
			$(".btn-submit").removeAttr("disabled");
			$(".btn-submit").text($('#btn-save').data('text'));
		}
		else
		{
			message = responseText.error;
			message = message.replace(/<\/?p[^>]*>/g, "");
			if( message != '')
			{
				App.alert({container: $('#notification-alert'), type: "danger", close: true, message: message});
				$(".btn-submit").removeAttr("disabled");
				$(".btn-submit").text($('#btn-save').data('text'));
			}
			else
			{
				App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#default-update-success').data('message')});
				location.reload();
			}
			$(".btn-submit").removeAttr("disabled");
			$(".btn-submit").text($('#btn-save').data('text'));
		}
	},
    handleOrderTemplates = function () {
        $locale = $('#user-language').data('language');
        switch($locale) {
            case "french":
                $locale = 'fr-FR';
                break;
            case "german":
                $locale = 'de-DE';
                break;
            case "russian":
                $locale = 'ru-RU';
                break;
            case "romanian":
                $locale = 'ro';
                break;
            case "spanish":
                $locale = 'es-ES';
                break;
            case "english":
                $locale = 'en-US';
                break;
            case "dutch":
                $locale = 'nl-NL';
                break;
            case "greek":
                $locale = 'el-EL';
                break;
            case "arabic":
                $locale = 'ar-AR';
                break;
            default:
                $locale = "en-US";
                break;
        }
        $('#tpl_order_placed').summernote({
            height: 300,
            lang: $locale
        });
        $('#tpl_order_shipped').summernote({
            height: 300,
            lang: $locale
        });
        $('#tpl_order_terms').summernote({
            height: 300,
            lang: $locale
        });
        $('#tpl_footer').summernote({
            height: 300,
            lang: $locale
        });
        //API:
        url = $('#base-url').data('target') + 'index.php/settings/ajax/get_order_placed_tpl';
        url2 = $('#base-url').data('target') + 'index.php/settings/ajax/get_order_shipped_tpl';
        url3 = $('#base-url').data('target') + 'index.php/settings/ajax/get_order_terms_tpl';
        url4 = $('#base-url').data('target') + 'index.php/settings/ajax/get_order_footer_tpl';

        $.getJSON(url, function(data){
            $('#tpl_order_placed').summernote('code', data);
        });
        $.getJSON(url2, function(data){
            $('#tpl_order_shipped').summernote('code', data);
        });
        $.getJSON(url3, function(data){
            $('#tpl_order_terms').summernote('code', data);
        });
        $.getJSON(url4, function(data){
            $('#tpl_footer').summernote('code', data);
            if (data) {
                $('#save-order-templates').removeAttr("disabled");
            }
        });
    },
    handleOrderTemplatesChanges = function(){
        $('#save-order-templates').on('click', function(){
           url = $('#base-url').data('target') + 'index.php/settings/ajax/set_order_templates';
           $.post( url, { csrf_mmanager: $('#csrf_mmanager').data('value'), tpl_order_placed: $('#tpl_order_placed').summernote('code'), tpl_order_shipped: $('#tpl_order_shipped').summernote('code'), tpl_order_terms: $('#tpl_order_terms').summernote('code'), tpl_footer: $('#tpl_footer').summernote('code') }, function(data){
            App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#default-update-success').data('message')});
            $(".btn-submit").removeAttr("disabled");
           });
        });
    };
	return {
		init: function(){
			handleOrderSettings(),
			handleOrderTemplates(),
			handleOrderTemplatesChanges()
		}
	}
})(jQuery);
jQuery(document).ready(function(){
	Settings.init()
});