var Payments = (function($) {

    var handlePaymentGateways = function() {
            $('#add-payment-modal').on('show.bs.modal', function(e) {

                // Mollie var
                var mollieTarget = $(e.relatedTarget).data('mollietarget'),
                // Ingenico vars
                ingenicoAcceptUrl = $(e.relatedTarget).data('ingenicoaccepturl'),
                ingenicoAmount = $(e.relatedTarget).data('ingenicoamount'),
                ingenicoCancelUrl = $(e.relatedTarget).data('ingenicocancelurl'),
                ingenicoCurrency = $(e.relatedTarget).data('ingenicocurrency'),
                ingenicoDeclineUrl = $(e.relatedTarget).data('ingenicodeclineurl'),
                ingenicoExceptionUrl = $(e.relatedTarget).data('ingenicoexceptionurl'),
                ingenicoLanguage = $(e.relatedTarget).data('ingenicolanguage'),
                ingenicoOrderId = $(e.relatedTarget).data('ingenicoorderid'),
                ingenicoPspid = $(e.relatedTarget).data('ingenicopspid'),
                ingenicoShasign = $(e.relatedTarget).data('ingenicoshasign');
                ingenicoTpUrl = $(e.relatedTarget).data('ingenicotpurl');
                ingenicoHomeUrl = $(e.relatedTarget).data('ingenicohomeurl');
                ingenicoCatalogUrl = $(e.relatedTarget).data('ingenicocatalogurl');
                // Stripe vars
                stripeAmount = $(e.relatedTarget).data('stripeamount');
                stripeCurrency = $(e.relatedTarget).data('stripecurrency');
                stripeCompany = $(e.relatedTarget).data('stripecompany');
                stripeInvoiceNumberStr = $(e.relatedTarget).data('stripeinvoicenumberstr');
                stripeInvoiceNumber = $(e.relatedTarget).data('stripeinvoicenumber');
                // Paypal vars
                paypalAmount = $(e.relatedTarget).data('paypalamount');
                paypalCurrency = $(e.relatedTarget).data('paypalcurrency');
                paypalInvoiceNumber = $(e.relatedTarget).data('paypalinvoicenumber');
                // Mollie set value in modal
                $(e.currentTarget).find('a[id="molliePaymentLink"]').attr("href", mollieTarget);
                // Ingenico set value in modal
                $(e.currentTarget).find('input[name="ACCEPTURL"]').val(ingenicoAcceptUrl);
                $(e.currentTarget).find('input[name="AMOUNT"]').val(ingenicoAmount);
                $(e.currentTarget).find('input[name="CANCELURL"]').val(ingenicoCancelUrl);
                $(e.currentTarget).find('input[name="CATALOGURL"]').val(ingenicoCatalogUrl);
                $(e.currentTarget).find('input[name="CURRENCY"]').val(ingenicoCurrency);
                $(e.currentTarget).find('input[name="DECLINEURL"]').val(ingenicoDeclineUrl);
                $(e.currentTarget).find('input[name="EXCEPTIONURL"]').val(ingenicoExceptionUrl);
                $(e.currentTarget).find('input[name="HOMEURL"]').val(ingenicoHomeUrl);
                $(e.currentTarget).find('input[name="LANGUAGE"]').val(ingenicoLanguage);
                $(e.currentTarget).find('input[name="ORDERID"]').val(ingenicoOrderId);
                $(e.currentTarget).find('input[name="PSPID"]').val(ingenicoPspid);
                $(e.currentTarget).find('input[name="SHASIGN"]').val(ingenicoShasign);
                $(e.currentTarget).find('input[name="TP"]').val(ingenicoTpUrl);
                // Stripe set value in modal
                $(e.currentTarget).find('button[id="stripeButton"]').data('value', stripeAmount);
                $(e.currentTarget).find('button[id="stripeButton"]').data('currency', stripeCurrency);
                $(e.currentTarget).find('button[id="stripeButton"]').data('company', stripeCompany);
                $(e.currentTarget).find('button[id="stripeButton"]').data('invoicenumberstr', stripeInvoiceNumberStr);
                $(e.currentTarget).find('button[id="stripeButton"]').data('invoicenumber', stripeInvoiceNumber);
                // Paypal set value in modal
                $(e.currentTarget).find('div[id="paypal-button-container"]').data('value', paypalAmount);
                $(e.currentTarget).find('div[id="paypal-button-container"]').data('currency', paypalCurrency);
                $(e.currentTarget).find('div[id="paypal-button-container"]').data('invoicenumber', paypalInvoiceNumber);
            });
        },
        handleStripePayment = function() {
            var $has_stripe = $('#user-has-stripe').data('value');
            if($has_stripe)
            {
                var stripeUrl = $('#base-url').data('target') + 'index.php/stripe_payment/stripe_return/charge';
                var handler = StripeCheckout.configure({
                    key: document.getElementById('stripe_publishable_key').getAttribute("value"),
                    image: 'https://stripe.com/img/documentation/checkout/marketplace.png',
                    locale: 'auto',
                    token: function(token) {
                        // You can access the token ID with `token.id`.
                        // Get the token ID to your server-side code for use.
                        $tokenID = token.id;
                        $amount = $('#stripeButton').data('value');
                        $currency = $('#stripeButton').data('currency');
                        $invoiceNumber = $('#stripeButton').data('invoicenumber');
                        $.getJSON(stripeUrl, {
                            token: $tokenID,
                            amount: $amount,
                            currency: $currency,
                            invoicenumber: $invoiceNumber
                        }, function(result) {
                            var $obj = $('#status'),
                            $status = result.status,
                            $message = $obj.data('message'),
                            $message_open = $obj.data('message2'),
                            $title = $obj.data('title') + ' ' + $status; 
                            if ($status == 'Paid')
                            {
                               swal({
                                 title: $title,
                                 text: $message,
                                 type: "success",
                                 showCancelButton: false,
                                 confirmButtonClass: "btn-success",
                                 closeOnConfirm: true
                               },
                               function(isConfirm) {
                                 location.reload();
                                });
                            }
                            else
                            {
                                swal({
                                  title: $title,
                                  text: $message_open,
                                  type: "info",
                                  showCancelButton: true,
                                  confirmButtonClass: "btn-info",
                                  confirmButtonText: $obj.data('confirm'),
                                  cancelButtonText: $obj.data('cancel'),
                                  closeOnConfirm: true,
                                  closeOnCancel: true
                                },
                                function(isConfirm) {
                                  location.reload();
                                 });
                            }
                        });
                    }
                });
                document.getElementById('stripeButton').addEventListener('click', function(e) {
                    // Open Checkout with further options:
                    $('#add-payment-modal').hide();
                    handler.open({
                        name: $('#stripeButton').data('company'),
                        description: $('#stripeButton').data('invoicenumberstr'),
                        zipCode: true,
                        currency: $('#stripeButton').data('currency'),
                        amount: $('#stripeButton').data('value')
                    });
                    e.preventDefault();
                });

                // Close Checkout on page navigation:
                window.addEventListener('popstate', function() {
                    handler.close();
                });
            }
            else
            {
                return;
            }
        },
        handlePaypalPayment = function(){
            var $has_paypal = $('#user-has-paypal').data('value');
            if ($has_paypal)
            {
                var paypalUrl = $('#base-url').data('target') + 'index.php/payments/paypal',
                $amount = $('#paypal-button-container').data('value'),
                $currency = $('#paypal-button-container').data('currency'),
                $invoiceNumber = $('#paypal-button-container').data('invoicenumber');
                paypal.Button.render({

                    env: $('#paypal-button-container').data('environment'), // sandbox | production

                    style: {
                        label: 'checkout', // checkout | credit | pay
                        size:  'responsive',    // small | medium | responsive
                        shape: 'rect',     // pill | rect
                        color: 'blue'      // gold | blue | silver
                    },
                    // PayPal Client IDs - replace with your own
                    // Create a PayPal app: https://developer.paypal.com/developer/applications/create
                    client: {
                        sandbox:    $('#paypal-button-container').data('sandboxid'),
                        production: $('#paypal-button-container').data('productionid')
                    },

                    // Show the buyer a 'Pay Now' button in the checkout flow
                    commit: true,

                    // payment() is called when the button is clicked
                    payment: function(data, actions) {

                        // Make a call to the REST api to create the payment
                        return actions.payment.create({
                            payment: {
                                transactions: [
                                    {
                                        amount: { total: $('#paypal-button-container').data('value'), currency: $('#paypal-button-container').data('currency') }
                                    }
                                ]
                            }
                        });
                    },

                    // onAuthorize() is called when the buyer approves the payment
                    onAuthorize: function(data, actions) {
                        $('#add-payment-modal').hide();
                        // Make a call to the REST api to execute the payment
                        return actions.payment.execute().then(function() {
                            $.getJSON(paypalUrl, {
                                token: data.paymentToken,
                                payment_id: data.paymentID,
                                payer_id: data.payerID,
                                amount: $amount,
                                currency: $currency,
                                invoicenumber: $('#paypal-button-container').data('invoicenumber')
                            }, function(result) {
                                var $obj = $('#status'),
                                $status = result.status,
                                $db_status = result.db_status,
                                $message = $obj.data('message'),
                                $message_open = $obj.data('message2'),
                                $title = $obj.data('title') + ' ' + $status; 
                                if ($db_status == 'Paid')
                                {
                                   swal({
                                     title: $title,
                                     text: $message,
                                     type: "success",
                                     showCancelButton: false,
                                     confirmButtonClass: "btn-success",
                                     closeOnConfirm: true
                                   },
                                   function(isConfirm) {
                                     location.reload();
                                    });
                                }
                                else
                                {
                                    swal({
                                      title: $title,
                                      text: $message_open,
                                      type: "info",
                                      showCancelButton: true,
                                      confirmButtonClass: "btn-info",
                                      confirmButtonText: $obj.data('confirm'),
                                      cancelButtonText: $obj.data('cancel'),
                                      closeOnConfirm: true,
                                      closeOnCancel: true
                                    },
                                    function(isConfirm) {
                                      location.reload();
                                     });
                                }
                            });
                        });
                    }
                }, '#paypal-button-container');
            }
            else
            {
                return;
            }
        };
    return {
        init: function() {
                handlePaymentGateways(),
                handleStripePayment(),
                handlePaypalPayment()
        }
    }
})(jQuery);
jQuery(document).ready(function() {
    Payments.init()
});