var Products = (function($){
	var handleProductForm = function(){
		var options = {
				dataType:  'json',
				uploadProgress: ajaxDone,
				success: serverResponse
			};
		$("#add-product-form").submit(function() {
			$(".btn-submit").attr("disabled","disabled");
			$(".btn-submit").text($('#btn-loading').data('text'));
			$(this).ajaxSubmit(options);	
			return false;
		});
	},
	handleSelectProductGroup = function(){
		if ($("#product_group").length != 0) {
			var $base_url = $('#base-url').data('target'),
				$url = $.trim( $base_url + 'index.php/products/get_products_groups' );

			$.getJSON($url, function(response){
				var stringified = JSON.stringify(response);
				stringified = stringified.replace(/group_id/g, 'id');
				stringified = stringified.replace(/group_name/g, 'text');
				var data = JSON.parse(stringified);
				
				$("#product_group").select2({
					data: data
				})
			});
		}
	},
	handleSelectServiceGroup = function(){
		if ($("#service_group").length != 0) {
			var $base_url = $('#base-url').data('target'),
				$url = $.trim( $base_url + 'index.php/services/get_products_groups' );

			$.getJSON($url, function(response){
				var stringified = JSON.stringify(response);
				stringified = stringified.replace(/group_id/g, 'id');
				stringified = stringified.replace(/group_name/g, 'text');
				var data = JSON.parse(stringified);
				
				$("#service_group").select2({
					data: data
				})
			});
		}
	},
	handleAddProductGroupModal = function(){
		var options = {
				dataType:  'json',
				uploadProgress: ajaxDone,
				success: serverResponseAddGroup
			};
		$("#add-productsgroup").submit(function() {
			$(".btn-submit").attr("disabled","disabled");
			$(".btn-submit").text($('#btn-loading').data('text'));
			$(this).ajaxSubmit(options);
			return false;
		});
	},
	handleAddChargesModal = function(){
		var options = {
				dataType:  'json',
				uploadProgress: ajaxDone,
				success: serverResponseAddCharges
			};
		$("#charges-add-modal").submit(function() {
			$(".btn-submit").attr("disabled","disabled");
			$(".btn-submit").text($('#btn-loading').data('text'));
			$(this).ajaxSubmit(options);
			return false;
		});
	},
	handleAddIncomesModal = function(){
		var options = {
				dataType:  'json',
				uploadProgress: ajaxDone,
				success: serverResponseAddIncomes
			};
		$("#incomes-add-modal").submit(function() {
			$(".btn-submit").attr("disabled","disabled");
			$(".btn-submit").text($('#btn-loading').data('text'));
			$(this).ajaxSubmit(options);
			return false;
		});
	},
	handleEditCharges = function(){
		var options = {
				dataType:  'json',
				uploadProgress: ajaxDone,
				success: serverResponseEditCharges
			};
		$("#edit-charges-form").submit(function() {
			$(".btn-submit").attr("disabled","disabled");
			$(".btn-submit").text($('#btn-loading').data('text'));
			$(this).ajaxSubmit(options);
			return false;
		});
	},
	handleEditIncomes = function(){
		var options = {
				dataType:  'json',
				uploadProgress: ajaxDone,
				success: serverResponseEditIncomes
			};
		$("#edit-incomes-form").submit(function() {
			$(".btn-submit").attr("disabled","disabled");
			$(".btn-submit").text($('#btn-loading').data('text'));
			$(this).ajaxSubmit(options);
			return false;
		});
	},
	handleAddServiceGroupModal = function(){
		var options = {
				dataType:  'json',
				uploadProgress: ajaxDone,
				success: serverResponseAddServiceGroup
			};
		$("#add-servicesgroup").submit(function() {
			$(".btn-submit").attr("disabled","disabled");
			$(".btn-submit").text($('#btn-loading').data('text'));
			$(this).ajaxSubmit(options);
			return false;
		});
	},
	handleEditProductGroup = function(){
		var options = {
				dataType:  'json',
				uploadProgress: ajaxDone,
				success: serverResponseEditGroup
			};
		$("#edit-productsgroup").submit(function() {
			$(".btn-submit").attr("disabled","disabled");
			$(".btn-submit").text($('#btn-loading').data('text'));
			$(this).ajaxSubmit(options);
			return false;
		});
	},
	handleItemProfite = function(){
		$(document).on('change keyup mouseup blur', '.calculate-price', function(){
			calculatePrice();
		});
		$(document).on('change keyup mouseup blur', '.calculate-price-vat-included', function(){
			calculatePrice();
		});
		$(document).on('change', '#tax_rate', function(){
			calculatePrice();
		});
		$(document).on('change keyup mouseup blur', '#purchase_price', function(){
			calculatePrice();
		});
	},
	handleDeleteItems = function(){
		var $table = $('#btable'),
		    $remove = $('#remove-item'),
		    selections = [];
		$table.bootstrapTable('refreshOptions', {
		    exportOptions: {ignoreColumn: ['0', 'checkbox'], // or as string array: ['0','checkbox']
		                    onCellHtmlData: DoOnCellHtmlData}
		});
		// sometimes footer render error.
		setTimeout(function () {
			$table.bootstrapTable('resetView');
		}, 200);
		$table.on('check.bs.table uncheck.bs.table ' +
		                'check-all.bs.table uncheck-all.bs.table', function () {
		            $remove.prop('disabled', !$table.bootstrapTable('getSelections').length);

		            // save your data, here just save the current page
		            selections = getIdSelections();
		            // push or splice the selections if you want to save all data selections
		        });
		$remove.click(function () {
		    var ids = getIdSelections();
		    $base_url = $('#base-url').data('target'),
		    $url = $.trim( $base_url + 'index.php/products/delete_item' );
		    $this = $('#remove-item');
		    swal({
		      title: $this.data('sure'),
		      text: $this.data('message'),
		      type: "warning",
		      showCancelButton: true,
		      cancelButtonText: $('#btn-cancel').data('text'),
		      confirmButtonClass: "btn-danger",
		      confirmButtonText: $this.data('confirm'),
		      closeOnConfirm: true
		    },
		    function(){ 
		        $.getJSON({
		            url: $url,
		            data: {
		                id: ids
		            },
		            success: function (data) {
		            	if (data.success > 0)
		            	{
		            		$table.bootstrapTable('remove', {
		            		    field: 'item_id',
		            		    values: ids
		            		});
		            		App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#remove-item').data('success')});
		            		$remove.prop('disabled', true);
		            	}
		            	if(data.fail > 0)
		            	{
		            		App.alert({container: $('#notification-alert'), type: "danger", close: true, message: $('#remove-item').data('danger') + '&nbsp;' + data.fail});
		            		setTimeout(function () {
		            			$table.bootstrapTable('refresh', true);
		            		}, 200);
		            		$remove.prop('disabled', true);
		            	}
		            }
		        });
		    });
		});
		function getIdSelections() {
		    return $.map($table.bootstrapTable('getSelections'), function (row) {
		        return row.item_id
		    });
		}
		function detailFormatter(index, row) {
		    var html = [];
		    $.each(row, function (key, value) {
		        html.push('<p><b>' + key + ':</b> ' + value + '</p>');
		    });
		    return html.join('');
		}

		function DoOnCellHtmlData(cell, row, col, data) {
		    var result = "";
		    if (typeof data != 'undefined' && data != "") {
		      var html = $.parseHTML(data);

		      $.each( html, function() {
		          if ( typeof $(this).html() === 'undefined' )
		              result += $(this).text();
		          else if ( typeof $(this).attr('class') === 'undefined' || $(this).hasClass('th-inner') === true )
		              result += $(this).html();
		      });
		    }
		    return result;
		}
	},
	handleItemActivation = function(){
		var $table = $('#btable'),
		    $activation = $('#activate-item'),
		    selections = [];

		// sometimes footer render error.
		setTimeout(function () {
			$table.bootstrapTable('resetView');
		}, 200);
		$table.on('check.bs.table uncheck.bs.table ' +
		                'check-all.bs.table uncheck-all.bs.table', function () {
		            $activation.prop('disabled', !$table.bootstrapTable('getSelections').length);

		            // save your data, here just save the current page
		            selections = getIdSelections();
		            // push or splice the selections if you want to save all data selections
		        });
		$activation.click(function () {
		    var ids = getIdSelections();
		    $base_url = $('#base-url').data('target'),
		    $url = $.trim( $base_url + 'index.php/products/activate_item' );
		    $this = $('#activate-item');
		    swal({
		      title: $this.data('sure'),
		      text: $this.data('message'),
		      type: "warning",
		      showCancelButton: true,
		      confirmButtonClass: "btn-warning",
		      confirmButtonText: $this.data('confirm'),
		      cancelButtonText: $('#btn-cancel').data('text'),
		      closeOnConfirm: true
		    },
		    function(){ 
		        $.getJSON({
		            url: $url,
		            data: {
		                id: ids
		            },
		            success: function (data) {
		            	if (data.success > 0)
		            	{
		            		App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#activate-item').data('success')});
		            		setTimeout(function () {
		            			$table.bootstrapTable('refresh', true);
		            		}, 200);
		            		$activation.prop('disabled', true);
		            	}
		            	if(data.fail > 0)
		            	{
		            		App.alert({container: $('#notification-alert'), type: "danger", close: true, message: $('#activate-item').data('danger')});
		            		setTimeout(function () {
		            			$table.bootstrapTable('refresh', true);
		            		}, 200);
		            		$activation.prop('disabled', true);
		            	}
		            }
		        });
		    });
		});
		function getIdSelections() {
		    return $.map($table.bootstrapTable('getSelections'), function (row) {
		        return row.item_id
		    });
		}
	},
	handleGenerateQRBarCode = function(){
		var $table = $('#btable'),
		    $generateQRBarCode = $('#generate-item-qrbar-code'),
		    selections = [];

		// sometimes footer render error.
		setTimeout(function () {
			$table.bootstrapTable('resetView');
		}, 200);
		$table.on('check.bs.table uncheck.bs.table ' +
		                'check-all.bs.table uncheck-all.bs.table', function () {
		            $generateQRBarCode.prop('disabled', !$table.bootstrapTable('getSelections').length);

		            // save your data, here just save the current page
		            selections = getIdSelections();
		            // push or splice the selections if you want to save all data selections
		        });
		$generateQRBarCode.click(function () {
		    var ids = getIdSelections();
		    $base_url = $('#base-url').data('target'),
		    $url = $.trim( $base_url + 'index.php/products/generateQRBarCode' );
		    $this = $('#generate-item-qrbar-code');
		    swal({
		      title: $this.data('sure'),
		      text: $this.data('message'),
		      type: "warning",
		      showCancelButton: true,
		      confirmButtonClass: "btn-warning",
		      confirmButtonText: $this.data('confirm'),
		      cancelButtonText: $('#btn-cancel').data('text'),
		      closeOnConfirm: true
		    },
		    function(){ 
		        $.getJSON({
		            url: $url,
		            data: {
		                id: ids
		            },
		            success: function (data) {
		            	if (data.success > 0)
		            	{
		            		App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#generate-item-qrbar-code').data('success')});
		            		setTimeout(function () {
		            			$table.bootstrapTable('refresh', true);
		            		}, 200);
		            		$generateQRBarCode.prop('disabled', true);
		            	}
		            	if(data.fail > 0)
		            	{
		            		App.alert({container: $('#notification-alert'), type: "danger", close: true, message: $('#generate-item-qrbar-code').data('danger')});
		            		setTimeout(function () {
		            			$table.bootstrapTable('refresh', true);
		            		}, 200);
		            		$generateQRBarCode.prop('disabled', true);
		            	}
		            }
		        });
		    });
		});
		function getIdSelections() {
		    return $.map($table.bootstrapTable('getSelections'), function (row) {
		        return row.item_id
		    });
		}
	},
	handlePrintBarcode = function(){
		var $table = $('#btable'),
		    $printBarcode = $('#print-item-barcode'),
		    selections = [];

		// sometimes footer render error.
		setTimeout(function () {
			$table.bootstrapTable('resetView');
		}, 200);
		$table.on('check.bs.table uncheck.bs.table ' +
		                'check-all.bs.table uncheck-all.bs.table', function () {
		            $printBarcode.prop('disabled', !$table.bootstrapTable('getSelections').length);

		            // save your data, here just save the current page
		            selections = getIdSelections();
		            // push or splice the selections if you want to save all data selections
		        });
		$printBarcode.click(function () {
		    var ids = getIdSelections();
		    $base_url = $('#base-url').data('target'),
		    $url = $.trim( $base_url + 'index.php/products/print_barcode' );
		    $this = $('#print-item-barcode');
		    swal({
		      title: $this.data('sure'),
		      text: $this.data('message'),
		      type: "warning",
		      showCancelButton: true,
		      confirmButtonClass: "btn-warning",
		      confirmButtonText: $this.data('confirm'),
		      cancelButtonText: $('#btn-cancel').data('text'),
		      closeOnConfirm: true
		    },
		    function(){ 
		        $.getJSON({
		            url: $url,
		            data: {
		                id: ids
		            },
		            success: function (data) {
		            	if (data.success > 0)
		            	{
		            		App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#print-item-barcode').data('success')});
		            		setTimeout(function () {
		            			$table.bootstrapTable('refresh', true);
		            		}, 200);
		            		window.location = $base_url + 'index.php/products/download_barcode';
		            		$printBarcode.prop('disabled', true);
		            	}
		            	if(data.fail > 0)
		            	{
		            		App.alert({container: $('#notification-alert'), type: "danger", close: true, message: $('#print-item-barcode').data('danger')});
		            		setTimeout(function () {
		            			$table.bootstrapTable('refresh', true);
		            		}, 200);
		            		$printBarcode.prop('disabled', true);
		            	}
		            }
		        });
		    });
		});
		function getIdSelections() {
		    return $.map($table.bootstrapTable('getSelections'), function (row) {
		        return row.item_id
		    });
		}
	},
	handleItemDesactivation = function(){
		var $table = $('#btable'),
		    $desactivation = $('#desactivate-item'),
		    selections = [];

		// sometimes footer render error.
		setTimeout(function () {
			$table.bootstrapTable('resetView');
		}, 200);
		$table.on('check.bs.table uncheck.bs.table ' +
		                'check-all.bs.table uncheck-all.bs.table', function () {
		            $desactivation.prop('disabled', !$table.bootstrapTable('getSelections').length);

		            // save your data, here just save the current page
		            selections = getIdSelections();
		            // push or splice the selections if you want to save all data selections
		        });
		$desactivation.click(function () {
		    var ids = getIdSelections();
		    $base_url = $('#base-url').data('target'),
		    $url = $.trim( $base_url + 'index.php/products/desactivate_item' );
		    $this = $('#desactivate-item');
		    swal({
		      title: $this.data('sure'),
		      text: $this.data('message'),
		      type: "warning",
		      showCancelButton: true,
		      confirmButtonClass: "btn-warning",
		      confirmButtonText: $this.data('confirm'),
		      cancelButtonText: $('#btn-cancel').data('text'),
		      closeOnConfirm: true
		    },
		    function(){ 
		        $.getJSON({
		            url: $url,
		            data: {
		                id: ids
		            },
		            success: function (data) {
		            	if (data.success > 0)
		            	{
		            		App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#desactivate-item').data('success')});
		            		setTimeout(function () {
		            			$table.bootstrapTable('refresh', true);
		            		}, 200);
		            		$desactivation.prop('disabled', true);
		            	}
		            	if(data.fail > 0)
		            	{
		            		App.alert({container: $('#notification-alert'), type: "danger", close: true, message: $('#desactivate-item').data('danger')});
		            		setTimeout(function () {
		            			$table.bootstrapTable('refresh', true);
		            		}, 200);
		            		$desactivation.prop('disabled', true);
		            	}
		            }
		        });
		    });
		});
		function getIdSelections() {
		    return $.map($table.bootstrapTable('getSelections'), function (row) {
		        return row.item_id
		    });
		}
	},
	serverResponse = function(responseText, statusText, xhr, $form){
		if(responseText.status == 1)
		{
			var is_edit = $('#is-edit').data('value');
			if (!is_edit)
			{
				$('#add-product-form').trigger('reset');
				$(".select2").val('-1').trigger('change');
				generateSku();
			}
			$(".btn-submit").removeAttr("disabled");
			$(".btn-submit").text($('#btn-save').data('text'));
			App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#default-save-success').data('message')});
		}
		else
		{
			message = responseText.error;
			message = message.replace(/<\/?p[^>]*>/g, "");
			if( message != '')
			{
				App.alert({container: $('#notification-alert'), type: "danger", close: true, message: message});
			}
			else
			{
				App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#default-update-success').data('message')});
			}
			$(".btn-submit").removeAttr("disabled");
			$(".btn-submit").text($('#btn-save').data('text'));
		}
	},
	serverResponseAddGroup = function(responseText, statusText, xhr, $form){
		if(responseText.status == 1)
		{
			$(".btn-submit").removeAttr("disabled");
			$(".btn-submit").text($('#btn-save').data('text'));
			$("#add-productgroup-modal").modal('hide');
			$('#add-productgroup-modal').on('hidden.bs.modal', function () {
				$(this).find('form').trigger('reset');

				var $base_url = $('#base-url').data('target'),
				$url = $.trim( $base_url + 'index.php/products/get_products_groups' );
				$.getJSON($url, function(response){
					var stringified = JSON.stringify(response);
					stringified = stringified.replace(/group_id/g, 'id');
					stringified = stringified.replace(/group_name/g, 'text');
					var data = JSON.parse(stringified);
					$("#product_group").select2({
						data: data
					})
				});
			});
		}
		else
		{
			$("#group-modal-validation-errors").html(responseText.error);
			$(".btn-submit").removeAttr("disabled");
			$(".btn-submit").text($('#btn-save').data('text'));
		}
	},
	serverResponseAddCharges = function(responseText, statusText, xhr, $form){
		if(responseText.status == 1)
		{
			$(".btn-submit").removeAttr("disabled");
			$(".btn-submit").text($('#btn-save').data('text'));
			$("#add-charges-modal").modal('hide');
			$('#add-charges-modal').on('hidden.bs.modal', function () {
				var $table = $('#chargesTable');
				setTimeout(function () {
					$table.bootstrapTable('refresh');
				}, 200);
			});
		}
		else
		{
			$("#charges-modal-validation-errors").html(responseText.error);
			$(".btn-submit").removeAttr("disabled");
			$(".btn-submit").text($('#btn-save').data('text'));
		}
	},
	serverResponseAddIncomes = function(responseText, statusText, xhr, $form){
		if(responseText.status == 1)
		{
			$(".btn-submit").removeAttr("disabled");
			$(".btn-submit").text($('#btn-save').data('text'));
			$("#add-incomes-modal").modal('hide');
			$('#add-incomes-modal').on('hidden.bs.modal', function () {
				var $table = $('#incomesTable');
				setTimeout(function () {
					$table.bootstrapTable('refresh');
				}, 200);
			});
		}
		else
		{
			$("#invoices-modal-validation-errors").html(responseText.error);
			$(".btn-submit").removeAttr("disabled");
			$(".btn-submit").text($('#btn-save').data('text'));
		}
	},
	serverResponseEditCharges = function(responseText, statusText, xhr, $form){
		if(responseText.status == 1)
		{
			App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#default-update-success').data('message')});
			$(".btn-submit").removeAttr("disabled");
			$(".btn-submit").text($('#btn-save').data('text'));
		}
		else
		{
			message = responseText.error;
			message = message.replace(/<\/?p[^>]*>/g, "");
			if( message != '')
			{
				App.alert({container: $('#notification-alert'), type: "danger", close: true, message: message});
			}
			else
			{
				App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#default-update-success').data('message')});
			}
			$(".btn-submit").removeAttr("disabled");
			$(".btn-submit").text($('#btn-save').data('text'));
		}
	},
	serverResponseEditIncomes = function(responseText, statusText, xhr, $form){
		if(responseText.status == 1)
		{
			App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#default-update-success').data('message')});
			$(".btn-submit").removeAttr("disabled");
			$(".btn-submit").text($('#btn-save').data('text'));
		}
		else
		{
			message = responseText.error;
			message = message.replace(/<\/?p[^>]*>/g, "");
			if( message != '')
			{
				App.alert({container: $('#notification-alert'), type: "danger", close: true, message: message});
			}
			else
			{
				App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#default-update-success').data('message')});
			}
			$(".btn-submit").removeAttr("disabled");
			$(".btn-submit").text($('#btn-save').data('text'));
		}
	},
	serverResponseAddServiceGroup = function(responseText, statusText, xhr, $form){
		if(responseText.status == 1)
		{
			$(".btn-submit").removeAttr("disabled");
			$(".btn-submit").text($('#btn-save').data('text'));
			$("#add-servicegroup-modal").modal('hide');
			$('#add-servicegroup-modal').on('hidden.bs.modal', function () {
				$(this).find('form').trigger('reset');

				var $base_url = $('#base-url').data('target'),
				$url = $.trim( $base_url + 'index.php/services/get_products_groups' );
				$.getJSON($url, function(response){
					var stringified = JSON.stringify(response);
					stringified = stringified.replace(/group_id/g, 'id');
					stringified = stringified.replace(/group_name/g, 'text');
					var data = JSON.parse(stringified);
					$("#service_group").select2({
						data: data
					})
				});
			});
		}
		else
		{
			$("#service-group-modal-validation-errors").html(responseText.error);
			$(".btn-submit").removeAttr("disabled");
			$(".btn-submit").text($('#btn-save').data('text'));
		}
	},
	calculatePrice = function(){
		var purchase_price = 0,
			item_profit = 0,
			product_price = 0;
		if ($('#purchase_price').val() != '' && $('#item_profit').val() != '')
		{
			purchase_price = parseFloat($('#purchase_price').val());
			item_profit = parseFloat($('#item_profit').val());

			product_price = parseFloat(purchase_price + (purchase_price * item_profit / 100));
			$('#product_price').val(product_price);
			if ($('#tax_rate').val() > 0) {
				var data = $('#tax_rate').select2('data');
				$tax_val = data[0].text;
				$coef = 1 + (parseFloat($tax_val) / 100);

				$('#product_price_vat_included').val( parseFloat(product_price * $coef) );
			}
		}
		else if ($('#product_price_vat_included').val() != '' && $('#tax_rate').val() > 0) {
			var data = $('#tax_rate').select2('data');
			$tax_val = data[0].text;
			$gross = parseFloat($('#product_price_vat_included').val());
			$coef = 1 + (parseFloat($tax_val) / 100);

			$('#product_price').val(parseFloat($gross / $coef).toFixed(5));
		}
		else if ($('#product_price_vat_included').val() == '' && $('#tax_rate').val() > 0 && $('#product_price').val() != '') {
			var data = $('#tax_rate').select2('data');
			$tax_val = data[0].text;
			$coef = 1 + (parseFloat($tax_val) / 100);
			$('#product_price_vat_included').val(parseFloat($('#product_price').val() * $coef).toFixed(2));
		}
	},
	generateSku = function(){
		if ($('#product_sku').length != 0) {
			url = $('#base-url').data('target') + 'index.php/products/generate_sku';
			$.getJSON(url, function(data){
				$('#product_sku').val(data);
			});
		}
	},
	handleItemSearch = function(){
		$(function() {
		  $('#btable').bootstrapTable({
		    formatSearch: function () {
		      return 'Search'
		    }
		  })
		})

		function itemSearch(data, text) {
		  return data.filter(function (row) {
		    return row.name.indexOf(text) > -1
		  })
		}
	},
	serverResponseEditGroup = function(responseText, statusText, xhr, $form){
		if(responseText.status == 1)
		{
			App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#default-update-success').data('message')});
			$(".btn-submit").removeAttr("disabled");
			$(".btn-submit").text($('#btn-save').data('text'));
		}
		else
		{
			message = responseText.error;
			message = message.replace(/<\/?p[^>]*>/g, "");
			if( message != '')
			{
				App.alert({container: $('#notification-alert'), type: "danger", close: true, message: message});
			}
			else
			{
				App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#default-update-success').data('message')});
			}
			$(".btn-submit").removeAttr("disabled");
			$(".btn-submit").text($('#btn-save').data('text'));
		}
	};
	return {
		init: function(){
			handleProductForm(), 
			handleAddProductGroupModal(),
			handleAddServiceGroupModal(),
			handleEditProductGroup(),
			handleSelectProductGroup(),
			handleSelectServiceGroup(),
			handleDeleteItems(),
			handleAddChargesModal(),
			handleEditCharges(),
			handleItemProfite(),
			generateSku(),
			handleItemActivation(),
			handleItemDesactivation(),
			handleAddIncomesModal(),
			handleEditIncomes(),
			handleGenerateQRBarCode(),
			handlePrintBarcode(),
			handleItemSearch()
		}
	}
})(jQuery);
jQuery(document).ready(function() {
    Products.init() 
	if ($('#product_price_vat_included').val() == '' && $('#tax_rate').val() > 0 && $('#product_price').val() != '') {
		var data = $('#tax_rate').select2('data');
		$tax_val = data[0].text;
		$coef = 1 + (parseFloat($tax_val) / 100);
		$('#product_price_vat_included').val(parseFloat($('#product_price').val() * $coef).toFixed(2));
	}
});
