var ProformaIndex = (function($){
	var handleMergeProforma = function(){
		var $table = $('#proformatable'),
		    $merge = $('#merge-proforma'),
		    selections = [];

		// sometimes footer render error.
		setTimeout(function () {
			$table.bootstrapTable('resetView');
		}, 200);
		$table.on('check.bs.table uncheck.bs.table ' +
		                'check-all.bs.table uncheck-all.bs.table', function () {
		            $merge.prop('disabled', !$table.bootstrapTable('getSelections').length);

		            // save your data, here just save the current page
		            selections = getIdSelections();
		            // push or splice the selections if you want to save all data selections
		        });
		$merge.click(function () {
		    var ids = getIdSelections();
		    $base_url = $('#base-url').data('target'),
		    $url = $.trim( $base_url + 'index.php/proforma/merge_proforma' );
		    $this = $('#merge-proforma');
		    swal({
		      title: $this.data('sure'),
		      text: $this.data('message'),
		      type: "warning",
		      showCancelButton: true,
		      confirmButtonClass: "btn-danger",
		      confirmButtonText: $this.data('confirm'),
		      cancelButtonText: $('#btn-cancel').data('text'),
		      closeOnConfirm: true
		    },
		    function(){ 
		        $.getJSON({
		            url: $url,
		            data: {
		                id: ids
		            },
		            success: function (data) {
		            	if (data.success > 0)
		            	{
		            		App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#merge-proforma').data('success')});
		            		$merge.prop('disabled', true);
		            		setTimeout(function () {
		            			$table.bootstrapTable('refresh', true);
		            		}, 200);
		            	}
		            	if(data.fail > 0)
		            	{
		            		App.alert({container: $('#notification-alert'), type: "danger", close: true, message: $('#merge-proforma').data('danger') + ' ' + data.fail });
		            		setTimeout(function () {
		            			$table.bootstrapTable('refresh', true);
		            		}, 200);
		            		$merge.prop('disabled', true);
		            	}
		            }
		        });
		    });
		});
		function getIdSelections() {
		    return $.map($table.bootstrapTable('getSelections'), function (row) {
		        return row.enc_proforma_number
		    });
		}
	},
	handleMassEmailInvoices = function(){
		var $table = $('#btable'),
		    $markSent = $('#send-email'),
		    selections = [];

		// sometimes footer render error.
		setTimeout(function () {
			$table.bootstrapTable('resetView');
		}, 200);
		$table.on('check.bs.table uncheck.bs.table ' +
		                'check-all.bs.table uncheck-all.bs.table', function () {
		            $markSent.prop('disabled', !$table.bootstrapTable('getSelections').length);

		            // save your data, here just save the current page
		            selections = getIdSelections();
		            // push or splice the selections if you want to save all data selections
		        });
		$markSent.click(function () {
		    var ids = getIdSelections();
		    $base_url = $('#base-url').data('target'),
		    $url = $.trim( $base_url + 'index.php/invoices/mass_invoices_email' );
		    $this = $('#send-email');
		    swal({
		      title: $this.data('sure'),
		      text: $this.data('message'),
		      type: "warning",
		      showCancelButton: true,
		      confirmButtonClass: "btn-danger",
		      confirmButtonText: $this.data('confirm'),
		      cancelButtonText: $('#btn-cancel').data('text'),
		      closeOnConfirm: true
		    },
		    function(){ 
		        $.getJSON({
		            url: $url,
		            data: {
		                id: ids
		            },
		            success: function (data) {
		            	if (data.success > 0)
		            	{
		            		App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#send-email').data('success')});
		            		setTimeout(function () {
		            			$table.bootstrapTable('refresh', true);
		            		}, 200);
		            		$markSent.prop('disabled', true);
		            	}
		            	if(data.fail > 0)
		            	{
		            		App.alert({container: $('#notification-alert'), type: "danger", close: true, message: $('#send-email').data('danger') + ' ' + data.fail });
		            		setTimeout(function () {
		            			$table.bootstrapTable('refresh', true);
		            		}, 200);
		            		$markSent.prop('disabled', true);
		            	}
		            }
		        });
		    });
		});
		function getIdSelections() {
		    return $.map($table.bootstrapTable('getSelections'), function (row) {
		        return row.enc_proforma_number
		    });
		}
	},
    handleDeleteProforma = function(){
		var $table = $('#proformatable'),
		    $remove = $('#remove-proforma'),
		    selections = [];

		// sometimes footer render error.
		setTimeout(function () {
			$table.bootstrapTable('resetView');
		}, 200);
		$table.on('check.bs.table uncheck.bs.table ' +
		                'check-all.bs.table uncheck-all.bs.table', function () {
		            $remove.prop('disabled', !$table.bootstrapTable('getSelections').length);

		            // save your data, here just save the current page
		            selections = getIdSelections();
		            // push or splice the selections if you want to save all data selections
		        });
		$remove.click(function () {
		    var ids = getIdSelections();
		    $base_url = $('#base-url').data('target'),
		    $url = $.trim( $base_url + 'index.php/proforma/delete_proforma' );
		    $this = $('#remove-proforma');
		    swal({
		      title: $this.data('sure'),
		      text: $this.data('message'),
		      type: "warning",
		      showCancelButton: true,
		      confirmButtonClass: "btn-danger",
		      confirmButtonText: $this.data('confirm'),
		      cancelButtonText: $('#btn-cancel').data('text'),
		      closeOnConfirm: true
		    },
		    function(){ 
		        $.getJSON({
		            url: $url,
		            data: {
		                id: ids
		            },
		            success: function (data) {
		            	if (data.success > 0)
		            	{
		            		$table.bootstrapTable('remove', {
		            		    field: 'enc_proforma_number',
		            		    values: ids
		            		});
		            		App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#remove-proforma').data('success')});
		            		$remove.prop('disabled', true);
		            	}
		            	if(data.fail > 0)
		            	{
		            		App.alert({container: $('#notification-alert'), type: "danger", close: true, message: $('#remove-proforma').data('danger') + ' ' + data.fail });
		            		setTimeout(function () {
		            			$table.bootstrapTable('refresh', true);
		            		}, 200);
		            		$remove.prop('disabled', true);
		            	}
		            }
		        });
		    });
		});
		function getIdSelections() {
		    return $.map($table.bootstrapTable('getSelections'), function (row) {
		        return row.enc_proforma_number
		    });
		}
	},
	handleConvertToInvoice = function(){
		var $table = $('#proformatable'),
		    $invoice = $('#generate-invoice'),
		    selections = [];

		// sometimes footer render error.
		setTimeout(function () {
			$table.bootstrapTable('resetView');
		}, 200);
		$table.on('check.bs.table uncheck.bs.table ' +
		                'check-all.bs.table uncheck-all.bs.table', function () {
		            $invoice.prop('disabled', !$table.bootstrapTable('getSelections').length);

		            // save your data, here just save the current page
		            selections = getIdSelections();
		            // push or splice the selections if you want to save all data selections
		        });
		$invoice.click(function () {
		    var ids = getIdSelections();
		    $base_url = $('#base-url').data('target'),
		    $url = $.trim( $base_url + 'index.php/proforma/convert_to_invoice' );
		    $this = $('#generate-invoice');
		    swal({
		      title: $this.data('sure'),
		      text: $this.data('message'),
		      type: "warning",
		      showCancelButton: true,
		      confirmButtonClass: "btn-danger",
		      confirmButtonText: $this.data('confirm'),
		      cancelButtonText: $('#btn-cancel').data('text'),
		      closeOnConfirm: true
		    },
		    function(){ 
		        $.getJSON({
		            url: $url,
		            data: {
		                id: ids
		            },
		            success: function (data) {
		            	if (data.success > 0)
		            	{
		            		App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#generate-invoice').data('success')});
		            		$invoice.prop('disabled', true);
		            		if (data.post_delete) {
		            			$table.bootstrapTable('remove', {
		            			    field: 'enc_proforma_number',
		            			    values: ids
		            			});
		            		} else {
		            			setTimeout(function () {
		            				$table.bootstrapTable('refresh', true);
		            			}, 200);
		            		}
		            	}
		            	if(data.fail > 0)
		            	{
		            		App.alert({container: $('#notification-alert'), type: "danger", close: true, message: $('#generate-invoice').data('danger') + ' ' + data.fail });
		            		setTimeout(function () {
		            			$table.bootstrapTable('refresh', true);
		            		}, 200);
		            		$invoice.prop('disabled', true);
		            	}
		            }
		        });
		    });
		});
		function getIdSelections() {
		    return $.map($table.bootstrapTable('getSelections'), function (row) {
		        return row.enc_proforma_number
		    });
		}
	},
	handleClientMassEmailProforma = function(){
		var $table = $('#clientProformatable'),
		    $markSent = $('#client-send-proforma-email'),
		    selections = [];

		// sometimes footer render error.
		setTimeout(function () {
			$table.bootstrapTable('resetView');
		}, 200);
		$table.on('check.bs.table uncheck.bs.table ' +
		                'check-all.bs.table uncheck-all.bs.table', function () {
		            $markSent.prop('disabled', !$table.bootstrapTable('getSelections').length);

		            // save your data, here just save the current page
		            selections = getIdSelections();
		            // push or splice the selections if you want to save all data selections
		        });
		$markSent.click(function () {
		    var ids = getIdSelections();
		    $base_url = $('#base-url').data('target'),
		    $url = $.trim( $base_url + 'index.php/client/mass_proforma_email' );
		    $this = $('#client-send-proforma-email');
		    swal({
		      title: $this.data('sure'),
		      text: $this.data('message'),
		      type: "warning",
		      showCancelButton: true,
		      confirmButtonClass: "btn-danger",
		      confirmButtonText: $this.data('confirm'),
		      cancelButtonText: $('#btn-cancel').data('text'),
		      closeOnConfirm: true
		    },
		    function(){ 
		        $.getJSON({
		            url: $url,
		            data: {
		                id: ids
		            },
		            success: function (data) {
		            	if (data.success > 0)
		            	{
		            		App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#client-send-proforma-email').data('success')});
		            		setTimeout(function () {
		            			$table.bootstrapTable('refresh', true);
		            		}, 200);
		            		$markSent.prop('disabled', true);
		            	}
		            	if(data.fail > 0)
		            	{
		            		App.alert({container: $('#notification-alert'), type: "danger", close: true, message: $('#client-send-proforma-email').data('danger') + ' ' + data.fail });
		            		setTimeout(function () {
		            			$table.bootstrapTable('refresh', true);
		            		}, 200);
		            		$markSent.prop('disabled', true);
		            	}
		            }
		        });
		    });
		});
		function getIdSelections() {
		    return $.map($table.bootstrapTable('getSelections'), function (row) {
		        return row.enc_proforma_number
		    });
		}
	},
	handleMassEmailProforma = function(){
		var $table = $('#proformatable'),
		    $markSent = $('#send-email'),
		    selections = [];

		// sometimes footer render error.
		setTimeout(function () {
			$table.bootstrapTable('resetView');
		}, 200);
		$table.on('check.bs.table uncheck.bs.table ' +
		                'check-all.bs.table uncheck-all.bs.table', function () {
		            $markSent.prop('disabled', !$table.bootstrapTable('getSelections').length);

		            // save your data, here just save the current page
		            selections = getIdSelections();
		            // push or splice the selections if you want to save all data selections
		        });
		$markSent.click(function () {
		    var ids = getIdSelections();
		    $base_url = $('#base-url').data('target'),
		    $url = $.trim( $base_url + 'index.php/proforma/mass_proforma_email' );
		    $this = $('#send-email');
		    swal({
		      title: $this.data('sure'),
		      text: $this.data('message'),
		      type: "warning",
		      showCancelButton: true,
		      confirmButtonClass: "btn-danger",
		      confirmButtonText: $this.data('confirm'),
		      cancelButtonText: $('#btn-cancel').data('text'),
		      closeOnConfirm: true
		    },
		    function(){ 
		        $.getJSON({
		            url: $url,
		            data: {
		                id: ids
		            },
		            success: function (data) {
		            	if (data.success > 0)
		            	{
		            		App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#send-email').data('success')});
		            		setTimeout(function () {
		            			$table.bootstrapTable('refresh', true);
		            		}, 200);
		            		$markSent.prop('disabled', true);
		            	}
		            	if(data.fail > 0)
		            	{
		            		App.alert({container: $('#notification-alert'), type: "danger", close: true, message: $('#send-email').data('danger') + ' ' + data.fail });
		            		setTimeout(function () {
		            			$table.bootstrapTable('refresh', true);
		            		}, 200);
		            		$markSent.prop('disabled', true);
		            	}
		            }
		        });
		    });
		});
		function getIdSelections() {
		    return $.map($table.bootstrapTable('getSelections'), function (row) {
		        return row.enc_proforma_number
		    });
		}
	};
	return {
		init: function(){
			handleDeleteProforma(),
			handleMassEmailInvoices(),
			handleMassEmailProforma(),
			handleMergeProforma(),
			handleConvertToInvoice(),
			handleClientMassEmailProforma()
		}
	}
})(jQuery);
jQuery(document).ready(function() {
	ProformaIndex.init()
});
