var Proforma = (function($){
	var handleProformaForm = function(){
		var options = {
			dataType:  'json',
			success: serverResponse
		};
		$('#create-proforma-form').submit(function(){

			// Prevent 2 or more submissions
			$("#btn-create-proforma").attr("disabled","disabled");
			$('#create-proforma-form').ajaxSubmit(options);
			return false; 
		});
	},
	handleSelectClient = function(){
		$('.invoice_to').each(function(){
			var $base_url = $('#base-url').data('target'),
				$url = $.trim( $base_url + 'index.php/clients/get_active_clients' );

			$.getJSON( $url, function(response){
				var stringified = JSON.stringify(response);
				var data = JSON.parse(stringified);
				$('.invoice_to').select2({
					data: data
				})
			});
		});
	},
	handleUpdateProforma = function(){
		var options = {
			dataType:  'json',
			success: updateProformaServerResponse
		};
		$('#update-proforma-form').submit(function(){
			$(this).ajaxSubmit(options);
			return false; 
		});
	},
	handleMergeProforma = function(){
		var $table = $('#proformatable'),
		    $merge = $('#merge-proforma'),
		    selections = [];

		// sometimes footer render error.
		setTimeout(function () {
			$table.bootstrapTable('resetView');
		}, 200);
		$table.on('check.bs.table uncheck.bs.table ' +
		                'check-all.bs.table uncheck-all.bs.table', function () {
		            $merge.prop('disabled', !$table.bootstrapTable('getSelections').length);

		            // save your data, here just save the current page
		            selections = getIdSelections();
		            // push or splice the selections if you want to save all data selections
		        });
		$merge.click(function () {
		    var ids = getIdSelections();
		    $base_url = $('#base-url').data('target'),
		    $url = $.trim( $base_url + 'index.php/proforma/merge_proforma' );
		    $this = $('#merge-proforma');
		    swal({
		      title: $this.data('sure'),
		      text: $this.data('message'),
		      type: "warning",
		      showCancelButton: true,
		      confirmButtonClass: "btn-danger",
		      confirmButtonText: $this.data('confirm'),
		      cancelButtonText: $('#btn-cancel').data('text'),
		      closeOnConfirm: true
		    },
		    function(){ 
		        $.getJSON({
		            url: $url,
		            data: {
		                id: ids
		            },
		            success: function (data) {
		            	if (data.success > 0)
		            	{
		            		App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#merge-proforma').data('success')});
		            		$merge.prop('disabled', true);
		            		setTimeout(function () {
		            			$table.bootstrapTable('refresh', true);
		            		}, 200);
		            	}
		            	if(data.fail > 0)
		            	{
		            		App.alert({container: $('#notification-alert'), type: "danger", close: true, message: $('#merge-proforma').data('danger') + ' ' + data.fail });
		            		setTimeout(function () {
		            			$table.bootstrapTable('refresh', true);
		            		}, 200);
		            		$merge.prop('disabled', true);
		            	}
		            }
		        });
		    });
		});
		function getIdSelections() {
		    return $.map($table.bootstrapTable('getSelections'), function (row) {
		        return row.enc_proforma_number
		    });
		}
	},
	handleMassEmailInvoices = function(){
		var $table = $('#btable'),
		    $markSent = $('#send-email'),
		    selections = [];

		// sometimes footer render error.
		setTimeout(function () {
			$table.bootstrapTable('resetView');
		}, 200);
		$table.on('check.bs.table uncheck.bs.table ' +
		                'check-all.bs.table uncheck-all.bs.table', function () {
		            $markSent.prop('disabled', !$table.bootstrapTable('getSelections').length);

		            // save your data, here just save the current page
		            selections = getIdSelections();
		            // push or splice the selections if you want to save all data selections
		        });
		$markSent.click(function () {
		    var ids = getIdSelections();
		    $base_url = $('#base-url').data('target'),
		    $url = $.trim( $base_url + 'index.php/invoices/mass_invoices_email' );
		    $this = $('#send-email');
		    swal({
		      title: $this.data('sure'),
		      text: $this.data('message'),
		      type: "warning",
		      showCancelButton: true,
		      confirmButtonClass: "btn-danger",
		      confirmButtonText: $this.data('confirm'),
		      cancelButtonText: $('#btn-cancel').data('text'),
		      closeOnConfirm: true
		    },
		    function(){ 
		        $.getJSON({
		            url: $url,
		            data: {
		                id: ids
		            },
		            success: function (data) {
		            	if (data.success > 0)
		            	{
		            		App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#send-email').data('success')});
		            		setTimeout(function () {
		            			$table.bootstrapTable('refresh', true);
		            		}, 200);
		            		$markSent.prop('disabled', true);
		            	}
		            	if(data.fail > 0)
		            	{
		            		App.alert({container: $('#notification-alert'), type: "danger", close: true, message: $('#send-email').data('danger') + ' ' + data.fail });
		            		setTimeout(function () {
		            			$table.bootstrapTable('refresh', true);
		            		}, 200);
		            		$markSent.prop('disabled', true);
		            	}
		            }
		        });
		    });
		});
		function getIdSelections() {
		    return $.map($table.bootstrapTable('getSelections'), function (row) {
		        return row.enc_proforma_number
		    });
		}
	},
	handleAutoComplete = function(){
		var i = $('table tr').length;
		var t = $('.additionalTax').length;
		var ids = [];
		
		var client_id = $('.invoice_to').val();
		if (client_id == 0)
		{
			credit = 0;
		} else {
			url = $.trim( $('#base-url').data('target') + 'index.php/clients/get_client_credit' );
			$.getJSON(url, {client_id : client_id}).done(function(data){
				credit = parseFloat(data);
				if (credit >= 0.01)
				{
					$("#client-credit").removeAttr("readonly");
					html = $('#c-available').data('text');
					$('#credit-available > span').removeClass('mydanger');
					$('#credit-available > span').text(html + credit).addClass('mysuccess');
				}
				else
				{
					$('#credit-available > span').removeClass('mysuccess');
					$('#credit-available > span').text("");
					$("#client-credit").val(parseFloat(0));
					$("#client-credit").attr("readonly","readonly");
				}
			});
		}
		var $user_currency = $('#money-format').data('symbol');
		var $displayDiscountValue = $('#display-discount').data('value');
		var $displayVatValue = $('#display-vat').data('value');
		if ( ! $displayDiscountValue )
		{
			$displayDiscount = ' class="hidden"';
		}
		else
		{
			$displayDiscount = '';
		}
		if ( ! $displayVatValue )
		{
			$displayVat = ' class="hidden"';
		}
		else
		{
			$displayVat = '';
		}
		url = $.trim( $('#base-url').data('target') + 'index.php/invoices/invoice_autocomplete' );
		var price = [];
		$.getJSON(url, function(data, status, xhr){
			if (status === 'success')
				prices = data;
		});
		$('#add-new-row').on('click', function(){
			newRow = '<tr>';
			newRow += '<td> <input type="text" data-type="itemSN" name="itemSN[]" id="itemSN_'+i+'" class="form-control autocomplete_txt itemSN" autocomplete="off" style="width: auto" /></td>';
			newRow += '<td> <input type="text" data-type="itemSku" name="itemSku[]" id="itemSku_'+i+'" class="form-control autocomplete_txt itemSku" autocomplete="off" style="width: auto" /></td>';
			newRow += '<td> <input type="text" data-type="itemName" name="itemName[]" id="itemName_'+i+'" class="form-control autocomplete_txt itemName" autocomplete="off" style="width: auto"> </td>';
			newRow += '<td> <input type="text" min="0" name="itemQuantity[]" id="itemQuantity_'+i+'" class="form-control changeNo" autocomplete="off" style="width: 65px;" onkeypress="return IsNumeric(event);" ondrop="return false;" onpaste="return false;" /> </td>';
			newRow += '<td> <input type="text" name="itemUom[]" id="itemUom_'+i+'" class="form-control" style="width: 50px" /> </td>';
			newRow += '<td> <div class="input-group"><span class="input-group-addon currency">' +$user_currency+ '</span><input type="text" min="0" name="itemPrice[]" id="itemPrice_'+i+'" class="form-control itemPrice changeNo" autocomplete="off" style="width: 100px;" onkeypress="return IsNumeric(event);" ondrop="return false;" onpaste="return false;" /> </div></td>';
			newRow += '<td> <div class="input-group"><span class="input-group-addon currency">' +$user_currency+ '</span><input type="text" min="0" step="0.01" name="itemAmountDiscount[]" id="itemAmountDiscount_'+i+'" class="form-control changeNo" style="width: 65px;" onkeypress="return IsNumeric(event);" ondrop="return false;" onpaste="return false;" /> <input type="hidden" disabled name="itemAmountDiscountAmount[]" id="itemAmountDiscountAmount_'+i+'" class="itemAmountDiscountAmount"/></div></td>';
			newRow += '<td> <div class="input-group"><span class="input-group-addon">%</span><input type="text" min="0" step="0.01" name="itemDiscount[]" id="itemDiscount_'+i+'" class="form-control changeNo" style="width: 65px;" onkeypress="return IsNumeric(event);" ondrop="return false;" onpaste="return false;" /> <input type="hidden" disabled name="itemDiscountAmount[]" id="itemDiscountAmount_'+i+'" class="itemDiscountAmount"/></div></td>';
			newRow += '<td> <div class="input-group"><span class="input-group-addon">%</span><input type="text" min="0" step="0.01" name="itemTax[]" id="itemTax_'+i+'" class="form-control changeNo" style="width: 65px;" onkeypress="return IsNumeric(event);" ondrop="return false;" onpaste="return false;" /></div><input type="hidden" disabled name="itemTaxAmount[]" id="itemTaxAmount_'+i+'" class="itemTaxAmount"/></td>';
			newRow += '<td> <div class="input-group"><span class="input-group-addon currency">' +$user_currency+ '</span><input type="text" name="itemSubTotal[]" id="itemSubTotal_'+i+'" class="form-control itemSubTotal" readonly="readonly" autocomplete="off" style="width: 100px;"> </div></td>';
			newRow += '<td>  <a href="javascript:;" class="btn btn-sm btn-danger delete_item"><i class="icon-trash"></i><input type="hidden" class="autocomplete_txt itemID" name="itemID[]" id="itemID_'+i+'"></td>';
			newRow += '</tr>';

			$('table').append(newRow);
			i++;
			
		});
		$(document).on('click', '#add-additional-taxes', function(){
			$( ".additionalTaxes" ).prop( "checked", function( i, val ) {
				if (val == true) {
					var $this = $(this);
					if (ids.indexOf($this.data('id')) < 0 ) {
						$html = '<div class="col-sm-6"></div><div class="col-sm-6"><div class="form-group"><label class="control-label col-sm-4">'+$this.data('name')+'</label><div class="col-sm-8"><div class="input-group"><span class="input-group-addon">%</span><input type="text" name="additional_taxes[]" id="additionaltax_'+t+'" data-name="'+$this.data('name')+'" data-rate="'+$this.data('value')+'" data-criteria="'+$this.data('criteria')+'" value="'+$this.data('value')+'" class="form-control additionalTax" /><input type="hidden" name="additional_taxes_ID[]" value="'+$this.data('id')+'" class="additional_taxes_ID" /><input type="hidden" name="additional_taxes_values[]" id="additionaltaxValue_'+t+'" class="additionaltaxValues" /></div></div></div></div>';
						$('.additionalTaxFields').append($html);
						t++;
						ids.push($this.data('id'));
					}
				}
			});
			$("#add-invoice-tax-modal").modal('hide');
			$('#add-invoice-tax-modal').on('hidden.bs.modal', function() {
			    $('.additionalTaxes').iCheck('uncheck');
			    calculateTotal();
			});
		});
		$(document).on('click', 'a.delete_item', function(){
			$(this).parents('tr').remove();
			calculateTotal();
		});

		// Autocomplete
		$(document).on('focus', '.autocomplete_txt', function(){
			client_id = $('.invoice_to').val();
			if (client_id == 0)
			{
				credit = 0;
			}
			var $type = $(this).data('type');
			if($type == 'itemSku')
				var autoTypeNo = 0;
			if($type == 'itemName')
				autoTypeNo = 1;
			if($type == 'itemSN')
				autoTypeNo = 11;
			$(this).autocomplete({
				source: function( request, response ){
					var array = $.map(prices, function(item){
						var code = item.split('|');
						return {
							label: code[autoTypeNo],
							value: code[autoTypeNo],
							data: item
						}
					});
					response($.ui.autocomplete.filter(array, request.term));
				},
				autoFocus: true,
				minLength: 1,
				select: function(event, ui) {
					var names = ui.item.data.split('|'),
					id_arr = $(this).attr('id'),
					id = id_arr.split('_');

					globalDiscount = $('#globalDiscount').val();
					if (globalDiscount != '' && globalDiscount > 0)
					{
						discount = globalDiscount;
						$('#itemDiscount_'+id[1]).prop('readonly', true);
					}
					else
					{
						discount = 0;
						$('#itemDiscount_'+id[1]).prop('readonly', false);
					}
					if(names)
					{
						if(names[3] == '')
						{
							names[3] = 0.00;
						}
						if(names[7] == '')
						{
							names[7] = 0.00;
						}
						if(names[8] == '')
						{
							names[8] = 0.00;
						}
						if(names[9] == '')
						{
							names[9] = 0.00;
						}
						if(names[10] == '')
						{
							names[10] = 0.00;
						}
						$('#itemSku_'+id[1]).val(names[0]);
						$('#itemID_'+id[1]).val(names[4]);
						$('#itemName_'+id[1]).val(names[1]);
						$('#itemQuantity_'+id[1]).val(1);
						$('#itemPrice_'+id[1]).val( parseFloat(names[2]) );
						$('#itemTax_'+id[1]).val(names[3]);
						$('#itemUom_'+id[1]).val(names[5]); // Unit of measure
						$('#itemDiscount_'+id[1]).val(discount);
						$('#itemSubTotal_'+id[1]).val( parseFloat((1 * names[2]) - (1 * names[2] * discount / 100)) );
						$('#itemTaxAmount_'+id[1]).val( parseFloat(names[2]) * parseFloat(names[3]) / 100 );
					}
					calculateTotal();
				}
			});
		});

		$(document).on('change blur', '.changeNo', function(){
			id_arr = $(this).attr('id');
			id = id_arr.split('_');

			var quantity = $('#itemQuantity_'+id[1]).val();
			var price = $('#itemPrice_'+id[1]).val();
			var itemDiscount = $('#itemDiscount_'+id[1]).val();
			var itemAmountDiscount = $('#itemAmountDiscount_'+id[1]).val();

			if (itemDiscount == "" || typeof(itemDiscount) == 'undefined') {
				$('#itemDiscount_'+id[1]).val(0);
			}

			if (itemAmountDiscount == "" || typeof(itemAmountDiscount) == 'undefined') {
				$('#itemAmountDiscount_'+id[1]).val(0);
			}

			if (itemAmountDiscount > 0) {
				$percentage = (itemAmountDiscount * 100) /price;
				$('#itemDiscount_'+id[1]).val($percentage);
			}
			
			if( quantity != '' && price != '' )
			{
				if( $('#itemDiscount_'+id[1]).val() != '')
				{
					var itemDiscount = $('#itemDiscount_'+id[1]).val();
				}
				else
				{
					itemDiscount = 0;
					$('#itemDiscount_'+id[1].val(0));
				}
				$('#itemSubTotal_'+id[1]).val( (parseFloat(price) * parseFloat(quantity) - (parseFloat(price) * parseFloat(quantity) * parseFloat(itemDiscount) / 100) ));
				var itemSubTotal = $('#itemSubTotal_'+id[1]).val();
				var itemTax = $('#itemTax_'+id[1]).val();

				if (itemTax == "" || typeof(itemTax) == 'undefined') {
					$('#itemTax_'+id[1]).val(0);
				}
				
				if( itemTax != '')
				{
					$('#itemTaxAmount_'+id[1]).val( (parseFloat(itemSubTotal) * parseFloat(itemTax) /100 ) );
					$('#taxAmount').val( (parseFloat(itemSubTotal) * parseFloat(itemTax) / 100 ) );

				}
				if( itemDiscount != '')
				{
					$('#itemDiscountAmount_'+id[1]).val( (price * quantity * itemDiscount ) /100 );
					$('#discountAmount').val( (price * quantity * itemDiscount ) /100 );
				}
				calculateTotal();
			}
		});

		// $(document).on('change', '#amountPaid', function(){
		// 	calculateAmountDue();
		// });
		$(document).on('change blur', '.additionalTax', function(){
			calculateTotal();
		});
		$(document).on('change blur', '#client-credit', function(){
			$amountDue = $(".amountDue").val();
			if ($amountDue > 0) {
				calculateAmountDue();
			}
		});
		// $(document).on('focus', '#amountPaid', function(){
		// 	$('#amountPaid').val($('.amountDue').val());
		// 	calculateAmountDue();
		// });
		$(document).on('change blur', '#globalDiscount', function(){
			globalDiscount = $(this).val();
			if (globalDiscount != '' && globalDiscount > 0)
			{
				discount = globalDiscount;
			}
			else
			{
				discount = 0;
			}
			$('.changeNo').each(function(){
				id_arr = $(this).attr('id');
				id = id_arr.split('_');

				var quantity = $('#itemQuantity_'+id[1]).val();
				var price = $('#itemPrice_'+id[1]).val();

				var itemDiscount = $('#itemDiscount_'+id[1]).val();

				if (itemDiscount == "" || typeof(itemDiscount) == 'undefined') {
					$('#itemDiscount_'+id[1]).val(0);
				}

				if (discount != '')
				{
					$('#itemDiscount_'+id[1]).prop('readonly', true);
				}
				else
				{
					$('#itemDiscount_'+id[1]).prop('readonly', false);
				}
				$('#itemDiscount_'+id[1]).val(discount);

				if( quantity != '' && price != '' )
				{
					if( $('#itemDiscount_'+id[1]).val() != '')
					{
						var itemDiscount = $('#itemDiscount_'+id[1]).val();
					}
					else
					{
						itemDiscount = 0;
						$('#itemDiscount_'+id[1].val(0));
					}
					$('#itemSubTotal_'+id[1]).val( (parseFloat(price) * parseFloat(quantity) - (parseFloat(price) * parseFloat(quantity) * parseFloat(itemDiscount) / 100) ));
					var itemSubTotal = $('#itemSubTotal_'+id[1]).val();
					var itemTax = $('#itemTax_'+id[1]).val();

					if (itemTax == "" || typeof(itemTax) == 'undefined') {
						$('#itemTax_'+id[1]).val(0);
					}
					

					if( itemTax != '')
					{
						$('#itemTaxAmount_'+id[1]).val( (parseFloat(itemSubTotal) * parseFloat(itemTax) /100 ) );
						$('#taxAmount').val( (parseFloat(itemSubTotal) * parseFloat(itemTax) / 100 ) );

					}

					if( itemDiscount != '')
					{
						$('#itemDiscountAmount_'+id[1]).val( (price * quantity * itemDiscount ) /100 );
						$('#discountAmount').val( (price * quantity * itemDiscount ) /100 );

					}
					else
					{
						$('#itemDiscountAmount_'+id[1]).val(0);
						$('#discountAmount').val(0);
					}
					calculateTotal();
				}
			});
		});
		$(document).on('change', '.invoice_to', function(){
			credit = 0;
			client_id = $('.invoice_to').val();
			url2 = $.trim( $('#base-url').data('target') + 'index.php/clients/get_client_duedate' );
			$.getJSON(url2, {client_id : client_id}).done(function(data){
			    $('#default-duedate').data('value', parseInt(data));
			    DatePicker.init();
			});
			multiCurrencySupport = $('#multicurrency-support').data('value');
			if (client_id == 0)
			{
				credit = 0;
				$('#credit-available > span').removeClass('mysuccess');
				$('#credit-available > span').text("");
				$("#client-credit").attr("readonly","readonly");
			}
			else
			{
				url = $.trim( $('#base-url').data('target') + 'index.php/clients/get_client_credit' );
				if ( multiCurrencySupport )
				{
					clientCurrencyUrl = $.trim( $('#base-url').data('target') + 'index.php/client/get_client_currency');
					$.getJSON(url, {client_id : client_id}).done(function(data){
						credit = parseFloat(data);
						if (credit >= 0.01)
						{
							$("#client-credit").removeAttr("readonly");
							html = $('#c-available').data('text');
							$('#credit-available > span').removeClass('mydanger');
							$('#credit-available > span').text(html + credit).addClass('mysuccess');
						}
						else
						{
							$('#credit-available > span').removeClass('mysuccess');
							$('#credit-available > span').text("");
							$("#client-credit").val(parseFloat(0));
							$("#client-credit").attr("readonly","readonly");
						}
					});
					$.getJSON(clientCurrencyUrl, {client_id : client_id}).done(function(data){
						clientCurrencyStr = data.currency_str;
						clientCurrencySymb = data.currency_symb;
						changeRate = data.change_rate;
						$('#changerate').val(changeRate);
						$('#clientchangerate').val(changeRate);
						latestChangeRate = $('#latestchangerate').data('message').replace(/%s/g, changeRate);
						clientCurrencyNotification = $('#clientcurrencywarning').data('message').replace(/%s/g, clientCurrencyStr + ' (' + clientCurrencySymb + ' ' +latestChangeRate + ')');
						toastr.options = {
						  "closeButton": true,
						  "debug": false,
						  "newestOnTop": true,
						  "progressBar": true,
						  "positionClass": "toast-top-right",
						  "preventDuplicates": true,
						  "onclick": null,
						  "showDuration": "300",
						  "hideDuration": "1000",
						  "timeOut": "5000",
						  "extendedTimeOut": "1000",
						  "showEasing": "swing",
						  "hideEasing": "linear",
						  "showMethod": "fadeIn",
						  "hideMethod": "fadeOut"
						}
						if (changeRate != 1)
						{
							toastr.info(clientCurrencyNotification, "");
						}
					});
				}
				else
				{
					$.getJSON(url, {client_id : client_id}).done(function(data){
						credit = parseFloat(data);
						if (credit >= 0.01)
						{
							$("#client-credit").removeAttr("readonly");
							html = $('#c-available').data('text');
							$('#credit-available > span').removeClass('mydanger');
							$('#credit-available > span').text(html + credit).addClass('mysuccess');
						}
						else
						{
							$('#credit-available > span').removeClass('mysuccess');
							$('#credit-available > span').text("");
							$("#client-credit").val(parseFloat(0));
							$("#client-credit").attr("readonly","readonly");
						}
					});
				}
			}
		});
	},
	setDate = function(){
		var currentDate = new Date(),
			dueDate = currentDate.setDate(currentDate.getDate() + $("#default-duedate").data("value")),
			$locale = $('#user-language').data('language');
		switch($locale) {
		    case "french":
                $locale = "fr";
                break;
            case "swedish":
                $locale = "sv";
                break;
            case "german":
                $locale = "de";
                break
            case "russian":
                $locale = "ru";
                break
            case "spanish":
                $locale = "es";
                break
            case "english":
                $locale = "en-GB";
                break
            case "italian":
                $locale = "it";
                break
            case "dutch":
                $locale = "nl";
                break
            case "arabic":
                $locale = "ar-sa";
                break
            default:
                $locale = "en-GB";
		}
		$('.datepicker').datepicker({
			language: $.trim($locale),
			autoclose: true,
			todayHighlight: true
		});
		$('.due_date').datepicker({
			language: $.trim($locale),
			autoclose: true,
			todayHighlight: true
		});
		$('.datepicker-edit').datepicker({
			language: $.trim($locale),
			autoclose: true,
			todayHighlight: true
		});
		$(".datepicker").datepicker("setDate", currentDate);
		$(".due_date").datepicker("setDate", currentDate);
		$(".datepicker-edit").datepicker();
	},
	serverResponse = function(responseText, statusText, xhr, $form){
		if(responseText.status == 1)
		{
			App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#btn-create-proforma').data('message')});
			setTimeout(function(){
			   window.location.reload();
			}, 3000);
		}
		else
		{
			message = responseText.error;
			message = message.replace(/<\/?p[^>]*>/g, "");
			if( message != '')
			{
				App.alert({container: $('#notification-alert'), type: "danger", close: true, message: message});
			}
			else
			{
				App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#default-update-success').data('message')});
			}
			$("#btn-create-proforma").removeAttr("disabled");
			$(".btn-submit").text($('#btn-save').data('text'));
		}
	},
	updateProformaServerResponse = function(responseText, statusText, xhr, $form){

		if(responseText.status == 1)
		{
			App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#btn-update-invoice').data('message')});
			setTimeout(function () {
				window.location.reload();
			}, 3000);
		}
		else
		{
			message = responseText.error;
			message = message.replace(/<\/?p[^>]*>/g, "");
			if( message != '')
			{
				App.alert({container: $('#notification-alert'), type: "danger", close: true, message: message});
			}
			else
			{
				App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#default-update-success').data('message')});
			}
			$(".btn-submit").removeAttr("disabled");
			$(".btn-submit").text($('#btn-save').data('text'));
		}
	},
	calculateTotal = function(){
		var taxAmount = 0,
			discountAmount = 0,
			subTotal = 0,
			surchargeTotal = 0,
			deductTotal = 0,
			total = 0;
		$('.itemSubTotal').each(function() {
			if( $(this).val() != '' )
			{
				subTotal += parseFloat( $(this).val() );
			}
		});

		$('.itemTaxAmount').each(function() {
			if( $(this).val() != '')
			{
				taxAmount += parseFloat( $(this).val() );
			}
		});
		$('.itemDiscountAmount').each(function() {
			if( $(this).val() != '')
			{
				discountAmount += parseFloat( $(this).val() );
			}
		});

		$('#subTotal').val( subTotal );
		$('#taxAmount').val( taxAmount );
		$('#discountAmount').val( discountAmount );

		var surchargeTotal = 0;
		var deductTotal = 0;

		$('.additionaltaxValues').each(function(){
			id_arr = $(this).attr('id');
			id = id_arr.split('_');
			var criteria = $('#additionaltax_'+id[1]).data('criteria');
			var rate = parseFloat($('#additionaltax_'+id[1]).val());

			if (criteria == 'add_after_all_taxes') {
				surchargeTotal = (subTotal + taxAmount) * rate /100;
				$('#additionaltaxValue_'+id[1]).val(surchargeTotal);
			}
			if (criteria == 'deduct_after_all_taxes') {
				deductTotal = ((subTotal + taxAmount + surchargeTotal) * rate /100);
				$('#additionaltaxValue_'+id[1]).val(deductTotal);
			}
		});

		total = (subTotal + taxAmount + surchargeTotal) - deductTotal;

		$('#totalAftertax').val( total );
		$('#items_subTotal').val( subTotal );

		calculateAmountDue();
	},
	calculateAmountDue = function(){
		client_id = $('.invoice_to').val();
		if (client_id == 0)
		{
			credit = 0;
		}
		var amountPaid = $('#amountPaid').val(),
			credit_used = $('#client-credit').val(),
			total = $('#totalAftertax').val();
			if (credit_used == "" || typeof(credit_used) == "undefined")
			{
				credit_used = 0.00;
			}
		if( amountPaid != '' && typeof(amountPaid) != "undefined")
		{
			amountDue = parseFloat(total) - parseFloat( amountPaid ) - parseFloat( credit_used );
			$('.amountDue').val( amountDue );
			credit_remaining = parseFloat(credit - credit_used);
			if (credit_remaining > 0)
			{
				html = $('#c-available').data('text');
				$('#credit-available > span').text(html + credit_remaining).addClass('mysuccess');
			}
			else
			{
				html = $('#c-available').data('text');
			$('#credit-available > span').text(html + credit_remaining).addClass('mydanger');
			}
		}
		else
		{
			total = parseFloat(total) - parseFloat(credit_used);
			if (total < 0)
			{
				$('.amountDue').val(parseFloat(total)).addClass('mydanger');
			}
			else
			{
				$('.amountDue').removeClass('mydanger');
				$('.amountDue').val(parseFloat(total));
			}
			credit_remaining = parseFloat(credit - credit_used);
			if (credit_remaining > 0)
			{
				html = $('#c-available').data('text');
				$('#credit-available > span').removeClass('mydanger');
				$('#credit-available > span').text(html + credit_remaining).addClass('mysuccess');
			}
			else
			{
				html = $('#c-available').data('text');
				$('#credit-available > span').text(html + credit_remaining).addClass('mydanger');
			}
		}
	},
	handleProformaTemplates = function () {
		if ($('#tpl_proforma_generated').length != 0) {
			$locale = $('#user-language').data('language');
			switch($locale) {
			    case "french":
			        $locale = 'fr-FR';
			        break;
			    case "german":
			        $locale = 'de-DE';
			        break;
			    case "russian":
			        $locale = 'ru-RU';
			        break;
			    case "romanian":
			        $locale = 'ro';
			        break;
			    case "spanish":
			        $locale = 'es-ES';
			        break;
			    case "english":
			        $locale = 'en-US';
			        break;
			    case "dutch":
			        $locale = 'nl-NL';
			        break;
			    case "greek":
			        $locale = 'el-EL';
			        break;
			    case "arabic":
			        $locale = 'ar-AR';
			        break;
			    default:
			        $locale = "en-US";
			        break;
			}
			$('#tpl_proforma_generated').summernote({
			    height: 300,
			    lang: $locale
			});
			$('#tpl_proforma_terms').summernote({
			    height: 300,
			    lang: $locale
			});
			$('#tpl_footer').summernote({
			    height: 300,
			    lang: $locale
			});
			//API:
			url = $('#base-url').data('target') + 'index.php/settings/ajax/get_proforma_generated_tpl';
			url2 = $('#base-url').data('target') + 'index.php/settings/ajax/get_proforma_term_tpl';
			url3 = $('#base-url').data('target') + 'index.php/settings/ajax/get_proforma_footer_tpl';

			$.getJSON(url, function(data){
			    $('#tpl_proforma_generated').summernote('code', data);
			});
			$.getJSON(url2, function(data){
			    $('#tpl_proforma_terms').summernote('code', data);
			});
			$.getJSON(url3, function(data){
			    $('#tpl_footer').summernote('code', data);
			    $('#save-proforma-templates').removeAttr("disabled");
			});
		}
    },
    handleProformaTemplatesChanges = function(){
        $('#save-proforma-templates').on('click', function(){
           url = $('#base-url').data('target') + 'index.php/settings/ajax/set_proforma_templates';
           $.post( url, { tpl_proforma_generated: $('#tpl_proforma_generated').summernote('code'), tpl_proforma_terms: $('#tpl_proforma_terms').summernote('code'), tpl_footer: $('#tpl_footer').summernote('code'), delete_once_invoiced: $('#delete_once_invoiced').val(), delete_once_merged: $('#delete_once_merged').val() }, function(data){
            App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#default-update-success').data('message')});
            $(".btn-submit").removeAttr("disabled");
           });
        });
    },
    nextProformaNumber = function(){
    	url = $('#base-url').data('target') + 'index.php/proforma/next_proforma_number';
    	$.getJSON(url, function(data){
    		if (data) {
    			$('#proforma_number').val(data);
    			$('#btn-create-proforma').removeAttr("disabled");
    		}
    	});
    },
    handleDeleteProforma = function(){
		var $table = $('#proformatable'),
		    $remove = $('#remove-proforma'),
		    selections = [];

		// sometimes footer render error.
		setTimeout(function () {
			$table.bootstrapTable('resetView');
		}, 200);
		$table.on('check.bs.table uncheck.bs.table ' +
		                'check-all.bs.table uncheck-all.bs.table', function () {
		            $remove.prop('disabled', !$table.bootstrapTable('getSelections').length);

		            // save your data, here just save the current page
		            selections = getIdSelections();
		            // push or splice the selections if you want to save all data selections
		        });
		$remove.click(function () {
		    var ids = getIdSelections();
		    $base_url = $('#base-url').data('target'),
		    $url = $.trim( $base_url + 'index.php/proforma/delete_proforma' );
		    $this = $('#remove-proforma');
		    swal({
		      title: $this.data('sure'),
		      text: $this.data('message'),
		      type: "warning",
		      showCancelButton: true,
		      confirmButtonClass: "btn-danger",
		      confirmButtonText: $this.data('confirm'),
		      cancelButtonText: $('#btn-cancel').data('text'),
		      closeOnConfirm: true
		    },
		    function(){ 
		        $.getJSON({
		            url: $url,
		            data: {
		                id: ids
		            },
		            success: function (data) {
		            	if (data.success > 0)
		            	{
		            		$table.bootstrapTable('remove', {
		            		    field: 'enc_proforma_number',
		            		    values: ids
		            		});
		            		App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#remove-proforma').data('success')});
		            		$remove.prop('disabled', true);
		            	}
		            	if(data.fail > 0)
		            	{
		            		App.alert({container: $('#notification-alert'), type: "danger", close: true, message: $('#remove-proforma').data('danger') + ' ' + data.fail });
		            		setTimeout(function () {
		            			$table.bootstrapTable('refresh', true);
		            		}, 200);
		            		$remove.prop('disabled', true);
		            	}
		            }
		        });
		    });
		});
		function getIdSelections() {
		    return $.map($table.bootstrapTable('getSelections'), function (row) {
		        return row.enc_proforma_number
		    });
		}
	},
	handleConvertToInvoice = function(){
		var $table = $('#proformatable'),
		    $invoice = $('#generate-invoice'),
		    selections = [];

		// sometimes footer render error.
		setTimeout(function () {
			$table.bootstrapTable('resetView');
		}, 200);
		$table.on('check.bs.table uncheck.bs.table ' +
		                'check-all.bs.table uncheck-all.bs.table', function () {
		            $invoice.prop('disabled', !$table.bootstrapTable('getSelections').length);

		            // save your data, here just save the current page
		            selections = getIdSelections();
		            // push or splice the selections if you want to save all data selections
		        });
		$invoice.click(function () {
		    var ids = getIdSelections();
		    $base_url = $('#base-url').data('target'),
		    $url = $.trim( $base_url + 'index.php/proforma/convert_to_invoice' );
		    $this = $('#generate-invoice');
		    swal({
		      title: $this.data('sure'),
		      text: $this.data('message'),
		      type: "warning",
		      showCancelButton: true,
		      confirmButtonClass: "btn-danger",
		      confirmButtonText: $this.data('confirm'),
		      cancelButtonText: $('#btn-cancel').data('text'),
		      closeOnConfirm: true
		    },
		    function(){ 
		        $.getJSON({
		            url: $url,
		            data: {
		                id: ids
		            },
		            success: function (data) {
		            	if (data.success > 0)
		            	{
		            		App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#generate-invoice').data('success')});
		            		$invoice.prop('disabled', true);
		            		if (data.post_delete) {
		            			$table.bootstrapTable('remove', {
		            			    field: 'enc_proforma_number',
		            			    values: ids
		            			});
		            		} else {
		            			setTimeout(function () {
		            				$table.bootstrapTable('refresh', true);
		            			}, 200);
		            		}
		            	}
		            	if(data.fail > 0)
		            	{
		            		App.alert({container: $('#notification-alert'), type: "danger", close: true, message: $('#generate-invoice').data('danger') + ' ' + data.fail });
		            		setTimeout(function () {
		            			$table.bootstrapTable('refresh', true);
		            		}, 200);
		            		$invoice.prop('disabled', true);
		            	}
		            }
		        });
		    });
		});
		function getIdSelections() {
		    return $.map($table.bootstrapTable('getSelections'), function (row) {
		        return row.enc_proforma_number
		    });
		}
	},
	handleMassEmailProforma = function(){
		var $table = $('#proformatable'),
		    $markSent = $('#send-email'),
		    selections = [];

		// sometimes footer render error.
		setTimeout(function () {
			$table.bootstrapTable('resetView');
		}, 200);
		$table.on('check.bs.table uncheck.bs.table ' +
		                'check-all.bs.table uncheck-all.bs.table', function () {
		            $markSent.prop('disabled', !$table.bootstrapTable('getSelections').length);

		            // save your data, here just save the current page
		            selections = getIdSelections();
		            // push or splice the selections if you want to save all data selections
		        });
		$markSent.click(function () {
		    var ids = getIdSelections();
		    $base_url = $('#base-url').data('target'),
		    $url = $.trim( $base_url + 'index.php/proforma/mass_proforma_email' );
		    $this = $('#send-email');
		    swal({
		      title: $this.data('sure'),
		      text: $this.data('message'),
		      type: "warning",
		      showCancelButton: true,
		      confirmButtonClass: "btn-danger",
		      confirmButtonText: $this.data('confirm'),
		      cancelButtonText: $('#btn-cancel').data('text'),
		      closeOnConfirm: true
		    },
		    function(){ 
		        $.getJSON({
		            url: $url,
		            data: {
		                id: ids
		            },
		            success: function (data) {
		            	if (data.success > 0)
		            	{
		            		App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#send-email').data('success')});
		            		setTimeout(function () {
		            			$table.bootstrapTable('refresh', true);
		            		}, 200);
		            		$markSent.prop('disabled', true);
		            	}
		            	if(data.fail > 0)
		            	{
		            		App.alert({container: $('#notification-alert'), type: "danger", close: true, message: $('#send-email').data('danger') + ' ' + data.fail });
		            		setTimeout(function () {
		            			$table.bootstrapTable('refresh', true);
		            		}, 200);
		            		$markSent.prop('disabled', true);
		            	}
		            }
		        });
		    });
		});
		function getIdSelections() {
		    return $.map($table.bootstrapTable('getSelections'), function (row) {
		        return row.enc_proforma_number
		    });
		}
	};
	return {
		init: function(){
			handleProformaForm(),
			handleAutoComplete(),
			handleUpdateProforma(),
			handleSelectClient(),
			handleProformaTemplates(),
			handleProformaTemplatesChanges(),
			handleMassEmailProforma(),
			handleMergeProforma(),
			nextProformaNumber()
		}
	}
})(jQuery);
jQuery(document).ready(function() {
	Proforma.init()
});
