var Providers = (function($){
	var handleAddProvider = function(){
		var options = {
			dataType: 'json',
			success: addProviderFormServerResponse
		};
		$("#provider-add-form").submit(function() {
			$(".btn-submit").attr("disabled","disabled");
			$(this).ajaxSubmit(options);	
			return false;
		});
	},
	handleProviderPassword = function(){
		var hasPassword = $('#has_password').data('value');
		var passwordMessage = $('#password_message').data('value');
		var pwdVerified = $('#has_password').data('pwdverified');
		var provider_id = $('#provider_id').data('value');
 		checkPwdUrl = $("#base-url").data('target') + 'index.php/provider/check_password';
		if (hasPassword === 1 && pwdVerified !== 1)
		{
			bootbox.prompt({
			    title: passwordMessage,
			    inputType: 'password',
			    callback: function (result) {
			    	if (result)
			    	{
			    		$.getJSON(checkPwdUrl, {provider_id: provider_id, password: result}, function(data){
			    			if(data.success == 1)
			    			{
			    				$('#provider-view').removeClass('hidden');
			    				$('#frontend-provider-view').removeClass('hidden');
			    			}
			    			else if(data.success == 0)
			    			{
			    				location.reload();
			    			}
			    		});
			    	}
			    	else
			    	{
			    		location.reload();
			    	}
			    }
			});
		}
		else
		{
			$('#provider-view').removeClass('hidden');
			$('#frontend-provider-view').removeClass('hidden');
		}
	},
	handlePurchaseByProvider = function(){
		var url = $('.actions').data('target'),
			$range = 'this_month',
			$id = $('.actions').data('providerid');
		$.getJSON(url, {id: $id, range: $range}).done(function(data){
			$('#income-by-provider').text(accounting.formatMoney(parseFloat(data[0])));
			$('#unpaid-by-provider').text(accounting.formatMoney(parseFloat(data[1])));
			$('#range').text($('#this_month').text());
		});
		$('.income-by-provider').on('click', function(){
			var $this = $(this),
				url = $('.actions').data('target'),
				$range = $this.data('range'),
				$id = $('.actions').data('providerid');
			$.getJSON(url, {id: $id, range: $range}).done(function(data){
				$('#income-by-provider').text(accounting.formatMoney(parseFloat(data[0])));
				$('#unpaid-by-provider').text(accounting.formatMoney(parseFloat(data[1])));
				$('#range').text($this.text());
			});
		});
	},
	handleHideShowProviderFields = function() {
	    $('#add-contact').change(function() {
	        var $input = $(this);
	        if ($input.prop("checked")) 
	        {
	            $('#contact-div').removeClass('hidden');
	        } 
	        else 
	        {
	            $('#contact-div').removeClass('hidden');
	            $('#contact-div').addClass('hidden');
	        }
	    });
	    $('#add-address').change(function() {
	        var $input = $(this);
	        if ($input.prop("checked")) 
	        {
	            $('#add-address-div').removeClass('hidden');
	        } 
	        else 
	        {
	            $('#add-address-div').removeClass('hidden');
	            $('#add-address-div').addClass('hidden');
	        }
	    });
	},
	addProviderFormServerResponse = function(responseText, statusText, xhr, $form){
		if(responseText.status == 1)
		{
			App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#default-save-success').data('message')});
			$(".btn-submit").removeAttr("disabled");
			$(".btn-submit").text($('#btn-save').data('text'));
		}
		else
		{
			message = responseText.error;
			message = message.replace(/<\/?p[^>]*>/g, "");
			if( message != '')
			{
				App.alert({container: $('#notification-alert'), type: "danger", close: true, message: message});
			}
			else
			{
				App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#default-update-success').data('message')});
			}
			$(".btn-submit").removeAttr("disabled");
			$(".btn-submit").text($('#btn-save').data('text'));
		}
	};
	return {
		init: function(){
			handleAddProvider(),
			handlePurchaseByProvider(), 
			handleHideShowProviderFields(),
			handleProviderPassword()
		}
	}
})(jQuery);
jQuery(document).ready(function() {
    Providers.init()
    type = $('#provider-type').val();
    if (type == 1)
    {
    	$('.professional').addClass('hidden');
    }
    $(document).on('change', '#provider-type', function(){
    	type = $(this).val();
    	if (type == 1)
    	{
    		$('.professional').addClass('hidden');
    	}
    	if(type == 2)
    	{
    		$('.professional').removeClass('hidden');
    	}
    });
});
