var Purchases = (function($){
    var handlePurchaseForm = function(){
        var options = {
            dataType:  'json',
            success: serverResponse
        };
        $('#create-purchase-form').submit(function(){

            // Prevent 2 or more submissions
            $("#btn-create-purchase").attr("disabled","disabled");
            $('#create-purchase-form').ajaxSubmit(options);
            return false; 
        });
    },
    handleSelectClient = function(){
        $('.invoice_to').each(function(){
            var $base_url = $('#base-url').data('target'),
                $url = $.trim( $base_url + 'index.php/providers/get_active_providers' );

            $.getJSON( $url, function(response){
                var stringified = JSON.stringify(response);
                stringified = stringified.replace(/provider_id/g, 'id');
                stringified = stringified.replace(/name_company/g, 'text');
                var data = JSON.parse(stringified);
                $('.invoice_to').select2({
                    data: data
                })
            });
        });
    },
    handleSelectShippingAddress = function(){
        $('.companyshippingaddress').each(function(){
            var $base_url = $('#base-url').data('target'),
                $url = $.trim( $base_url + 'index.php/purchases/get_shipping_addresses' );

            $.getJSON( $url, function(response){
                var stringified = JSON.stringify(response);
                stringified = stringified.replace(/id/g, 'id');
                stringified = stringified.replace(/name_company/g, 'text');
                var data = JSON.parse(stringified);
                $('.companyshippingaddress').select2({
                    data: data
                })
            });
        });
    },
    handleUpdatePurchase = function(){
        var options = {
            dataType:  'json',
            success: updateInvoiceServerResponse
        };
        $('#update-purchase-form').submit(function(){
            $('#update-purchase-form').ajaxSubmit(options);
            return false; 
        });
    },
    handleDeletePurchase = function(){
        var $table = $('#purchaseTable'),
            $remove = $('#remove-purchase'),
            selections = [];

        // sometimes footer render error.
        setTimeout(function () {
            $table.bootstrapTable('resetView');
        }, 200);
        $table.on('check.bs.table uncheck.bs.table ' +
                        'check-all.bs.table uncheck-all.bs.table', function () {
                    $remove.prop('disabled', !$table.bootstrapTable('getSelections').length);

                    // save your data, here just save the current page
                    selections = getIdSelections();
                    // push or splice the selections if you want to save all data selections
                });
        $remove.click(function () {
            var ids = getIdSelections();
            $base_url = $('#base-url').data('target'),
            $url = $.trim( $base_url + 'index.php/purchases/delete_purchase' );
            $this = $('#remove-purchase');
            swal({
              title: $this.data('sure'),
              text: $this.data('message'),
              type: "warning",
              showCancelButton: true,
              confirmButtonClass: "btn-danger",
              confirmButtonText: $this.data('confirm'),
              cancelButtonText: $('#btn-cancel').data('text'),
              closeOnConfirm: true
            },
            function(){ 
                $.getJSON({
                    url: $url,
                    data: {
                        id: ids
                    },
                    success: function (data) {
                        if (data.success > 0)
                        {
                            $table.bootstrapTable('remove', {
                                field: 'enc_purchase_number',
                                values: ids
                            });
                            App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#remove-purchase').data('success')});
                            $remove.prop('disabled', true);
                        }
                        if(data.fail > 0)
                        {
                            App.alert({container: $('#notification-alert'), type: "danger", close: true, message: $('#remove-purchase').data('danger') + ' ' + data.fail });
                            setTimeout(function () {
                                $table.bootstrapTable('refresh', true);
                            }, 200);
                            $remove.prop('disabled', true);
                        }
                    }
                });
            });
        });
        function getIdSelections() {
            return $.map($table.bootstrapTable('getSelections'), function (row) {
                return row.enc_purchase_number
            });
        }
    },
    handleMassPayment = function(){
        var $table = $('#purchaseTable'),
            $markPaid = $('#mark-paid'),
            selections = [];

        // sometimes footer render error.
        setTimeout(function () {
            $table.bootstrapTable('resetView');
        }, 200);
        $table.on('check.bs.table uncheck.bs.table ' +
                        'check-all.bs.table uncheck-all.bs.table', function () {
                    $markPaid.prop('disabled', !$table.bootstrapTable('getSelections').length);

                    // save your data, here just save the current page
                    selections = getIdSelections();
                    // push or splice the selections if you want to save all data selections
                });
        $markPaid.click(function () {
            var ids = getIdSelections();
            $base_url = $('#base-url').data('target'),
            $url = $.trim( $base_url + 'index.php/purchases/mark_paid' );
            $this = $('#mark-paid');
            swal({
              title: $this.data('sure'),
              text: $this.data('message'),
              type: "warning",
              showCancelButton: true,
              confirmButtonClass: "btn-danger",
              confirmButtonText: $this.data('confirm'),
              cancelButtonText: $('#btn-cancel').data('text'),
              closeOnConfirm: true
            },
            function(){ 
                $.getJSON({
                    url: $url,
                    data: {
                        id: ids
                    },
                    success: function (data) {
                        if (data.success > 0)
                        {
                            App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#mark-paid').data('success')});
                            setTimeout(function () {
                                $table.bootstrapTable('refresh', true);
                            }, 200);
                            $markPaid.prop('disabled', true);
                        }
                        if(data.fail > 0)
                        {
                            App.alert({container: $('#notification-alert'), type: "danger", close: true, message: $('#mark-paid').data('danger') + ' ' + data.fail });
                            setTimeout(function () {
                                $table.bootstrapTable('refresh', true);
                            }, 200);
                            $markPaid.prop('disabled', true);
                        }
                    }
                });
            });
        });
        function getIdSelections() {
            return $.map($table.bootstrapTable('getSelections'), function (row) {
                return row.enc_purchase_number
            });
        }
    },
    handleMassEmailPurchases = function(){
        var $table = $('#purchaseTable'),
            $markSent = $('#send-email'),
            selections = [];

        // sometimes footer render error.
        setTimeout(function () {
            $table.bootstrapTable('resetView');
        }, 200);
        $table.on('check.bs.table uncheck.bs.table ' +
                        'check-all.bs.table uncheck-all.bs.table', function () {
                    $markSent.prop('disabled', !$table.bootstrapTable('getSelections').length);

                    // save your data, here just save the current page
                    selections = getIdSelections();
                    // push or splice the selections if you want to save all data selections
                });
        $markSent.click(function () {
            var ids = getIdSelections();
            $base_url = $('#base-url').data('target'),
            $url = $.trim( $base_url + 'index.php/purchases/mass_email' );
            $this = $('#send-email');
            swal({
              title: $this.data('sure'),
              text: $this.data('message'),
              type: "warning",
              showCancelButton: true,
              confirmButtonClass: "btn-danger",
              confirmButtonText: $this.data('confirm'),
              cancelButtonText: $('#btn-cancel').data('text'),
              closeOnConfirm: true
            },
            function(){ 
                $.getJSON({
                    url: $url,
                    data: {
                        id: ids
                    },
                    success: function (data) {
                        if (data.success > 0)
                        {
                            App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#send-email').data('success')});
                            setTimeout(function () {
                                $table.bootstrapTable('refresh', true);
                            }, 200);
                            $markSent.prop('disabled', true);
                        }
                        if(data.fail > 0)
                        {
                            App.alert({container: $('#notification-alert'), type: "danger", close: true, message: $('#send-email').data('danger') + ' ' + data.fail });
                            setTimeout(function () {
                                $table.bootstrapTable('refresh', true);
                            }, 200);
                            $markSent.prop('disabled', true);
                        }
                    }
                });
            });
        });
        function getIdSelections() {
            return $.map($table.bootstrapTable('getSelections'), function (row) {
                return row.enc_purchase_number
            });
        }
    },
    handleAutoComplete = function(){
        var i = $('table tr').length;
        var client = $('#client').val();
        if (client == 0)
        {
            credit = 0;
        }
        var $user_currency = $('#money-format').data('symbol');
        var $displayDiscountValue = $('#display-discount').data('value');
        var $displayVatValue = $('#display-vat').data('value');
        var $displayMpn = $('#display-mpn').data('value');
        if ( ! $displayDiscountValue )
        {
            $displayDiscount = ' class="hidden"';
        }
        else
        {
            $displayDiscount = '';
        }
        if ( ! $displayVatValue )
        {
            $displayVat = ' class="hidden"';
        }
        else
        {
            $displayVat = '';
        }
        if ($('#add-new-row').length != 0) {
            url = $.trim( $('#base-url').data('target') + 'index.php/provider/purchase_autocomplete' );
            var price = [];
            $.getJSON(url, function(data, status, xhr){
                if (status === 'success')
                    prices = data;
            });
            $('#add-new-row').on('click', function(){
                newRow = '<tr>';
                newRow += '<td> <input type="text" data-type="itemSku" name="itemSku[]" id="itemSku_'+i+'" class="form-control autocomplete_txt itemSku" autocomplete="off" style="width: auto" /></td>';
                newRow += '<td> <input type="text" data-type="itemName" name="itemName[]" id="itemName_'+i+'" class="form-control autocomplete_txt itemName" autocomplete="off" style="width: auto"> </td>';
                if ($displayMpn) {
                    newRow += '<td> <input type="text" name="itemMpn[]" id="itemMpn_'+i+'" class="form-control autocomplete_txt itemMpn" autocomplete="off" style="width: auto"> </td>';
                }
                newRow += '<td> <input type="text" min="0" name="itemQuantity[]" id="itemQuantity_'+i+'" class="form-control changeNo" autocomplete="off" style="width: 65px;" onkeypress="return IsNumeric(event);" ondrop="return false;" onpaste="return false;" /> </td>';
                newRow += '<td> <input type="text" name="itemUom[]" id="itemUom_'+i+'" class="form-control" style="width: 50px" /> </td>';
                newRow += '<td> <div class="input-group"><span class="input-group-addon currency">' +$user_currency+ '</span><input type="text" min="0" name="itemPrice[]" id="itemPrice_'+i+'" class="form-control itemPrice changeNo" autocomplete="off" style="width: 100px;" onkeypress="return IsNumeric(event);" ondrop="return false;" onpaste="return false;" /> </div></td>';
                newRow += '<td> <div class="input-group"><span class="input-group-addon">%</span><input type="text" min="0" step="0.01" name="itemDiscount[]" id="itemDiscount_'+i+'" class="form-control changeNo" style="width: 65px;" onkeypress="return IsNumeric(event);" ondrop="return false;" onpaste="return false;" /> <input type="hidden" disabled name="itemDiscountAmount[]" id="itemDiscountAmount_'+i+'" class="itemDiscountAmount"/></div></td>';
                newRow += '<td> <div class="input-group"><span class="input-group-addon">%</span><input type="text" min="0" step="0.01" name="itemTax[]" id="itemTax_'+i+'" class="form-control changeNo" style="width: 65px;" onkeypress="return IsNumeric(event);" ondrop="return false;" onpaste="return false;" /></div><input type="hidden" disabled name="itemTaxAmount[]" id="itemTaxAmount_'+i+'" class="itemTaxAmount"/></td>';
                newRow += '<td> <div class="input-group"><span class="input-group-addon currency">' +$user_currency+ '</span><input type="text" name="itemSubTotal[]" id="itemSubTotal_'+i+'" class="form-control itemSubTotal" readonly="readonly" autocomplete="off" style="width: 100px;"> </div></td>';
                newRow += '<td>  <a href="javascript:;" class="btn btn-sm btn-danger delete_item"><i class="icon-trash"></i><input type="hidden" class="autocomplete_txt itemID" name="itemID[]" id="itemID_'+i+'"></td>';
                newRow += '</tr>';

                $('table').append(newRow);
                i++;
                
            });
        }
        $(document).on('click', 'a.delete_item', function(){
            $(this).parents('tr').remove();
            calculateTotal();
        });

        // Autocomplete
        $(document).on('focus', '.autocomplete_txt', function(){
            provider_id = $('.invoice_to').val();
            if (provider_id == 0)
            {
                credit = 0;
            }
            var $type = $(this).data('type');
            if($type == 'itemSku')
                var autoTypeNo = 0;
            if($type == 'itemName')
                autoTypeNo = 1;
            $(this).autocomplete({
                source: function( request, response ){
                    var array = $.map(prices, function(item){
                        var code = item.split('|');
                        return {
                            label: code[autoTypeNo],
                            value: code[autoTypeNo],
                            data: item
                        }
                    });
                    response($.ui.autocomplete.filter(array, request.term));
                },
                autoFocus: true,
                minLength: 1,
                select: function(event, ui) {
                    var names = ui.item.data.split('|'),
                    id_arr = $(this).attr('id'),
                    id = id_arr.split('_');

                    globalDiscount = $('#globalDiscount').val();
                    if (globalDiscount != '')
                    {
                        discount = globalDiscount;
                        $('#itemDiscount_'+id[1]).prop('readonly', true);
                    }
                    else
                    {
                        discount = 0;
                        $('#itemDiscount_'+id[1]).prop('readonly', false);
                    }
                    if(names)
                    {
                        if(names[3] == '')
                        {
                            names[3] = 0.00;
                        }
                        if(names[2] == '')
                        {
                            names[2] = 0.00;
                        }
                        if(names[7] == '')
                        {
                            names[7] = 0.00;
                        }
                        if(names[8] == '')
                        {
                            names[8] = 0.00;
                        }
                        if(names[9] == '')
                        {
                            names[9] = 0.00;
                        }
                        if(names[10] == '')
                        {
                            names[10] = 0.00;
                        }
                        $('#itemSku_'+id[1]).val(names[0]);
                        $('#itemID_'+id[1]).val(names[4]);
                        $('#itemName_'+id[1]).val(names[1]);
                        $('#itemMpn_'+id[1]).val(names[11]);
                        $('#itemQuantity_'+id[1]).val(1);
                        $('#itemPrice_'+id[1]).val( parseFloat(names[2]) );
                        $('#itemTax_'+id[1]).val(names[3]);
                        $('#itemUom_'+id[1]).val(names[5]); // Unit of measure
                        $('#itemDiscount_'+id[1]).val(discount);
                        $('#itemSubTotal_'+id[1]).val( parseFloat((1 * names[2]) - (1 * names[2] * discount / 100)) );
                        $('#itemTaxAmount_'+id[1]).val( parseFloat(names[2]) * parseFloat(names[3]) / 100 );
                    }
                    calculateTotal();
                }
            });
        });

        $(document).on('change', '.changeNo', function(){
            id_arr = $(this).attr('id');
            id = id_arr.split('_');

            var quantity = $('#itemQuantity_'+id[1]).val();
            var price = $('#itemPrice_'+id[1]).val();

            if( quantity != '' && price != '' )
            {
                if( $('#itemDiscount_'+id[1]).val() != '')
                {
                    var itemDiscount = $('#itemDiscount_'+id[1]).val();
                }
                else
                {
                    itemDiscount = 0;
                }
                $('#itemSubTotal_'+id[1]).val( (parseFloat(price) * parseFloat(quantity) - (parseFloat(price) * parseFloat(quantity) * parseFloat(itemDiscount) / 100) ));
                var itemSubTotal = $('#itemSubTotal_'+id[1]).val();
                var itemTax = $('#itemTax_'+id[1]).val();
                

                if( itemTax != '')
                {
                    $('#itemTaxAmount_'+id[1]).val( (parseFloat(itemSubTotal) * parseFloat(itemTax) /100 ) );
                    $('#taxAmount').val( (parseFloat(itemSubTotal) * parseFloat(itemTax) / 100 ) );

                }
                if( itemDiscount != '')
                {
                    $('#itemDiscountAmount_'+id[1]).val( (price * quantity * itemDiscount ) /100 );
                    $('#discountAmount').val( (price * quantity * itemDiscount ) /100 );
                }
                calculateTotal();
            }
        });

        // $(document).on('change', '#amountPaid', function(){
        //  calculateAmountDue();
        // });
        $(document).on('change', '#client-credit', function(){
            calculateAmountDue();
        });
        $(document).on('change', '#shipping-amount', function(){
            calculateAmountDue();
        });
        $(document).on('change', '#other-expenses', function(){
            calculateAmountDue();
        });
        // $(document).on('focus', '#amountPaid', function(){
        //  $('#amountPaid').val($('.amountDue').val());
        //  calculateAmountDue();
        // });
        $(document).on('change', '#globalDiscount', function(){
            globalDiscount = $(this).val();
            if (globalDiscount != '')
            {
                discount = globalDiscount;
            }
            else
            {
                discount = 0;
            }
            $('.changeNo').each(function(){
                id_arr = $(this).attr('id');
                id = id_arr.split('_');

                var quantity = $('#itemQuantity_'+id[1]).val();
                var price = $('#itemPrice_'+id[1]).val();

                if (discount != '')
                {
                    $('#itemDiscount_'+id[1]).prop('readonly', true);
                }
                else
                {
                    $('#itemDiscount_'+id[1]).prop('readonly', false);
                }
                $('#itemDiscount_'+id[1]).val(discount);

                if( quantity != '' && price != '' )
                {
                    if( $('#itemDiscount_'+id[1]).val() != '')
                    {
                        var itemDiscount = $('#itemDiscount_'+id[1]).val();
                    }
                    else
                    {
                        itemDiscount = 0;
                    }
                    $('#itemSubTotal_'+id[1]).val( (parseFloat(price) * parseFloat(quantity) - (parseFloat(price) * parseFloat(quantity) * parseFloat(itemDiscount) / 100) ));
                    var itemSubTotal = $('#itemSubTotal_'+id[1]).val();
                    var itemTax = $('#itemTax_'+id[1]).val();
                    

                    if( itemTax != '')
                    {
                        $('#itemTaxAmount_'+id[1]).val( (parseFloat(itemSubTotal) * parseFloat(itemTax) /100 ) );
                        $('#taxAmount').val( (parseFloat(itemSubTotal) * parseFloat(itemTax) / 100 ) );

                    }

                    if( itemDiscount != '')
                    {
                        $('#itemDiscountAmount_'+id[1]).val( (price * quantity * itemDiscount ) /100 );
                        $('#discountAmount').val( (price * quantity * itemDiscount ) /100 );

                    }
                    else
                    {
                        $('#itemDiscountAmount_'+id[1]).val(0);
                        $('#discountAmount').val(0);
                    }
                    calculateTotal();
                }
            });
        });
        $(document).on('change', '.invoice_to', function(){
            credit = 0;
            provider_id = $('.invoice_to').val();
            multiCurrencySupport = $('#multicurrency-support').data('value');
            if (provider_id == 0)
            {
                credit = 0;
                $('#credit-available > span').removeClass('mysuccess');
                $('#credit-available > span').text("");
                $("#client-credit").attr("readonly","readonly");
            }
            else
            {
                url = $.trim( $('#base-url').data('target') + 'index.php/clients/get_client_credit' );
                if ( multiCurrencySupport )
                {
                    clientCurrencyUrl = $.trim( $('#base-url').data('target') + 'index.php/client/get_client_currency');
                    $.getJSON(url, {provider_id : provider_id}).done(function(data){
                        credit = parseFloat(data);
                        if (credit >= 0.01)
                        {
                            $("#client-credit").removeAttr("readonly");
                            html = $('#c-available').data('text');
                            $('#credit-available > span').removeClass('mydanger');
                            $('#credit-available > span').text(html + credit).addClass('mysuccess');
                        }
                        else
                        {
                            $('#credit-available > span').removeClass('mysuccess');
                            $('#credit-available > span').text("");
                            $("#client-credit").val(parseFloat(0));
                            $("#client-credit").attr("readonly","readonly");
                        }
                    });
                    $.getJSON(clientCurrencyUrl, {provider_id : provider_id}).done(function(data){
                        clientCurrencyStr = data.currency_str;
                        clientCurrencySymb = data.currency_symb;
                        changeRate = data.change_rate;
                        $('#changerate').val(changeRate);
                        $('#clientchangerate').val(changeRate);
                        latestChangeRate = $('#latestchangerate').data('message').replace(/%s/g, changeRate);
                        clientCurrencyNotification = $('#clientcurrencywarning').data('message').replace(/%s/g, clientCurrencyStr + ' (' + clientCurrencySymb + ' ' +latestChangeRate + ')');
                        toastr.options = {
                          "closeButton": true,
                          "debug": false,
                          "newestOnTop": true,
                          "progressBar": true,
                          "positionClass": "toast-top-right",
                          "preventDuplicates": true,
                          "onclick": null,
                          "showDuration": "300",
                          "hideDuration": "1000",
                          "timeOut": "5000",
                          "extendedTimeOut": "1000",
                          "showEasing": "swing",
                          "hideEasing": "linear",
                          "showMethod": "fadeIn",
                          "hideMethod": "fadeOut"
                        }
                        if (changeRate != 1)
                        {
                            toastr.info(clientCurrencyNotification, "");
                        }
                    });
                }
            }
        });
    },
    serverResponse = function(responseText, statusText, xhr, $form){
        if(responseText.status == 1)
        {
            App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#default-save-success').data('message')});
            setTimeout(function(){
               window.location.reload();
            }, 3000);
        }
        else
        {
            message = responseText.error;
            message = message.replace(/<\/?p[^>]*>/g, "");
            if( message != '')
            {
                App.alert({container: $('#notification-alert'), type: "danger", close: true, message: message});
            }
            else
            {
                App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#default-save-success').data('message')});
            }
            $("#btn-create-purchase").removeAttr("disabled");
            $(".btn-submit").text($('#btn-save').data('text'));
        }
    },
    updateInvoiceServerResponse = function(responseText, statusText, xhr, $form){

        if(responseText.status == 1)
        {
            if (responseText.stockupdated == 1)
            {
                App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#stock-updated').data('message')});
                $(".btn-submit").removeAttr("disabled");
                $(".btn-submit").text($('#btn-save').data('text'));
            }
            else
            {
                App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#default-update-success').data('message')});
                $(".btn-submit").removeAttr("disabled");
                $(".btn-submit").text($('#btn-save').data('text'));
            }
        }
        else
        {
            message = responseText.error;
            message = message.replace(/<\/?p[^>]*>/g, "");
            if( message != '')
            {
                App.alert({container: $('#notification-alert'), type: "danger", close: true, message: message});
            }
            else
            {
                App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#default-update-success').data('message')});
            }
            $(".btn-submit").removeAttr("disabled");
            $(".btn-submit").text($('#btn-save').data('text'));
        }
    },
    calculateTotal = function(){
        var taxAmount = 0,
            discountAmount = 0,
            subTotal = 0,
            total = 0;
        $('.itemSubTotal').each(function() {
            if( $(this).val() != '' )
            {
                subTotal += parseFloat( $(this).val() );
            }
        });

        $('.itemTaxAmount').each(function() {
            if( $(this).val() != '')
            {
                taxAmount += parseFloat( $(this).val() );
            }
        });
        $('.itemDiscountAmount').each(function() {
            if( $(this).val() != '')
            {
                discountAmount += parseFloat( $(this).val() );
            }
        });

        $('#subTotal').val( subTotal );
        $('#taxAmount').val( taxAmount );
        $('#discountAmount').val( discountAmount );

        total = (subTotal + taxAmount);

        $('#totalAftertax').val( total );
        $('#items_subTotal').val( subTotal );

        calculateAmountDue();
    },
    calculateAmountDue = function(){
        provider_id = $('.invoice_to').val();
        credit = 0;
        if (provider_id == 0)
        {
            credit = 0;
        }
        var shippingAmount = $('#shipping-amount').val();
        if (shippingAmount == '' || typeof(shippingAmount) == "undefined")
        {
            shippingAmount = 0;
        }
        var otherExpenses = $('#other-expenses').val();
        if (otherExpenses == '' || typeof(otherExpenses) == "undefined")
        {
            otherExpenses = 0;
        }
        var amountPaid = $('#amountPaid').val(),
            credit_used = $('#client-credit').val(),
            total = $('#totalAftertax').val();
            if (credit_used == "" || typeof(credit_used) == "undefined")
            {
                credit_used = 0.00;
            }
        if( amountPaid != '' && typeof(amountPaid) != "undefined")
        {
            amountDue = parseFloat(total) - parseFloat( amountPaid ) - parseFloat( credit_used );
            $('.amountDue').val( amountDue );
            credit_remaining = parseFloat(credit - credit_used);
            if (credit_remaining > 0)
            {
                html = $('#c-available').data('text');
                $('#credit-available > span').text(html + credit_remaining).addClass('mysuccess');
            }
            else
            {
                html = $('#c-available').data('text');
            $('#credit-available > span').text(html + credit_remaining).addClass('mydanger');
            }
        }
        else
        {
            total = parseFloat(total) - parseFloat(credit_used) + parseFloat(shippingAmount) + parseFloat(otherExpenses);
            if (total < 0)
            {
                $('.amountDue').val(parseFloat(total)).addClass('mydanger');
            }
            else
            {
                $('.amountDue').removeClass('mydanger');
                $('.amountDue').val(parseFloat(total));
            }
            credit_remaining = parseFloat(credit - credit_used);
            if (credit_remaining > 0)
            {
                html = $('#c-available').data('text');
                $('#credit-available > span').removeClass('mydanger');
                $('#credit-available > span').text(html + credit_remaining).addClass('mysuccess');
            }
            else
            {
                html = $('#c-available').data('text');
                $('#credit-available > span').text(html + credit_remaining).addClass('mydanger');
            }
        }
    },
    mollieRefund = function() {
        $("#mollie-refund").click(function(e) {
            e.preventDefault();
            $user_currency = $('#money-format').data('symbol');
            $notMolliePayment = $('#total-refunded').data('notmolliepayment');
            $header = $('#total-refunded').data('message') + $user_currency + parseFloat($('#total-refunded').data('value'));
            bootbox.prompt({
                title:  $header,
                inputType: 'number',
                buttons: {
                        'cancel': {
                            label: $('#btn-cancel').data('text'),
                            className: 'btn-default pull-left'
                        },
                        'confirm': {
                            label: $('#btn-save').data('text'),
                            className: 'btn-danger pull-right'
                        }
                    },
                callback: function (result) {
                    if (result > 0)
                    {
                        $amount = result;
                        $transaction_id = $('#mollie-refund').data('transaction');
                        $url = $('#base-url').data('target') + 'index.php/mollie/refund_payment/index';
                        $.getJSON({
                            url: $url,
                            data: {
                                amount: $amount,
                                transaction_id: $transaction_id
                            },
                            success: function (data) {
                                if (data.success > 0)
                                {
                                    location.reload(true);
                                }
                                if(data.fail > 0)
                                {
                                    swal({
                                      title: 'Oooops',
                                      text: $notMolliePayment,
                                      type: "warning",
                                      confirmButtonClass: "btn-danger",
                                      closeOnConfirm: true
                                    });
                                }
                            }
                        });
                    }
                }
            });
        })
    },
    manualRefund = function() {
        $("#manual-refund").click(function(e) {
            e.preventDefault();
            $user_currency = $('#money-format').data('symbol');
            $header = $('#total-refunded').data('message') + $user_currency + parseFloat($('#total-refunded').data('value'));
            bootbox.prompt({
                title:  $header,
                inputType: 'number',
                callback: function (result) {
                    if (result > 0)
                    {
                        $amount = result;
                        $order_number = $('#manual-refund').data('invoice');
                        $url = $('#base-url').data('target') + 'index.php/invoices/ajax/refund_payment';
                        $.getJSON({
                            url: $url,
                            data: {
                                amount: $amount,
                                order_number: $order_number
                            },
                            success: function (data) {
                                if (data.success > 0)
                                {
                                    location.reload(true);
                                }
                                if(data.fail > 0)
                                {
                                    swal({
                                      title: 'Oooops',
                                      text: $('#manual-refund').data('refundfailed'),
                                      type: "warning",
                                      confirmButtonClass: "btn-danger",
                                      closeOnConfirm: true
                                    });
                                }
                            }
                        });
                    }
                }
            });
        })
    },
    handleShowTransactionHistory = function(){
        $("#view-transaction").on('click', function(){
            $('#transaction-details').toggleClass('hidden');
        });
    },
    handleSelectProvider = function(){
        $('.providers').each(function(){
            var $base_url = $('#base-url').data('target'),
                $url = $.trim( $base_url + 'index.php/providers/get_active_providers' );

            $.getJSON( $url, function(response){
                var stringified = JSON.stringify(response);
                stringified = stringified.replace(/provider_id/g, 'id');
                stringified = stringified.replace(/name_company/g, 'text');
                var data = JSON.parse(stringified);
                $('.providers').select2({
                    data: data
                })
            });
        });
    },
    handleSelectProviderContact = function(){
        $('#select-provider').on('change', function(){
            var $this = $(this);
            var $id = $this.val();
            var $base_url = $('#base-url').data('target'),
                $url = $.trim( $base_url + 'index.php/providers/get_provider_contacts' );

            $.getJSON( $url, {provider_id: $id}, function(response){
                var stringified = JSON.stringify(response);
                stringified = stringified.replace(/provider_id/g, 'id');
                stringified = stringified.replace(/provider_contact1/g, 'text');
                var data = JSON.parse(stringified);
                $('input[id="provider-contact"]').val(data.text);
            });
        });
    },
    handleMassApproved = function(){
        var $table = $('#purchaseTable'),
            $markApproved = $('#purchase-mark-approved'),
            selections = [];

        // sometimes footer render error.
        setTimeout(function () {
            $table.bootstrapTable('resetView');
        }, 200);
        $table.on('check.bs.table uncheck.bs.table ' +
                        'check-all.bs.table uncheck-all.bs.table', function () {
                    $markApproved.prop('disabled', !$table.bootstrapTable('getSelections').length);

                    // save your data, here just save the current page
                    selections = getIdSelections();
                    // push or splice the selections if you want to save all data selections
                });
        $markApproved.click(function () {
            var ids = getIdSelections();
            $base_url = $('#base-url').data('target'),
            $url = $.trim( $base_url + 'index.php/purchases/mark_approved' );
            $this = $('#purchase-mark-approved');
            swal({
              title: $this.data('sure'),
              text: $this.data('message'),
              type: "warning",
              showCancelButton: true,
              confirmButtonClass: "btn-danger",
              confirmButtonText: $this.data('confirm'),
              cancelButtonText: $('#btn-cancel').data('text'),
              closeOnConfirm: true
            },
            function(){ 
                $.getJSON({
                    url: $url,
                    data: {
                        id: ids
                    },
                    success: function (data) {
                        if (data.success > 0)
                        {
                            App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#purchase-mark-approved').data('success')});
                            setTimeout(function () {
                                $table.bootstrapTable('refresh', true);
                            }, 200);
                            $markApproved.prop('disabled', true);
                        }
                        if(data.fail > 0)
                        {
                            App.alert({container: $('#notification-alert'), type: "danger", close: true, message: $('#purchase-mark-approved').data('danger') + ' ' + data.fail });
                            setTimeout(function () {
                                $table.bootstrapTable('refresh', true);
                            }, 200);
                            $markApproved.prop('disabled', true);
                        }
                    }
                });
            });
        });
        function getIdSelections() {
            return $.map($table.bootstrapTable('getSelections'), function (row) {
                return row.enc_purchase_number
            });
        }
    },
    handleDeletePurchase = function(){
        var $table = $('#purchaseTable'),
            $remove = $('#remove-purchase'),
            selections = [];

        // sometimes footer render error.
        setTimeout(function () {
            $table.bootstrapTable('resetView');
        }, 200);
        $table.on('check.bs.table uncheck.bs.table ' +
                        'check-all.bs.table uncheck-all.bs.table', function () {
                    $remove.prop('disabled', !$table.bootstrapTable('getSelections').length);

                    // save your data, here just save the current page
                    selections = getIdSelections();
                    // push or splice the selections if you want to save all data selections
                });
        $remove.click(function () {
            var ids = getIdSelections();
            $base_url = $('#base-url').data('target'),
            $url = $.trim( $base_url + 'index.php/purchases/delete_purchase' );
            $this = $('#remove-purchase');
            swal({
              title: $this.data('sure'),
              text: $this.data('message'),
              type: "warning",
              showCancelButton: true,
              confirmButtonClass: "btn-danger",
              confirmButtonText: $this.data('confirm'),
              cancelButtonText: $('#btn-cancel').data('text'),
              closeOnConfirm: true
            },
            function(){ 
                $.getJSON({
                    url: $url,
                    data: {
                        id: ids
                    },
                    success: function (data) {
                        if (data.success > 0)
                        {
                            $table.bootstrapTable('remove', {
                                field: 'enc_purchase_number',
                                values: ids
                            });
                            App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#remove-purchase').data('success')});
                            $remove.prop('disabled', true);
                        }
                        if(data.fail > 0)
                        {
                            App.alert({container: $('#notification-alert'), type: "danger", close: true, message: $('#remove-purchase').data('danger') + ' ' + data.fail });
                            setTimeout(function () {
                                $table.bootstrapTable('refresh', true);
                            }, 200);
                            $remove.prop('disabled', true);
                        }
                    }
                });
            });
        });
        function getIdSelections() {
            return $.map($table.bootstrapTable('getSelections'), function (row) {
                return row.enc_purchase_number
            });
        }
    },
    nextPurchaseNumber = function(){
        if ($('#purchase_number').length != 0) {
            url = $('#base-url').data('target') + 'index.php/purchases/next_purchase_order_number';
            $.getJSON(url, function(data){
                if (data) {
                    $('#purchase_number').val(data);
                    $('#btn-create-purchase').removeAttr("disabled");
                }
            });
        }
    };
    return {
        init: function(){
            handlePurchaseForm(),
            handleAutoComplete(),
            handleUpdatePurchase(),
            handleSelectClient(),
            handleDeletePurchase(),
            handleMassPayment(),
            handleMassEmailPurchases(),
            mollieRefund(),
            manualRefund(),
            handleShowTransactionHistory(),
            handleSelectProvider(),
            handleSelectProviderContact(),
            nextPurchaseNumber(),
            handleMassApproved(),
            handleDeletePurchase(),
            handleSelectShippingAddress()
        }
    }
})(jQuery);
jQuery(document).ready(function() {
    Purchases.init()
});
