var Repair = (function($){
	var handleWalkinCustomer = function() {
			$("#btn-walkincustomer").click(function(e) {
				$('#client_id').val('-1').trigger('change');
				$('#walkincustomer-div').removeClass('hidden');
				$('#default-customer').removeClass('hidden');
				$('#default-customer').addClass('hidden');
			})

			$is_edit = $('#is_edit').data('value');
			if ($is_edit && $('#client_id').val() == 0) {
				$('#default-customer').removeClass('hidden');
				$('#default-customer').addClass('hidden');

				$('#walkincustomer-div').removeClass('hidden');
			}
			$('#client_id').on('change', function(){
				if ($is_edit && $('#client_id').val() != 0) {
					$('#walkincustomer-div').removeClass('hidden');
					$('#walkincustomer-div').addClass('hidden');

					$('.walkin-input').find('input:text').val('');
				} else if ($is_edit && $('#client_id').val() == 0){
					$('#default-customer').removeClass('hidden');
				}
			});
	    },
	    handleCannedResponsesCategory = function() {
			$("#btn-add-canned-response-category").click(function(e) {
				$('.modal-add-category').removeClass('hidden');
				$('#btn-add-canned-response-category').removeClass('hidden');
				$('#label-or').removeClass('hidden');
				$('#label-or').addClass('hidden');
				$('#label-add-new').removeClass('hidden');
				$('#label-add-new').addClass('hidden');
			})
	    },
	    handleAppointment = function() {
			$("#btn-createasset").click(function(e) {
				$('#asset-options').removeClass('hidden');
			})
			$("#btn-appointmenttype").click(function(e) {
				$('#appointment-type').toggleClass('hidden');
				if ($('#appointment-type').hasClass('hidden')) {
					$('#btn-appointmenttype').text($('#btn-appointmenttype').data('default'));
					$('#datetimepickerappointment').val('');
					$('#appointment-location').val('');
					$("#appointment-owner").val('-1').trigger('change');
					$("#appointment-where").val('-1').trigger('change');
					$("#appointment-attendees").val('-1').trigger('change');
				} else {
					$('#btn-appointmenttype').text($('#btn-appointmenttype').data('remove'));
				}
			})
	    },
	    handleRepairAttachment = function() {
			$("#btn-add-attachment").click(function(e) {
				$('#add-files').removeClass('hidden');
			})
			$("#btn-submit-attachements").click(function(e) {
				var options = {
					dataType:  'json'
				};
				$('#import').submit(function(e){
					e.preventDefault();
					// Prevent 2 or more submissions
					$("#btn-submit-attachements").attr("disabled","disabled");
					$('#import').ajaxSubmit(options);
					return false; 
				});
			})

	    },
	    handleFillCannedResponse = function() {
			$(".canned-responses").on('change', function() {
				var $this = $(this);
				url = $('#base-url').data('target') + 'index.php/repair/ajax/get_canned_response_body';
				$.getJSON( url, {id:$this.val()}, function(data){
					$('#issue-description').text(data);
				});
			})
	    },
	    handleAssetTypeFields = function() {
	    	var $type = $("#asset-type").val();
	    	if ($type == '1') {
	    		$('#computer-asset').removeClass('hidden');
	    		$('#phone-asset').removeClass('hidden');
	    		$('#phone-asset').addClass('hidden');
	    		$('#mechanics-asset').removeClass('hidden');
	    		$('#mechanics-asset').addClass('hidden');
	    		$('#electronics-asset').removeClass('hidden');
	    		$('#electronics-asset').addClass('hidden');

	    	} else if($type == '2'){
	    		$('#phone-asset').removeClass('hidden');
	    		$('#computer-asset').removeClass('hidden');
	    		$('#computer-asset').addClass('hidden');
	    		$('#mechanics-asset').removeClass('hidden');
	    		$('#mechanics-asset').addClass('hidden');
	    		$('#electronics-asset').removeClass('hidden');
	    		$('#electronics-asset').addClass('hidden');

	    	} else if($type == '3'){
	    		$('#electronics-asset').removeClass('hidden');
	    		$('#computer-asset').removeClass('hidden');
	    		$('#computer-asset').addClass('hidden');
	    		$('#phone-asset').removeClass('hidden');
	    		$('#phone-asset').addClass('hidden');
	    		$('#mechanics-asset').removeClass('hidden');
	    		$('#mechanics-asset').addClass('hidden');

	    	} else if($type == '4'){
	    		$('#mechanics-asset').removeClass('hidden');
	    		$('#computer-asset').removeClass('hidden');
	    		$('#computer-asset').addClass('hidden');
	    		$('#phone-asset').removeClass('hidden');
	    		$('#phone-asset').addClass('hidden');
	    		$('#electronics-asset').removeClass('hidden');
	    		$('#electronics-asset').addClass('hidden');

	    	}
	    	
			$("#asset-type").on('change', function(e) {
				var $this = $(this).val();
				$('.asset-fields').find('input:text').val('');  
				if ($this == '1') {
					$('#computer-asset').removeClass('hidden');
					$('#phone-asset').removeClass('hidden');
					$('#phone-asset').addClass('hidden');
					$('#mechanics-asset').removeClass('hidden');
					$('#mechanics-asset').addClass('hidden');
					$('#electronics-asset').removeClass('hidden');
					$('#electronics-asset').addClass('hidden');

				} else if($this == '2'){
					$('#phone-asset').removeClass('hidden');
					$('#computer-asset').removeClass('hidden');
					$('#computer-asset').addClass('hidden');
					$('#mechanics-asset').removeClass('hidden');
					$('#mechanics-asset').addClass('hidden');
					$('#electronics-asset').removeClass('hidden');
					$('#electronics-asset').addClass('hidden');

				} else if($this == '3'){
					$('#electronics-asset').removeClass('hidden');
					$('#computer-asset').removeClass('hidden');
					$('#computer-asset').addClass('hidden');
					$('#phone-asset').removeClass('hidden');
					$('#phone-asset').addClass('hidden');
					$('#mechanics-asset').removeClass('hidden');
					$('#mechanics-asset').addClass('hidden');

				} else if($this == '4'){
					$('#mechanics-asset').removeClass('hidden');
					$('#computer-asset').removeClass('hidden');
					$('#computer-asset').addClass('hidden');
					$('#phone-asset').removeClass('hidden');
					$('#phone-asset').addClass('hidden');
					$('#electronics-asset').removeClass('hidden');
					$('#electronics-asset').addClass('hidden');

				} else {
					$('#computer-asset').removeClass('hidden');
					$('#computer-asset').addClass('hidden');
					$('#phone-asset').removeClass('hidden');
					$('#phone-asset').addClass('hidden');
					$('#electronics-asset').removeClass('hidden');
					$('#electronics-asset').addClass('hidden');
					$('#mechanics-asset').removeClass('hidden');
					$('#mechanics-asset').addClass('hidden');

				}
			})
	    },
	    handleAppointmentDateTime = function() {
	    	var $locale = $("#user-language").data("language");
	    	switch ($locale) {
	    	  case 'french':
	    	    $locale = 'fr';
	    	    break;
	    	  case 'german':
	    	    $locale = 'de';
	    	    break;
	    	  case 'russian':
	    	    $locale = 'ru';
	    	    break;
	    	  case 'spanish':
	    	    $locale = 'es';
	    	    break;
	    	  case 'italian':
	    	    $locale = 'it';
	    	    break;
	    	  case 'greek':
	    	    $locale = 'el';
	    	    break;
	    	}
			$('#datetimepickerappointment').datetimepicker({
			    locale: $.trim($locale),
			     autoclose: true,
			});
	    },
	    handleCreateTicket = function(){
	    	var options = {
	    		dataType:  'json',
	    		success: serverResponse
	    	};
	    	$('#create-ticket-form').submit(function(e){
	    		e.preventDefault();
	    		// Prevent 2 or more submissions
	    		$("#btn-create-ticket").attr("disabled","disabled");
	    		$('#create-ticket-form').ajaxSubmit(options);
	    		return false; 
	    	});
	    },
	    serverResponse = function(responseText, statusText, xhr, $form){
	    	if(responseText.status == 1)
	    	{
	    		window.location.replace("ticket?id="+$.trim(responseText.ticket_number));
	    	}
	    	else
	    	{
	    		message = responseText.error;
	    		message = message.replace(/<\/?p[^>]*>/g, "");
	    		if( message != '')
	    		{
	    			App.alert({container: $('#notification-alert'), type: "danger", close: true, message: message});
	    		}
	    		else
	    		{
	    			App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#default-update-success').data('message')});
	    		}
	    		$("#btn-create-ticket").removeAttr("disabled");
	    		$(".btn-submit").text($('#btn-save').data('text'));
	    	}
	    },
	    handleEditRepairTicket = function(){
	    	var options = {
	    		dataType:  'json',
	    		success: editRepairTicketServerResponse
	    	};
	    	$('#edit-repair-ticket-form').submit(function(){

	    		// Prevent 2 or more submissions
	    		$("#btn-edit-repair-ticket").attr("disabled","disabled");
	    		$('#edit-repair-ticket-form').ajaxSubmit(options);
	    		return false; 
	    	});
	    	$('#generate-ticket-invoice').on('click', function(e){
	    		e.preventDefault();
	    		var $this = $(this);

	    		$base_url = $('#base-url').data('target'),
	    		$url = $.trim( $base_url + 'index.php/repair/generate_invoice' );
	    		$id = $this.data('id');
	    		swal({
	    		  title: $this.data('sure'),
	    		  text: $this.data('message'),
	    		  type: "warning",
	    		  showCancelButton: true,
	    		  confirmButtonClass: "btn-danger",
	    		  confirmButtonText: $this.data('confirm'),
	    		  cancelButtonText: $('#btn-cancel').data('text'),
	    		  closeOnConfirm: true
	    		},
	    		function(){
	    			$.getJSON({
	    			    url: $url,
	    			    data: {
	    			        id: $id
	    			    },
	    			    success: function (data) {
	    			    	if (data.success > 0)
	    			    	{
	    			    		App.alert({container: $('#notification-alert'), type: "success", close: true, message: $this.data('messagesuccess')});
	    			    		setTimeout(function () {
	    			    			window.location.reload();
	    			    		}, 200);
	    			    		$this.prop('disabled', true);
	    			    	}
	    			    	if(data.fail > 0)
	    			    	{
	    			    		App.alert({container: $('#notification-alert'), type: "danger", close: true, message: $this.data('messagefail') });
	    			    		setTimeout(function () {
	    			    			window.location.reload();
	    			    		}, 200);
	    			    		$this.prop('disabled', true);
	    			    	}
	    			    }
	    			});
	    		});
	    	});
	    },
	    handleDeleteRepairTicket = function(){
	    	var $table = $('#btable'),
	    	    $remove = $('#remove-repairs'),
	    	    selections = [];

	    	// sometimes footer render error.
	    	setTimeout(function () {
	    		$table.bootstrapTable('resetView');
	    	}, 200);
	    	$table.on('check.bs.table uncheck.bs.table ' +
	    	                'check-all.bs.table uncheck-all.bs.table', function () {
	    	            $remove.prop('disabled', !$table.bootstrapTable('getSelections').length);

	    	            // save your data, here just save the current page
	    	            selections = getIdSelections();
	    	            // push or splice the selections if you want to save all data selections
	    	        });
	    	$remove.click(function () {
	    	    var ids = getIdSelections();
	    	    $base_url = $('#base-url').data('target'),
	    	    $url = $.trim( $base_url + 'index.php/repair/delete_ticket' );
	    	    $this = $('#remove-repairs');
	    	    swal({
	    	      title: $this.data('sure'),
	    	      text: $this.data('message'),
	    	      type: "warning",
	    	      showCancelButton: true,
	    	      confirmButtonClass: "btn-danger",
	    	      confirmButtonText: $this.data('confirm'),
	    	      cancelButtonText: $('#btn-cancel').data('text'),
	    	      closeOnConfirm: true
	    	    },
	    	    function(){ 
	    	        $.getJSON({
	    	            url: $url,
	    	            data: {
	    	                id: ids
	    	            },
	    	            success: function (data) {
	    	            	if (data.success > 0)
	    	            	{
	    	            		$table.bootstrapTable('remove', {
	    	            		    field: 'encrypted_id',
	    	            		    values: ids
	    	            		});
	    	            		App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#remove-repairs').data('success')});
	    	            		$remove.prop('disabled', true);
	    	            	}
	    	            	if(data.fail > 0)
	    	            	{
	    	            		App.alert({container: $('#notification-alert'), type: "danger", close: true, message: $('#remove-repairs').data('danger') + ' ' + data.fail });
	    	            		setTimeout(function () {
	    	            			$table.bootstrapTable('refresh', true);
	    	            		}, 200);
	    	            		$remove.prop('disabled', true);
	    	            	}
	    	            }
	    	        });
	    	    });
	    	});
	    	function getIdSelections() {
	    	    return $.map($table.bootstrapTable('getSelections'), function (row) {
	    	        return row.encrypted_id
	    	    });
	    	}
	    },
	    editRepairTicketServerResponse = function(responseText, statusText, xhr, $form){
	    	if(responseText.status == 1)
	    	{
	    		App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#default-update-success').data('message')});
	    		setTimeout(function () {
	    			window.location.reload();
	    		}, 200);
	    	}
	    	else
	    	{
	    		message = responseText.error;
	    		message = message.replace(/<\/?p[^>]*>/g, "");
	    		if( message != '')
	    		{
	    			App.alert({container: $('#notification-alert'), type: "danger", close: true, message: message});
	    		}
	    		else
	    		{
	    			App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#default-update-success').data('message')});
	    		}
	    		$("#btn-edit-repair-ticket").removeAttr("disabled");
	    		$(".btn-submit").text($('#btn-save').data('text'));
	    	}
	    },
	    handleAppointmentCalendar = function() {
	    	$('#calendar').fullCalendar({
	    	    events: '/index.php/repair/get_tickets_appointments',
	    	    eventDataTransform: function (rawEventData) {
	    	        return {
	    	            id: rawEventData.id,
	    	            title: rawEventData.title,
	    	            start: rawEventData.start
	    	        };
	    	    },
	    	    eventClick: function(rawEventData) {
	    	       
	    	    }
	    	});
	    };
	return {
		init: function(){
			handleWalkinCustomer(),
			handleAppointment(),
			handleAppointmentDateTime(),
			handleAppointmentCalendar(),
			handleAssetTypeFields(),
			handleCreateTicket(),
			handleCannedResponsesCategory(),
			handleFillCannedResponse(),
			handleEditRepairTicket(),
			handleDeleteRepairTicket(),
			handleRepairAttachment()
		}
	};
})(jQuery);
jQuery(document).ready(function() {
	Repair.init()
	$(function(){
		if ($('.repair-agent').length != 0 ){
			url = $('#base-url').data('target') + 'index.php/repair/get_active_agents';
			$.getJSON( url, function(data){
			    $('.repair-agent').select2({
			        data: data
			    })
			});
		}
	});
	$(function(){
		if ($("#ticket-issue-type").length != 0 ){
			var $base_url = $('#base-url').data('target'),
			    $url = $.trim($base_url + 'index.php/repair/get_ticket_issue_types');

			$.getJSON($url, function(response) {
			    var stringified = JSON.stringify(response);
			    stringified = stringified.replace(/id/g, 'id');
			    stringified = stringified.replace(/name/g, 'text');
			    var data = JSON.parse(stringified);
			    $("#ticket-issue-type").select2({
			        data: data
			    })
			});
		}
	});
	$(function(){
		if ($("#additional_emails_to_notify").length != 0) {
			var $base_url = $('#base-url').data('target'),
			    $url = $.trim($base_url + 'index.php/repair/get_ticket_additional_emails_to_notify');

			$.getJSON($url, function(data) {
			    $("#additional_emails_to_notify").select2({
			        data: data
			    })
			});
		}
	});
	$(function(){
		if ($("#canned-responses-categories").length != 0) {
			var $base_url = $('#base-url').data('target'),
			    $url = $.trim($base_url + 'index.php/repair/get_ticket_canned_responses_categories');

			$.getJSON($url, function(data) {
			    $("#canned-responses-categories").select2({
			        data: data
			    })
			});
		}
	});
	$(function(){
		if ($(".canned-responses").length != 0) {
			var $base_url = $('#base-url').data('target'),
			    $url = $.trim($base_url + 'index.php/repair/get_ticket_canned_responses');
			$.getJSON($url, function(data) {
			    $(".canned-responses").select2({
			        data: data
			    })
			});
		}
	});
});