var Settings = (function($){
	var handlePaymentGateway =function(){
		var $canPayOnline = $('#payonline').prop("checked");
		if($canPayOnline)
		{
			$('#payment-gateway-options').removeClass('hidden');
		}
		$('#payonline').change(function(){
			var $canPayOnline = $('#payonline').prop("checked");
			if($canPayOnline)
			{
				$('#payment-gateway-options').removeClass('hidden');
			}
			else
			{
				$('#payment-gateway-options').removeClass('hidden');
				$('#payment-gateway-options').addClass('hidden');
			}
		});
	},
	handleInvoiceLateFeesSettings = function(){
		var options = {
			dataType:  'json',
			success: invoiceLateFeesResponse
		};

		$('.invoice-late-fees-settings-form').submit(function(e){
			e.preventDefault();
			$(".btn-submit").attr("disabled","disabled");
			$(this).ajaxSubmit(options);
			return false; 
		});
	},
	invoiceLateFeesResponse = function(responseText, statusText, xhr, $form){
		if(responseText.status == 1)
		{
			App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#default-settings-saved-success').data('message')});
			$(".btn-submit").removeAttr("disabled");
			$(".btn-submit").text($('#btn-save').data('text'));
		}
		else
		{
			message = responseText.error;
			message = message.replace(/<\/?p[^>]*>/g, "");
			if( message != '')
			{
				App.alert({container: $('#notification-alert'), type: "danger", close: true, message: message});
				$(".btn-submit").removeAttr("disabled");
				$(".btn-submit").text($('#btn-save').data('text'));
			}
			else
			{
				App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#default-settings-saved-success').data('message')});
				//location.reload();
			}
			$(".btn-submit").removeAttr("disabled");
			$(".btn-submit").text($('#btn-save').data('text'));
		}
	},
	handleSettings = function(){
		var options = {
			dataType:  'json',
			success: settingsServerResponse
		};
		$('#settings-general-form').submit(function(e){
			e.preventDefault();
			$(".btn-submit").attr("disabled","disabled");
			$(this).ajaxSubmit(options);
			return false; 
		});
		$('#settings-general-settings-form').submit(function(e){
			e.preventDefault();
			$(".btn-submit").attr("disabled","disabled");
			$(this).ajaxSubmit(options);
			return false; 
		});
		$('#maps-settings-form').submit(function(e){
			e.preventDefault();
			$(".btn-submit").attr("disabled","disabled");
			$(this).ajaxSubmit(options);
			return false; 
		});
		$('#recaptcha-settings-form').submit(function(e){
			e.preventDefault();
			$(".btn-submit").attr("disabled","disabled");
			$(this).ajaxSubmit(options);
			return false; 
		});
	},
	settingsServerResponse = function(responseText, statusText, xhr, $form){
		if(responseText.status == 1)
		{
			App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#default-update-success').data('message')});
			$(".btn-submit").removeAttr("disabled");
			$(".btn-submit").text($('#btn-save').data('text'));
		}
		else
		{
			message = responseText.error;
			message = message.replace(/<\/?p[^>]*>/g, "");
			if( message != '')
			{
				App.alert({container: $('#notification-alert'), type: "danger", close: true, message: message});
				$(".btn-submit").removeAttr("disabled");
				$(".btn-submit").text($('#btn-save').data('text'));
			}
			else
			{
				App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#default-update-success').data('message')});
				location.reload();
			}
			$(".btn-submit").removeAttr("disabled");
			$(".btn-submit").text($('#btn-save').data('text'));
		}
	},
	handleIndiaGstOptions =function(){
		var $isIndian = $('#isindian').prop("checked");
		if($isIndian)
		{
			$('#isromanian').prop("checked", false);
		}
		$('#isindian').change(function(){
			var $isIndian = $('#isindian').prop("checked");
			if($isIndian)
			{
				$('#isromanian').prop("checked", false);
				$('#checkbox-41').prop("checked", false);
				$('#checkbox-42').prop("checked", false);
				$('#romania-invoice-options').addClass('hidden');
			}
		});
	},
	handleRomaniaOptions =function(){
		var $isRomanian = $('#isromanian').prop("checked");
		if($isRomanian)
		{
			$('#romania-invoice-options').removeClass('hidden');
			$('#isindian').prop("checked", false);
		}
		$('#isromanian').change(function(){
			var $isRomanian = $('#isromanian').prop("checked");
			if($isRomanian)
			{
				$('#romania-invoice-options').removeClass('hidden');
				$('#isindian').prop("checked", false);
			}
			else
			{
				$('#romania-invoice-options').removeClass('hidden');
				$('#romania-invoice-options').addClass('hidden');
			}
		});
	},
	handleDeletePaymentMethod = function(){
		var $table = $('#payment-method-table'),
		    $remove = $('#remove-payment-method'),
		    selections = [];

		// sometimes footer render error.
		setTimeout(function () {
			$table.bootstrapTable('resetView');
		}, 200);
		$table.on('check.bs.table uncheck.bs.table ' +
		                'check-all.bs.table uncheck-all.bs.table', function () {
		            $remove.prop('disabled', !$table.bootstrapTable('getSelections').length);

		            // save your data, here just save the current page
		            selections = getIdSelections();
		            // push or splice the selections if you want to save all data selections
		        });
		$remove.click(function () {
		    var ids = getIdSelections();
		    $base_url = $('#base-url').data('target'),
		    $url = $.trim( $base_url + 'index.php/settings/delete_payment_method' );
		    $this = $('#remove-payment-method');
		    swal({
		      title: $this.data('sure'),
		      text: $this.data('message'),
		      type: "warning",
		      showCancelButton: true,
		      confirmButtonClass: "btn-danger",
		      confirmButtonText: $this.data('confirm'),
		      cancelButtonText: $('#btn-cancel').data('text'),
		      closeOnConfirm: true
		    },
		    function(){ 
		        $.getJSON({
		            url: $url,
		            data: {
		                id: ids
		            },
		            success: function (data) {
		            	if (data.success > 0)
		            	{
		            		$table.bootstrapTable('remove', {
		            		    field: 'payment_method_id',
		            		    values: ids
		            		});
		            		App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#remove-payment-method').data('success')});
		            		$remove.prop('disabled', true);
		            	}
		            	if(data.fail > 0)
		            	{
		            		App.alert({container: $('#notification-alert'), type: "danger", close: true, message: $('#remove-payment-method').data('danger') + ' ' + data.fail });
		            		setTimeout(function () {
		            			$table.bootstrapTable('refresh', true);
		            		}, 200);
		            		$remove.prop('disabled', true);
		            	}
		            }
		        });
		    });
		});
		function getIdSelections() {
		    return $.map($table.bootstrapTable('getSelections'), function (row) {
		        return row.payment_method_id
		    });
		}
	},
	handleDeleteAdditionalTaxes = function(){
		var $table = $('#additional-taxes-table'),
		    $remove = $('#remove-additional-taxes'),
		    selections = [];

		// sometimes footer render error.
		setTimeout(function () {
			$table.bootstrapTable('resetView');
		}, 200);
		$table.on('check.bs.table uncheck.bs.table ' +
		                'check-all.bs.table uncheck-all.bs.table', function () {
		            $remove.prop('disabled', !$table.bootstrapTable('getSelections').length);

		            // save your data, here just save the current page
		            selections = getIdSelections();
		            // push or splice the selections if you want to save all data selections
		        });
		$remove.click(function () {
		    var ids = getIdSelections();
		    $base_url = $('#base-url').data('target'),
		    $url = $.trim( $base_url + 'index.php/settings/delete_additional_taxes' );
		    $this = $('#remove-additional-taxes');
		    swal({
		      title: $this.data('sure'),
		      text: $this.data('message'),
		      type: "warning",
		      showCancelButton: true,
		      confirmButtonClass: "btn-danger",
		      confirmButtonText: $this.data('confirm'),
		      cancelButtonText: $('#btn-cancel').data('text'),
		      closeOnConfirm: true
		    },
		    function(){ 
		        $.getJSON({
		            url: $url,
		            data: {
		                id: ids
		            },
		            success: function (data) {
		            	if (data.success > 0)
		            	{
		            		$table.bootstrapTable('remove', {
		            		    field: 'id',
		            		    values: ids
		            		});
		            		App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#remove-additional-taxes').data('success')});
		            		$remove.prop('disabled', true);
		            	}
		            	if(data.fail > 0)
		            	{
		            		App.alert({container: $('#notification-alert'), type: "danger", close: true, message: $('#remove-additional-taxes').data('danger') + ' ' + data.fail });
		            		setTimeout(function () {
		            			$table.bootstrapTable('refresh', true);
		            		}, 200);
		            		$remove.prop('disabled', true);
		            	}
		            }
		        });
		    });
		});
		function getIdSelections() {
		    return $.map($table.bootstrapTable('getSelections'), function (row) {
		        return row.id
		    });
		}
	},
	handleShowSmtpSettings = function(){

		$('input:radio[id=smtp]').on('ifClicked', function(event){
			var $input = $(this);

			$input.on('ifChecked', function(){
			  $('#smtp-div').removeClass('hidden');
			});

			$input.on('ifUnchecked', function(){
			  $('#smtp-div').removeClass('hidden');
			  $('#smtp-div').removeClass('hidden');
			});
		});

		$('input:checkbox[id=turn_off_emails]').on('ifClicked', function(event){
			var $input = $(this);

			$input.on('ifChecked', function(){
			  $('#email-subsequent').removeClass('hidden');
			  $('#email-subsequent').addClass('hidden');
			});
			$input.on('ifUnchecked', function(){
			  $('#email-subsequent').removeClass('hidden');
			});
		});
		$('#smtp').on('ifClicked', function(event){
			var $input = $(this);

			$input.on('ifChecked', function(){
			  $('#smtp-div').removeClass('hidden');
			});

			$input.on('ifUnchecked', function(){
			  $('#smtp-div').removeClass('hidden');
			  $('#smtp-div').removeClass('hidden');
			});
		});
		$('#email').on('ifClicked', function(event){
			var $input = $(this);

			$input.on('ifChecked', function(){
			  $('#smtp-div').addClass('hidden');
			});

			$input.on('ifUnchecked', function(){
			  $('#smtp-div').removeClass('hidden');
			  $('#smtp-div').addClass('hidden');
			});
		});
	};
	return {
		init: function(){
			handlePaymentGateway(),
			handleDeletePaymentMethod(),
			handleShowSmtpSettings(),
			handleIndiaGstOptions(),
			handleRomaniaOptions(),
			handleSettings(),
			handleDeleteAdditionalTaxes(),
			handleInvoiceLateFeesSettings()
		}
	}
})(jQuery);
jQuery(document).ready(function(){
	Settings.init()
});