var Summernote = (function($){
	var handleInvoiceTemplates = function () {
        $locale = $('#user-language').data('language');
        switch($locale) {
            case "french":
                $locale = 'fr-FR';
                break;
            case "german":
                $locale = 'de-DE';
                break;
            case "russian":
                $locale = 'ru-RU';
                break;
            case "romanian":
                $locale = 'ro';
                break;
            case "spanish":
                $locale = 'es-ES';
                break;
            case "english":
                $locale = 'en-US';
                break;
            case "dutch":
                $locale = 'nl-NL';
                break;
            case "greek":
                $locale = 'el-EL';
                break;
            case "arabic":
                $locale = 'ar-AR';
                break;
            default:
                $locale = "en-US";
                break;
        }
        $('#tpl_invoice_generated').summernote({
            height: 300,
            lang: $locale
        });
        $('#tpl_payment_notification').summernote({
            height: 300,
            lang: $locale
        });
        $('#tpl_payment_refunded').summernote({
            height: 300,
            lang: $locale
        });
        $('#tpl_invoice_terms').summernote({
            height: 300,
            lang: $locale
        });
        $('#tpl_footer').summernote({
            height: 300,
            lang: $locale
        });
        $('#tpl_overdue_invoice_reminder').summernote({
            height: 300,
            lang: $locale
        });
        $('#tpl_overdue_invoice_single_reminder').summernote({
            height: 300,
            lang: $locale
        });
        //API:
        url = $('#base-url').data('target') + 'index.php/settings/ajax/get_invoice_generated_tpl';
        url2 = $('#base-url').data('target') + 'index.php/settings/ajax/get_invoice_payment_tpl';
        url3 = $('#base-url').data('target') + 'index.php/settings/ajax/get_invoice_term_tpl';
        url4 = $('#base-url').data('target') + 'index.php/settings/ajax/get_invoice_footer_tpl';
        url5 = $('#base-url').data('target') + 'index.php/settings/ajax/get_invoice_refunded_tpl';
        url6 = $('#base-url').data('target') + 'index.php/settings/ajax/get_overdue_invoice_reminder_tpl';
        url7 = $('#base-url').data('target') + 'index.php/settings/ajax/get_overdue_invoice_single_reminder_tpl';

        $.getJSON(url, function(data){
            $('#tpl_invoice_generated').summernote('code', data);
        });
        $.getJSON(url2, function(data){
            $('#tpl_payment_notification').summernote('code', data);
        });
        $.getJSON(url3, function(data){
            $('#tpl_invoice_terms').summernote('code', data);
        });
        $.getJSON(url4, function(data){
            $('#tpl_footer').summernote('code', data);
        });
        $.getJSON(url5, function(data){
            $('#tpl_payment_refunded').summernote('code', data);
        });
        $.getJSON(url6, function(data){
            $('#tpl_overdue_invoice_reminder').summernote('code', data);
        });
        $.getJSON(url7, function(data){
            $('#tpl_overdue_invoice_single_reminder').summernote('code', data);
            if (data) {
                $('#save-invoice-templates').removeAttr("disabled");
            }
        });
    },
    handleQuoteTemplates = function () {
        $locale = $('#user-language').data('language');
        switch($locale) {
            case "french":
                $locale = 'fr-FR';
                break;
            case "german":
                $locale = 'de-DE';
                break;
            case "russian":
                $locale = 'ru-RU';
                break;
            case "romanian":
                $locale = 'ro';
                break;
            case "spanish":
                $locale = 'es-ES';
                break;
            case "english":
                $locale = 'en-US';
                break;
            case "dutch":
                $locale = 'nl-NL';
                break;
            case "greek":
                $locale = 'el-EL';
                break;
            case "arabic":
                $locale = 'ar-AR';
                break;
            default:
                $locale = "en-US";
                break;
        }
        $('#tpl_quote_generated').summernote({
            height: 300,
            lang: $locale
        });
        $('#tpl_quoteaccepted_notification').summernote({
            height: 300,
            lang: $locale
        });
        $('#tpl_quote_terms').summernote({
            height: 300,
            lang: $locale
        });
        $('#tpl_quote_footer').summernote({
            height: 300,
            lang: $locale
        });
        //API:
        url = $('#base-url').data('target') + 'index.php/settings/ajax/get_quote_generated_tpl';
        url2 = $('#base-url').data('target') + 'index.php/settings/ajax/get_quoteaccepted_tpl';
        url3 = $('#base-url').data('target') + 'index.php/settings/ajax/get_quote_term_tpl';
        url4 = $('#base-url').data('target') + 'index.php/settings/ajax/get_quote_footer_tpl';

        $.getJSON(url, function(data){
            $('#tpl_quote_generated').summernote('code', data);
        });
        $.getJSON(url2, function(data){
            $('#tpl_quoteaccepted_notification').summernote('code', data);
        });
        $.getJSON(url3, function(data){
            $('#tpl_quote_terms').summernote('code', data);
        });
        $.getJSON(url4, function(data){
            $('#tpl_quote_footer').summernote('code', data);
            if (data) {
                $('#save-quote-templates').removeAttr("disabled");
            }
        });
    },
    handleInvoiceTemplatesChanges = function(){
        $('#save-invoice-templates').on('click', function(){
           url = $('#base-url').data('target') + 'index.php/settings/ajax/set_invoice_templates';
           $.post( url, { csrf_mmanager: $('#csrf_mmanager').data('value'), terms_length: $('#terms_length').val(), attach_pdf_to_invoice: $('#attach_pdf_to_invoice').val(), reminder_interval: $('#reminder_interval').val(),reminder_type: $('#reminder_type').val(), tpl_invoice_generated: $('#tpl_invoice_generated').summernote('code'), tpl_payment_notification: $('#tpl_payment_notification').summernote('code'), tpl_payment_refunded: $('#tpl_payment_refunded').summernote('code'), tpl_invoice_terms: $('#tpl_invoice_terms').summernote('code'), tpl_overdue_invoice_reminder: $('#tpl_overdue_invoice_reminder').summernote('code'), tpl_overdue_invoice_single_reminder: $('#tpl_overdue_invoice_single_reminder').summernote('code'), tpl_footer: $('#tpl_footer').summernote('code') }, function(data){
            App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#default-update-success').data('message')});
            $(".btn-submit").removeAttr("disabled");
           });
        });
    },
    handleQuoteTemplatesChanges = function(){
        $('#save-quote-templates').on('click', function(){
           url = $('#base-url').data('target') + 'index.php/settings/ajax/set_quote_templates';
           $.post( url, { csrf_mmanager: $('#csrf_mmanager').data('value'), tpl_quote_generated: $('#tpl_quote_generated').summernote('code'), tpl_quoteaccepted_notification: $('#tpl_quoteaccepted_notification').summernote('code'), tpl_quote_terms: $('#tpl_quote_terms').summernote('code'), tpl_quote_footer: $('#tpl_quote_footer').summernote('code')}, function(data){
            App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#default-update-success').data('message')});
            $(".btn-submit").removeAttr("disabled");
           });
        });
    };
	return {
	        init: function() {
	        	handleInvoiceTemplates(), 
	        	handleInvoiceTemplatesChanges(),
                handleQuoteTemplatesChanges(),
                handleQuoteTemplates()
	        }
	    }
})(jQuery);
jQuery(document).ready(function() {
    Summernote.init()
});
