var Support = (function($) {
    var handleAddEventForm = function(){
        var options = {
            dataType:  'json',
            success: serverResponse
        };
        $('#ticket-event-form').submit(function(){
            $("#add-event").attr("disabled","disabled");
            $('#ticket-event-form').ajaxSubmit(options);
            return false;
        });
    },
    serverResponse = function(responseText, statusText, xhr, $form){
        if(responseText.status == 1)
        {
            App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#add-event').data('message')});
            window.location = '/index.php/support';
        }
        else
        {
            message = responseText.error;
            message = message.replace(/<\/?p[^>]*>/g, "");
            if( message != '')
            {
                App.alert({container: $('#notification-alert'), type: "danger", close: true, message: message});
                $("#add-event").removeAttr("disabled");
                $(".btn-submit").text($('#btn-save').data('text'));
            }
            else
            {
                App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#add-event').data('message')});
                $("#add-event").removeAttr("disabled");
                $(".btn-submit").text($('#btn-save').data('text'));
            }
            $("#add-event").removeAttr("disabled");
            $(".btn-submit").text($('#btn-save').data('text'));
        }
    },
    handleClientSupportContract = function() {
        $(document).on('change', '.invoice_to', function(){
            var $support = 0,
            $client_id = $('.invoice_to').val();
            if ($client_id == 0)
            {
                $('#client-support-message').removeClass('hidden');
                $('#client-support-message').addClass('hidden');
                $('#client-support-message-ended').removeClass('hidden');
                $('#client-support-message-ended').addClass('hidden');
            }
            else
            {
                url = $.trim( $('#base-url').data('target') + 'index.php/clients/get_client_support' );
                $.getJSON(url, {client_id : $client_id}).done(function(data){
                    $support = parseFloat(data);
                    $support = ($support * 60);
                    if ($support >= 0.01)
                    {
                        $('#client-support-message').removeClass('hidden');
                        $('#remaining-support').text(niceTime($support));
                        $('#client-support-message-ended').removeClass('hidden');
                        $('#client-support-message-ended').addClass('hidden');
                    }
                    else
                    {
                        $('#client-support-message').removeClass('hidden');
                        $('#client-support-message').addClass('hidden');
                        $('#client-support-message-ended').removeClass('hidden');
                    }
                });
            }
        });
    },
    niceTime = function(s) {
        if (!s) {s=0;}
        hours = parseInt( s / 3600 ) % 24;
        minutes = parseInt( s / 60 ) % 60;
        seconds = s % 60;

        return (hours < 10 ? "0" + hours : hours) + ":" + (minutes < 10 ? "0" + minutes : minutes) + ":" + (seconds  < 10 ? "0" + seconds.toFixed(0) : seconds.toFixed(0));
    },
    handleSelectClient = function(){
        $('.invoice_to').each(function(){
            var $base_url = $('#base-url').data('target'),
                $url = $.trim( $base_url + 'index.php/clients/get_active_clients' );

            $.getJSON( $url, function(response){
                var stringified = JSON.stringify(response);
                stringified = stringified.replace(/client_id/g, 'id');
                stringified = stringified.replace(/name_company/g, 'text');
                var data = JSON.parse(stringified);
                $('.invoice_to').select2({
                    data: data
                })
            });
        });
    },
    handleUpdateClientExtraTime = function() {
        $("#deduct-extra").on('click', function(){
            var $this = $(this);
            $this.attr("disabled","disabled");
            var $url = $('#base-url').data('target') + 'index.php/clients/substract_from_support';
            $.getJSON({
                url: $url,
                data: {
                    duration: $this.data('duration'),
                    client_id: $this.data('clientid'),
                    ticket_id: $this.data('ticketid')
                },
                success: function (data) {
                    location.reload();
                }
            });
        });
    },
    handleBillClientExtraTime = function() {
        $("#bill-extra").on('click', function(){
            var $this = $(this);
            swal({
              title: $('#time-billed').data('generateinvoice'),
              text: $('#time-billed').data('prompt'),
              type: "warning",
              showCancelButton: true,
              confirmButtonClass: "btn-success",
              cancelButtonClass: "btn-danger",
              confirmButtonText: $('#btn-generate').data('text'),
              cancelButtonText: $('#btn-cancel').data('text'),
              closeOnConfirm: true,
              closeOnCancel: false
            },
            function(isConfirm) {
              if (isConfirm) {
                var url = $('#base-url').data('target') + 'index.php/invoices/generate_from_support';
                $.getJSON({
                    url: url,
                    data: {
                        subject: $this.data('subject'),
                        duration: $this.data('duration'),
                        client_id: $this.data('clientid'),
                        ticket_id: $this.data('ticketid')
                    },
                    success: function (data) {
                        if (data.success == 1 ) {
                            App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#support-billed').data('success')});
                            setTimeout(function () {
                                window.location = $('#base-url').data('target') + 'index.php/invoices/edit?id='+data.invoicenumb;
                            }, 6000);
                        }
                    }
                });
              } else {
                swal({
                  title: $('#time-billed').data('cancelled'),
                  text: $('#time-billed').data('cancel'),
                  type: "error"
                });
              }
            });
        });
    },
    handleDeleteSupport = function(){
        var $table = $('#btable'),
            $remove = $('#remove-support'),
            selections = [];

        // sometimes footer render error.
        setTimeout(function () {
            $table.bootstrapTable('resetView');
        }, 200);
        $table.on('check.bs.table uncheck.bs.table ' +
                        'check-all.bs.table uncheck-all.bs.table', function () {
                    $remove.prop('disabled', !$table.bootstrapTable('getSelections').length);

                    // save your data, here just save the current page
                    selections = getIdSelections();
                    // push or splice the selections if you want to save all data selections
                });
        $remove.click(function () {
            var ids = getIdSelections();
            $base_url = $('#base-url').data('target'),
            $url = $.trim( $base_url + 'index.php/support/delete_support' );
            $this = $('#remove-support');
            swal({
              title: $this.data('sure'),
              text: $this.data('message'),
              type: "warning",
              showCancelButton: true,
              confirmButtonClass: "btn-danger",
              confirmButtonText: $this.data('confirm'),
              cancelButtonText: $('#btn-cancel').data('text'),
              closeOnConfirm: true
            },
            function(){ 
                $.getJSON({
                    url: $url,
                    data: {
                        id: ids
                    },
                    success: function (data) {
                        if (data.success > 0)
                        {
                            $table.bootstrapTable('remove', {
                                field: 'id',
                                values: ids
                            });
                            App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#remove-support').data('success')});
                            $remove.prop('disabled', true);
                        }
                        if(data.fail > 0)
                        {
                            App.alert({container: $('#notification-alert'), type: "danger", close: true, message: $('#remove-support').data('danger') + ' ' + data.fail });
                            setTimeout(function () {
                                $table.bootstrapTable('refresh', true);
                            }, 200);
                            $remove.prop('disabled', true);
                        }
                    }
                });
            });
        });
        function getIdSelections() {
            return $.map($table.bootstrapTable('getSelections'), function (row) {
                return row.id
            });
        }
    };
    return {
        init: function() {
            handleAddEventForm(),
            handleClientSupportContract(),
            handleSelectClient(),
            handleUpdateClientExtraTime(),
            handleBillClientExtraTime(),
            handleDeleteSupport()
        }
    }
})(jQuery);
jQuery(document).ready(function() {
    Support.init()
});