var Timetracker = (function($) {
    var handleTimetracker = function() {
        $labelBillNow = $('#timer-warning').data('bill-now');
        $labelClearTask = $('#timer-warning').data('clear-task');
    	t.run = function() {
            $("#tracker-table input[type=checkbox]" ).each(function(index){
                // Operate on the given row
                var tr = $(this).closest('tr'),
                    // Get the task ID
                    id = tr.find('.selectedid').val(),
                    isChecked = tr.find('.timer'),
                    userID = tr.find('.timer'),
                    // Get the task total timed milliseconds
                    timed = tr.find('.timed'),
                    // Get the amount of time in seconds
                    taskContinuousElapsedTime = tr.find('.taskContinuousElapsedTime'),
                    // When the task first started ?
                    startedOn = tr.find('.startedOn');
                // Store a local copy to speed up computation
                localStorage.setItem('startedOn_'+id, startedOn.val().toString());

                // if (isChecked.val() == 1 && userID.data('userid') != localStorage.getItem('user_id')) {
                //     isChecked.prop('disabled', true);
                //     tr.find('.client').prop('readonly', true);
                //     tr.find('.task').prop('readonly', true);
                //     tr.find('.agent').prop('readonly', true);
                //     tr.find('.rate').prop('readonly', true);
                //     tr.find('.total').prop('readonly', true);
                //     tr.find('.desc').prop('readonly', true);
                //     timed.prop('readonly', true);
                //     tr.find('.bill').prop('disabled', true);
                //     tr.find('.delete').prop('disabled', true);
                // }
                // Fire events when timer is started
                if ($(this).is(":checked")) {
                    // Task amount in specified currency in settings
                    var total = tr.find('.total'),
                        // Current timestamp
                        timeStamp = Date.now(),
                        // Current rate per hour
                        rate = tr.find('.rate');

                    localStorage.setItem(id, 'checked');
                    localStorage.setItem('user_id', localStorage.getItem('user_id'));
                    isChecked.data('value', 1);
                    userID.data('userid', localStorage.getItem('user_id'));

                    taskStartedOn = localStorage.getItem('startedOn_'+id);
                    if (!taskStartedOn || taskStartedOn <= 0) {
                        localStorage.setItem('startedOn_'+id, timeStamp.toString());
                        startedOn.val(localStorage.getItem('startedOn_'+id));
                        t.config.savenext = 0;
                    }
                    taskStamp = parseInt(taskStartedOn); // Assign taskStartedOn to taskStamp
                    taskContinuousElapsed = (parseInt(t.increment(taskStamp)) + 1); // Track continuous elapsed time

                    sessionStamp = localStorage.getItem('ts_'+id);
                    if (!sessionStamp) {
                     localStorage.setItem('ts_'+id, timeStamp.toString());
                      sessionStamp = timeStamp;
                    }
                    else {
                      sessionStamp = parseInt(sessionStamp);
                    }

                    sessionElapsedTime = (parseInt(t.increment(sessionStamp)) + 1);

                    taskContinuousElapsedTime.data('value', parseInt(taskContinuousElapsed));
                    taskContinuousElapsedTime.val( t.niceTime(taskContinuousElapsedTime.data('value')) );

                    sessionTimed = t.computeSessionDuration(taskStartedOn, sessionElapsedTime);

                    timed.data('value', parseInt(t.totalTimed(sessionTimed, id)));
                    timed.val( t.niceTime(timed.data('value')) );

                    total.data('value', parseInt(t.totalTimed(sessionTimed, id)) * (rate.val()/3600) );
                    total.val( t.config.currency+total.data('value') );
                    tr.addClass('success');
                }
                else
                {
                    tr.removeClass('success');
                    localStorage.setItem(id, '');
                    localStorage.setItem('ts_'+id, '');
                    localStorage.setItem('timed_'+id, parseInt(timed.data('value')));
                    //t.config.savenext = 0;
                }
                $(this).on('change', function(){
                    t.config.savenext = 0;
                });
            });
    		// Update title and save countdown
    		if ($('.timer:checked').length>0) {
    			t.config.savenext = t.config.savenext - 1000;
                localStorage.setItem('running_timers', 1);
    		} else {
                localStorage.setItem('running_timers', '');
    		}
    		// Saving time?
    		if (t.config.savenext <= 0) {
    			t.config.savenext = t.config.savedefault;
    			t.save();
    		}
    	};
        t.computeSessionDuration = function(start, elapsed) {
            now = Date.now();
            return parseInt((now/1000) - ((start / 1000) + (((now/1000) - (start/1000)) - (elapsed))));
        };

        t.increment = function(s) {
            elapsedTime = Date.now() - s;
            return Math.round(elapsedTime / 1000).toString();
        };
        t.totalTimed = function(s, id) {
            id = 'timed_' + id;
            return parseInt(localStorage.getItem(id)) + s;
        };
    	t.save = function() {

    		var data = {};

    		$( "#tracker-table tr.taskrow" ).each(function(index){
    			var tr = $(this);
    			var row = {
    				timer: tr.find('.timer').checked,
    				date: tr.find('.date').val(),
    				client: t.escape(tr.find('.client').val()),
                    task: tr.find('.task').val(),
    				agent: t.escape(tr.find('.agent').val()),
    				rate: tr.find('.rate').val(),
    				total: tr.find('.total').data('value'),
    				desc: tr.find('.desc').val(),
                    timed: tr.find('.timed').data('value'),
                    isChecked: tr.find('.timer').data('value'),
                    userID: tr.find('.timer').data('userid'),
                    taskContinuousElapsedTime: tr.find('.taskContinuousElapsedTime').data('value'),
    				startedOn: tr.find('.startedOn').val()
    			};

    			data[tr.data('id')] = row;
    		});

    	
    		var jsondata = JSON.stringify(data);

    		$.ajax({
    			type: "POST",
    			url: "?action=save",
    			data: { json: jsondata }
    		})
    		.done(function( msg ) {
    			//console.log(msg);
    		});

    	};

    	t.load = function() {
    		jsondata = t.config.initialdata;
    		data = JSON.parse(jsondata);

            $clientPlaceholder = $('#time-billed').data('client');
            $taskPlaceholder = $('#time-billed').data('task');
            $assignedToPlaceholder = $('#time-billed').data('assignedto');
            $notesPlaceholder = $('#time-billed').data('notes');

    		$('#tracker-table tbody').html('');
    		var buffer = '<!--start-->';
    		//console.log(data);
    		for (var key in data) {
    			var obj = data[key];
    			buffer += 
    				'<tr id="task-'+key+'" data-id="'+key+'" class="taskrow">' +
                        '<td><input class="selectedid hidden" value="'+key+'"></td>' +
                        '<td><input class="timer" type="checkbox" '+localStorage.getItem(key)+' data-value="'+obj.isChecked+'" data-userid="'+obj.userID+'" data-agent="'+obj.agent+'" value="'+obj.isChecked+'"></td>' +
                        '<td><input class="startedOn hidden" type="text" value="'+obj.startedOn+'"></td>' +
    					'<td><input class="client" type="text" placeholder="'+$clientPlaceholder+'" value="'+obj.client+'" style="color:'+t.generateColor( obj.client )+'"></td>' +
                        '<td><input class="task" type="text" placeholder="'+$taskPlaceholder+'" value="'+obj.task+'"></td>' +
    					'<td><input class="agent" type="text" placeholder="'+$assignedToPlaceholder+'" value="'+obj.agent+'"></td>' +
    					'<td><input class="rate" type="text" placeholder="'+obj.rate+'" value="'+obj.rate+'"></td>' +
                        '<td><input class="timed" type="text" placeholder="0:00:00" data-value="'+obj.timed+'" value="'+t.niceTime(obj.timed)+'"></td>' +
    					'<td><input class="taskContinuousElapsedTime hidden" type="text" placeholder="0:00:00" data-value="'+obj.taskContinuousElapsedTime+'" value="'+t.niceTime(obj.taskContinuousElapsedTime)+'"></td>' +
    					'<td><input class="total" data-value="'+obj.total+'" type="text" placeholder="'+t.config.currency+obj.total+'" value="'+t.config.currency+obj.total+'"></td>' +
                        '<td><input class="desc" type="text" placeholder="'+$notesPlaceholder+'" value="'+obj.desc+'"></td>' +
                        '<td><button class="bill btn btn-success btn-sm" title="'+$labelBillNow+'"><i class="fa fa-dollar"></i></button></td>' +
                        '<td><button class="delete btn btn-danger btn-sm" title="'+$labelClearTask+'"><i class="fa fa-close"></i></button></td>' +
    				'</tr>';
    		};
    		//console.log(buffer);
    		$('#tracker-table tbody').html(buffer);
    	};

    	t.niceTime = function(s) {
    		if (!s) {s=0;}
    		hours = parseInt( s / 3600 ) % 24;
    		minutes = parseInt( s / 60 ) % 60;
    		seconds = s % 60;

    		return (hours < 10 ? "0" + hours : hours) + ":" + (minutes < 10 ? "0" + minutes : minutes) + ":" + (seconds  < 10 ? "0" + seconds.toFixed(0) : seconds.toFixed(0));
    	};
        t.escape = function(s) {
            return s.replace(/'/g, "\\'");
        }
        t.isChecked = function(s) {
            return s == 1 ? 'checked': '';
        };

    	t.generateColor = function(string) {
    		string += 'mmanagerisanimportantprojectbuiltformydaughtermaelys';
    		var hash = '',
    			curchar;
    		for (var i = 0; i < string.length; i++) {
    			curchar = (string.toLowerCase().charCodeAt(i)-97) /25*255;
    			curchar = parseInt(curchar.toFixed(0), 10).toString(16);
    			hash += curchar;
    		}
    		return '#'+hash.substr(0,6);
    	};

    	/**
    	 * Events
    	 */

    	$('#save').on('click', function() {
    		t.config.savenext = 0;
    	});

    	$(document.body).on('click', 'button.delete', function() {
            var tr = $(this).closest('tr'),
                timerReset = $('#timer-reset');
            swal({
              title: $('#time-billed').data('clear'),
              text: $('#time-billed').data('promptclear'),
              type: "warning",
              showCancelButton: true,
              confirmButtonClass: "btn-success",
              cancelButtonClass: "btn-danger",
              confirmButtonText: $('#btn-reset').data('text'),
              cancelButtonText: $('#btn-cancel').data('text'),
              closeOnConfirm: true,
              closeOnCancel: true
            },
            function(isConfirm) {
              if (isConfirm) {
                var url = $('#base-url').data('target') + 'index.php/invoices/generate_from_tracker';
                tr.find('.task').val('');
                tr.find('.agent').val('');
                tr.find('.client').val('');
                tr.find('.total').data('value', 0);
                tr.find('.timer').data('value', 0);
                tr.find('.total').val(t.config.currency+'0.00');
                tr.find('.rate').val(t.config.rate);
                tr.find('.desc').val('');
                tr.find('.timed').data('value', 0);
                tr.find('.taskContinuousElapsedTime').data('value', 0);
                tr.find('.timed').val('00:00:00');
                tr.find('.taskContinuousElapsedTime').val('00:00:00');
                tr.find('.startedOn').val('0');
                t.config.savenext = 0;
              }
            });
        });

        //Bill Now
        $(document.body).on('click', 'button.bill', function() {
            var tr = $(this).closest('tr');

            swal({
              title: $('#time-billed').data('generateinvoice'),
              text: $('#time-billed').data('prompt'),
              type: "warning",
              showCancelButton: true,
              confirmButtonClass: "btn-success",
              cancelButtonClass: "btn-danger",
              confirmButtonText: $('#btn-generate').data('text'),
              cancelButtonText: $('#btn-cancel').data('text'),
              closeOnConfirm: true,
              closeOnCancel: false
            },
            function(isConfirm) {
              if (isConfirm) {
                var url = $('#base-url').data('target') + 'index.php/invoices/generate_from_tracker';
                $.getJSON({
                    url: url,
                    data: {
                        item_name: tr.find('.task').val(),
                        client_name: tr.find('.client').val(),
                        agent: tr.find('.agent').val(),
                        subtotal: tr.find('.total').data('value'),
                        item_price: tr.find('.rate').val(),
                        notes: tr.find('.desc').val(),
                        item_quantity: tr.find('.timed').val()
                    },
                    success: function () {}
                });
                t.config.savenext = 0;
                App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#time-billed').data('success')});
                setTimeout(function () {
                    window.location = $('#base-url').data('target') + 'index.php/invoices';
                }, 3000);
              } else {
                swal({
                  title: $('#time-billed').data('cancelled'),
                  text: $('#time-billed').data('cancel'),
                  type: "error"
                });
              }
            });
    	});

        $(document.body).on('focus', 'input.client', function(){
            var tr = $(this).closest('tr');
            url = $('#base-url').data('target') + 'index.php/clients/clients_autocomplete';
            $.getJSON(url, function(data){
                $( ".client" ).autocomplete({
                  source: data
                });
                tr.find('.client').autocomplete( "option", "appendTo", "#tracker-table tbody");
            });
        });
        $(document.body).on('focus', 'input.agent', function(){
            var tr = $(this).closest('tr');
            url = $('#base-url').data('target') + 'index.php/users/ajax/users_autocomplete';
            $.getJSON(url, function(data){
                $( ".agent" ).autocomplete({
                  source: data
                });
                tr.find('.agent').autocomplete( "option", "appendTo", "#tracker-table tbody");
            });
        });
    	// Update time manually
    	$(document.body).on('keyup', 'input.timed', function() {
    		var secs = $(this).val().split(':');
    		$(this).data('value', parseInt(secs[0])*3600+parseInt(secs[1])*60+parseInt(secs[2]));
    		t.config.savenext = 0;
    	});

    	// Update total manually
    	$(document.body).on('keyup', 'input.total', function() {
    		$(this).data('value', parseFloat($(this).val().replace(/[^0-9\.]/g, '')) );
    		t.config.savenext = 0;
    	});

    	// Change color of Client
    	$(document.body).on('input paste', 'input.client', function() {
    		$(this).css('color', t.generateColor( $(this).val() ) );
    		t.config.savenext = 0;
    	});

    	// Trigger saving when editing other fields too
    	$(document.body).on('keyup', 'input.date,input.task,input.rate,input.desc', function() {
    		t.config.savenext = 0;
    	});

        setInterval(function(){t.run();}, 1000);
    	t.load();
    },
    handleMergeInvoiceTasks = function(){
        var $table = $('#mergeTable'),
            $remove = $('#merge-tasks'),
            selections = [];

        // sometimes footer render error.
        setTimeout(function () {
            $table.bootstrapTable('resetView');
        }, 200);
        $table.on('check.bs.table uncheck.bs.table ' +
                        'check-all.bs.table uncheck-all.bs.table', function () {
                    $remove.prop('disabled', !$table.bootstrapTable('getSelections').length);

                    // save your data, here just save the current page
                    selections = getIdSelections();
                    // push or splice the selections if you want to save all data selections
                });
        $remove.click(function () {
            var ids = getIdSelections();
            $base_url = $('#base-url').data('target'),
            $url = $.trim( $base_url + 'index.php/tracking/merge_tasks' );
            $this = $('#merge-tasks');
            swal({
              title: $this.data('sure'),
              text: $this.data('message'),
              type: "warning",
              showCancelButton: true,
              confirmButtonClass: "btn-danger",
              confirmButtonText: $this.data('confirm'),
              cancelButtonText: $('#btn-cancel').data('text'),
              closeOnConfirm: true
            },
            function(){ 
                $.getJSON({
                    url: $url,
                    data: {
                        id: ids
                    },
                    success: function (data) {
                        if (data.success > 0)
                        {
                            // $table.bootstrapTable('remove', {
                            //     field: 'enc_invoice_number',
                            //     values: ids
                            // });
                            $("#modalTable").modal('hide');
                            $('#modalTable').on('hidden.bs.modal', function() {
                                App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#merge-tasks').data('success')});
                                $remove.prop('disabled', true);
                                setTimeout(function () {
                                    window.location = $base_url + 'index.php/invoices/edit?id='+data.invoice_number;
                                }, 3000);
                            });
                        }
                        if(data.fail > 0)
                        {
                            $("#modalTable").modal('hide');
                            $('#modalTable').on('hidden.bs.modal', function() {
                                App.alert({container: $('#notification-alert'), type: "danger", close: true, message: $('#merge-tasks').data('danger') });
                                setTimeout(function () {
                                    $table.bootstrapTable('refresh', true);
                                }, 200);
                                $remove.prop('disabled', true);
                            });
                        }
                    }
                });
            });
        });
        function getIdSelections() {
            return $.map($table.bootstrapTable('getSelections'), function (row) {
                return row.taskid
            });
        }
    };
    return {
        init: function() {
            handleTimetracker(),
            handleMergeInvoiceTasks()
        }
    }
})(jQuery);
jQuery(document).ready(function() {
    if (storageAvailable('localStorage')) {
        Timetracker.init()
    } else {
        swal("Local Storage is not enabled on your browser !");
    }

    function storageAvailable(type) {
        try {
            var storage = window[type],
                x = '__storage_test__';
            storage.setItem(x, x);
            storage.removeItem(x);
            return true;
        }
        catch(e) {
            return e instanceof DOMException && (
                // everything except Firefox
                e.code === 22 ||
                // Firefox
                e.code === 1014 ||
                // test name field too, because code might not be present
                // everything except Firefox
                e.name === 'QuotaExceededError' ||
                // Firefox
                e.name === 'NS_ERROR_DOM_QUOTA_REACHED') &&
                // acknowledge QuotaExceededError only if there's something already stored
                storage.length !== 0;
        }
    }
});