var UpdatePrice = (function ($) {
    var handleTable = function () {
        function restoreRow(oTable, nRow) {
            var aData = oTable.fnGetData(nRow);
            var jqTds = $('>td', nRow);

            for (var i = 0, iLen = jqTds.length; i < iLen; i++) {
                oTable.fnUpdate(aData[i], nRow, i, false);
            }

            oTable.fnDraw();
        }
        function editRow(oTable, nRow) {
            var aData = oTable.fnGetData(nRow);
            var jqTds = $('>td', nRow);
            jqTds[0].innerHTML = '<input type="text" readonly="true" class="form-control input-small" value="' + aData[0] + '">';
            jqTds[1].innerHTML = '<input type="text" class="form-control input-small" value="' + aData[1] + '">';
            jqTds[2].innerHTML = '<input type="text" class="form-control input-small" value="' + aData[2] + '">';
            jqTds[3].innerHTML = '<input type="text" class="form-control input-small" onkeypress="return IsNumeric(event);" ondrop="return false;" onpaste="return false;" value="' + aData[3] + '">';
            jqTds[4].innerHTML = '<input type="text" class="form-control input-small" onkeypress="return IsNumeric(event);" ondrop="return false;" onpaste="return false;" value="' + aData[4] + '">';
            jqTds[5].innerHTML = '<a class="edit" href=""><i class="fa fa-floppy-o" aria-hidden="true"></i></a>';
            jqTds[6].innerHTML = '<a class="cancel" href=""><i class="fa fa-ban" aria-hidden="true"></i></a>';
        }
        function saveRow(oTable, nRow) {
            var jqInputs = $('input', nRow);
            oTable.fnUpdate(jqInputs[0].value, nRow, 0, false);
            oTable.fnUpdate(jqInputs[1].value, nRow, 1, false);
            oTable.fnUpdate(jqInputs[2].value, nRow, 2, false);
            oTable.fnUpdate(jqInputs[3].value, nRow, 3, false);
            oTable.fnUpdate(jqInputs[4].value, nRow, 4, false);
            oTable.fnUpdate('<a class="edit" href=""><i class="icon-note"></i></a>', nRow, 5, false);
            oTable.fnUpdate('<a class="delete" href=""><i class="icon-trash" style="color: red"></i></a>', nRow, 6, false);
            oTable.fnDraw();

            var updateItemUrl = $('#base-url').data('target') + 'index.php/products/ajax/batch_update';
            var item_id = jqInputs[0].value;
            var $db_data = {
                sku: jqInputs[1].value,
                name: jqInputs[2].value,
                purchase_price: jqInputs[3].value,
                price: jqInputs[4].value
            };
            $.getJSON(updateItemUrl, {item_id: item_id, db_data: $db_data}, function(result){
                if(result.status == 1)
                {

                    App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#default-save-success').data('message')});
                }
                else
                {
                    message = result.error;
                    message = message.replace(/<\/?p[^>]*>/g, "");
                    if( message != '')
                    {
                        App.alert({container: $('#notification-alert'), type: "danger", close: true, message: message});
                    }
                }
            });
        }
        function cancelEditRow(oTable, nRow) {
            var jqInputs = $('input', nRow);
            oTable.fnUpdate(jqInputs[0].value, nRow, 0, false);
            oTable.fnUpdate(jqInputs[1].value, nRow, 1, false);
            oTable.fnUpdate(jqInputs[2].value, nRow, 2, false);
            oTable.fnUpdate(jqInputs[3].value, nRow, 3, false);
            oTable.fnUpdate(jqInputs[4].value, nRow, 4, false);
            oTable.fnUpdate('<a class="edit" href=""><i class="icon-note"></i></a>', nRow, 5, false);
            oTable.fnDraw();
        }
        var table = $('#update_price');

        var oTable = table.dataTable({

            // Uncomment below line("dom" parameter) to fix the dropdown overflow issue in the datatable cells. The default datatable layout
            // setup uses scrollable div(table-scrollable) with overflow:auto to enable vertical scroll(see: assets/global/plugins/datatables/plugins/bootstrap/dataTables.bootstrap.js). 
            // So when dropdowns used the scrollable div should be removed. 
            //"dom": "<'row'<'col-md-6 col-sm-12'l><'col-md-6 col-sm-12'f>r>t<'row'<'col-md-5 col-sm-12'i><'col-md-7 col-sm-12'p>>",

            "lengthMenu": [
                [5, 15, 20, -1],
                [5, 15, 20, "All"] // change per page values here
            ],

            // Or you can use remote translation file
            //"language": {
            //   url: '//cdn.datatables.net/plug-ins/3cfcc339e89/i18n/Portuguese.json'
            //},

            // set the initial value
            "pageLength": 15,

            "language": {
                "lengthMenu": " _MENU_ records"
            },
            "columnDefs": [{ // set default column settings
                'orderable': true,
                'targets': [0]
            }, {
                "searchable": true,
                "targets": [0]
            }],
            "order": [
                [0, "asc"]
            ] // set first column as a default sort by asc
        });

        var tableWrapper = $("#update_price_wrapper");

        var nEditing = null;
        var nNew = false;

        $('#update_price_new').click(function (e) {
            e.preventDefault();

            if (nNew && nEditing) {
                if (confirm("Previose row not saved. Do you want to save it ?")) {
                    saveRow(oTable, nEditing); // save
                    $(nEditing).find("td:first").html("Untitled");
                    nEditing = null;
                    nNew = false;

                } else {
                    oTable.fnDeleteRow(nEditing); // cancel
                    nEditing = null;
                    nNew = false;
                    
                    return;
                }
            }

            var aiNew = oTable.fnAddData(['', '', '', '', '', '']);
            var nRow = oTable.fnGetNodes(aiNew[0]);
            editRow(oTable, nRow);
            nEditing = nRow;
            nNew = true;
        });

        table.on('click', '.delete', function (e) {
            e.preventDefault();
            var $this = $(this);
            swal({
              title: $this.data('sure'),
              text: $this.data('message'),
              type: "warning",
              showCancelButton: true,
              confirmButtonClass: "btn-danger",
              confirmButtonText: $this.data('confirm'),
              cancelButtonText: $('#btn-cancel').data('text'),
              closeOnConfirm: true
            },
            function(){ 
                var nRow = $this.parents('tr')[0];
                var $item_id = [].concat(oTable.fnGetData(nRow)[0]);
                var deleteItemUrl = $('#base-url').data('target') + 'index.php/products/delete_item';
                $.getJSON(deleteItemUrl, {id: $item_id}, function(result){
                    if(result.success > 0)
                    {
                        oTable.fnDeleteRow(nRow);
                        App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#remove-item').data('success')});
                    }
                    if(result.fail > 0)
                    {
                        App.alert({container: $('#notification-alert'), type: "danger", close: true, message: $('#remove-item').data('danger') + '&nbsp;' + result.fail});
                    }
                });
            });
        });
        table.on('click', '.cancel', function (e) {
            e.preventDefault();
            if (nNew) {
                oTable.fnDeleteRow(nEditing);
                nEditing = null;
                nNew = false;
            } else {
                restoreRow(oTable, nEditing);
                nEditing = null;
            }
        });

        table.on('click', '.edit', function (e) {
            e.preventDefault();
            nNew = false;
            
            /* Get the row as a parent of the link that was clicked on */
            var nRow = $(this).parents('tr')[0];

            if (nEditing !== null && nEditing != nRow) {
                /* Currently editing - but not this row - restore the old before continuing to edit mode */
                restoreRow(oTable, nEditing);
                editRow(oTable, nRow);
                nEditing = nRow;
            } else if (nEditing == nRow && this.innerHTML == '<i class="fa fa-floppy-o" aria-hidden="true"></i>') {
                /* Editing this row and want to save it */
                saveRow(oTable, nEditing);
                nEditing = null;
            } else {
                /* No edit in progress - let's start one */
                editRow(oTable, nRow);
                nEditing = nRow;
            }
        });
    };
    return {
        init: function () {
            handleTable();
        }
    };

})(jQuery);
jQuery(document).ready(function() {
    UpdatePrice.init();
});