var userIncome = (function($) {
    var handlePieCharts = function() {
            var pieChart = echarts.init(document.getElementById("echarts_pie")),
                options = {
                    tooltip: {
                        trigger: "item",
                        formatter: "{a} <br/>{b}: {c} ({d}%)"
                    },
                    legend: {
                        orient: "vertical",
                        x: "left",
                        y: "left",
                        padding: 0,
                        show: false
                    },
                    toolbox: {
                        show: !0,
                        showTitle: !1,
                        feature: {
                            mark: {
                                show: !1
                            },
                            dataView: {
                                show: !1,
                                readOnly: !1
                            },
                            restore: {
                                show: !0
                            },
                            saveAsImage: {
                                show: !0
                            }
                        }
                    },
                    series: [{
                        name: '',
                        type: "pie",
                        selectedMode: "single",
                        radius: ["50%", "75%"],
                        avoidLabelOverlap: true,
                        label: {
                            normal: {
                                show: true
                            },
                            emphasis: {
                                show: true
                            }
                        },
                        labelLine: {
                            normal: {
                                show: true
                            },
                            emphasis: {
                                show: true
                            }
                        },
                        data: []
                    }]
                };
            // Dynamic range
            $('#tax-report-range').on('apply.daterangepicker', function(ev, picker) {
                start = picker.startDate.format('YYYY-MM-DD');
                end = picker.endDate.format('YYYY-MM-DD');

                url = $("#base-url").data("target") + "index.php/reports/get_income_by_user", $.getJSON(url, {
                    start: start,
                    end: end
                }).done(function(e) {
                    pieChart.setOption({
                        series: [{
                            name: '',
                            data: e
                        }]
                    })
                });
                url2 = $('#base-url').data('target') + 'index.php/reports/get_income_by_user?start='+start+'&end='+end;
                $('#home-items-count').bootstrapTable('refresh', {url: url2});
            });

            // Default range
            url = $("#base-url").data("target") + "index.php/reports/get_income_by_user", $.getJSON(url, {
                start: start.format('YYYY-MM-DD'),
                end: end.format('YYYY-MM-DD')
            }).done(function(e) {
                pieChart.setOption({
                    series: [{
                        name: '',
                        data: e
                    }]
                })
            });
            url2 = $('#base-url').data('target') + 'index.php/reports/get_income_by_user?start='+start.format('YYYY-MM-DD')+'&end='+end.format('YYYY-MM-DD');
            $('#home-items-count').bootstrapTable('refresh', {url: url2});

            // Resize the graph
            jQuery(window).on("resize", function() {
                null != pieChart && void 0 != pieChart && pieChart.resize()
            });
            pieChart.setOption(options);
        },
        handleGenerateCommissions = function() {
            $("#generate-commissions").click(function () {
                var $this = $(this);
                $base_url = $('#base-url').data('target'),
                $url = $.trim( $base_url + 'index.php/reports/generate_commissions' );
                swal({
                  title: $this.data('sure'),
                  text: $this.data('message'),
                  type: "warning",
                  showCancelButton: true,
                  confirmButtonClass: "btn-success",
                  confirmButtonText: $this.data('confirm'),
                  cancelButtonText: $('#btn-cancel').data('text'),
                  closeOnConfirm: true
                },
                function(){ 
                    $.getJSON({
                        url: $url,
                        data: {},
                        success: function (data) {
                            if (data.success > 0)
                            {
                                App.alert({container: $('#notification-alert'), type: "success", close: true, message: $this.data('success')});
                                setTimeout(function () {
                                    location.reload()
                                }, 2000);
                            }
                            if(data.fail > 0)
                            {
                                App.alert({container: $('#notification-alert'), type: "danger", close: true, message: $this.data('danger')});
                            }
                        }
                    });
                });
            });
        },
        handleGenerateUsersCommissions = function(){
            var $table = $('#home-items-count'),
                $selected = $('#generate-selection-commissions'),
                selections = [];

            // sometimes footer render error.
            setTimeout(function () {
                $table.bootstrapTable('resetView');
            }, 200);
            $table.on('check.bs.table uncheck.bs.table ' +
                            'check-all.bs.table uncheck-all.bs.table', function () {
                        $selected.prop('disabled', !$table.bootstrapTable('getSelections').length);

                        // save your data, here just save the current page
                        selections = getIdSelections();
                        // push or splice the selections if you want to save all data selections
                    });
            $selected.click(function () {
                var ids = getIdSelections();
                $base_url = $('#base-url').data('target'),
                $url = $.trim( $base_url + 'index.php/reports/generate_users_commissions' );
                $this = $('#generate-selection-commissions');
                swal({
                  title: $this.data('sure'),
                  text: $this.data('message'),
                  type: "warning",
                  showCancelButton: true,
                  confirmButtonClass: "btn-danger",
                  confirmButtonText: $this.data('confirm'),
                  cancelButtonText: $('#btn-cancel').data('text'),
                  closeOnConfirm: true
                },
                function(){ 
                    $.getJSON({
                        url: $url,
                        data: {
                            id: ids
                        },
                        success: function (data) {
                            if (data.success > 0)
                            {
                                App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#generate-selection-commissions').data('success')});
                                setTimeout(function () {
                                    location.reload()
                                }, 2000);
                            }
                            if(data.fail > 0)
                            {
                                App.alert({container: $('#notification-alert'), type: "danger", close: true, message: $('#generate-selection-commissions').data('danger') + ' ' + data.fail });
                            }
                        }
                    });
                });
            });
            function getIdSelections() {
                return $.map($table.bootstrapTable('getSelections'), function (row) {
                    return row.user_id
                });
            }
        },
        handlePayUsersCommissions = function(){
            var $table = $('#home-items-count'),
                $selected = $('#pay-users-commissions'),
                selections = [];

            // sometimes footer render error.
            setTimeout(function () {
                $table.bootstrapTable('resetView');
            }, 200);
            $table.on('check.bs.table uncheck.bs.table ' +
                            'check-all.bs.table uncheck-all.bs.table', function () {
                        $selected.prop('disabled', !$table.bootstrapTable('getSelections').length);

                        // save your data, here just save the current page
                        selections = getIdSelections();
                        // push or splice the selections if you want to save all data selections
                    });
            $selected.click(function () {
                var ids = getIdSelections();
                $base_url = $('#base-url').data('target'),
                $url = $.trim( $base_url + 'index.php/reports/generate_users_commissions' );
                $this = $('#pay-users-commissions');
                swal({
                  title: $this.data('sure'),
                  text: $this.data('message'),
                  type: "warning",
                  showCancelButton: true,
                  confirmButtonClass: "btn-danger",
                  confirmButtonText: $this.data('confirm'),
                  cancelButtonText: $('#btn-cancel').data('text'),
                  closeOnConfirm: true
                },
                function(){ 
                    $.getJSON({
                        url: $url,
                        data: {
                            id: ids,
                            pay: true
                        },
                        success: function (data) {
                            if (data.success > 0)
                            {
                                App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#pay-users-commissions').data('success')});
                                setTimeout(function () {
                                    location.reload()
                                }, 2000);
                            }
                            if(data.fail > 0)
                            {
                                App.alert({container: $('#notification-alert'), type: "danger", close: true, message: $('#pay-users-commissions').data('danger') + ' ' + data.fail });
                            }
                        }
                    });
                });
            });
            function getIdSelections() {
                return $.map($table.bootstrapTable('getSelections'), function (row) {
                    return row.user_id
                });
            }
        },
        handlePayCommissions = function() {
            $("#pay-commissions").click(function () {
                var $this = $(this);
                $base_url = $('#base-url').data('target'),
                $url = $.trim( $base_url + 'index.php/reports/generate_commissions' );
                swal({
                  title: $this.data('sure'),
                  text: $this.data('message'),
                  type: "warning",
                  showCancelButton: true,
                  confirmButtonClass: "btn-success",
                  confirmButtonText: $this.data('confirm'),
                  cancelButtonText: $('#btn-cancel').data('text'),
                  closeOnConfirm: true
                },
                function(){ 
                    $.getJSON({
                        url: $url,
                        data: {pay: true},
                        success: function (data) {
                            if (data.success > 0)
                            {
                                App.alert({container: $('#notification-alert'), type: "success", close: true, message: $this.data('success')});
                                setTimeout(function () {
                                    location.reload()
                                }, 2000);
                            }
                            if(data.fail > 0)
                            {
                                App.alert({container: $('#notification-alert'), type: "danger", close: true, message: $this.data('danger')});
                            }
                        }
                    });
                });
            });
        };
    return {
        init: function() {
            handlePieCharts(),
            handleGenerateCommissions(),
            handlePayCommissions(),
            handleGenerateUsersCommissions(),
            handlePayUsersCommissions()
        }
    }
})(jQuery);
jQuery(document).ready(function() {
    userIncome.init()
});