var Users = (function($){
	var handleRedirections = function(){
		jQuery('#register-btn').click(function() {
            jQuery('.login-form').hide();
            jQuery('.register-form').show();
        });
        jQuery('#register-back-btn').click(function() {
            jQuery('.login-form').show();
            jQuery('.register-form').hide();
            var $this = $(this);
            window.location = $this.data('location');
        });
        jQuery('#forget-password').click(function() {
            jQuery('.login-form').hide();
            jQuery('.forget-form').show();
        });
        jQuery('#back-btn').click(function() {
            jQuery('.login-form').show();
            jQuery('.forget-form').hide();
        });
        jQuery('#back-btn-forgot').click(function() {
        	var $this = $(this);
        	window.location = $this.data('location');
        });
	},
	handleEditUserInfo = function(){
		var options = {
			dataType:  'json',
			success: userInfoServerResponse
		};
		$('#edit-user-form').submit(function(e){
			e.preventDefault();
			$(".btn-submit").attr("disabled","disabled");
			$(this).ajaxSubmit(options);
			return false; 
		});
	},
	handleUserRolesPermissions = function(){
		var options = {
			dataType:  'json',
			success: userRolesPermissionsServerResponse
		};
		$('.role-permission-form').submit(function(e){
			e.preventDefault();
			$(".btn-submit").attr("disabled","disabled");
			$(this).ajaxSubmit(options);
			return false; 
		});
		$('.assign-role-form').submit(function(e){
			e.preventDefault();
			$(".btn-submit").attr("disabled","disabled");
			$(this).ajaxSubmit(options);
			return false; 
		});
		$('.user-commission-settings-form').submit(function(e){
			e.preventDefault();
			$(".btn-submit").attr("disabled","disabled");
			$(this).ajaxSubmit(options);
			return false; 
		});
	},
	userRolesPermissionsServerResponse = function(responseText, statusText, xhr, $form){
		if(responseText.status == 1)
		{
			App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#default-settings-saved-success').data('message')});
			$(".btn-submit").removeAttr("disabled");
			$(".btn-submit").text($('#btn-save').data('text'));
		}
		else
		{
			message = responseText.error;
			message = message.replace(/<\/?p[^>]*>/g, "");
			if( message != '')
			{
				App.alert({container: $('#notification-alert'), type: "danger", close: true, message: message});
				$(".btn-submit").removeAttr("disabled");
				$(".btn-submit").text($('#btn-save').data('text'));
			}
			else
			{
				App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#default-settings-saved-success').data('message')});
				//location.reload();
			}
			$(".btn-submit").removeAttr("disabled");
			$(".btn-submit").text($('#btn-save').data('text'));
		}
	},
	handleUserStatus = function(){
		$('.user-status').click(function(e){
			e.preventDefault();
	        $this = $(this);
	        url = $this.attr('href');
	        id = $this.data('id');
	        swal({
	          title: $('#change-user-status').data('sure'),
	          text: $('#change-user-status').data('message'),
	          type: "info",
	          showCancelButton: true,
	          cancelButtonText: $('#btn-cancel').data('text'),
	          confirmButtonClass: "btn-info",
	          confirmButtonText: $('#change-user-status').data('confirm'),
	          closeOnConfirm: true
	        },
	        function(){ 
	            $.getJSON({
	                url: url,
	                data: {
	                    id: id
	                },
	                success: function (data) {
	                	if (data.status == 1)
	                	{
	                		location.reload();
	                	}
	                }
	            });
	        });
	    });
	},
	handleLogo = function(){
		var options = {
			dataType:  'json',
			success: logoServerResponse
		};
		$('#logo').submit(function(){
			$(".btn-submit").attr("disabled","disabled");
			$(this).ajaxSubmit(options);
			return false; 
		});
	},
	handleEmailSettings = function(){
		var options = {
			dataType:  'json',
			success: emailSettingsServerResponse
		};
		$('#email_settings_form').submit(function(){
			$(".btn-submit").attr("disabled","disabled");
			$(this).ajaxSubmit(options);
			return false; 
		});
	},
	handleEmailNotificationsSettings = function(){
		var options = {
			dataType:  'json',
			success: emailNotificationsSettingsServerResponse
		};
		$('#email_notifications_settings_form').submit(function(){
			$(".btn-submit").attr("disabled","disabled");
			$(this).ajaxSubmit(options);
			return false; 
		});
	},
	handleAvatar = function(){
		var options = {
			dataType:  'json',
			success: avatarServerResponse
		};
		$('#avatar').submit(function(){
			$(".btn-submit").attr("disabled","disabled");
			$(this).ajaxSubmit(options);
			return false; 
		});
	},
	handleChangePassword = function(){
		var options = {
			dataType:  'json',
			success: passwordServerResponse
		};
		$('#change-password-form').submit(function(){
			$(".btn-submit").attr("disabled","disabled");
			$(this).ajaxSubmit(options);
			return false; 
		});
	},
	handleMollieSettings = function(){
		var options = {
			dataType:  'json',
			success: mollieSettingsServerResponse
		};
		$('#mollie-settings-form').submit(function(){
			$(".btn-submit").attr("disabled","disabled");
			$(this).ajaxSubmit(options);
			return false; 
		});
	},
	handleIngenicoSettings = function(){
		var options = {
			dataType:  'json',
			success: ingenicoSettingsServerResponse
		};
		$('#ingenico-settings-form').submit(function(){
			$(".btn-submit").attr("disabled","disabled");
			$(this).ajaxSubmit(options);
			return false; 
		});
	},
	handleStripeSettings = function(){
		var options = {
			dataType:  'json',
			success: stripeSettingsServerResponse
		};
		$('#stripe-settings-form').submit(function(){
			$(".btn-submit").attr("disabled","disabled");
			$(this).ajaxSubmit(options);
			return false; 
		});
	},
	handlePaypalSettings = function(){
		var options = {
			dataType:  'json',
			success: paypalSettingsServerResponse
		};
		$('#paypal-settings-form').submit(function(){
			$(".btn-submit").attr("disabled","disabled");
			$(this).ajaxSubmit(options);
			return false; 
		});
		$('#sms-messages-settings-form').submit(function(){
			$(".btn-submit").attr("disabled","disabled");
			$(this).ajaxSubmit(options);
			return false; 
		});
	},
	handleInvoiceLayoutSettings = function(){
		var options = {
			dataType:  'json',
			success: layoutInvoiceSettingsServerResponse
		};
		$('#invoice_settings_layout').submit(function(){
			$(".btn-submit").attr("disabled","disabled");
			$(this).ajaxSubmit(options);
			return false; 
		});
	},
	handleQuoteLayoutSettings = function(){
		var options = {
			dataType:  'json',
			success: layoutQuoteSettingsServerResponse
		};
		$('#quote_settings_layout').submit(function(){
			$(".btn-submit").attr("disabled","disabled");
			$(this).ajaxSubmit(options);
			return false; 
		});
	},
	handleDefaultPaymentMethod = function(){
		var options = {
			dataType:  'json',
			success: defaultPaymentMethodServerResponse
		};
		$('#default-payment-method-form').submit(function(){
			$(".btn-submit").attr("disabled","disabled");
			$(this).ajaxSubmit(options);
			return false; 
		});
	},
	handleUserPreferences = function(){
		var options = {
			dataType:  'json',
			success: userPreferencesServerResponse
		};
		var optionsDayHour = {
			dataType:  'json',
			success: userPreferencesServerResponseDayHour
		};
		$('#invoice_settings_numb_curr').submit(function(){
			$(".btn-submit").attr("disabled","disabled");
			$(this).ajaxSubmit(options);
			return false; 
		});
		$('#invoice_settings_h_d').submit(function(){
			$(".btn-submit").attr("disabled","disabled");
			$(this).ajaxSubmit(optionsDayHour);
			return false; 
		});
	},
	handleUserAppVersion = function(){
		$('.appversion').click(function(){
			var $this = $(this),
				version = $this.data('version'),
				url = $('#base-url').data('target') + 'index.php/settings/ajax/set_update_version';
			$.getJSON(url, {app_version : version}).done(function(data){
				location.reload();
			});
		});
	},
	passwordServerResponse = function(responseText, statusText, xhr, $form){
		if(responseText.status == 1)
		{
			App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#default-update-success').data('message')});
			$(".btn-submit").removeAttr("disabled");
			$(".btn-submit").text($('#btn-save').data('text'));
		}
		else
		{
			message = responseText.error;
			message = message.replace(/<\/?p[^>]*>/g, "");
			App.alert({container: $('#notification-alert'), type: "danger", close: true, message: message});
			$(".btn-submit").removeAttr("disabled");
			$(".btn-submit").text($('#btn-save').data('text'));
		}
	},
	logoServerResponse = function(responseText, statusText, xhr, $form){
		if(responseText.status == 1)
		{
			App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#default-update-success').data('message')});
			location = $('#base-url').data('target') + 'index.php/settings/invoice_settings/#invoice_logo';
			location.reload();
		}
		else
		{
			var message = responseText.error;
			App.alert({container: $('#notification-alert'), type: "danger", close: true, message: message});
			$(".btn-submit").removeAttr("disabled");
			$(".btn-submit").text($('#btn-save').data('text'));
		}
	},
	emailSettingsServerResponse = function(responseText, statusText, xhr, $form){
		if(responseText.status == 1)
		{
			App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#default-update-success').data('message')});
			$(".btn-submit").removeAttr("disabled");
			$(".btn-submit").text($('#btn-save').data('text'));
		}
		else
		{
			var message = responseText.error;
			App.alert({container: $('#notification-alert'), type: "danger", close: true, message: message});
			$(".btn-submit").removeAttr("disabled");
			$(".btn-submit").text($('#btn-save').data('text'));
		}
	},
	emailNotificationsSettingsServerResponse = function(responseText, statusText, xhr, $form){
		if(responseText.status == 1)
		{
			App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#default-update-success').data('message')});
			$(".btn-submit").removeAttr("disabled");
			$(".btn-submit").text($('#btn-save').data('text'));
		}
		else
		{
			var message = responseText.error;
			App.alert({container: $('#notification-alert'), type: "danger", close: true, message: message});
			$(".btn-submit").removeAttr("disabled");
			$(".btn-submit").text($('#btn-save').data('text'));
		}
	},
	avatarServerResponse = function(responseText, statusText, xhr, $form){
		if(responseText.status == 1)
		{
			App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#default-update-success').data('message')});
			location = $('#base-url').data('target') + 'users/auth/edit_user/#tab_1_2';
			location.reload();
		}
		else
		{
			var message = responseText.error;
			App.alert({container: $('#notification-alert'), type: "danger", close: true, message: message});
			$(".btn-submit").removeAttr("disabled");
			$(".btn-submit").text($('#btn-save').data('text'));
		}
	},
	userInfoServerResponse = function(responseText, statusText, xhr, $form){
		if(responseText.status == 1)
		{
			App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#default-update-success').data('message')});
			$(".btn-submit").removeAttr("disabled");
			$(".btn-submit").text($('#btn-save').data('text'));
		}
		else
		{
			message = responseText.error;
			message = message.replace(/<\/?p[^>]*>/g, "");
			if( message != '')
			{
				App.alert({container: $('#notification-alert'), type: "danger", close: true, message: message});
				$(".btn-submit").removeAttr("disabled");
				$(".btn-submit").text($('#btn-save').data('text'));
			}
			else
			{
				App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#default-update-success').data('message')});
				location.reload();
			}
			$(".btn-submit").removeAttr("disabled");
			$(".btn-submit").text($('#btn-save').data('text'));
		}
	},
	mollieSettingsServerResponse = function(responseText, statusText, xhr, $form){
		if(responseText.status == 1)
		{
			App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#default-settings-saved-success').data('message')});
			$(".btn-submit").removeAttr("disabled");
			$(".btn-submit").text($('#btn-save').data('text'));
		}
		else
		{
			message = responseText.error;
			message = message.replace(/<\/?p[^>]*>/g, "");
			if( message != '')
			{
				App.alert({container: $('#notification-alert'), type: "danger", close: true, message: message});
				$(".btn-submit").removeAttr("disabled");
				$(".btn-submit").text($('#btn-save').data('text'));
			}
			else
			{
				App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#default-settings-saved-success').data('message')});
				location.reload();
			}
			$(".btn-submit").removeAttr("disabled");
			$(".btn-submit").text($('#btn-save').data('text'));
		}
	},
	ingenicoSettingsServerResponse = function(responseText, statusText, xhr, $form){
		if(responseText.status == 1)
		{
			App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#default-settings-saved-success').data('message')});
			$(".btn-submit").removeAttr("disabled");
			$(".btn-submit").text($('#btn-save').data('text'));
		}
		else
		{
			message = responseText.error;
			message = message.replace(/<\/?p[^>]*>/g, "");
			if( message != '')
			{
				App.alert({container: $('#notification-alert'), type: "danger", close: true, message: message});
				$(".btn-submit").removeAttr("disabled");
				$(".btn-submit").text($('#btn-save').data('text'));
			}
			else
			{
				App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#default-settings-saved-success').data('message')});
				location.reload();
			}
			$(".btn-submit").removeAttr("disabled");
			$(".btn-submit").text($('#btn-save').data('text'));
		}
	},
	ingenicoSettingsServerResponse = function(responseText, statusText, xhr, $form){
		if(responseText.status == 1)
		{
			App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#default-settings-saved-success').data('message')});
			$(".btn-submit").removeAttr("disabled");
			$(".btn-submit").text($('#btn-save').data('text'));
		}
		else
		{
			message = responseText.error;
			message = message.replace(/<\/?p[^>]*>/g, "");
			if( message != '')
			{
				App.alert({container: $('#notification-alert'), type: "danger", close: true, message: message});
				$(".btn-submit").removeAttr("disabled");
				$(".btn-submit").text($('#btn-save').data('text'));
			}
			else
			{
				App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#default-settings-saved-success').data('message')});
				location.reload();
			}
			$(".btn-submit").removeAttr("disabled");
			$(".btn-submit").text($('#btn-save').data('text'));
		}
	},
	stripeSettingsServerResponse = function(responseText, statusText, xhr, $form){
		if(responseText.status == 1)
		{
			App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#default-settings-saved-success').data('message')});
			$(".btn-submit").removeAttr("disabled");
			$(".btn-submit").text($('#btn-save').data('text'));
		}
		else
		{
			message = responseText.error;
			message = message.replace(/<\/?p[^>]*>/g, "");
			if( message != '')
			{
				App.alert({container: $('#notification-alert'), type: "danger", close: true, message: message});
				$(".btn-submit").removeAttr("disabled");
				$(".btn-submit").text($('#btn-save').data('text'));
			}
			else
			{
				App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#default-settings-saved-success').data('message')});
				location.reload();
			}
			$(".btn-submit").removeAttr("disabled");
			$(".btn-submit").text($('#btn-save').data('text'));
		}
	},
	paypalSettingsServerResponse = function(responseText, statusText, xhr, $form){
		if(responseText.status == 1)
		{
			App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#default-settings-saved-success').data('message')});
			$(".btn-submit").removeAttr("disabled");
			$(".btn-submit").text($('#btn-save').data('text'));
		}
		else
		{
			message = responseText.error;
			message = message.replace(/<\/?p[^>]*>/g, "");
			if( message != '')
			{
				App.alert({container: $('#notification-alert'), type: "danger", close: true, message: message});
				$(".btn-submit").removeAttr("disabled");
				$(".btn-submit").text($('#btn-save').data('text'));
			}
			else
			{
				App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#default-settings-saved-success').data('message')});
				location.reload();
			}
			$(".btn-submit").removeAttr("disabled");
			$(".btn-submit").text($('#btn-save').data('text'));
		}
	},
	userPreferencesServerResponse = function(responseText, statusText, xhr, $form){
		if(responseText.status == 1)
		{
			App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#default-update-success').data('message')});
			$(".btn-submit").removeAttr("disabled");
			$(".btn-submit").text($('#btn-save').data('text'));
		}
		else
		{
			message = responseText.error;
			message = message.replace(/<\/?p[^>]*>/g, "");
			if( message != '')
			{
				App.alert({container: $('#notification-alert'), type: "danger", close: true, message: message});
			}
			else
			{
				App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#default-update-success').data('message')});
			}
			$(".btn-submit").removeAttr("disabled");
			$(".btn-submit").text($('#btn-save').data('text'));
		}
	},
	userPreferencesServerResponseDayHour = function(responseText, statusText, xhr, $form){
		if(responseText.status == 1)
		{
			location = $('#base-url').data('target') + 'index.php/settings/invoice_settings/#invoice_hour_date';
			location.reload();
		}
		else
		{
			message = responseText.error;
			message = message.replace(/<\/?p[^>]*>/g, "");
			if( message != '')
			{
				App.alert({container: $('#notification-alert'), type: "danger", close: true, message: message});
				$(".btn-submit").removeAttr("disabled");
				$(".btn-submit").text($('#btn-save').data('text'));
			}
			else
			{
				App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#default-update-success').data('message')});
			}
			$(".btn-submit").removeAttr("disabled");
			$(".btn-submit").text($('#btn-save').data('text'));
		}
	},
	layoutInvoiceSettingsServerResponse = function(responseText, statusText, xhr, $form){
		if(responseText.status == 1)
		{
			location = $('#base-url').data('target') + 'index.php/settings/invoice_settings/#invoice_templates';
			location.reload();
		}
		else
		{
			message = responseText.error;
			message = message.replace(/<\/?p[^>]*>/g, "");
			if( message != '')
			{
				App.alert({container: $('#notification-alert'), type: "danger", close: true, message: message});
				$(".btn-submit").removeAttr("disabled");
				$(".btn-submit").text($('#btn-save').data('text'));
			}
			else
			{
				App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#default-update-success').data('message')});
			}
			$(".btn-submit").removeAttr("disabled");
			$(".btn-submit").text($('#btn-save').data('text'));
		}
	},
	layoutQuoteSettingsServerResponse = function(responseText, statusText, xhr, $form){
		if(responseText.status == 1)
		{
			location = $('#base-url').data('target') + 'index.php/settings/quote_settings/#quote_templates';
			location.reload();
		}
		else
		{
			message = responseText.error;
			message = message.replace(/<\/?p[^>]*>/g, "");
			if( message != '')
			{
				App.alert({container: $('#notification-alert'), type: "danger", close: true, message: message});
				$(".btn-submit").removeAttr("disabled");
				$(".btn-submit").text($('#btn-save').data('text'));
			}
			else
			{
				App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#default-update-success').data('message')});
			}
			$(".btn-submit").removeAttr("disabled");
			$(".btn-submit").text($('#btn-save').data('text'));
		}
	},
	defaultPaymentMethodServerResponse = function(responseText, statusText, xhr, $form){
		if(responseText.status == 1)
		{
			App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#default-update-success').data('message')});
			$(".btn-submit").removeAttr("disabled");
			$(".btn-submit").text($('#btn-save').data('text'));
		}
		else
		{
			message = responseText.error;
			message = message.replace(/<\/?p[^>]*>/g, "");
			if( message != '')
			{
				App.alert({container: $('#notification-alert'), type: "danger", close: true, message: message});
				$(".btn-submit").removeAttr("disabled");
				$(".btn-submit").text($('#btn-save').data('text'));
			}
			else
			{
				App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#default-update-success').data('message')});
			}
			$(".btn-submit").removeAttr("disabled");
			$(".btn-submit").text($('#btn-save').data('text'));
		}
	},
	p = function(){

		var options = {
			dataType:  'json',
			success: newsletterServerResponse
		};
		$('#register-newsletter').submit(function(){
			$(".btn-submit").attr("disabled","disabled");
			$(this).ajaxSubmit(options);
			return false; 
		});
	},
	handleRegisterUser = function(){
		var options = {
			dataType:  'json',
			success: serverResponseRegister
		};
		$('#register-user').submit(function(){
			$(".btn-submit").attr("disabled","disabled");
			$("#register-user").ajaxSubmit(options);
			return false; 
		});
	},
	serverResponseRegister = function(responseText, statusText, xhr, $form){
		if(responseText.status != 1)
		{
			$("#register-validation-errors").html(responseText.error);
			$(".btn-submit").removeAttr("disabled");
		}
		else
		{
            $('#add-user-modal').modal('hide');
            $('#add-user-modal').on('hidden.bs.modal', function () {
            	$('#register-user').trigger('reset');
            	App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#default-save-success').data('message')});
            	setTimeout(function(){ location.reload(); }, 3000);
            });
		}
	},
	newsletterServerResponse = function(responseText, statusText, xhr, $form){

		if(responseText.status != 1)
		{
			var message = responseText.error;
			if( typeof message != 'undefined')
			{
				App.alert({container: $('#notification-alert'), type: "danger", close: true, message: message});
			}
		}
		else
		{
			App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#newsletter_message').data('message')});
			$('#register-newsletter').resetForm();
			$(".btn-submit").removeAttr("disabled");
		}
	},
	handleRegisterNewCompany = function(){
		var options = {
			dataType:  'json',
			success: serverResponseRegisterNewCompany
		};
		$('#register-company').submit(function(){
			$(".btn-submit").attr("disabled","disabled");
			$("#register-company").ajaxSubmit(options);
			return false; 
		});
	},
	serverResponseRegisterNewCompany = function(responseText, statusText, xhr, $form){
		if(responseText.status != 1)
		{
			$("#register-company-validation-errors").html(responseText.error);
			$(".btn-submit").removeAttr("disabled");
		}
		else
		{
            $('#add-company-modal').modal('hide');
            $('#add-company-modal').on('hidden.bs.modal', function () {
            	$('#register-company').trigger('reset');
            	App.alert({container: $('#notification-alert'), type: "success", close: true, message: $('#default-save-success').data('message')});
            	setTimeout(function(){ location.reload(); }, 3000);
            });
		}
	},
	handleSelectUsers = function(){
		$('.users-select').each(function(){
			var $url = $('#base-url').data('target') + 'index.php/users/ajax/roles_users_select';
			$.getJSON( $url, function(response){
				var stringified = JSON.stringify(response);
				stringified = stringified.replace(/id/g, 'id');
				stringified = stringified.replace(/name/g, 'text');
				var data = JSON.parse(stringified);
				$('.users-select').select2({
					data: data
				})
			});
		});
	},
	handleSelectRoles = function(){
		$('.roles-select').each(function(){
			var $url = $('#base-url').data('target') + 'index.php/users/ajax/roles_select';
			$.getJSON( $url, function(response){
				var stringified = JSON.stringify(response);
				stringified = stringified.replace(/id/g, 'id');
				stringified = stringified.replace(/name/g, 'text');
				var data = JSON.parse(stringified);
				$('.roles-select').select2({
					data: data
				})
			});
		});
	},
	handleDeleteGroup = function() {
			$("#delete_group").click(function(e) {
				e.preventDefault();
				var $confirmationMessage = $(this).data( "message" ),
					$group_id = $("#groupHiddenId").val(),
					$redirect_url = $('#base-url').attr('action'),
					$post_url = $(this).attr("href");
	            bootbox.confirm($confirmationMessage, function(o) {
	                if( o == true)
					{
						$.ajax({
						  method: "POST",
						  url: $post_url,
						  data: { group_id: $group_id }
						})
						  .done(function(response) {
							  if(response == true)
							  {
								toastr.success("Gnome & Growl type non-blocking notifications", "Toastr Notifications");
								window.location = $redirect_url + "users/auth/index";
							  }
							  else
							  {
								  bootbox.alert('You cannot delete this group');
							  }
						  });
					}
	            })
	        })
	    };
	return {
		init: function(){
			handleRedirections(), 
			p(),
			handleUserStatus()
			handleEditUserInfo(),
			handleUserAppVersion(),
			handleLogo(),
			handleAvatar(),
			handleChangePassword(),
			handleUserPreferences(),
			handleMollieSettings(),
			handleIngenicoSettings(),
			handleStripeSettings(),
			handlePaypalSettings(),
			handleInvoiceLayoutSettings(),
			handleQuoteLayoutSettings(),
			handleDefaultPaymentMethod(),
			handleEmailSettings(),
			handleEmailNotificationsSettings(),
			handleUserRolesPermissions(),
			handleRegisterUser(),
			handleDeleteGroup(),
			handleRegisterNewCompany(),
			handleSelectUsers(),
			handleSelectRoles()
		}
	};
})(jQuery);
jQuery(document).ready(function() {
	Users.init()
});