<?php
$tax_rate_0 = null == $tax_value[0]['tax_rate'] ? -1: $tax_value[0]['tax_rate'];
$tax_rate_1 = null == $tax_value[1]['tax_rate'] ? -1: $tax_value[1]['tax_rate'];
$tax_rate_2 = null == $tax_value[2]['tax_rate'] ? -1: $tax_value[2]['tax_rate'];

$ftax_rate_0 = null == $tax_value[0]['tax_rate'] ? '-': $tax_value[0]['tax_rate'].'%';
$ftax_rate_1 = null == $tax_value[1]['tax_rate'] ? '-': $tax_value[1]['tax_rate'].'%';
$ftax_rate_2 = null == $tax_value[2]['tax_rate'] ? '-': $tax_value[2]['tax_rate'].'%';

$tax_rate_2_subtotal = -1 == $tax_rate_2 ? '-' : format_number(getInvoiceTaxVars($non_formatted_invoice_number, $tax_value[2]['tax_rate'], 'subtotal') * $change_rate);
$tax_rate_1_subtotal = -1 == $tax_rate_1 ? '-' : format_number(getInvoiceTaxVars($non_formatted_invoice_number, $tax_value[1]['tax_rate'], 'subtotal') * $change_rate);
$tax_rate_0_subtotal = -1 == $tax_rate_0 ? '-' : format_number(getInvoiceTaxVars($non_formatted_invoice_number, $tax_value[0]['tax_rate'], 'subtotal') * $change_rate);

$tax_rate_2_amount = -1 == $tax_rate_2 ? '-' : format_number(getInvoiceTaxVars($non_formatted_invoice_number, $tax_value[2]['tax_rate'], 'tax_amount') * $change_rate);
$tax_rate_1_amount = -1 == $tax_rate_1 ? '-' : format_number(getInvoiceTaxVars($non_formatted_invoice_number, $tax_value[1]['tax_rate'], 'tax_amount') * $change_rate);
$tax_rate_0_amount = -1 == $tax_rate_0 ? '-' : format_number(getInvoiceTaxVars($non_formatted_invoice_number, $tax_value[0]['tax_rate'], 'tax_amount') * $change_rate);


$html = '
<html>
<head>
<link rel="shortcut icon" href="'. __common('pages/img/favicon.ico').'" />
</head>
<body>
<!--mpdf
<htmlpageheader name="myheader">
<table width="100%"><tr>
<td width="40%"><img src="./uploads/admin/img/'. $logo. '" height="75px"/></td>
<td width="60%" style="text-align: right;"><h1 style="color:#8B0000;">'.$status.'</h1><br />
</tr></table>
</htmlpageheader>
<htmlpagefooter name="myfooter">
<p style="border-top: 1px solid #000000; font-size: 9pt; text-align: center; padding-top: 1mm; ">'. $invoice_footer .'</p>
<div style="border-top: 0px solid #000000; font-size: 9pt; text-align: center; padding-top: 1mm; ">
Page {PAGENO} of {nb}
</div>
</htmlpagefooter>
<sethtmlpageheader name="myheader" value="on" show-this-page="1" />
<sethtmlpagefooter name="myfooter" value="on" />
mpdf-->';
if ($is_credit_note) {
  $html .= '<div style="text-align: right"><span class="bordercolor" style="color:#8B0000;">'. $this->lang->line('label_credit_note'). '</span>: '. $page_title. '</div>';
} else {
  $html .= '<div style="text-align: right"><span class="bordercolor" style="color:#8B0000;">'. $this->lang->line('invoices_invoice'). '</span>: '. $invoice_number. '</div>';
}
$html .= '
<div style="text-align: right"><span class="bordercolor" style="color:#8B0000;">'. $this->lang->line('issued_date'). '</span>: '. $date. '</div>
<div style="text-align: right"><span class="bordercolor" style="color:#8B0000;">'. $this->lang->line('due_date'). '</span>: '. $due_date. '</div>
<table width="100%" style="font-family: serif;" cellpadding="10"><tr>
<td width="45%" style="border-top: solid 0.1px #8B0000;"><span style="font-size: 8pt; color: #555555; font-family: sans;">'.strtoupper($this->lang->line('label_payment_to')).':</span><br /><br /><strong>'.trim($user_company).'</strong>';
if ($user_address)
{
    if ($user_address["user_address1"])
    {
        $html .= '<br /><span style="font-size: 12px;">'.trim($user_address["user_address1"]).'</span>';
    }
    if($user_address["user_address2"])
    {
        $html .= ' <span style="font-size: 12px;">'. trim($user_address["user_address2"]).'</span>';
    }
    if($user_address["user_postcode"])
    {
        $html .= '<br /><span style="font-size: 12px;">'. trim($user_address["user_postcode"]).'</span>';
    }
    if($user_address["user_city"])
    {
        $html .= ' <span style="font-size: 12px;">'. trim($user_address["user_city"]).'</span>';
    }
    if($user_address["user_state"])
    {
        $html .= ' <span style="font-size: 12px;">'. trim($user_address["user_state"]).'</span>';
    }
    if($user_address["user_country"])
    {
        $html .= ' <span style="font-size: 11px;">'. trim($user_address["user_country"]).'</span>';
    }
}

if (_has_option('display_bank_name') && $bank_name)
{
    $html .= '<br /><span style="font-size: 13px;">'.$this->lang->line('label_bank') .': ' .trim($bank_name).'</span>';
}
if( _has_option( 'display_iban' ) ) 
{
    $html .= '<br /><span style="font-size: 13px;">'.$this->lang->line('label_bank_number') .': ' .trim($bank_number).'</span>';
}

$html .= '</td><td width="10%">&nbsp;</td><td width="45%" style="border-top: solid 0.1px #8B0000;"><span style="font-size: 8pt; color: #555555; font-family: sans;">'. strtoupper($this->lang->line('label_invoiced_to')).':</span><br /><br />';
if ($client)
{
    $html .= '<strong>'.$client["name_company"].'</strong>';
    if ($client['address1'])
    {
        $html .= '<br />'.trim($client["address1"]);
    }
    if($client["address2"])
    {
        $html .= '<br />'. trim($client["address2"]);
    }
    if($client["postcode"])
    {
        $html .= '<br />'. trim($client["postcode"]);
    }
    if($client["city"])
    {
        $html .= ' '. trim($client["city"]);
    }
    if($client["state"])
    {
        $html .= ' '. trim($client["state"]);
    }
    if($client["country"])
    {
        $html .= '<br />'. trim($client["country"]);
    }
    if($client["client_tax_number"])
    {
        $html .= '<br /><br />'.$this->lang->line('label_tax_number'). ': ' .trim($client["client_tax_number"]);
    }
    if($client["client_fiscal_code"] && $client["client_type"] == 2)
    {
        $html .= '<br /><br />'.$this->lang->line('label_fiscal_code'). ': ' .trim($client["client_fiscal_code"]);
    }
}
$html .= '</td>
</tr></table>
<br />
<table class="items" width="100%" style="font-size: 11pt; border-collapse: collapse;border-top: solid #8B0000;border-bottom: solid #ffffff;" cellpadding="9">
<thead>
<tr>
<td width="43%" align="left">'.$this->lang->line('th_sku').' - '.$this->lang->line('th_item').'</td>
<td width="10%" align="right">'.$this->lang->line('quantity').'</td>
<td width="17%" align="right">'.$this->lang->line('th_price').'</td>
<td width="19%" align="right">'.$this->lang->line('th_discount').'</td>
<td width="15%" align="right">'.$this->lang->line('label_subtotal').'</td>
<td width="8%" align="right">'.$this->lang->line('label_tax').'</td>
</tr>
</thead>
<tbody>
<!-- ITEMS HERE -->';
foreach ($invoiceitems as $item) {
$discount_value = ($item->item_price * $item->item_quantity) * $item->item_discount / 100;
$html .= '<tr>
<td><span style="font-size: 12px;">'.$item->item_sku . ' - '.strtoupper($item->item_name).'<br />'.get_item_description($item->item_id).'</span></td>
<td align="right"><span style="font-size: 12px;">'.$item->item_quantity . ' '.$item->item_uom. '<br /></span></td>
<td class="cost" align="right"><span style="font-size: 12px;">'.format_number($item->item_price * $change_rate).'</span></td>
<td class="cost" align="right"><span style="font-size: 12px;">'.$item->item_discount . '%</span><br /><span style="font-size: 9px;"><em>'.add_currency( format_number( $discount_value * $change_rate), $client_id ).'</em></span></td>
<td class="cost" align="right"><span style="font-size: 12px;">'.format_number($item->item_subtotal * $change_rate). '</span></td>
<td align="center"><span style="font-size: 9px;"><em>'. $item->item_tax_rate.'%</em></span></td>
</tr>';
}
$html .= '<!-- END ITEMS HERE -->
</tbody>
</table><br />';
$html .= '
<table width="100%" style="font-size: 10pt; border-collapse: collapse;border-top: solid #8B0000;border-bottom: solid #8B0000;" cellpadding="9">
<thead>
<tr>
<td style="background-color: #ffffff;"></td>
<td style="background-color: #ffffff;"></td>
<td style="background-color: #ffffff;" width="30%">'.$this->lang->line('label_total').'</td>
<td style="background-color: #ffffff;" width="30%">'.$this->lang->line('label_items_total_amount').'</td>
<td style="background-color: #ffffff;" align="right" width="30%">'.$this->lang->line('label_tax_basis').'</td>
</tr>
</thead>
<tbody>
<tr>
<td></td>
<td style="background-color: #ffffff;" align="left">'.$this->lang->line('label_total').'</td>
<td style="background-color: #ffffff;" align="center" width="30%">'.add_currency( format_number($subtotal * $change_rate), $client_id ).'</td>
<td style="background-color: #ffffff;" align="center" width="30%">'.add_currency( format_number($subtotal * $change_rate), $client_id ).'</td>
<td style="background-color: #ffffff;" align="right" width="30%">'.add_currency( format_number($subtotal * $change_rate), $client_id ).'</td>
</tr>
</tbody></table>
<table width="100%" style="font-size: 10pt; border-collapse: collapse;border-top: solid #ffffff;border-bottom: solid #ffffff;">
<thead>
<tr>
<td style="background-color: #ffffff;" align="center"></td>
<td style="background-color: #ffffff;" align="center" width="5%"></td>
<td style="background-color: #ffffff;" align="center"> 0% </td>
<td style="background-color: #ffffff;" align="center">'.$ftax_rate_0.'</td>
<td style="background-color: #ffffff;" align="center">'.$ftax_rate_1.'</td>
<td style="background-color: #ffffff;" align="center">'.$ftax_rate_2.'</td>
<td style="background-color: #ffffff;" align="right">'.get_option("user_currency").'</td>
</tr>
</thead>
<tbody>
<tr>
<td style="background-color: #ffffff;" align="left">'.$this->lang->line('label_tax_basis').'</td>
<td style="background-color: #ffffff;" align="center" width="5%"></td>
<td style="background-color: #ffffff;" align="center">'.format_number(getInvoiceTaxVars($non_formatted_invoice_number, 0, 'subtotal') * $change_rate) .'</td>
<td style="background-color: #ffffff;" align="center">'.$tax_rate_0_subtotal.'</td>
<td style="background-color: #ffffff;" align="center">'.$tax_rate_1_subtotal.'</td>
<td style="background-color: #ffffff;" align="center">'.$tax_rate_2_subtotal.'</td>
<td style="background-color: #ffffff;" align="right">'.add_currency( format_number($subtotal * $change_rate), $client_id ).'</td>
</tr>
<tr>
<td style="background-color: #ffffff;padding-bottom: 3%" align="left">'.$this->lang->line('label_tax').'</td>
<td style="background-color: #ffffff;" align="center" width="5%"></td>
<td style="background-color: #ffffff;" align="center">'.format_number(getInvoiceTaxVars($non_formatted_invoice_number, 0, 'tax_amount') * $change_rate) .'</td>
<td style="background-color: #ffffff;" align="center">'.$tax_rate_0_amount.' </td>
<td style="background-color: #ffffff;" align="center">'.$tax_rate_1_amount.' </td>
<td style="background-color: #ffffff;" align="center">'.$tax_rate_2_amount.'</td>
<td style="background-color: #ffffff;" align="right">'.add_currency( format_number($tax_amount * $change_rate), $client_id).'</td>
</tr>
<tr>
<td style="background-color: #ffffff;" align="left"></td>
<td style="background-color: #ffffff;" align="center" width="5%"></td>
<td style="background-color: #ffffff;" align="center"></td>
<td style="background-color: #ffffff;" align="center"></td>
<td style="background-color: #ffffff;" align="center"></td>
<td><b>'.$this->lang->line('label_total').':</b></td>
<td align="right"><b>'. add_currency( format_number( $total * $change_rate ), $client_id ) .'</b></td>
</tr>
<tr>
<td style="background-color: #ffffff;" align="left"></td>
<td style="background-color: #ffffff;" align="center" width="5%"></td>
<td style="background-color: #ffffff;" align="center"></td>
<td style="background-color: #ffffff;" align="center"></td>
<td style="background-color: #ffffff;" align="center"></td>
<td><b>'.$this->lang->line('label_credit').':</b></td>
<td align="right"><b>'. add_currency( format_number( $credit * $change_rate ), $client_id ) .'</b></td>
</tr>
<tr>
<td style="background-color: #ffffff;" align="left"></td>
<td style="background-color: #ffffff;" align="center" width="5%"></td>
<td style="background-color: #ffffff;" align="center"></td>
<td style="background-color: #ffffff;" align="center"></td>
<td style="background-color: #ffffff;" align="center"></td>
<td><b>'.$this->lang->line('label_amount_paid').':</b></td>
<td align="right"><b>'. add_currency( format_number( $amount_paid * $change_rate ), $client_id ) .'</b></td>
</tr>
<tr>
<td style="background-color: #ffffff;" align="left"></td>
<td style="background-color: #ffffff;" align="center" width="5%"></td>
<td style="background-color: #ffffff;" align="center"></td>
<td style="background-color: #ffffff;" align="center"></td>
<td style="background-color: #ffffff;" align="center"></td>
<td class="totals balance amount" style="background-color:#8B0000 !important;"><b>' . $this->lang->line('invoice_balance') . ':</b></td>
<td class="totals cost balance amount" style="background-color:#8B0000 !important;" align="right"><b>'. add_currency( format_number( $balance * $change_rate ), $client_id ) .'</b></td>
</tr>
</tbody></table>
';
if (null !== $initial_invoice_number){
    $html .='<br/>
    <table width="100%">
    <tr>
    <td width="100%" align="left"><span style="font-size: 9pt; color: #000000; font-family: sans;"><b>'. '<sup>*</sup>'. $this->lang->line('message_from_initial_invoice') .$format_initial_invoice_number.'<br /></br /></b></span></td>
    </tr>
    </table>';
}
# Notes
if ($notes) {
    $html .= $this->lang->line('notes') . ': ' . $notes;
}

if($transactions) {
    if (count($invoiceitems) > 6) {
        $html .='<p style="page-break-before:always;">'; 
    }
$html .='
<p><h4>'.$this->lang->line('invoice_transactions').'</h4></p>';
 $html .= '<table width="100%" style="font-size: 10pt; border-collapse: collapse;" cellpadding="9">
 <thead>
     <tr>
         <td width="25%" align="center"><span style="font-size: 11px;">' . $this->lang->line('transaction_date') . '</span></td>
         <td width="25%" align="center"><span style="font-size: 11px;">' . $this->lang->line('transaction_gateway') . '</span></td>
         <td width="30%" align="center"><span style="font-size: 11px;">' . $this->lang->line('label_transaction_id') . '</span></td>
         <td width="20%" align="center"><span style="font-size: 11px;">' . $this->lang->line('transaction_amount') . '</span></td>
     </tr>';

 } if (!count($transactions) OR !$transactions) {
     $html .= '
     <tr bgcolor="#fff"></tr>';
 } else {
     foreach ($transactions AS $trans) {
         $html .= '
         <tr bgcolor="#fff">
             <td align="center"><span style="font-size: 11px;">' . $trans['date'] . '</span></td>
             <td align="center"><span style="font-size: 11px;">' . $trans['gateway'] . '</span></td>
             <td align="center"><span style="font-size: 11px;">' . $trans['transid'] . '</span></td>
             <td align="center"><span style="font-size: 11px;">' . add_currency( format_number($trans['amount'] * $change_rate), $client_id ) . '</span></td>
         </tr>';
     }
 }
 if($transactions) {
     $html .= '
     <tr nobr="true" height="30" bgcolor="#efefef" style="font-weight:bold;">
         <td colspan="3" align="right"><strong><span style="font-size: 11px;">' . $this->lang->line('invoice_balance') . '</span></strong></td>
         <td align="center"><span style="font-size: 11px;">' . add_currency( format_number($balance * $change_rate), $client_id ) . '</span></td>
     </tr>';

 }
 $html .= '</table>';

if( _has_option('display_terms') )
{
    if ($transactions && count($invoiceitems) > 6) {
        $html .= $terms; 
    } else {
        // $html .='<p style="page-break-before:always;">';
        $html .= $terms;
    }
}

$html .='
</body>
</html>';

//==============================================================
//==============================================================
//==============================================================
//==============================================================
//==============================================================
//==============================================================

require_once 'vendor/autoload.php';

$mpdf = new \Mpdf\Mpdf([
  'margin_left' => 20,
  'margin_right' => 15,
  'margin_top' => 48,
  'margin_bottom' => 25,
  'margin_header' => 10,
  'margin_footer' => 10,
  'mirrorMargins' => true
]);

$mpdf->SetTitle($invoice_title);
$mpdf->setAutoBottomMargin = 'stretch';
$mpdf->SetDisplayMode('fullpage');

// LOAD a stylesheet
$stylesheet = file_get_contents(__common('pages/css/pdf.css'));
$mpdf->WriteHTML($stylesheet,1); // The parameter 1 tells that this is css/style only and no body/html/text
$mpdf->WriteHTML($html);

$mpdf->Output(FCPATH.'uploads/pdf/invoices/'.$non_formatted_invoice_number.'.pdf', 'F');
$mpdf->Output(FCPATH.'uploads/pdf/invoices/'.$invoice_title.'-'.$client["name_company"].'.pdf', 'I');exit;