<?php
tcpdf();
$pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
$pdf->setRTL(false);
$pdf->SetTitle($invoice_title);
$pdf->setPrintHeader(false);

$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
$pdf->SetFont('dejavusans', '', 9);
$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
$pdf->SetFont('dejavusans', 'BI', 20);
$pdf->AddPage();
if (_has_option('display_logo')) 
{
    # Logo
    $pdf->Image('uploads/admin/img/'. $logo, 15, 5, 50);
}
# Invoice Status
if (_has_option('display_status')) 
{
    $pdf->SetXY(0, 0);
    $pdf->SetFont('dejavusans', 'B', 16);
    $pdf->SetTextColor(255);
    $pdf->SetLineWidth(0.75);
    $pdf->StartTransform();
    $pdf->Rotate(-35, 100, 225);
    if ($status == $this->lang->line('paid') ){
        $pdf->SetFillColor(151, 223, 74);
        $pdf->SetDrawColor(110, 192, 70);
    } elseif ($status == $this->lang->line('cancelled') ) {
        $pdf->SetFillColor(200);
        $pdf->SetDrawColor(140);
    } elseif ($status == $this->lang->line('refunded') OR $has_refund == true) {
        $pdf->SetFillColor(131, 182, 218);
        $pdf->SetDrawColor(91, 136, 182);
    } elseif ($status == $this->lang->line('collections') ) {
        $pdf->SetFillColor(3, 3, 2);
        $pdf->SetDrawColor(127);
    } elseif ($status == $this->lang->line('draft') ) {
       $pdf->SetFillColor(200);
       $pdf->SetDrawColor(140);
    }
     else {
        $pdf->SetFillColor(223, 85, 74);
        $pdf->SetDrawColor(171, 49, 43);
    }
    $pdf->Cell(100, 8, ucfirst( $status ), 'TB', 0, 'C', '1');
    $pdf->StopTransform();
    $pdf->SetTextColor(0);
     # Adjust company details
    $pdf->SetXY(15, 42);
}
else
{
    // Move up if not showing invoice status
    $pdf->SetXY(15, 15);
}
# Company Details
$pdf->SetFont('dejavusans', 'B', 8);
$pdf->Cell(180, 4, $this->lang->line('label_payment_to'), 0, 1, 'R');
$pdf->SetFont('dejavusans', '', 9);
$pdf->Cell(180, 4, trim($user_company), 0, 1, 'R');

if ($user_address) 
{
    $pdf->SetFont('dejavusans', '', 9);
    if ($user_address['user_address1'])
    {
        $pdf->Cell(180, 4, trim($user_address['user_address1']), 0, 1, 'R');
    }
    if ($user_address['user_address2'])
    {
        $pdf->Cell(180, 4, trim($user_address['user_address2']), 0, 1, 'R');
    }
    if ($user_address['user_city'] && $user_address["user_postcode"] && $user_address['user_country'] && $user_address['user_country'] !== 'None')
    {
        $pdf->Cell(180, 4, trim($user_address["user_postcode"] . " " . $user_address['user_city'] . " ". $user_address["user_state"] . " " . $user_address["user_country"]), 0, 1, 'R');
    }
}
if (_has_option('display_vat_number') &&  $tax_id)
{
    $pdf->Cell(180, 4, $this->lang->line('label_tax_number') .': ' .trim($tax_id), 0, 1, 'R');
}
if( _has_option('display_ch_commerce') && $chamber_commerce_id)
{
    $pdf->Cell(180, 4, $this->lang->line('label_short_chamber_commerce') .': ' .trim($chamber_commerce_id), 0, 1, 'R');
    $pdf->Ln(2);
}
if (_has_option('display_bank_name') && $bank_name)
{
    $pdf->Ln(2);
    $pdf->SetFont('dejavusans', 'B', 8);
    $pdf->Cell(180, 4, $this->lang->line('message_wire_funds'), 0, 1, 'R');
    $pdf->SetFont('dejavusans', '', 10);
    $pdf->Cell(180, 4, $this->lang->line('label_bank') .': ' .trim($bank_name), 0, 1, 'R');
}
if (_has_option('display_iban') &&  $bank_number)
{
    $pdf->Cell(180, 4, $this->lang->line('label_bank_number') .': ' .trim($bank_number), 0, 1, 'R');
}
else
{
    // Add padding if not displaying IBAN
    $pdf->Ln(10);
}
// Padding
$pdf->Ln(5);

# Header Bar
$pdf->SetFont('dejavusans', 'B', 12);
$pdf->SetFillColor(239);
$pdf->Cell(0, 8, $page_title, 0, 1, 'C', '1');
$pdf->SetFont('dejavusans', '', 8);
$pdf->Cell(0, 6, $this->lang->line('issued_date') . ': ' . $date, 0, 1, 'C', '1');
$pdf->Cell(0, 6, $this->lang->line('due_date') . ': ' . $due_date, 0, 1, 'C', '1');
$pdf->SetFillColor(239);
if (_has_option('display_contact_info') )
{
    $pdf->SetFont('dejavusans', '', 8);
    $contact = '<p style="text-align:center;">' .$this->lang->line('message_invoice_contact_info') . "<br />";
    $contact .= get_option('first_name') . " ". get_option('last_name') . " (". get_option('notifications_email') ."/ ";
    $contact .= get_option('phone') . ") ";
    $contact .= '</p>';
    $pdf->writeHTML($contact, true, false, false, false, '');
    $pdf->Ln(5);
}
else
{
    // Add padding if no contact info
    $pdf->Ln(5);
}

$startpage = $pdf->GetPage();

# Clients Details
$addressypos = $pdf->GetY();
$pdf->SetFont('dejavusans', 'B', 8);
$pdf->Cell(0, 4, $this->lang->line('label_invoiced_to'), 0, 1);
$pdf->SetFont('dejavusans', '', 9);
if ($client) {
    if ($client["name_company"]) {
        $pdf->Cell(0, 4, $client["name_company"], 0, 1, 'L');
    }
    $pdf->Cell(0, 4, $client["address1"], 0, 1, 'L');
    if ($client["address2"]) {
        $pdf->Cell(0, 4, $client["address2"], 0, 1, 'L');
    }
    if ($client["country"] == 'None')
    {
        $client["country"] = "";
    }
    if ($client["postcode"])
    {
        $pdf->Cell(0, 4, $client["postcode"] . " " . $client["city"] . " " . $client["state"] . " " . $client["country"], 0, 1, 'L');
    }
    if ($client["client_tax_number"])
    {
        $pdf->Cell(0, 4, $this->lang->line('label_tax_number') .': ' .$client["client_tax_number"], 0, 1, 'L');
    }
    if ($client["client_phone"])
    {
        $pdf->Cell(0, 4, $this->lang->line('label_phone') .': ' .$client["client_phone"], 0, 1, 'L');
    }
    if ($subject)
    {
        $pdf->Cell(0, 4, $this->lang->line('label_external_number') .': ' .$subject, 0, 1, 'L');
    }
}
$pdf->Ln(5);

# Invoice Items
$tblhtml = '<table width="100%" bgcolor="#ccc" cellspacing="1" cellpadding="2" border="0">
    <tr height="30" bgcolor="#efefef" style="font-weight:bold;text-align:center;">
        <th width="5%" align="left">#</th>
        <th width="29%" align="left">' . $this->lang->line('th_item') . '</th>
        <th width="10%">' . $this->lang->line('quantity') . '</th>
        <th width="20%" align="right">' . $this->lang->line('th_price') . '</th>
        <th width="20%" align="right">' . $this->lang->line('th_discount') . '</th>
        <th width="20%" align="right">' . $this->lang->line('label_subtotal') . '</th>
    </tr>';
foreach ($invoiceitems as $k => $item) {
    $k += 1;
    $discount_value = ($item->item_price * $item->item_quantity) * $item->item_discount / 100;
    $tblhtml .= '
    <tr bgcolor="#fff">
        <td align="left">' . $k. '<br /></td>
        <td align="left">' . $item->item_name. '<br /><em>'. get_item_description(null, $item->item_name);
        if (null != $item->specific_serial_number) {
            $tblhtml .= $this->lang->line('serial_number_short').$item->specific_serial_number;

            }
        $tblhtml .= '</em></td>
        <td align="center">' . $item->item_quantity . ' '.$item->item_uom. '<br /></td>
        <td align="right">' . format_number($item->item_price * $change_rate) . '<br /></td>
        <td align="right">' . $item->item_discount . '%<br /><span style="font-size: 7px;"><em>'.add_currency( format_number( $discount_value ), $client_id ).'</em></span></td>
        <td align="right">' . format_number($item->item_subtotal * $change_rate). '<br /><span style="font-size: 7px;"><em>'.$this->lang->line('label_tax').' @'. $item->item_tax_rate.'%</em></span></td>
    </tr>';
}
if ($discount) {
    $tblhtml .= '
    <tr height="30" bgcolor="#efefef" style="font-weight:bold;">
        <td></td>
        <td></td>
        <td></td>
        <td align="right">' . $discount_name . '</td>
        <td align="right">' . add_currency( format_number($discount_amount * $change_rate), $client_id ). '</td>
        <td></td>
    </tr>';
}
$tblhtml .= '
    <tr height="30" bgcolor="#efefef">
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td align="right">' . $this->lang->line('label_subtotal') . '</td>
        <td align="right">' . add_currency( format_number($subtotal * $change_rate), $client_id ) . '</td>
    </tr>';
if ($tax_value) 
{
    for ($i=0; $i < count($tax_value); $i++) {
    $tblhtml .= '
    <tr height="30" bgcolor="#efefef">
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td align="right">' . $this->lang->line('label_tax') . " (". $tax_value[$i]['tax_rate']. "%)".'</td>
        <td align="right">' . add_currency( format_number($tax_value[$i]['tax_sum'] * $change_rate), $client_id ) . '</td>
    </tr>';
    }
}
if (!$tax_value)
{
    $tblhtml .= '
    <tr height="30" bgcolor="#efefef">
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td align="right">' . $this->lang->line('label_total_duty_free') . '<strong><sup>*</sup></strong></td>
        <td align="right">' . add_currency( format_number($total * $change_rate), $client_id ) . '</td>
    </tr>';
}
else
{
    $tblhtml .= '
    <tr height="30" bgcolor="#efefef" style="font-weight:bold;">
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td align="right">' . $this->lang->line('label_grand_total') . '</td>
        <td align="right">' . add_currency( format_number($total * $change_rate), $client_id ) . '</td>
    </tr>';
}
if ($amount_refunded) {
    $tblhtml .= '
    <tr height="30" bgcolor="#efefef" style="font-weight:bold;">
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td align="right">' . $this->lang->line('label_amount_refunded') . '</td>
        <td align="right">' . add_currency( format_number($amount_refunded * $change_rate), $client_id ) . '</td>
    </tr>';
}
if ($credit) {
    $tblhtml .= '
    <tr height="30" bgcolor="#efefef" style="font-weight:bold;">
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td align="right">' . $this->lang->line('label_credit') . '</td>
        <td align="right">' . add_currency( format_number($credit * $change_rate), $client_id ) . '</td>
    </tr>';
}
$tblhtml .= '</table>';
if (!$taxname){
    $tblhtml .= '<p style="text-align: right; font-weight:bold"><sup>*</sup>'. $this->lang->line('message_no_tax_applied') .'</p>';
}
$pdf->writeHTML($tblhtml, true, false, false, false, '');

$pdf->Ln(2);

# Transactions
$pdf->SetFont('dejavusans', 'B', 10);
$pdf->Cell(0, 4, $this->lang->line('invoice_transactions'), 0, 1);

$pdf->Ln(2);

$pdf->SetFont('dejavusans', '', 9);

$tblhtml = '<table width="100%" bgcolor="#ccc" cellspacing="1" cellpadding="2" border="0">
    <tr height="30" bgcolor="#efefef" style="font-weight:bold;text-align:center;">
        <td width="25%">' . $this->lang->line('transaction_date') . '</td>
        <td width="25%">' . $this->lang->line('transaction_gateway') . '</td>
        <td width="30%">' . $this->lang->line('label_transaction_id') . '</td>
        <td width="20%">' . $this->lang->line('transaction_amount') . '</td>
    </tr>';

if (!$transactions) {
    $tblhtml .= '
    <tr bgcolor="#fff">
        <td colspan="4" align="center">' . $this->lang->line('transaction_not_found') . '</td>
    </tr>';
} else {
    foreach ($transactions AS $trans) {
        $tblhtml .= '
        <tr bgcolor="#fff">
            <td align="center">' . $trans['date'] . '</td>
            <td align="center">' . $trans['gateway'] . '</td>
            <td align="center">' . $trans['transid'] . '</td>
            <td align="center">' . add_currency( format_number($trans['amount'] * $change_rate), $client_id ) . '</td>
        </tr>';
    }
}
if($transactions) {
    $tblhtml .= '
    <tr nobr="true" height="30" bgcolor="#efefef" style="font-weight:bold;">
        <td colspan="3" align="right">' . $this->lang->line('invoice_balance') . '</td>
        <td align="center">' . add_currency( format_number($balance * $change_rate), $client_id ) . '</td>
    </tr>';

}
$tblhtml .= '</table>';

$pdf->writeHTML($tblhtml, true, false, false, false, '');

# Notes
if ($notes) {
    $pdf->SetFont('dejavusans', '', 8);
    $pdf->MultiCell(170, 5, $this->lang->line('notes') . ': ' . $notes, 0, 'L', 0);
}
if( _has_option('display_terms') )
{
    $pdf->writeHTML('<p style="page-break-before:always;">');
    $pdf->writeHTML($terms, true, false, false, false, '');
    $pdf->Ln(2);
}

# Generation Date
$pdf->SetFont('dejavusans', '', 8);
$pdf->Cell(180, 4, $this->lang->line('invoicepdfgenerated') . ' ' . $current_date, '', '', 'C');
# Custum Footer
$pdf->SetFont('dejavusans', '', 8);
$pdf->Ln(1);
$pdf->MultiCell(180, 4, '____________________________________', 0, 'C', 0);
$pdf->Ln(2);

$html = '<p style="text-align: center;">'. $invoice_footer .'</p>';
$pdf->writeHTML($html, true, false, false, false, '');

$pdf->Output(FCPATH.'uploads/pdf/invoices/'.$non_formatted_invoice_number.'.pdf', 'F');
$pdf->Output($invoice_title.'-'.$client["name_company"].'.pdf', 'I');