<?php
$html = '
<html>
<link rel="shortcut icon" href="'. __css('/oc_contents/theme/img/favicon.ico').'" />
<head>
</head>
<body>
<!--mpdf
<htmlpageheader name="myheader">
<table width="100%"><tr>
<td width="50%"><img src="../uploads/admin/img/'. $logo. '" height="150px"/></td>
<td width="50%" style="text-align: right;"><h1>'.$this->lang->line('invoices_invoice').'</h1><br /><span style="font-weight: bold; font-size: 14pt;">' . $invoice_number.'</span></td>
</tr></table>
</htmlpageheader>
<htmlpagefooter name="myfooter">
<div style="border-top: 1px solid #000000; font-size: 9pt; text-align: center; padding-top: 3mm; ">
Page {PAGENO} of {nb}
</div>
</htmlpagefooter>
<sethtmlpageheader name="myheader" value="on" show-this-page="1" />
<sethtmlpagefooter name="myfooter" value="on" />
mpdf-->
<div style="text-align: right"><span class="bordercolor">'. $this->lang->line('issued_date'). '</span>: '. $date. '</div>
<table width="100%" style="font-family: serif;" cellpadding="10"><tr>
<td width="45%" style="border-top: solid 0.1px #90b041;"><span style="font-size: 7pt; color: #555555; font-family: sans;">'.strtoupper($this->lang->line('label_payment_to')).':</span><br /><br />'.trim($user_company);
if ($user_address)
{
    if ($user_address["user_address1"])
    {
        $html .= '<br />'.trim($user_address["user_address1"]);
    }
    if($user_address["user_address2"])
    {
        $html .= ' '. trim($user_address["user_address2"]);
    }
    if($user_address["user_postcode"])
    {
        $html .= '<br />'. trim($user_address["user_postcode"]);
    }
    if($user_address["user_city"])
    {
        $html .= ' '. trim($user_address["user_city"]);
    }
    if($user_address["user_state"])
    {
        $html .= ' '. trim($user_address["user_state"]);
    }
    if($user_address["user_country"])
    {
        $html .= ' '. trim($user_address["user_country"]);
    }
}
if($tax_id) 
{
    $html .= '<br />'.$this->lang->line('label_tax_number'). ': ' .trim($tax_id);
}
if($chamber_commerce_id) 
{
    $html .= '<br />'.$this->lang->line('label_short_chamber_commerce'). ': ' .trim($chamber_commerce_id);
}
if($bank_number) 
{
    $html .= '<br />'.$this->lang->line('label_bank_number') .': ' .trim($bank_number);
}
if($bank_name) 
{
    $html .= '<br />'.$this->lang->line('label_bank') .': ' .trim($bank_name);
}
$html .= '</td><td width="10%">&nbsp;</td><td width="45%" style="border-top: solid 0.1px #90b041;"><span style="font-size: 7pt; color: #555555; font-family: sans;">'. strtoupper($this->lang->line('label_invoiced_to')).':</span><br /><br />';
if ($client) 
{
    $html .= $client["name_company"];
    if ($client['address1']) 
    {
        $html .= '<br />'.trim($client["address1"]);
    }
    if($client["address2"])
    {
        $html .= '<br />'. trim($client["address2"]);
    }
    if($client["postcode"])
    {
        $html .= '<br />'. trim($client["postcode"]);
    }
    if($client["city"])
    {
        $html .= ' '. trim($client["city"]);
    }
    if($client["state"])
    {
        $html .= ' '. trim($client["state"]);
    }
    if($client["country"])
    {
        $html .= ' '. trim($client["country"]);
    }
    if($client["client_tax_number"])
    {
        $html .= '<br />'.$this->lang->line('label_tax_number'). ': ' .trim($client["client_tax_number"]);
    }
    if($client["client_chamber_com"])
    {
        $html .= '<br />'.$this->lang->line('label_short_chamber_commerce'). ': ' .trim($client["client_chamber_com"]);
    }
    if($client["client_bank_name"])
    {
        $html .= '<br />'.$this->lang->line('label_bank'). ': ' .trim($client["client_bank_name"]);
    }
    if($client["client_bank_number"])
    {
        $html .= '<br />'.$this->lang->line('label_bank_number'). ': ' .trim($client["client_bank_number"]);
    }
}
$html .= '</td>
</tr></table>
<br />
<table class="items" width="100%" style="font-size: 10pt; border-collapse: collapse;border-top: solid #8ab144;" cellpadding="9">
<thead>
<tr>
<td>#</td>
<td>Product Name</td>
<td>UOM</td>
<td>QTY</td>
<td>'.$this->lang->line('th_price').'</td>
<td>Discount</td>
<td>Line Price</td>
<td>VAT %</td>
<td>VAT Value</td>
</tr>
</thead>
<tbody>
<!-- ITEMS HERE -->';
foreach ($invoiceitems as $k => $item) {
    $k += 1;
    $tax_value = $item->item_subtotal * $item->item_tax_rate / 100;
    $total_tax += $tax_value;
    $grand_total = $total + $total_tax;
$html .= '<tr>
<td align="left">'.$k.'</td>
<td>'.$item->item_name.' ['. $item->item_sku. ']<br /><em>'. get_item_description(null, $item->item_name).'</em></td>
<td align="center">'.$item->item_uom.'</td>
<td align="left">'.$item->item_quantity.'</td>
<td class="cost">'.nl2br(format_number($item->item_price)).'</td>';
$html .= '
<td class="cost">'.$item->item_discount.'%</td>
<td class="cost">'.nl2br(format_number($item->item_subtotal)).'</td>
<td class="cost">'.$item->item_tax_rate.'%</td>
<td class="cost">'.nl2br( format_number( $tax_value) ).'<br /></td>
</tr>';
}
$html .= '<!-- END ITEMS HERE -->
<tr>
<td class="blanktotal" colspan="7" rowspan="12"></td>
<td class="totals">Subtotal:</td>
<td class="totals cost">'.nl2br(format_number($subtotal) ).'</td>
</tr>';
$html .= '<tr>
    <td class="totals">VAT:</td>
    <td class="totals cost">'.nl2br(format_number( $total_tax )).'</td>
    </tr>';
$html .='
    <tr>
    <td class="totals"><b>TOTAL</b></td>
    <td class="totals cost"><b>'.add_currency( nl2br( format_number( $subtotal + $total_tax ) ) ).'</b></td>
    </tr>
</tbody>
</table>
<div style="text-align: left; color: #82b53f"><br /><br />'.$this->lang->line('invoice_transactions').'<hr style="text-align:left; color:#82b53f width:100%"></div>';

$html .= '<table width="100%" bgcolor="#ccc" cellspacing="1" cellpadding="2" border="0">
    <tr height="30" bgcolor="#efefef" style="font-weight:bold;text-align:center;">
        <td width="25%">' . $this->lang->line('transaction_date') . '</td>
        <td width="25%">' . $this->lang->line('transaction_gateway') . '</td>
        <td width="30%">' . $this->lang->line('label_transaction_id') . '</td>
        <td width="20%">' . $this->lang->line('transaction_amount') . '</td>
    </tr>';

if (!$transactions) {
    $html .= '
    <tr bgcolor="#fff">
        <td colspan="4" align="center">' . $this->lang->line('transaction_not_found') . '</td>
    </tr>';
} else {
    foreach ($transactions AS $trans) {
        $html .= '
        <tr bgcolor="#fff">
            <td align="center">' . $trans['date'] . '</td>
            <td align="center">' . $trans['gateway'] . '</td>
            <td align="center">' . $trans['transid'] . '</td>
            <td align="center">' . add_currency( format_number($trans['amount'] * $change_rate ) ). '</td>
        </tr>';
    }
}
if($transactions) {
    $html .= '
    <tr nobr="true" height="30" bgcolor="#efefef" style="font-weight:bold;">
        <td colspan="3" align="right">' . $this->lang->line('invoice_balance') . '</td>
        <td align="center">' . add_currency( format_number($balance) ) . '</td>
    </tr>';

}
$html .='
</table>';
# Notes
if ($notes) {
    $html .= $this->lang->line('notes') . ': ' . $notes;
}
if( _has_option('display_terms') )
{
    $html .= $terms;
}
$html .='
</body>
</html>';

//==============================================================
//==============================================================
//==============================================================
//==============================================================
//==============================================================
//==============================================================

require_once 'vendor/autoload.php';

$mpdf = new \Mpdf\Mpdf([
  'margin_left' => 20,
  'margin_right' => 15,
  'margin_top' => 48,
  'margin_bottom' => 25,
  'margin_header' => 10,
  'margin_footer' => 10,
  'mirrorMargins' => true
]);

$mpdf->SetTitle($invoice_title);
$mpdf->setAutoBottomMargin = 'stretch';
$mpdf->SetDisplayMode('fullpage');

// LOAD a stylesheet
$stylesheet = file_get_contents(__common('pages/css/pdf.css'));
$mpdf->WriteHTML($stylesheet,1); // The parameter 1 tells that this is css/style only and no body/html/text
$mpdf->WriteHTML($html);

$mpdf->Output(FCPATH.'uploads/pdf/invoices/'.$non_formatted_invoice_number.'.pdf', 'F');
$mpdf->Output($invoice_title.'-'.$client["name_company"].'.pdf', 'I');exit;