<?php
tcpdf();
$pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
$pdf->SetTitle($purchase_title);
$pdf->setPrintHeader(false);

$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
$pdf->SetFont('dejavusans', '', 9);
$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
$pdf->SetFont('dejavusans', 'BI', 20);
$pdf->AddPage();
if (_has_option('display_logo')) 
{
    # Logo
    $pdf->Image('uploads/admin/img/'. $logo, 15, 5, 50);
}
# Quote Status
if (_has_option('display_status')) 
{
    $pdf->SetXY(0, 0);
    $pdf->SetFont('dejavusans', 'B', 28);
    $pdf->SetTextColor(255);
    $pdf->SetLineWidth(0.75);
    $pdf->StartTransform();
    $pdf->Rotate(-35, 100, 225);
    if ($status == $this->lang->line('accepted') || $status == $this->lang->line('paid') ){
        $pdf->SetFillColor(151, 223, 74);
        $pdf->SetDrawColor(110, 192, 70);
    } elseif ($status == $this->lang->line('declined') ) {
        $pdf->SetFillColor(200);
        $pdf->SetDrawColor(140);
    } elseif ($status == $this->lang->line('pending') ) {
        $pdf->SetFillColor(131, 182, 218);
        $pdf->SetDrawColor(91, 136, 182);
    } elseif ($status == $this->lang->line('collections') ) {
        $pdf->SetFillColor(3, 3, 2);
        $pdf->SetDrawColor(127);
    } elseif ($status == $this->lang->line('draft') ) {
       $pdf->SetFillColor(200);
       $pdf->SetDrawColor(140);
    }
     else {
        $pdf->SetFillColor(223, 85, 74);
        $pdf->SetDrawColor(171, 49, 43);
    }
    $pdf->Cell(100, 8, ucfirst( $status ), 'TB', 0, 'C', '1');
    $pdf->StopTransform();
    $pdf->SetTextColor(0);
     # Adjust company details
    $pdf->SetXY(15, 42);
}
else
{
    // Move up if not showing invoice status
    $pdf->SetXY(15, 15);
    // Add padding if not displaying IBAN
    $pdf->Ln(10);
}
# Company Details
$pdf->SetFont('dejavusans', 'B', 8);
$pdf->Cell(180, 4, $this->lang->line('label_client'), 0, 1, 'R');
$pdf->SetFont('dejavusans', '', 9);
$pdf->Cell(180, 4, trim($user_company), 0, 1, 'R');

if ($user_address) 
{
    $pdf->SetFont('dejavusans', '', 9);
    if ($user_address['user_address1'])
    {
        $pdf->Cell(180, 4, trim($user_address['user_address1']), 0, 1, 'R');
    }
    if ($user_address['user_address2'])
    {
        $pdf->Cell(180, 4, trim($user_address['user_address2']), 0, 1, 'R');
    }
    if ($user_address['user_city'] && $user_address["user_postcode"] && $user_address['user_country'] && $user_address['user_country'] !== 'None')
    {
        $pdf->Cell(180, 4, trim($user_address["user_postcode"] . " " . $user_address['user_city'] . " ". $user_address["user_state"] . " " . $user_address["user_country"]), 0, 1, 'R');
    }
}
if (_has_option('display_vat_number') &&  $tax_id)
{
    $pdf->Cell(180, 4, $this->lang->line('label_tax_number') .': ' .trim($tax_id), 0, 1, 'R');
}
if( _has_option('display_ch_commerce') && $chamber_commerce_id)
{
    $pdf->Cell(180, 4, $this->lang->line('label_short_chamber_commerce') .': ' .trim($chamber_commerce_id), 0, 1, 'R');
    $pdf->Ln(2);
}
if (_has_option('display_bank_name') && $bank_name)
{
    $pdf->Ln(2);
    $pdf->SetFont('dejavusans', '', 10);
    $pdf->Cell(180, 4, $this->lang->line('label_bank') .': ' .trim($bank_name), 0, 1, 'R');
}
if (_has_option('display_iban') &&  $bank_number)
{
    $pdf->Cell(180, 4, $this->lang->line('label_bank_number') .': ' .trim($bank_number), 0, 1, 'R');
}
else
{
    // Add padding if not displaying IBAN
    $pdf->Ln(10);
}
// Padding
$pdf->Ln(5);

# Header Bar
$pdf->SetFont('dejavusans', 'B', 12);
$pdf->SetFillColor(239);
$pdf->Cell(0, 8, $page_title, 0, 1, 'C', '1');
$pdf->SetFont('dejavusans', '', 8);
$pdf->Cell(0, 6, $this->lang->line('issued_date') . ': ' . $date, 0, 1, 'C', '1');
$pdf->Cell(0, 6, $this->lang->line('date_shipping_date') . ': ' . $shipping_date, 0, 1, 'C', '1');
$pdf->SetFillColor(239);
if (_has_option('display_contact_info') )
{
    $pdf->SetFont('dejavusans', '', 8);
    $contact = '<p style="text-align:center;">' .$this->lang->line('message_invoice_contact_info') . "<br />";
    $contact .= get_option('first_name') . " ". get_option('last_name') . " (". get_option('notifications_email') ."/ ";
    $contact .= get_option('phone') . ") ";
    $contact .= '</p>';
    $pdf->writeHTML($contact, true, false, false, false, '');
    $pdf->Ln(5);
}
else
{
    // Add padding if no contact info
    $pdf->Ln(5);
}

$startpage = $pdf->GetPage();

# providers Details
if ($provider) {

    // Vertical alignment
    $providerDetails = '<h4><i>'.$this->lang->line('providers_provider').'</i></h4><br />';
    if ($provider["name_company"]) {
        $providerDetails .= '<h3>'.$provider["name_company"]."</h3><br />";
    }
    $providerDetails .= $provider["address1"]."<br />";
    if ($provider["address2"]) {
        $providerDetails .= $provider["address2"]."<br />";
    }
    if ($provider["country"] == 'None')
    {
        $provider["country"] = "";
    }
    if ($provider["postcode"])
    {
        $providerDetails .= $provider["postcode"]." ";
        $providerDetails .= $provider["city"]." ";
        $providerDetails .= " ".$provider["state"]." <br />";
        $providerDetails .= $provider["country"]."<br />";
    }
    if ($provider["provider_tax_number"])
    {
        $providerDetails .= $this->lang->line('label_tax_number'). ': '.$provider["provider_tax_number"]."<br />";
    }
    if ($provider["provider_phone"])
    {
        $providerDetails .= $this->lang->line('label_phone'). ': '.$provider["provider_phone"]."<br />";
    }
    if ($subject)
    {
        $providerDetails .= $this->lang->line('label_external_number'). ': '.$subject."<br />";
    }
}

// Billing Address
$billTo = '<h4><i>'.$this->lang->line('label_bill_to').'</i></h4><br />';
if ($user_company) {
    $billTo .= '<h3>'.$user_company."</h3><br />";
}
$billTo .= $user_address['user_address1']."<br />";
if ($user_address['user_address2']) {
    $billTo .= $user_address['user_address2']."<br />";
}
if ($user_address["user_country"] == 'None')
{
    $user_address["user_country"] = "";
}
if ($user_address["user_postcode"])
{
    $billTo .= $user_address["user_postcode"]." ";
    $billTo .= $user_address['user_city']." ";
    $billTo .= " ".$user_address["user_state"]." <br />";
    $billTo .= $user_address["user_country"]."<br />";
}
if (_has_option('display_vat_number') &&  $tax_id)
{
    $billTo .= $this->lang->line('label_tax_number'). ': '.$tax_id."<br />";
}
if (_has_option('display_ch_commerce') &&  $chamber_commerce_id)
{
    $billTo .= $this->lang->line('label_short_chamber_commerce'). ': '.trim($chamber_commerce_id)."<br />";
}
if (_has_option('display_bank_name') && $bank_name)
{
    $billTo .= $this->lang->line('label_bank'). ': '.trim($bank_name)."<br />";
}
if (_has_option('display_iban') &&  $bank_number)
{
    $billTo .= $this->lang->line('label_bank_number'). ': '.trim($bank_number)."<br />";
}

// Shipping Address
$shipTo = '<h4><i><span style="background-color: #FFFF00">'.$this->lang->line('label_ship_to').'</span></i></h4><br />';
if ($shippingDetails["name_company"]) {
    $shipTo .= '<h3>'.$shippingDetails["name_company"]."</h3><br />";
}
$shipTo .= $shippingDetails["address1"]."<br />";
if ($shippingDetails["address2"]) {
    $shipTo .= $shippingDetails["address2"]."<br />";
}
if ($shippingDetails["country"] == 'None')
{
    $shippingDetails["country"] = "";
}
if ($shippingDetails["postcode"])
{
    $shipTo .= $shippingDetails["postcode"]." ";
    $shipTo .= $shippingDetails["city"]." ";
    $shipTo .= " ".$shippingDetails["state"]." <br />";
    $shipTo .= get_countries($shippingDetails["country"])."<br />";
}
if ($shippingDetails["phone"])
{
    $shipTo .= $this->lang->line('label_phone'). ': '.$shippingDetails["phone"]."<br />";
}

// MultiCell($w, $h, $txt, $border=0, $align='J', $fill=0, $ln=1, $x='', $y='', $reseth=true, $stretch=0, $ishtml=false, $autopadding=true, $maxh=0)
$pdf->MultiCell(60, 40, $providerDetails, 1, 'J', 0, 0, '', '', true, 0, true, true, 40);
$pdf->MultiCell(60, 40, $billTo, 1, 'J', 0, 0, '', '', true, 0, true, true, 40);
$pdf->MultiCell(60, 40, $shipTo, 1, 'J', 0, 1, '', '', true, 0, true, true, 40);
$pdf->Ln(5);

# Invoice Items
$tblhtml = '<table width="100%" bgcolor="#ccc" cellspacing="1" cellpadding="2" border="0">
    <tr height="30" bgcolor="#efefef" style="font-weight:bold;text-align:center;">
        <th width="5%" align="left">#</th>
        <th width="29%" align="left">' . $this->lang->line('th_item') . '</th>
        <th width="10%">' . $this->lang->line('quantity') . '</th>
        <th width="20%" align="right">' . $this->lang->line('th_price') . '</th>
        <th width="20%" align="right">' . $this->lang->line('th_discount') . '</th>
        <th width="20%" align="right">' . $this->lang->line('label_subtotal') . '</th>
    </tr>';
foreach ($invoiceitems as $k => $item) {
    $k += 1;
    $discount_value = ($item->item_price * $item->item_quantity) * $item->item_discount / 100;
    $tblhtml .= '
    <tr bgcolor="#fff">
        <td align="left">' . $k. '<br /></td>
        <td align="left">' . $item->item_name. '<br />';
        if (_has_option('display_mpn')) {
            $tblhtml .= $this->lang->line('label_mpn'). ':'.$item->product_mpn;
        }
    $tblhtml .= '</td>
        <td align="center">' . $item->item_quantity . ' '.$item->item_uom. '<br /></td>
        <td align="right">' . format_number($item->item_price * $change_rate) . '<br /></td>
        <td align="right">' . $item->item_discount . '%<br /><span style="font-size: 7px;"><em>'.add_provider_currency( format_number( $discount_value ), $provider_id ).'</em></span></td>
        <td align="right">' . format_number($item->item_subtotal * $change_rate). '<br /><span style="font-size: 7px;"><em>'.$this->lang->line('label_tax').' @'. $item->item_tax_rate.'%</em></span></td>
    </tr>';
}
if ($discount) {
    $tblhtml .= '
    <tr height="30" bgcolor="#fff" style="font-weight:bold;">
        <td></td>
        <td></td>
        <td></td>
        <td align="right">' . $discount_name . '</td>
        <td align="right">' . add_provider_currency( format_number($discount_amount * $change_rate), $provider_id ). '</td>
        <td></td>
    </tr>';
}
$tblhtml .= '
    <tr height="30" bgcolor="#fff">
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td align="right">' . $this->lang->line('label_subtotal') . '</td>
        <td align="right">' . add_provider_currency( format_number($subtotal * $change_rate), $provider_id ) . '</td>
    </tr>';
if ($tax_value) 
{
    for ($i=0; $i < count($tax_value); $i++) {
    $tblhtml .= '
    <tr height="30" bgcolor="#fff">
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td align="right">' . $this->lang->line('label_tax') . " (". $tax_value[$i]['tax_rate']. "%)".'</td>
        <td align="right">' . add_provider_currency( format_number($tax_value[$i]['tax_sum'] * $change_rate), $provider_id ) . '</td>
    </tr>';
    }
}
$tblhtml .= '
<tr height="30" bgcolor="#fff">
    <td></td>
    <td></td>
    <td></td>
    <td></td>
    <td align="right">' . $this->lang->line('label_shipping_amount') . '</td>
    <td align="right">' . add_provider_currency( format_number($shipping_amount * $change_rate), $provider_id ) . '</td>
</tr>';
$tblhtml .= '
<tr height="30" bgcolor="#fff">
    <td></td>
    <td></td>
    <td></td>
    <td></td>
    <td align="right">' . $this->lang->line('placeholder_other_expenses') . '</td>
    <td align="right">' . add_provider_currency( format_number($other_expenses * $change_rate), $provider_id ) . '</td>
</tr>';
if (!$tax_value)
{
    $tblhtml .= '
    <tr height="30" bgcolor="#efefef">
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td align="right">' . $this->lang->line('label_total_duty_free') . '<strong><sup>*</sup></strong></td>
        <td align="right">' . add_provider_currency( format_number($total * $change_rate), $provider_id ) . '</td>
    </tr>';
}
else
{
    $tblhtml .= '
    <tr height="30" bgcolor="#efefef" style="font-weight:bold;">
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td align="right">' . $this->lang->line('label_grand_total') . '</td>
        <td align="right">' . add_provider_currency( format_number($total * $change_rate), $provider_id ) . '</td>
    </tr>';
}

$tblhtml .= '</table>';
if (!$taxname){
    $tblhtml .= '<p style="text-align: right; font-weight:bold"><sup>*</sup>'. $this->lang->line('message_no_tax_applied') .'</p>';
}
$pdf->writeHTML($tblhtml, true, false, false, false, '');

$pdf->Ln(2);


# Notes
if ($notes) {
    $pdf->SetFont('dejavusans', '', 8);
    $pdf->MultiCell(170, 5, $this->lang->line('notes') . ': ' . $notes, 0, 'L', 0);
}
if( _has_option('display_terms') )
{
    $pdf->writeHTML($terms, true, false, false, false, '');
    $pdf->Ln(2);
}

# Generation Date
$pdf->SetFont('dejavusans', '', 8);
$pdf->Cell(180, 4, $this->lang->line('invoicepdfgenerated') . ' ' . $current_date, '', '', 'C');
# Custum Footer
$pdf->SetFont('dejavusans', '', 8);
$pdf->Ln(1);
$pdf->MultiCell(180, 4, '____________________________________', 0, 'C', 0);

$html = '<p style="text-align: center;">'. $purchase_footer .'</p>';
$pdf->writeHTML($html, true, false, false, false, '');

$pdf->Output(FCPATH.'uploads/pdf/purchases/'.$non_formatted_purchase_number.'.pdf', 'F');
$pdf->Output($page_title.'_'.$provider["name_company"].'.pdf', 'I');
